/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.loader;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataResultSet;
import com.posics.data.loader.LocalRes;
import com.posics.data.loader.SentenceExec;
import com.posics.data.loader.SentenceFind;
import com.posics.data.loader.SentenceList;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSentence
implements SentenceList,
SentenceFind,
SentenceExec {
    public abstract DataResultSet openExec(Object var1) throws BasicException;

    public abstract DataResultSet moreResults() throws BasicException;

    public abstract void closeExec() throws BasicException;

    @Override
    public final int exec() throws BasicException {
        return this.exec((Object)null);
    }

    @Override
    public final int exec(Object ... params) throws BasicException {
        return this.exec((Object)params);
    }

    @Override
    public final int exec(Object params) throws BasicException {
        DataResultSet SRS = this.openExec(params);
        if (SRS == null) {
            throw new BasicException(LocalRes.getIntString("exception.noupdatecount"));
        }
        int iResult = SRS.updateCount();
        SRS.close();
        this.closeExec();
        return iResult;
    }

    @Override
    public final List list() throws BasicException {
        return this.list((Object)null);
    }

    @Override
    public final List list(Object ... params) throws BasicException {
        return this.list((Object)params);
    }

    @Override
    public final List list(Object params) throws BasicException {
        DataResultSet SRS = this.openExec(params);
        List aSO = this.fetchAll(SRS);
        SRS.close();
        this.closeExec();
        return aSO;
    }

    @Override
    public final List listPage(int offset, int length) throws BasicException {
        return this.listPage(null, offset, length);
    }

    @Override
    public final List listPage(Object params, int offset, int length) throws BasicException {
        DataResultSet SRS = this.openExec(params);
        List aSO = this.fetchPage(SRS, offset, length);
        SRS.close();
        this.closeExec();
        return aSO;
    }

    @Override
    public final Object find() throws BasicException {
        return this.find((Object)null);
    }

    @Override
    public final Object find(Object ... params) throws BasicException {
        return this.find((Object)params);
    }

    @Override
    public final Object find(Object params) throws BasicException {
        DataResultSet SRS = this.openExec(params);
        Object obj = this.fetchOne(SRS);
        SRS.close();
        this.closeExec();
        return obj;
    }

    public final List fetchAll(DataResultSet SRS) throws BasicException {
        if (SRS == null) {
            throw new BasicException(LocalRes.getIntString("exception.nodataset"));
        }
        ArrayList<Object> aSO = new ArrayList<Object>();
        while (SRS.next()) {
            aSO.add(SRS.getCurrent());
        }
        return aSO;
    }

    public final List fetchPage(DataResultSet SRS, int offset, int length) throws BasicException {
        if (SRS == null) {
            throw new BasicException(LocalRes.getIntString("exception.nodataset"));
        }
        if (offset < 0 || length < 0) {
            throw new BasicException(LocalRes.getIntString("exception.nonegativelimits"));
        }
        while (offset > 0 && SRS.next()) {
            --offset;
        }
        ArrayList<Object> aSO = new ArrayList<Object>();
        if (offset == 0) {
            while (length > 0 && SRS.next()) {
                --length;
                aSO.add(SRS.getCurrent());
            }
        }
        return aSO;
    }

    public final Object fetchOne(DataResultSet SRS) throws BasicException {
        if (SRS == null) {
            throw new BasicException(LocalRes.getIntString("exception.nodataset"));
        }
        if (SRS.next()) {
            return SRS.getCurrent();
        }
        return null;
    }
}

