/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.loader;

import com.posics.data.loader.ComparatorCreator;
import com.posics.data.loader.ComparatorCreatorBasic;
import com.posics.data.loader.Datas;
import com.posics.data.loader.IKeyGetter;
import com.posics.data.loader.IRenderString;
import com.posics.data.loader.KeyGetterBasic;
import com.posics.data.loader.KeyGetterFirst;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.RenderStringBasic;
import com.posics.data.loader.SentenceExec;
import com.posics.data.loader.SentenceList;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadBasic;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteBasicExt;
import com.posics.data.loader.Session;
import com.posics.data.loader.Vectorer;
import com.posics.data.loader.VectorerBasic;
import com.posics.format.Formats;

public class TableDefinition {
    private Session m_s;
    private String tablename;
    private String[] fieldname;
    private String[] fieldtran;
    private Datas[] fielddata;
    private Formats[] fieldformat;
    private String m_orderBy;
    private int[] idinx;

    public TableDefinition(Session s, String tablename, String[] fieldname, String[] fieldtran, Datas[] fielddata, Formats[] fieldformat, int[] idinx) {
        this(s, tablename, fieldname, fieldtran, fielddata, fieldformat, idinx, null);
    }

    public TableDefinition(Session s, String tablename, String[] fieldname, String[] fieldtran, Datas[] fielddata, Formats[] fieldformat, int[] idinx, String orderby) {
        this.m_s = s;
        this.tablename = tablename;
        this.fieldname = fieldname;
        this.fieldtran = fieldtran;
        this.fielddata = fielddata;
        this.fieldformat = fieldformat;
        this.idinx = idinx;
        this.m_orderBy = orderby;
    }

    public TableDefinition(Session s, String tablename, String[] fieldname, Datas[] fielddata, Formats[] fieldformat, int[] idinx) {
        this(s, tablename, fieldname, fieldname, fielddata, fieldformat, idinx);
    }

    public String getTableName() {
        return this.tablename;
    }

    public String[] getFields() {
        return this.fieldname;
    }

    public Vectorer getVectorerBasic(int[] aiFields) {
        return new VectorerBasic(this.fieldtran, this.fieldformat, aiFields);
    }

    public IRenderString getRenderStringBasic(int[] aiFields) {
        return new RenderStringBasic(this.fieldformat, aiFields);
    }

    public ComparatorCreator getComparatorCreator(int[] aiOrders) {
        return new ComparatorCreatorBasic(this.fieldtran, this.fielddata, aiOrders);
    }

    public IKeyGetter getKeyGetterBasic() {
        if (this.idinx.length == 1) {
            return new KeyGetterFirst(this.idinx);
        }
        return new KeyGetterBasic(this.idinx);
    }

    public SerializerRead getSerializerReadBasic() {
        return new SerializerReadBasic(this.fielddata);
    }

    public SerializerWrite getSerializerInsertBasic(int[] fieldindx) {
        return new SerializerWriteBasicExt(this.fielddata, fieldindx);
    }

    public SerializerWrite getSerializerDeleteBasic() {
        return new SerializerWriteBasicExt(this.fielddata, this.idinx);
    }

    public SerializerWrite getSerializerUpdateBasic(int[] fieldindx) {
        int i;
        int[] aindex = new int[fieldindx.length + this.idinx.length];
        for (i = 0; i < fieldindx.length; ++i) {
            aindex[i] = fieldindx[i];
        }
        for (i = 0; i < this.idinx.length; ++i) {
            aindex[i + fieldindx.length] = this.idinx[i];
        }
        return new SerializerWriteBasicExt(this.fielddata, aindex);
    }

    public SentenceList getListSentence() {
        return this.getListSentence(this.getSerializerReadBasic());
    }

    public SentenceList getListSentence(SerializerRead sr) {
        return new PreparedSentence(this.m_s, this.getListSQL(), null, sr);
    }

    public String getListSQL() {
        StringBuilder sent = new StringBuilder();
        sent.append("select ");
        for (int i = 0; i < this.fieldname.length; ++i) {
            if (i > 0) {
                sent.append(", ");
            }
            sent.append(this.fieldname[i]);
        }
        sent.append(" from ");
        sent.append(this.tablename);
        if (this.m_orderBy != null && this.m_orderBy.length() > 0) {
            sent.append(" ORDER BY ");
            sent.append(this.m_orderBy);
        }
        return sent.toString();
    }

    public SentenceExec getDeleteSentence() {
        return this.getDeleteSentence(this.getSerializerDeleteBasic());
    }

    public SentenceExec getDeleteSentence(SerializerWrite sw) {
        return new PreparedSentence(this.m_s, this.getDeleteSQL(), sw, null);
    }

    public String getDeleteSQL() {
        StringBuilder sent = new StringBuilder();
        sent.append("delete from ");
        sent.append(this.tablename);
        for (int i = 0; i < this.idinx.length; ++i) {
            sent.append(i == 0 ? " where " : " and ");
            sent.append(this.fieldname[this.idinx[i]]);
            sent.append(" = ?");
        }
        return sent.toString();
    }

    public SentenceExec getInsertSentence() {
        return this.getInsertSentence(this.getAllFields());
    }

    public SentenceExec getInsertSentence(int[] fieldindx) {
        return new PreparedSentence(this.m_s, this.getInsertSQL(fieldindx), this.getSerializerInsertBasic(fieldindx), null);
    }

    private String getInsertSQL(int[] fieldindx) {
        StringBuilder sent = new StringBuilder();
        StringBuilder values = new StringBuilder();
        sent.append("insert into ");
        sent.append(this.tablename);
        sent.append(" (");
        for (int i = 0; i < fieldindx.length; ++i) {
            if (i > 0) {
                sent.append(", ");
                values.append(", ");
            }
            sent.append(this.fieldname[fieldindx[i]]);
            values.append("?");
        }
        sent.append(") values (");
        sent.append(values.toString());
        sent.append(")");
        return sent.toString();
    }

    private int[] getAllFields() {
        int[] fieldindx = new int[this.fieldname.length];
        for (int i = 0; i < this.fieldname.length; ++i) {
            fieldindx[i] = i;
        }
        return fieldindx;
    }

    public SentenceExec getUpdateSentence() {
        return this.getUpdateSentence(this.getAllFields());
    }

    public SentenceExec getUpdateSentence(int[] fieldindx) {
        return new PreparedSentence(this.m_s, this.getUpdateSQL(fieldindx), this.getSerializerUpdateBasic(fieldindx), null);
    }

    private String getUpdateSQL(int[] fieldindx) {
        int i;
        StringBuilder sent = new StringBuilder();
        sent.append("update ");
        sent.append(this.tablename);
        sent.append(" set ");
        for (i = 0; i < fieldindx.length; ++i) {
            if (i > 0) {
                sent.append(", ");
            }
            sent.append(this.fieldname[fieldindx[i]]);
            sent.append(" = ?");
        }
        for (i = 0; i < this.idinx.length; ++i) {
            sent.append(i == 0 ? " where " : " and ");
            sent.append(this.fieldname[this.idinx[i]]);
            sent.append(" = ?");
        }
        return sent.toString();
    }
}

