/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.model;

import com.posics.data.model.Column;

public class Table {
    private String name;
    private Column[] columns;

    public Table(String name, Column ... columns) {
        this.name = name;
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public String getListSQL() {
        StringBuffer sent = new StringBuffer();
        sent.append("select ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sent.append(", ");
            }
            sent.append(this.columns[i].getName());
        }
        sent.append(" from ");
        sent.append(this.name);
        return sent.toString();
    }

    public String getInsertSQL() {
        StringBuffer sent = new StringBuffer();
        StringBuffer values = new StringBuffer();
        sent.append("insert into ");
        sent.append(this.name);
        sent.append(" (");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sent.append(", ");
                values.append(", ");
            }
            sent.append(this.columns[i].getName());
            values.append("?");
        }
        sent.append(") values (");
        sent.append(values.toString());
        sent.append(")");
        return sent.toString();
    }

    public String getUpdateSQL() {
        StringBuffer values = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].isPK()) {
                if (filter.length() == 0) {
                    filter.append(" where ");
                } else {
                    filter.append(" and ");
                }
                filter.append(this.columns[i].getName());
                filter.append(" = ?");
                continue;
            }
            if (values.length() > 0) {
                values.append(", ");
            }
            values.append(this.columns[i].getName());
            values.append(" = ?");
        }
        return "update " + this.name + " set " + values + filter;
    }

    public String getDeleteSQL() {
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].isPK()) continue;
            if (filter.length() == 0) {
                filter.append(" where ");
            } else {
                filter.append(" and ");
            }
            filter.append(this.columns[i].getName());
            filter.append(" = ?");
        }
        return "delete from " + this.name + filter;
    }
}

