/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.catalog;

import com.posics.basic.BasicException;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.gui.JMessageDialog;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.SentenceList;
import com.posics.pos.catalog.CatalogSelector;
import com.posics.pos.catalog.JCatalogTab;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.CategoryInfo;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JCatalog
extends JPanel
implements ListSelectionListener,
CatalogSelector {
    protected EventListenerList listeners = new EventListenerList();
    private DataLogicSales m_dlSales;
    private TaxesLogic taxeslogic;
    private boolean pricevisible;
    private boolean taxesincluded;
    private boolean showproductscombo;
    private Map<String, ProductInfoExt> m_productsset = new HashMap<String, ProductInfoExt>();
    private Set<String> m_categoriesset = new HashSet<String>();
    private ThumbNailBuilder tnbbutton;
    private ThumbNailBuilder tnbcat;
    private ThumbNailBuilder tnbsubcat;
    private CategoryInfo showingcategory = null;
    public SentenceList m_productslist;
    private ComboBoxValModel m_ProductsModel;
    private boolean m_Materials = false;
    private boolean showcategories;
    private boolean catHideButton = false;
    double factor = 0.5;
    private String m_sProductLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JComboBox jProductsCombo;
    private JPanel jUp;
    private JButton m_btnBack1;
    private JButton m_btnBack2;
    private JPanel m_jCategories;
    private JButton m_jDown;
    private JButton m_jDown1;
    private JList m_jListCategories;
    private JPanel m_jProducts;
    private JPanel m_jRootCategories;
    private JPanel m_jSubCategories;
    private JButton m_jUp;
    private JScrollPane m_jscrollcat;
    private JLabel m_lblIndicator;

    public JCatalog(DataLogicSales dlSales, boolean pricevisible, boolean taxesincluded, int width, int height, boolean showproductscombo, boolean showcategories, boolean ismaterials) {
        this.m_dlSales = dlSales;
        this.pricevisible = pricevisible;
        this.taxesincluded = taxesincluded;
        this.showproductscombo = showproductscombo;
        this.showcategories = showcategories;
        this.m_Materials = ismaterials;
        this.initComponents();
        this.m_jListCategories.addListSelectionListener(this);
        this.m_jscrollcat.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
        if (!showcategories) {
            this.m_jCategories.remove(this.m_jRootCategories);
            this.m_jCategories.remove(this.m_jSubCategories);
            this.m_jCategories.setPreferredSize(this.m_jUp.getPreferredSize());
            this.m_jCategories.add(this.m_jUp);
        } else {
            this.m_jCategories.remove(this.m_jUp);
        }
        this.tnbcat = new ThumbNailBuilder(32, 32, "com/posics/images/category.png");
        this.tnbbutton = new ThumbNailBuilder((int)((double)width * 0.75), (int)((double)height * 0.75), "com/posics/images/product.png");
        this.tnbsubcat = new ThumbNailBuilder((int)((double)width * 0.75), (int)((double)height * 0.75), "com/posics/images/category.png");
        this.m_sProductLabel = this.m_dlSales.getResource("Product.Label");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void showCatalogPanel(String id) {
        if (id == null) {
            this.showRootCategoriesPanel();
        } else {
            this.showProductPanel(id);
        }
    }

    private String readProductLabel(ProductInfoExt product, String strLabel) {
        try {
            ScriptObject scr = new ScriptObject(product);
            Object result = scr.evalScript(strLabel);
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
            return "";
        }
    }

    @Override
    public boolean productscomboVisible() {
        return this.showproductscombo;
    }

    @Override
    public void loadCatalog() throws BasicException {
        List materials;
        this.m_jProducts.removeAll();
        this.m_productsset.clear();
        this.m_categoriesset.clear();
        this.showingcategory = null;
        this.taxeslogic = new TaxesLogic(this.m_dlSales.getTaxList().list());
        List<CategoryInfo> categories = this.m_dlSales.getRootCategories();
        if (this.m_Materials && (materials = this.m_dlSales.getMaterialList().list()).size() > 0) {
            categories.add(this.m_dlSales.getCategoryMaterial().get(0));
        }
        this.m_jListCategories.setCellRenderer(new SmallCategoryRenderer());
        this.m_jListCategories.setModel(new CategoriesListModel(categories));
        if (this.m_jListCategories.getModel().getSize() == 0) {
            this.m_jscrollcat.setVisible(false);
            this.jPanel2.setVisible(false);
        } else {
            this.m_jscrollcat.setVisible(true);
            this.jPanel2.setVisible(true);
            this.m_jListCategories.setSelectedIndex(0);
        }
        this.showRootCategoriesPanel();
        this.m_jRootCategories.remove(this.jProductsCombo);
        JTextComponent editor = (JTextComponent)this.jProductsCombo.getEditor().getEditorComponent();
        editor.setDocument(new CBDocument(this.jProductsCombo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComponentEnabled(boolean value) {
        this.m_jListCategories.setEnabled(value);
        this.m_jscrollcat.setEnabled(value);
        this.m_jUp.setEnabled(value);
        this.m_jDown.setEnabled(value);
        this.m_lblIndicator.setEnabled(value);
        this.m_btnBack1.setEnabled(value);
        this.m_jProducts.setEnabled(value);
        Object object = this.m_jProducts.getTreeLock();
        synchronized (object) {
            int compCount = this.m_jProducts.getComponentCount();
            for (int i = 0; i < compCount; ++i) {
                this.m_jProducts.getComponent(i).setEnabled(value);
            }
        }
        this.setEnabled(value);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listeners.add(ActionListener.class, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listeners.remove(ActionListener.class, l);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        int i;
        if (!evt.getValueIsAdjusting() && (i = this.m_jListCategories.getSelectedIndex()) >= 0) {
            Rectangle oRect = this.m_jListCategories.getCellBounds(i, i);
            this.m_jListCategories.scrollRectToVisible(oRect);
        }
    }

    protected void fireSelectedProduct(ProductInfoExt prod) {
        EventListener[] l = this.listeners.getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < l.length; ++i) {
            if (e == null) {
                e = new ActionEvent(prod, 1001, prod.getID());
            }
            ((ActionListener)l[i]).actionPerformed(e);
        }
    }

    private void selectCategoryPanel(String catid) {
        try {
            if (!this.m_categoriesset.contains(catid)) {
                JCatalogTab jcurrTab = new JCatalogTab();
                jcurrTab.applyComponentOrientation(this.getComponentOrientation());
                this.m_jProducts.add((Component)jcurrTab, catid);
                this.m_categoriesset.add(catid);
                if (this.m_Materials && catid.equals("-1")) {
                    List materials = this.m_dlSales.getMaterialList().list();
                    for (ProductInfoExt m : materials) {
                        jcurrTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(m.getImage(), m.getName())), new SelectedAction(m), m.getName());
                    }
                } else {
                    List<CategoryInfo> categories = this.m_dlSales.getSubcategories(catid);
                    for (CategoryInfo cat : categories) {
                        if (cat.getImage() != null) {
                            jcurrTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(cat.getImage(), cat.getName())), new SelectedCategory(cat), cat.getName());
                            continue;
                        }
                        jcurrTab.addButton(new ImageIcon(this.tnbsubcat.getThumbNailText(cat.getImage(), cat.getName())), new SelectedCategory(cat), cat.getName());
                    }
                    List<ProductInfoExt> products = this.m_dlSales.getProductCatalog(catid);
                    for (ProductInfoExt prod : products) {
                        jcurrTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(prod.getImage(), this.getProductLabel(prod))), new SelectedAction(prod), this.getProductLabel(prod));
                    }
                }
            }
            CardLayout cl = (CardLayout)this.m_jProducts.getLayout();
            cl.show(this.m_jProducts, catid);
        }
        catch (BasicException e) {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.notactive"), e));
        }
    }

    private String getProductLabel(ProductInfoExt product) {
        if (product.getProperty("style") != null) {
            return "<html>" + product.getProperty("style");
        }
        if (!this.m_sProductLabel.equals("")) {
            return this.readProductLabel(product, this.m_sProductLabel);
        }
        if (this.pricevisible) {
            if (this.taxesincluded) {
                TaxInfo tax = this.taxeslogic.getTaxInfo(product.getTaxCategoryID());
                return "<html><center>" + product.getName() + "<br>" + product.printPriceSellTax(tax);
            }
            return "<html><center>" + product.getName() + "<br>" + product.printPriceSell();
        }
        return product.getName();
    }

    private void selectIndicatorPanel(Icon icon, String label) {
        this.m_lblIndicator.setText(label);
        this.m_lblIndicator.setIcon(icon);
        CardLayout cl = (CardLayout)this.m_jCategories.getLayout();
        cl.show(this.m_jCategories, "subcategories");
    }

    private void selectIndicatorCategories() {
        CardLayout cl = (CardLayout)this.m_jCategories.getLayout();
        cl.show(this.m_jCategories, "rootcategories");
    }

    private void showRootCategoriesPanel() {
        this.selectIndicatorCategories();
        CategoryInfo cat = (CategoryInfo)this.m_jListCategories.getSelectedValue();
        if (cat != null) {
            this.selectCategoryPanel(cat.getID());
        }
        this.showingcategory = null;
    }

    private void showProdctsCombo() {
        try {
            this.m_productslist = this.m_Materials ? this.m_dlSales.getProductsListWithMaterials() : this.m_dlSales.getProductsList();
            this.m_ProductsModel = new ComboBoxValModel(this.m_productslist.list());
            this.jProductsCombo.setModel(this.m_ProductsModel);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Products Load Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void showSubcategoryPanel(CategoryInfo category) {
        this.selectIndicatorPanel(new ImageIcon(this.tnbbutton.getThumbNail(category.getImage())), category.getName());
        this.selectCategoryPanel(category.getID());
        this.showingcategory = category;
    }

    private void showProductPanel(String id) {
        block13: {
            ProductInfoExt product = this.m_productsset.get(id);
            if (product == null) {
                if (this.m_productsset.containsKey(id)) {
                    if (this.showingcategory == null) {
                        this.showRootCategoriesPanel();
                    } else {
                        this.showSubcategoryPanel(this.showingcategory);
                    }
                } else {
                    try {
                        List<ProductInfoExt> products = this.m_dlSales.getProductComments(id);
                        if (products.size() == 0) {
                            this.m_productsset.put(id, null);
                            if (this.showingcategory == null) {
                                this.showRootCategoriesPanel();
                            } else {
                                this.showSubcategoryPanel(this.showingcategory);
                            }
                            break block13;
                        }
                        product = this.m_dlSales.getProductInfo(id);
                        this.m_productsset.put(id, product);
                        JCatalogTab jcurrTab = new JCatalogTab();
                        jcurrTab.applyComponentOrientation(this.getComponentOrientation());
                        this.m_jProducts.add((Component)jcurrTab, "PRODUCT." + id);
                        for (ProductInfoExt prod : products) {
                            jcurrTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(prod.getImage(), this.getProductLabel(prod))), new SelectedAction(prod), this.getProductLabel(prod));
                        }
                        this.selectIndicatorPanel(new ImageIcon(this.tnbbutton.getThumbNail(product.getImage())), product.getName());
                        CardLayout cl = (CardLayout)this.m_jProducts.getLayout();
                        cl.show(this.m_jProducts, "PRODUCT." + id);
                    }
                    catch (BasicException eb) {
                        eb.printStackTrace();
                        this.m_productsset.put(id, null);
                        if (this.showingcategory == null) {
                            this.showRootCategoriesPanel();
                            break block13;
                        }
                        this.showSubcategoryPanel(this.showingcategory);
                    }
                }
            } else {
                this.selectIndicatorPanel(new ImageIcon(this.tnbbutton.getThumbNail(product.getImage())), product.getName());
                CardLayout cl = (CardLayout)this.m_jProducts.getLayout();
                cl.show(this.m_jProducts, "PRODUCT." + id);
            }
        }
    }

    private void initComponents() {
        this.m_jCategories = new JPanel();
        this.m_jRootCategories = new JPanel();
        this.m_jscrollcat = new JScrollPane();
        this.m_jListCategories = new JList();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.m_jUp = new JButton();
        this.m_jDown = new JButton();
        this.m_jDown1 = new JButton();
        this.jProductsCombo = new JComboBox();
        this.m_jSubCategories = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_lblIndicator = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel5 = new JPanel();
        this.m_btnBack1 = new JButton();
        this.jUp = new JPanel();
        this.jPanel7 = new JPanel();
        this.m_btnBack2 = new JButton();
        this.m_jProducts = new JPanel();
        this.setLayout(new BorderLayout());
        this.m_jCategories.setMaximumSize(new Dimension(275, 600));
        this.m_jCategories.setPreferredSize(new Dimension(275, 600));
        this.m_jCategories.setLayout(new CardLayout());
        this.m_jRootCategories.setLayout(new BorderLayout());
        this.m_jscrollcat.setHorizontalScrollBarPolicy(31);
        this.m_jscrollcat.setVerticalScrollBarPolicy(22);
        this.m_jListCategories.setSelectionMode(0);
        this.m_jListCategories.setFocusable(false);
        this.m_jListCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JCatalog.this.m_jListCategoriesValueChanged(evt);
            }
        });
        this.m_jscrollcat.setViewportView(this.m_jListCategories);
        this.m_jRootCategories.add((Component)this.m_jscrollcat, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanel3.setLayout(new GridLayout(0, 1, 0, 5));
        this.m_jUp.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1uparrow22.png")));
        this.m_jUp.setFocusPainted(false);
        this.m_jUp.setFocusable(false);
        this.m_jUp.setMargin(new Insets(8, 14, 8, 14));
        this.m_jUp.setRequestFocusEnabled(false);
        this.m_jUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCatalog.this.m_jUpActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.m_jUp);
        this.m_jDown.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1downarrow22.png")));
        this.m_jDown.setFocusPainted(false);
        this.m_jDown.setFocusable(false);
        this.m_jDown.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDown.setRequestFocusEnabled(false);
        this.m_jDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCatalog.this.m_jDownActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.m_jDown);
        this.m_jDown1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1leftarrow.png")));
        this.m_jDown1.setFocusPainted(false);
        this.m_jDown1.setFocusable(false);
        this.m_jDown1.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDown1.setRequestFocusEnabled(false);
        this.m_jDown1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCatalog.this.m_jDown1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.m_jDown1);
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.m_jRootCategories.add((Component)this.jPanel2, "After");
        this.jProductsCombo.setEditable(true);
        this.jProductsCombo.setPreferredSize(new Dimension(123, 25));
        this.m_jRootCategories.add((Component)this.jProductsCombo, "Last");
        this.m_jCategories.add((Component)this.m_jRootCategories, "rootcategories");
        this.m_jSubCategories.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BorderLayout());
        this.m_lblIndicator.setText("jLabel1");
        this.jPanel4.add((Component)this.m_lblIndicator, "North");
        this.m_jSubCategories.add((Component)this.jPanel4, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanel5.setLayout(new GridLayout(0, 1, 0, 5));
        this.m_btnBack1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/3uparrow2.png")));
        this.m_btnBack1.setFocusPainted(false);
        this.m_btnBack1.setFocusable(false);
        this.m_btnBack1.setMargin(new Insets(8, 14, 8, 14));
        this.m_btnBack1.setRequestFocusEnabled(false);
        this.m_btnBack1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCatalog.this.m_btnBack1ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.m_btnBack1);
        this.jPanel1.add((Component)this.jPanel5, "North");
        this.m_jSubCategories.add((Component)this.jPanel1, "After");
        this.m_jCategories.add((Component)this.m_jSubCategories, "subcategories");
        this.jUp.setLayout(new BorderLayout());
        this.jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanel7.setLayout(new GridLayout(0, 1, 0, 5));
        this.m_btnBack2.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/3uparrow2.png")));
        this.m_btnBack2.setFocusPainted(false);
        this.m_btnBack2.setFocusable(false);
        this.m_btnBack2.setMargin(new Insets(8, 14, 8, 14));
        this.m_btnBack2.setRequestFocusEnabled(false);
        this.m_btnBack2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCatalog.this.m_btnBack2ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.m_btnBack2);
        this.jUp.add((Component)this.jPanel7, "North");
        this.m_jCategories.add((Component)this.jUp, "card4");
        this.add((Component)this.m_jCategories, "Before");
        this.m_jProducts.setLayout(new CardLayout());
        this.add((Component)this.m_jProducts, "Center");
    }

    private void m_jDownActionPerformed(ActionEvent evt) {
        int i = this.m_jListCategories.getSelectionModel().getMaxSelectionIndex();
        if (i < 0) {
            i = 0;
        } else if (++i >= this.m_jListCategories.getModel().getSize()) {
            i = this.m_jListCategories.getModel().getSize() - 1;
        }
        if (i >= 0 && i < this.m_jListCategories.getModel().getSize()) {
            this.m_jListCategories.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private void m_jUpActionPerformed(ActionEvent evt) {
        int i = this.m_jListCategories.getSelectionModel().getMinSelectionIndex();
        if (i < 0) {
            i = this.m_jListCategories.getModel().getSize() - 1;
        } else if (--i < 0) {
            i = 0;
        }
        if (i >= 0 && i < this.m_jListCategories.getModel().getSize()) {
            this.m_jListCategories.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private void m_jListCategoriesValueChanged(ListSelectionEvent evt) {
        CategoryInfo cat;
        if (!evt.getValueIsAdjusting() && (cat = (CategoryInfo)this.m_jListCategories.getSelectedValue()) != null) {
            this.selectCategoryPanel(cat.getID());
        }
    }

    private void m_btnBack1ActionPerformed(ActionEvent evt) {
        this.showRootCategoriesPanel();
    }

    private void m_btnBack2ActionPerformed(ActionEvent evt) {
        this.showRootCategoriesPanel();
    }

    private void m_jDown1ActionPerformed(ActionEvent evt) {
        if (!this.catHideButton) {
            this.catHideButton = true;
            this.m_jscrollcat.setVisible(false);
            this.m_jDown1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1rightarrow.png")));
            this.m_jCategories.setPreferredSize(this.m_jUp.getPreferredSize());
            this.m_jCategories.revalidate();
            this.m_jCategories.repaint();
        } else {
            this.catHideButton = false;
            this.m_jDown1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1leftarrow.png")));
            this.m_jscrollcat.setVisible(true);
            this.m_jCategories.setPreferredSize(new Dimension(275, 600));
            this.m_jCategories.revalidate();
            this.m_jCategories.repaint();
        }
    }

    class DrawingPanel
    extends JPanel {
        double[] squareSize = new double[]{1000.0, 500.0};

        DrawingPanel() {
            this.setLayout(new CardLayout());
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getSize();
            int width = dim.width - 10;
            int height = dim.height - 10;
            for (int i = 0; i < this.squareSize.length; ++i) {
                int squareWidth = (int)(this.squareSize[i] * JCatalog.this.factor);
                int x = (width - squareWidth) / 2;
                int y = (height - squareWidth) / 2;
                g.drawRect(x, y, squareWidth, squareWidth);
            }
        }
    }

    private class SmallCategoryRenderer
    extends DefaultListCellRenderer {
        private SmallCategoryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            CategoryInfo cat = (CategoryInfo)value;
            this.setText(cat.getName());
            this.setIcon(new ImageIcon(JCatalog.this.tnbcat.getThumbNail(cat.getImage())));
            return this;
        }
    }

    private class CategoriesListModel
    extends AbstractListModel {
        private List m_aCategories;

        public CategoriesListModel(List aCategories) {
            this.m_aCategories = aCategories;
        }

        @Override
        public int getSize() {
            return this.m_aCategories.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.m_aCategories.get(i);
        }
    }

    private class SelectedCategory
    implements ActionListener {
        private CategoryInfo category;

        public SelectedCategory(CategoryInfo category) {
            this.category = category;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCatalog.this.showSubcategoryPanel(this.category);
        }
    }

    private class SelectedAction
    implements ActionListener {
        private ProductInfoExt prod;

        public SelectedAction(ProductInfoExt prod) {
            this.prod = prod;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCatalog.this.fireSelectedProduct(this.prod);
        }
    }

    public class ScriptObject {
        private ProductInfoExt product;

        private ScriptObject(ProductInfoExt product) {
            this.product = product;
        }

        public Object evalScript(String code) throws ScriptException {
            ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
            script.put("product", this.product);
            return script.eval(code);
        }
    }

    public class CBDocument
    extends PlainDocument {
        private JComboBox comboBox;
        private ComboBoxModel model;
        private JTextComponent editor;
        private boolean selecting = false;

        private CBDocument(final JComboBox comboBox) {
            this.comboBox = comboBox;
            this.model = comboBox.getModel();
            this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
            KeyListener[] ks = this.editor.getKeyListeners();
            if (ks.length == 0) {
                this.editor.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        int key;
                        if (comboBox.isDisplayable()) {
                            comboBox.setPopupVisible(true);
                        }
                        if ((key = e.getKeyCode()) == 10 && JCatalog.this.jProductsCombo.getSelectedItem() != null) {
                            CBDocument.this.addSelectedItem();
                        }
                    }
                });
            }
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!CBDocument.this.selecting) {
                        CBDocument.this.highlightCompletedText(0);
                    }
                }
            });
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                this.setSelectedItem(item);
            } else {
                item = this.comboBox.getSelectedItem();
                offs -= str.length();
                this.comboBox.getToolkit().beep();
            }
            if (item != null) {
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            }
        }

        private void setText(String text) throws BadLocationException {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }

        private void highlightCompletedText(int start) {
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(this.getLength());
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.model.setSelectedItem(item);
            this.selecting = false;
        }

        private void addSelectedItem() {
            try {
                ProductInfoExt prod = new ProductInfoExt();
                prod = JCatalog.this.m_dlSales.getProductInfo(JCatalog.this.m_ProductsModel.getSelectedKey().toString());
                JCatalog.this.fireSelectedProduct(prod);
                JCatalog.this.jProductsCombo.setSelectedItem(null);
            }
            catch (Exception e2) {
                JMessageDialog.showMessage(JCatalog.this, new MessageInf(-33554432, AppLocal.getIntString("message.notactive"), e2));
            }
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Object currentItem = this.model.getElementAt(i);
                if (!this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
                return currentItem;
            }
            return null;
        }

        private boolean startsWithIgnoreCase(String str1, String str2) {
            return str1.toUpperCase().startsWith(str2.toUpperCase());
        }
    }
}

