/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.config;

import com.posics.data.gui.MessageInf;
import com.posics.data.user.DirtyManager;
import com.posics.pos.config.PanelConfig;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.util.AltEncrypter;
import com.posics.pos.util.Online;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JPanelConfigEmail
extends JPanel
implements PanelConfig {
    private DirtyManager dirty = new DirtyManager();
    private JCheckBox jCheckEmailAuth;
    private JCheckBox jCheckTLS;
    private JLabel jLblEmail;
    private JLabel jLblHost;
    private JLabel jLblPassword;
    private JLabel jLblPort;
    private JLabel jLblSendTo;
    private JPanel jPanel1;
    private JButton jTestAccount;
    private JTextField jtxtEmail;
    private JTextField jtxtHost;
    private JPasswordField jtxtPassword;
    private JTextField jtxtPort;
    private JTextField jtxtSendTo;

    public JPanelConfigEmail() {
        this.initComponents();
        this.jtxtEmail.addActionListener(this.dirty);
        this.jtxtHost.addActionListener(this.dirty);
        this.jtxtPassword.addActionListener(this.dirty);
        this.jtxtPort.addActionListener(this.dirty);
        this.jtxtSendTo.addActionListener(this.dirty);
        this.jCheckEmailAuth.addActionListener(this.dirty);
        this.jCheckTLS.addActionListener(this.dirty);
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        this.jtxtHost.setText(config.getProperty("mail.host"));
        this.jCheckTLS.setSelected(Boolean.valueOf(config.getProperty("mail.tls")));
        this.jCheckEmailAuth.setSelected(Boolean.valueOf(config.getProperty("mail.auth")));
        this.jtxtPort.setText(config.getProperty("mail.port"));
        this.jtxtEmail.setText(config.getProperty("mail.emailaddress"));
        this.jtxtPassword.setText(config.getProperty("mail.password"));
        this.jtxtSendTo.setText(config.getProperty("mail.sendto"));
        String sMailUser = config.getProperty("mail.emailaddress");
        String sMailPassword = config.getProperty("mail.password");
        if (sMailUser != null && sMailPassword != null && sMailPassword.startsWith("crypt:")) {
            AltEncrypter cypher = new AltEncrypter("cypherkey" + sMailUser);
            sMailPassword = cypher.decrypt(sMailPassword.substring(6));
        }
        this.jtxtEmail.setText(sMailUser);
        this.jtxtPassword.setText(sMailPassword);
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        config.setProperty("mail.host", this.jtxtHost.getText());
        config.setProperty("mail.tls", String.valueOf(this.jCheckTLS.isSelected()));
        config.setProperty("mail.auth", String.valueOf(this.jCheckEmailAuth.isSelected()));
        config.setProperty("mail.port", this.jtxtPort.getText());
        config.setProperty("mail.emailaddress", this.jtxtEmail.getText());
        config.setProperty("mail.sendto", this.jtxtSendTo.getText());
        AltEncrypter cypher = new AltEncrypter("cypherkey" + this.jtxtEmail.getText());
        config.setProperty("mail.password", "crypt:" + cypher.encrypt(new String(this.jtxtPassword.getPassword())));
        this.dirty.setDirty(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLblHost = new JLabel();
        this.jtxtHost = new JTextField();
        this.jLblEmail = new JLabel();
        this.jtxtEmail = new JTextField();
        this.jLblPassword = new JLabel();
        this.jLblSendTo = new JLabel();
        this.jtxtSendTo = new JTextField();
        this.jLblPort = new JLabel();
        this.jtxtPort = new JTextField();
        this.jCheckEmailAuth = new JCheckBox();
        this.jCheckTLS = new JCheckBox();
        this.jtxtPassword = new JPasswordField();
        this.jTestAccount = new JButton();
        this.setPreferredSize(new Dimension(841, 218));
        this.jLblHost.setText(AppLocal.getIntString("Label.Host"));
        this.jLblEmail.setText(AppLocal.getIntString("Label.Email"));
        this.jLblPassword.setText(AppLocal.getIntString("Label.DbPassword"));
        this.jLblSendTo.setText(AppLocal.getIntString("Label.SendTo"));
        this.jLblPort.setText(AppLocal.getIntString("Label.Port"));
        this.jCheckEmailAuth.setText(AppLocal.getIntString("Label.Authentication"));
        this.jCheckTLS.setText(AppLocal.getIntString("Label.RequireTLS"));
        this.jtxtPassword.setText("jPasswordField1");
        this.jTestAccount.setText(AppLocal.getIntString("button.testemailaccount"));
        this.jTestAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigEmail.this.jTestAccountActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblSendTo).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLblPassword, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLblHost, GroupLayout.Alignment.LEADING, -1, 130, Short.MAX_VALUE)).addComponent(this.jLblEmail, -2, 118, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jtxtPassword, -2, 403, -2).addGap(28, 28, 28).addComponent(this.jTestAccount)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckEmailAuth).addGap(18, 18, 18).addComponent(this.jCheckTLS)).addComponent(this.jtxtEmail, -2, 403, -2).addComponent(this.jtxtSendTo, -2, 403, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jtxtHost, -2, 277, -2).addGap(18, 18, 18).addComponent(this.jLblPort, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jtxtPort, -2, 59, -2))).addGap(161, 161, 161)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblHost).addComponent(this.jtxtHost, -2, 25, -2).addComponent(this.jLblPort).addComponent(this.jtxtPort, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblEmail, -2, 14, -2).addComponent(this.jtxtEmail, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblPassword).addComponent(this.jtxtPassword, -2, 28, -2).addComponent(this.jTestAccount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSendTo).addComponent(this.jtxtSendTo, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckEmailAuth).addComponent(this.jCheckTLS)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 863, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 49, Short.MAX_VALUE)));
    }

    private void jTestAccountActionPerformed(ActionEvent evt) {
        Online m_online = new Online();
        if (m_online.isConfigured()) {
            String str = m_online.TestAccount(this.jtxtHost.getText(), String.valueOf(this.jCheckTLS.isSelected()), String.valueOf(this.jCheckEmailAuth.isSelected()), this.jtxtPort.getText(), this.jtxtEmail.getText(), new String(this.jtxtPassword.getPassword()));
            if (str.equals("Success")) {
                MessageInf msg = new MessageInf(-83886080, "Account settings are validated.");
                msg.show(this);
            } else {
                MessageInf msg = new MessageInf(-16777216, "Account testing failed.", str);
                msg.show(this);
            }
        } else {
            MessageInf msg = new MessageInf(-33554432, "Complete settings.");
            msg.show(this);
        }
    }
}

