/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.config;

import com.posics.data.user.DirtyManager;
import com.posics.pos.config.PanelConfig;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.util.ReportUtils;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class JPanelConfigGeneral
extends JPanel
implements PanelConfig {
    private DirtyManager dirty = new DirtyManager();
    private JLabel jLabel11;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel13;
    private JComboBox jcboFont;
    private JComboBox jcboFontStyle;
    private JComboBox jcboLAF;
    private JComboBox jcboMachineScreenmode;
    private JComboBox jcboTicketsBag;
    private JTextField jtxtFontSize;
    private JTextField jtxtMachineHostname;
    private JTextField jtxtMachinename;

    public JPanelConfigGeneral() {
        this.initComponents();
        String[] printernames = ReportUtils.getPrintNames();
        this.jtxtMachinename.getDocument().addDocumentListener(this.dirty);
        this.jtxtMachineHostname.getDocument().addDocumentListener(this.dirty);
        this.jcboLAF.addActionListener(this.dirty);
        this.jcboMachineScreenmode.addActionListener(this.dirty);
        this.jcboTicketsBag.addActionListener(this.dirty);
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            this.jcboLAF.addItem(new LAFInfo(lafs[i].getName(), lafs[i].getClassName()));
        }
        Map skins = SubstanceLookAndFeel.getAllSkins();
        for (SkinInfo skin : skins.values()) {
            this.jcboLAF.addItem(new LAFInfo(skin.getDisplayName(), skin.getClassName()));
        }
        this.jcboLAF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.changeLAF();
            }
        });
        this.jcboFont.addItem("Default");
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            this.jcboFont.addItem(fonts[i]);
        }
        this.jcboFontStyle.addItem("Plain");
        this.jcboFontStyle.addItem("Bold");
        this.jcboMachineScreenmode.addItem("window");
        this.jcboMachineScreenmode.addItem("fullscreen");
        this.jcboTicketsBag.addItem("simple");
        this.jcboTicketsBag.addItem("standard");
        this.jcboTicketsBag.addItem("restaurant");
        this.jcboTicketsBag.addItem("delivery");
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        this.jtxtMachinename.setText(config.getProperty("machine.name"));
        this.jtxtMachineHostname.setText(config.getProperty("machine.hostname"));
        String lafclass = config.getProperty("swing.defaultlaf");
        this.jcboLAF.setSelectedItem(null);
        for (int i = 0; i < this.jcboLAF.getItemCount(); ++i) {
            LAFInfo lafinfo = (LAFInfo)this.jcboLAF.getItemAt(i);
            if (!lafinfo.getClassName().equals(lafclass)) continue;
            this.jcboLAF.setSelectedIndex(i);
            break;
        }
        this.jcboMachineScreenmode.setSelectedItem(config.getProperty("machine.screenmode"));
        this.jcboTicketsBag.setSelectedItem(config.getProperty("machine.ticketsbag"));
        this.jtxtFontSize.setText(config.getProperty("font.size"));
        this.jcboFont.setSelectedItem(config.getProperty("font.name"));
        this.jcboFontStyle.setSelectedItem(config.getProperty("font.style"));
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        config.setProperty("machine.name", this.jtxtMachinename.getText());
        config.setProperty("machine.hostname", this.jtxtMachineHostname.getText());
        config.setProperty("font.name", this.jcboFont.getSelectedItem().toString());
        config.setProperty("font.size", this.jtxtFontSize.getText());
        config.setProperty("font.style", this.jcboFontStyle.getSelectedItem().toString());
        LAFInfo laf = (LAFInfo)this.jcboLAF.getSelectedItem();
        config.setProperty("swing.defaultlaf", laf == null ? System.getProperty("swing.defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel") : laf.getClassName());
        config.setProperty("machine.screenmode", this.comboValue(this.jcboMachineScreenmode.getSelectedItem()));
        config.setProperty("machine.ticketsbag", this.comboValue(this.jcboTicketsBag.getSelectedItem()));
        this.dirty.setDirty(false);
    }

    private String comboValue(Object value) {
        return value == null ? "" : value.toString();
    }

    private void changeLAF() {
        final LAFInfo laf = (LAFInfo)this.jcboLAF.getSelectedItem();
        if (laf != null && !laf.getClassName().equals(UIManager.getLookAndFeel().getClass().getName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String lafname = laf.getClassName();
                        Object laf2 = Class.forName(lafname).newInstance();
                        if (laf2 instanceof LookAndFeel) {
                            UIManager.setLookAndFeel((LookAndFeel)laf2);
                            JPanelConfigGeneral.this.repaint();
                        } else if (laf2 instanceof SubstanceSkin) {
                            SubstanceLookAndFeel.setSkin((SubstanceSkin)((SubstanceSkin)laf2));
                            JPanelConfigGeneral.this.repaint();
                        }
                        SwingUtilities.updateComponentTreeUI(JPanelConfigGeneral.this.getTopLevelAncestor());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void initComponents() {
        this.jPanel13 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jtxtMachinename = new JTextField();
        this.jLabel2 = new JLabel();
        this.jcboLAF = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jcboMachineScreenmode = new JComboBox();
        this.jLabel16 = new JLabel();
        this.jcboTicketsBag = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jtxtMachineHostname = new JTextField();
        this.jcboFont = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jtxtFontSize = new JTextField();
        this.jLabel7 = new JLabel();
        this.jcboFontStyle = new JComboBox();
        this.jLabel5.setText(AppLocal.getIntString("Label.MachineName"));
        this.jLabel2.setText(AppLocal.getIntString("label.looknfeel"));
        this.jLabel6.setText(AppLocal.getIntString("Label.MachineScreen"));
        this.jLabel16.setText(AppLocal.getIntString("Label.Ticketsbag"));
        this.jLabel11.setText(AppLocal.getIntString("Label.MachineHostName"));
        this.jLabel3.setText(AppLocal.getIntString("label.font"));
        this.jLabel4.setText(AppLocal.getIntString("label.fontsize"));
        this.jtxtFontSize.setText("12");
        this.jLabel7.setText(AppLocal.getIntString("label.fontstyle"));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcboMachineScreenmode, -2, 165, -2)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel16, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcboTicketsBag, -2, 165, -2)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcboLAF, -2, 165, -2)).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel13Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcboFont, -2, 165, -2).addGap(18, 18, 18).addComponent(this.jLabel7, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcboFontStyle, -2, 113, -2).addGap(18, 18, 18).addComponent(this.jLabel4, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jtxtFontSize, -2, 61, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel13Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtxtMachinename, -2, 165, -2).addGap(18, 18, 18).addComponent(this.jLabel11, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtxtMachineHostname, -2, 165, -2)))).addContainerGap(348, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jtxtMachineHostname, -2, 25, -2)).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jtxtMachinename, -2, 25, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jcboTicketsBag, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jcboMachineScreenmode, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jcboLAF, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jcboFont, -2, 25, -2).addComponent(this.jLabel4).addComponent(this.jtxtFontSize, -2, 25, -2).addComponent(this.jcboFontStyle, -2, 25, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel13, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
    }

    private static class LAFInfo {
        private String name;
        private String classname;

        public LAFInfo(String name, String classname) {
            this.name = name;
            this.classname = classname;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.classname;
        }

        public String toString() {
            return this.name;
        }
    }
}

