/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.config;

import com.posics.basic.BasicException;
import com.posics.data.gui.JMessageDialog;
import com.posics.data.gui.MessageInf;
import com.posics.pos.config.JPanelConfigDatabase;
import com.posics.pos.config.JPanelConfigEmail;
import com.posics.pos.config.JPanelConfigGeneral;
import com.posics.pos.config.JPanelConfigLocale;
import com.posics.pos.config.JPanelConfigPayment;
import com.posics.pos.config.JPanelConfigPeripheral;
import com.posics.pos.config.PanelConfig;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.JPanelView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;

public class JPanelConfiguration
extends JPanel
implements JPanelView {
    private List<PanelConfig> m_panelconfig;
    private AppConfig config;
    private JPanel jPanelDatabase;
    private JPanel jPanelEmail;
    private JPanel jPanelGeneral;
    private JPanel jPanelLocale;
    private JPanel jPanelPayment;
    private JPanel jPanelPeripherals;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JButton jbtnCancel;
    private JButton jbtnRestore;
    private JButton jbtnSave;

    public JPanelConfiguration(AppView oApp) {
        this(oApp.getProperties());
    }

    public JPanelConfiguration(AppProperties props) {
        this.config = new AppConfig(props.getConfigFile());
        this.initComponents();
        this.m_panelconfig = new ArrayList<PanelConfig>();
        JPanel panel = new JPanelConfigDatabase();
        this.m_panelconfig.add((PanelConfig)((Object)panel));
        this.jPanelDatabase.add(panel.getConfigComponent());
        panel = new JPanelConfigGeneral();
        this.m_panelconfig.add((PanelConfig)((Object)panel));
        this.jPanelGeneral.add(panel.getConfigComponent());
        panel = new JPanelConfigPeripheral();
        this.m_panelconfig.add((PanelConfig)((Object)panel));
        this.jPanelPeripherals.add(panel.getConfigComponent());
        panel = new JPanelConfigLocale();
        this.m_panelconfig.add((PanelConfig)((Object)panel));
        this.jPanelLocale.add(panel.getConfigComponent());
        panel = new JPanelConfigEmail();
        this.m_panelconfig.add((PanelConfig)((Object)panel));
        this.jPanelEmail.add(panel.getConfigComponent());
        panel = new JPanelConfigPayment();
        this.m_panelconfig.add((PanelConfig)((Object)panel));
        this.jPanelPayment.add(panel.getConfigComponent());
    }

    private void restoreProperties() {
        if (this.config.delete()) {
            this.loadProperties();
        } else {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.cannotdeleteconfig")));
        }
    }

    private void loadProperties() {
        this.config.load();
        for (PanelConfig c : this.m_panelconfig) {
            c.loadProperties(this.config);
        }
    }

    private void saveProperties() {
        for (PanelConfig c : this.m_panelconfig) {
            c.saveProperties(this.config);
        }
        try {
            this.config.save();
            JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.restartchanges"), AppLocal.getIntString("message.title"), 1);
        }
        catch (IOException e) {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.cannotsaveconfig"), e));
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.Configuration");
    }

    @Override
    public void activate() throws BasicException {
        this.loadProperties();
    }

    @Override
    public boolean deactivate() {
        boolean haschanged = false;
        for (PanelConfig c : this.m_panelconfig) {
            if (!c.hasChanged()) continue;
            haschanged = true;
        }
        if (haschanged) {
            int res = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannasave"), AppLocal.getIntString("title.editor"), 1, 3);
            if (res == 0) {
                this.saveProperties();
                return true;
            }
            return res == 1;
        }
        return true;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelDatabase = new JPanel();
        this.jPanelGeneral = new JPanel();
        this.jPanelPeripherals = new JPanel();
        this.jPanelLocale = new JPanel();
        this.jPanelEmail = new JPanel();
        this.jPanelPayment = new JPanel();
        this.jbtnCancel = new JButton();
        this.jbtnRestore = new JButton();
        this.jbtnSave = new JButton();
        this.jPanelDatabase.setLayout(new BoxLayout(this.jPanelDatabase, 2));
        this.jTabbedPane1.addTab("Database", this.jPanelDatabase);
        this.jPanelDatabase.getAccessibleContext().setAccessibleName("");
        this.jPanelGeneral.setLayout(new BoxLayout(this.jPanelGeneral, 2));
        this.jTabbedPane1.addTab("General", this.jPanelGeneral);
        this.jPanelPeripherals.setLayout(new BoxLayout(this.jPanelPeripherals, 2));
        this.jTabbedPane1.addTab("Peripherals", this.jPanelPeripherals);
        this.jPanelLocale.setLayout(new BoxLayout(this.jPanelLocale, 2));
        this.jTabbedPane1.addTab("Locale", this.jPanelLocale);
        this.jPanelEmail.setLayout(new BoxLayout(this.jPanelEmail, 2));
        this.jTabbedPane1.addTab("Email", this.jPanelEmail);
        this.jPanelPayment.setLayout(new BoxLayout(this.jPanelPayment, 2));
        this.jTabbedPane1.addTab("Payment", this.jPanelPayment);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.jbtnCancel.setText(AppLocal.getIntString("Button.Restore"));
        this.jbtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jbtnCancelActionPerformed(evt);
            }
        });
        this.jbtnRestore.setText(AppLocal.getIntString("Button.Factory"));
        this.jbtnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jbtnRestoreActionPerformed(evt);
            }
        });
        this.jbtnSave.setText(AppLocal.getIntString("Button.Save"));
        this.jbtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jbtnSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jbtnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnRestore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbtnCancel, -2, 25, -2).addComponent(this.jbtnRestore, -2, 25, -2).addComponent(this.jbtnSave, -2, 25, -2)).addContainerGap()));
    }

    private void jbtnCancelActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.configrestore"), AppLocal.getIntString("message.title"), 0, 3) == 0) {
            this.loadProperties();
        }
    }

    private void jbtnRestoreActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.configfactory"), AppLocal.getIntString("message.title"), 0, 3) == 0) {
            this.restoreProperties();
        }
    }

    private void jbtnSaveActionPerformed(ActionEvent evt) {
        this.saveProperties();
    }
}

