/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.customers;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializerRead;
import com.posics.format.Formats;
import java.util.Date;

public class CustomerDiary {
    private int m_iTicketId;
    private Date m_dDate;
    private String m_sPayment;
    private Double m_dAmount;

    public CustomerDiary(Date tdate, int id, String ptype, Double tamount) {
        this.m_iTicketId = id;
        this.m_dDate = tdate;
        this.m_sPayment = ptype;
        this.m_dAmount = tamount;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new CustomerDiary(dr.getTimestamp(1), dr.getInt(2), dr.getString(3), dr.getDouble(4));
            }
        };
    }

    public int getId() {
        return this.m_iTicketId;
    }

    public Date getDate() {
        return this.m_dDate;
    }

    public String getPaymentType() {
        return this.m_sPayment;
    }

    public Double getAmount() {
        return this.m_dAmount;
    }

    public String printDate() {
        return Formats.TIMESTAMP.formatValue(this.m_dDate);
    }

    public String printAmount() {
        return Formats.CURRENCY.formatValue(this.m_dAmount);
    }
}

