/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.customers;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializerRead;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerAddress;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.util.RoundUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CustomerInfoExt
extends CustomerInfo {
    private static final long serialVersionUID = 8554691273036L;
    protected String taxcustomerid;
    protected String notes;
    protected boolean visible;
    protected String card;
    protected Double maxdebt;
    protected Date curdate;
    protected Date advancedate;
    protected Double curdebt;
    protected Double curadvance;
    protected String firstname;
    protected String lastname;
    protected String email;
    protected String phone;
    protected String phone2;
    protected String fax;
    protected String address;
    protected String address2;
    protected String deliveryAddress;
    protected String postal;
    protected String city;
    protected String region;
    protected String country;
    protected Double points;
    protected Double pointsEarned = 0.0;
    protected List<CustomerAddress> m_aAddresses = new ArrayList<CustomerAddress>();

    public CustomerInfoExt(String id) {
        super(id);
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CustomerInfoExt customer = new CustomerInfoExt(dr.getString(1));
                customer.taxid = dr.getString(2);
                customer.searchkey = dr.getString(3);
                customer.name = dr.getString(4);
                customer.address = dr.getString(5);
                customer.address2 = dr.getString(6);
                customer.phone = dr.getString(7);
                customer.phone = dr.getString(8);
                return customer;
            }
        };
    }

    public String getTaxCustCategoryID() {
        return this.taxcustomerid;
    }

    public void setTaxCustomerID(String taxcustomerid) {
        this.taxcustomerid = taxcustomerid;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public Double getMaxdebt() {
        return this.maxdebt;
    }

    public String printMaxDebt() {
        return Formats.CURRENCY.formatValue(RoundUtils.getValue(this.getMaxdebt()));
    }

    public void setMaxdebt(Double maxdebt) {
        this.maxdebt = maxdebt;
    }

    public Date getCurdate() {
        return this.curdate;
    }

    public Date getAdvanceDate() {
        return this.advancedate;
    }

    public void setCurdate(Date curdate) {
        this.curdate = curdate;
    }

    public void setAdvanceDate(Date curdate) {
        this.advancedate = curdate;
    }

    public Double getCurdebt() {
        return this.curdebt;
    }

    public Double getCurAdvance() {
        return this.curadvance;
    }

    public String printCurDebt() {
        return Formats.CURRENCY.formatValue(RoundUtils.getValue(this.getCurdebt()));
    }

    public String printCurAdvance() {
        return Formats.CURRENCY.formatValue(RoundUtils.getValue(Math.abs(this.getCurAdvance())));
    }

    public void setCurdebt(Double curdebt) {
        this.curdebt = curdebt;
    }

    public void setCurAdvance(Double curadv) {
        this.curadvance = curadv;
    }

    public void updateCurDebt(Double amount, Date d) {
        this.curdebt = this.curdebt == null ? amount : this.curdebt + amount;
        if (RoundUtils.compare(this.curdebt, 0.0) > 0) {
            this.curdate = d;
        } else if (RoundUtils.compare(this.curdebt, 0.0) == 0) {
            this.curdebt = 0.0;
            this.curdate = d;
        } else {
            this.curdate = null;
        }
    }

    public void updateCurAdvance(Double amount, Date d) {
        this.curadvance = this.curadvance == null ? amount : this.curadvance + amount;
        if (RoundUtils.compare(this.curadvance, 0.0) == 0) {
            this.curadvance = 0.0;
            this.advancedate = d;
        } else {
            this.advancedate = d;
        }
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPhone2() {
        return this.phone2;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(String address2) {
        this.deliveryAddress = address2;
    }

    public String getPostal() {
        return this.postal;
    }

    public void setPostal(String postal) {
        this.postal = postal;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public double getPoints() {
        return this.points;
    }

    public void setPoints(double points) {
        this.points = points;
    }

    public double getPointsEarned() {
        return this.pointsEarned;
    }

    public void setPointsEarned(double pointsEarned) {
        this.pointsEarned = pointsEarned;
    }

    public double getTotalPoints() {
        return this.pointsEarned + this.points;
    }

    public String printPoints() {
        return Formats.CURRENCY.formatValue(this.points);
    }

    public String printPointsEarned() {
        return Formats.CURRENCY.formatValue(this.pointsEarned);
    }

    public String printTotalPoints() {
        return Formats.CURRENCY.formatValue(this.pointsEarned + this.points);
    }

    public void addAddress(CustomerAddress address) {
        this.m_aAddresses.add(address);
    }

    public List<CustomerAddress> getAddresses() {
        return this.m_aAddresses;
    }

    public void setAddresses(List<CustomerAddress> l) {
        this.m_aAddresses = l;
    }
}

