/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.customers;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataParams;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.QBFBuilder;
import com.posics.data.loader.SentenceExec;
import com.posics.data.loader.SentenceExecTransaction;
import com.posics.data.loader.SentenceList;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadBasic;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteBasic;
import com.posics.data.loader.SerializerWriteBasicExt;
import com.posics.data.loader.SerializerWriteParams;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.data.loader.TableDefinition;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerDiary;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.BeanFactoryDataSingle;
import java.util.List;

public class DataLogicCustomers
extends BeanFactoryDataSingle {
    protected Session s;
    private TableDefinition tcustomers;
    private static Datas[] customerdatas = new Datas[]{Datas.STRING, Datas.TIMESTAMP, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.INT, Datas.BOOLEAN, Datas.STRING};

    @Override
    public void init(Session s) {
        this.s = s;
        this.tcustomers = new TableDefinition(s, "CUSTOMERS", new String[]{"ID", "TAXID", "SEARCHKEY", "NAME", "NOTES", "VISIBLE", "CARD", "MAXDEBT", "CURDATE", "CURDEBT", "FIRSTNAME", "LASTNAME", "EMAIL", "PHONE", "PHONE2", "FAX", "ADDRESS", "ADDRESS2", "POSTAL", "CITY", "REGION", "COUNTRY", "TAXCATEGORY", "POINTS"}, new String[]{"ID", AppLocal.getIntString("label.taxid"), AppLocal.getIntString("label.searchkey"), AppLocal.getIntString("label.name"), AppLocal.getIntString("label.notes"), "VISIBLE", "CARD", AppLocal.getIntString("label.maxdebt"), AppLocal.getIntString("label.curdate"), AppLocal.getIntString("label.curdebt"), AppLocal.getIntString("label.firstname"), AppLocal.getIntString("label.lastname"), AppLocal.getIntString("label.email"), AppLocal.getIntString("label.phone"), AppLocal.getIntString("label.phone2"), AppLocal.getIntString("label.fax"), AppLocal.getIntString("label.address"), AppLocal.getIntString("label.address2"), AppLocal.getIntString("label.postal"), AppLocal.getIntString("label.city"), AppLocal.getIntString("label.region"), AppLocal.getIntString("label.country"), "TAXCATEGORY", "POINTS"}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.BOOLEAN, Datas.STRING, Datas.DOUBLE, Datas.TIMESTAMP, Datas.DOUBLE, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.DOUBLE}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.BOOLEAN, Formats.STRING, Formats.CURRENCY, Formats.TIMESTAMP, Formats.CURRENCY, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.DOUBLE}, new int[]{0});
    }

    public SentenceList getCustomerList() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT ID, TAXID, SEARCHKEY, NAME, ADDRESS, ADDRESS2 FROM CUSTOMERS WHERE VISIBLE = " + this.s.DB.TRUE() + " AND ?(QBF_FILTER) ORDER BY NAME", new String[]{"SEARCHKEY", "NAME", "ADDRESS", "ADDRESS2"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CustomerInfoExt c = new CustomerInfoExt(dr.getString(1));
                c.setTaxid(dr.getString(2));
                c.setSearchkey(dr.getString(3));
                c.setName(dr.getString(4));
                c.setAddress(dr.getString(5));
                c.setAddress2(dr.getString(6));
                return c;
            }
        });
    }

    public int updateCustomerExt(final CustomerInfoExt customer) throws BasicException {
        return new PreparedSentence(this.s, "UPDATE CUSTOMERS SET NOTES = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, customer.getNotes());
                this.setString(2, customer.getId());
            }
        });
    }

    public int saveNewCustomer(final String searchkey, final String custname, final String address, final String address2) throws BasicException {
        return new PreparedSentence(this.s, "INSERT INTO CUSTOMERS (ID, SEARCHKEY, NAME, ADDRESS, ADDRESS2) VALUES(?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, searchkey);
                this.setString(2, searchkey);
                this.setString(3, custname);
                this.setString(4, address);
                this.setString(5, address2);
            }
        });
    }

    public int saveCustomer(final String custid, final String searchkey, final String custname, final String address, final String address2) throws BasicException {
        return new PreparedSentence(this.s, "UPDATE CUSTOMERS SET SEARCHKEY=? , NAME=?, ADDRESS=?, ADDRESS2=? WHERE ID=?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, searchkey);
                this.setString(2, custname);
                this.setString(3, address);
                this.setString(4, address2);
                this.setString(5, custid);
            }
        });
    }

    public final SentenceList getReservationsList() {
        return new PreparedSentence(this.s, "SELECT R.ID, R.CREATED, R.DATENEW, C.CUSTOMER, CUSTOMERS.TAXID, CUSTOMERS.SEARCHKEY, COALESCE(CUSTOMERS.NAME, R.TITLE),  R.CHAIRS, R.ISDONE, R.DESCRIPTION FROM RESERVATIONS R LEFT OUTER JOIN RESERVATION_CUSTOMERS C ON R.ID = C.ID LEFT OUTER JOIN CUSTOMERS ON C.CUSTOMER = CUSTOMERS.ID WHERE date(R.DATENEW) = date(?)", new SerializerWriteBasic(Datas.TIMESTAMP), new SerializerReadBasic(customerdatas));
    }

    public final SentenceExec getReservationsUpdate() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicCustomers.this.s, "DELETE FROM RESERVATION_CUSTOMERS WHERE ID = ?", new SerializerWriteBasicExt(customerdatas, new int[]{0})).exec(params);
                if (((Object[])params)[3] != null) {
                    new PreparedSentence(DataLogicCustomers.this.s, "INSERT INTO RESERVATION_CUSTOMERS (ID, CUSTOMER) VALUES (?, ?)", new SerializerWriteBasicExt(customerdatas, new int[]{0, 3})).exec(params);
                }
                return new PreparedSentence(DataLogicCustomers.this.s, "UPDATE RESERVATIONS SET ID = ?, CREATED = ?, DATENEW = ?, TITLE = ?, CHAIRS = ?, ISDONE = ?, DESCRIPTION = ? WHERE ID = ?", new SerializerWriteBasicExt(customerdatas, new int[]{0, 1, 2, 6, 7, 8, 9, 0})).exec(params);
            }
        };
    }

    public final SentenceExec getReservationsDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicCustomers.this.s, "DELETE FROM RESERVATION_CUSTOMERS WHERE ID = ?", new SerializerWriteBasicExt(customerdatas, new int[]{0})).exec(params);
                return new PreparedSentence(DataLogicCustomers.this.s, "DELETE FROM RESERVATIONS WHERE ID = ?", new SerializerWriteBasicExt(customerdatas, new int[]{0})).exec(params);
            }
        };
    }

    public final SentenceExec getReservationsInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int i = new PreparedSentence(DataLogicCustomers.this.s, "INSERT INTO RESERVATIONS (ID, CREATED, DATENEW, TITLE, CHAIRS, ISDONE, DESCRIPTION) VALUES (?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(customerdatas, new int[]{0, 1, 2, 6, 7, 8, 9})).exec(params);
                if (((Object[])params)[3] != null) {
                    new PreparedSentence(DataLogicCustomers.this.s, "INSERT INTO RESERVATION_CUSTOMERS (ID, CUSTOMER) VALUES (?, ?)", new SerializerWriteBasicExt(customerdatas, new int[]{0, 3})).exec(params);
                }
                return i;
            }
        };
    }

    public final TableDefinition getTableCustomers() {
        return this.tcustomers;
    }

    public final List<CustomerDiary> getCustomerDiary(String custid, String datefrom, String dateto) throws BasicException {
        if (datefrom != null && dateto != null) {
            return new PreparedSentence(this.s, "SELECT RECEIPTS.DATENEW, TICKETS.TICKETID, PAYMENTS.PAYMENT, PAYMENTS.TOTAL FROM RECEIPTS, TICKETS, CUSTOMERS, PAYMENTS WHERE RECEIPTS.ID = TICKETS.ID AND RECEIPTS.ID = PAYMENTS.RECEIPT AND TICKETS.CUSTOMER = CUSTOMERS.ID  AND CUSTOMERS.ID = '" + custid + "' AND RECEIPTS.DATENEW >= '" + datefrom + "' AND RECEIPTS.DATENEW <= '" + dateto + "'  ORDER BY RECEIPTS.DATENEW ", null, CustomerDiary.getSerializerRead()).list();
        }
        if (datefrom != null) {
            return new PreparedSentence(this.s, "SELECT RECEIPTS.DATENEW, TICKETS.TICKETID, PAYMENTS.PAYMENT, PAYMENTS.TOTAL FROM RECEIPTS, TICKETS, CUSTOMERS, PAYMENTS WHERE RECEIPTS.ID = TICKETS.ID AND RECEIPTS.ID = PAYMENTS.RECEIPT AND TICKETS.CUSTOMER = CUSTOMERS.ID  AND CUSTOMERS.ID = '" + custid + "' AND RECEIPTS.DATENEW >= '" + datefrom + "'  ORDER BY RECEIPTS.DATENEW ", null, CustomerDiary.getSerializerRead()).list();
        }
        return new PreparedSentence(this.s, "SELECT RECEIPTS.DATENEW, TICKETS.TICKETID, PAYMENTS.PAYMENT, PAYMENTS.TOTAL FROM RECEIPTS, TICKETS, CUSTOMERS, PAYMENTS WHERE RECEIPTS.ID = TICKETS.ID AND RECEIPTS.ID = PAYMENTS.RECEIPT AND TICKETS.CUSTOMER = CUSTOMERS.ID  AND CUSTOMERS.ID = '" + custid + "'  ORDER BY RECEIPTS.DATENEW ", null, CustomerDiary.getSerializerRead()).list();
    }
}

