/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.customers;

import com.posics.basic.BasicException;
import com.posics.data.loader.QBFCompareEnum;
import com.posics.data.user.EditorCreator;
import com.posics.data.user.ListProvider;
import com.posics.data.user.ListProviderCreator;
import com.posics.editor.JEditorKB;
import com.posics.editor.JEditorStringKB;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.customers.CustomerRenderer;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.forms.AppLocal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JCustomerFinder
extends JDialog
implements EditorCreator {
    private CustomerInfo selectedCustomer;
    private ListProvider lpr;
    private DataLogicCustomers dlcustomers;
    private JButton jBtnSave;
    private JButton jButton1;
    private JButton jButton3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList jListCustomers;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JButton jcmdCancel;
    private JButton jcmdOK;
    private JEditorKB m_jKeys;
    private JEditorStringKB m_jtxtAddress1;
    private JEditorStringKB m_jtxtAddress2;
    private JEditorStringKB m_jtxtName;
    private JEditorStringKB m_jtxtSearchKey;

    private JCustomerFinder(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JCustomerFinder(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    public static JCustomerFinder getCustomerFinder(Component parent, DataLogicCustomers dlCustomers) {
        Window window = JCustomerFinder.getWindow(parent);
        JCustomerFinder myMsg = window instanceof Frame ? new JCustomerFinder((Frame)window, true) : new JCustomerFinder((Dialog)window, true);
        myMsg.init(dlCustomers);
        myMsg.applyComponentOrientation(parent.getComponentOrientation());
        return myMsg;
    }

    public CustomerInfo getSelectedCustomer() {
        return this.selectedCustomer;
    }

    private void init(DataLogicCustomers dlCustomers) {
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.dlcustomers = dlCustomers;
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
        this.m_jtxtSearchKey.addEditorKeys(this.m_jKeys);
        this.m_jtxtName.addEditorKeys(this.m_jKeys);
        this.m_jtxtAddress1.addEditorKeys(this.m_jKeys);
        this.m_jtxtAddress2.addEditorKeys(this.m_jKeys);
        this.m_jtxtSearchKey.reset();
        this.m_jtxtName.reset();
        this.m_jtxtAddress1.reset();
        this.m_jtxtAddress2.reset();
        this.m_jtxtSearchKey.activate();
        this.lpr = new ListProviderCreator(dlCustomers.getCustomerList(), this);
        this.jListCustomers.setCellRenderer(new CustomerRenderer());
        this.getRootPane().setDefaultButton(this.jcmdOK);
        this.selectedCustomer = null;
        this.m_jtxtName.activate();
    }

    public void setSearchKey(String searchkey) {
        this.m_jtxtSearchKey.setText(searchkey);
    }

    public void search(CustomerInfo customer) {
        if (customer == null || customer.getName() == null || customer.getName().equals("")) {
            this.m_jtxtSearchKey.reset();
            this.m_jtxtName.reset();
            this.m_jtxtAddress1.reset();
            this.m_jtxtAddress2.reset();
            this.m_jtxtSearchKey.activate();
            this.cleanSearch();
        } else {
            this.selectedCustomer = customer;
            this.m_jtxtSearchKey.setText(customer.getSearchkey());
            this.m_jtxtName.setText(customer.getName());
            this.m_jtxtAddress1.setText(((CustomerInfoExt)customer).getAddress());
            this.m_jtxtAddress2.setText(((CustomerInfoExt)customer).getAddress2());
            this.m_jtxtSearchKey.activate();
            this.executeSearch();
        }
    }

    private void cleanSearch() {
        this.jListCustomers.setModel(new MyListData(new ArrayList()));
    }

    public void executeSearch() {
        try {
            this.jListCustomers.setModel(new MyListData(this.lpr.loadData()));
            if (this.jListCustomers.getModel().getSize() > 0) {
                this.jListCustomers.setSelectedIndex(0);
                this.selectedCustomer = (CustomerInfo)this.jListCustomers.getSelectedValue();
            }
        }
        catch (BasicException e) {
            e.printStackTrace();
        }
    }

    public void saveCustomer() {
        try {
            this.dlcustomers.saveCustomer(this.selectedCustomer.getId(), this.m_jtxtSearchKey.getText(), this.m_jtxtName.getText(), this.m_jtxtAddress1.getText(), this.m_jtxtAddress2.getText());
        }
        catch (BasicException e) {
            e.printStackTrace();
        }
    }

    public void saveNewCustomer() {
        try {
            this.dlcustomers.saveNewCustomer(this.m_jtxtSearchKey.getText(), this.m_jtxtName.getText(), this.m_jtxtAddress1.getText(), this.m_jtxtAddress2.getText());
        }
        catch (BasicException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] afilter = new Object[10];
        if (this.m_jtxtSearchKey.getText() == null || this.m_jtxtSearchKey.getText().equals("")) {
            afilter[0] = QBFCompareEnum.COMP_NONE;
            afilter[1] = null;
        } else {
            afilter[0] = QBFCompareEnum.COMP_RE;
            afilter[1] = "%" + this.m_jtxtSearchKey.getText() + "%";
        }
        if (this.m_jtxtName.getText() == null || this.m_jtxtName.getText().equals("")) {
            afilter[2] = QBFCompareEnum.COMP_NONE;
            afilter[3] = null;
        } else {
            afilter[2] = QBFCompareEnum.COMP_RE;
            afilter[3] = "%" + this.m_jtxtName.getText() + "%";
        }
        if (this.m_jtxtAddress1.getText() == null || this.m_jtxtAddress1.getText().equals("")) {
            afilter[4] = QBFCompareEnum.COMP_NONE;
            afilter[5] = null;
        } else {
            afilter[4] = QBFCompareEnum.COMP_RE;
            afilter[5] = "%" + this.m_jtxtAddress1.getText() + "%";
        }
        if (this.m_jtxtAddress2.getText() == null || this.m_jtxtAddress2.getText().equals("")) {
            afilter[6] = QBFCompareEnum.COMP_NONE;
            afilter[7] = null;
        } else {
            afilter[6] = QBFCompareEnum.COMP_RE;
            afilter[7] = "%" + this.m_jtxtAddress2.getText() + "%";
        }
        return afilter;
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JCustomerFinder.getWindow(parent.getParent());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.m_jKeys = new JEditorKB();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.m_jtxtSearchKey = new JEditorStringKB();
        this.m_jtxtName = new JEditorStringKB();
        this.m_jtxtAddress1 = new JEditorStringKB();
        this.jLabel9 = new JLabel();
        this.m_jtxtAddress2 = new JEditorStringKB();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jBtnSave = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListCustomers = new JList();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jcmdOK = new JButton();
        this.jcmdCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("form.customertitle"));
        this.jPanel2.setMaximumSize(new Dimension(284, 283));
        this.jPanel2.setMinimumSize(new Dimension(450, 235));
        this.jPanel2.setPreferredSize(new Dimension(450, 235));
        this.m_jKeys.setMinimumSize(new Dimension(450, 235));
        this.jPanel2.add(this.m_jKeys);
        this.getContentPane().add((Component)this.jPanel2, "After");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel5.setPreferredSize(new Dimension(384, 210));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel7.setPreferredSize(new Dimension(384, 150));
        this.jLabel5.setText(AppLocal.getIntString("label.prodname"));
        this.jLabel6.setText(AppLocal.getIntString("label.searchkey"));
        this.jLabel8.setText(AppLocal.getIntString("label.address"));
        this.jLabel9.setText(AppLocal.getIntString("label.address2"));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtName, -1, -1, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtSearchKey, -2, 216, -2)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel8, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtAddress1, -1, -1, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel9, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtAddress2, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.m_jtxtSearchKey, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.m_jtxtName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.m_jtxtAddress1, -2, 45, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.m_jtxtAddress2, -2, 45, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.add((Component)this.jPanel7, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/reset.png")));
        this.jButton1.setText(AppLocal.getIntString("button.clean"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton1);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/launch.png")));
        this.jButton3.setText(AppLocal.getIntString("button.search"));
        this.jButton3.setRequestFocusEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton3);
        this.jBtnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/filesave.png")));
        this.jBtnSave.setText(AppLocal.getIntString("Button.Save"));
        this.jBtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jBtnSaveActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jBtnSave);
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel3.add((Component)this.jPanel5, "First");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.jListCustomers.setRequestFocusEnabled(false);
        this.jListCustomers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JCustomerFinder.this.jListCustomersMouseClicked(evt);
            }
        });
        this.jListCustomers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JCustomerFinder.this.jListCustomersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListCustomers);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel8.setLayout(new BorderLayout());
        this.jcmdOK.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.jcmdOK.setText(AppLocal.getIntString("Button.OK"));
        this.jcmdOK.setEnabled(false);
        this.jcmdOK.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdOK.setRequestFocusEnabled(false);
        this.jcmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jcmdOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdOK);
        this.jcmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.jcmdCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.jcmdCancel.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdCancel.setRequestFocusEnabled(false);
        this.jcmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jcmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdCancel);
        this.jPanel8.add((Component)this.jPanel1, "After");
        this.jPanel3.add((Component)this.jPanel8, "South");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.setSize(new Dimension(840, 610));
        this.setLocationRelativeTo(null);
    }

    private void jcmdOKActionPerformed(ActionEvent evt) {
        this.selectedCustomer = (CustomerInfo)this.jListCustomers.getSelectedValue();
        this.dispose();
    }

    private void jcmdCancelActionPerformed(ActionEvent evt) {
        this.selectedCustomer = null;
        this.dispose();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.executeSearch();
    }

    private void jListCustomersValueChanged(ListSelectionEvent evt) {
        this.jcmdOK.setEnabled(this.jListCustomers.getSelectedValue() != null);
    }

    private void jListCustomersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selectedCustomer = (CustomerInfo)this.jListCustomers.getSelectedValue();
            this.dispose();
        } else {
            this.selectedCustomer = (CustomerInfo)this.jListCustomers.getSelectedValue();
            this.m_jtxtSearchKey.setText(((CustomerInfoExt)this.jListCustomers.getSelectedValue()).getSearchkey());
            this.m_jtxtName.setText(((CustomerInfoExt)this.jListCustomers.getSelectedValue()).getName());
            this.m_jtxtAddress1.setText(((CustomerInfoExt)this.jListCustomers.getSelectedValue()).getAddress());
            this.m_jtxtAddress2.setText(((CustomerInfoExt)this.jListCustomers.getSelectedValue()).getAddress2());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.m_jtxtSearchKey.reset();
        this.m_jtxtName.reset();
        this.m_jtxtAddress1.reset();
        this.m_jtxtAddress2.reset();
        this.selectedCustomer = null;
        this.m_jtxtSearchKey.activate();
        this.cleanSearch();
    }

    private void jBtnSaveActionPerformed(ActionEvent evt) {
        if (this.selectedCustomer != null) {
            this.saveCustomer();
        } else if (this.m_jtxtName.getText() != null && this.m_jtxtSearchKey.getText() != null) {
            this.saveNewCustomer();
        }
        this.executeSearch();
    }

    private static class MyListData
    extends AbstractListModel {
        private List m_data;

        public MyListData(List data) {
            this.m_data = data;
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_data.get(index);
        }

        @Override
        public int getSize() {
            return this.m_data.size();
        }
    }
}

