/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.pos.forms.AppProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public class AppConfig
implements AppProperties {
    private static Logger logger = Logger.getLogger("com.posics.pos.forms.AppConfig");
    private Properties m_propsconfig;
    private File configfile;

    public AppConfig(String[] args) {
        if (args.length == 0) {
            this.init(this.getDefaultConfig());
        } else {
            this.init(new File(args[0]));
        }
    }

    public AppConfig(File configfile) {
        this.init(configfile);
    }

    private void init(File configfile) {
        this.configfile = configfile;
        this.m_propsconfig = new Properties();
        logger.info("Reading configuration file: " + configfile.getAbsolutePath());
    }

    private File getDefaultConfig() {
        return new File(new File(System.getProperty("user.home")), "SaleculatorPDA.properties");
    }

    @Override
    public String getProperty(String sKey) {
        return this.m_propsconfig.getProperty(sKey);
    }

    @Override
    public String getHost() {
        return this.getProperty("machine.hostname");
    }

    @Override
    public String getReceiptHost() {
        return this.getProperty("machine.receipthost");
    }

    @Override
    public String getMachineName() {
        return this.getProperty("machine.name");
    }

    @Override
    public File getConfigFile() {
        return this.configfile;
    }

    @Override
    public void setProperty(String sKey, String sValue) {
        if (sValue == null) {
            this.m_propsconfig.remove(sKey);
        } else {
            this.m_propsconfig.setProperty(sKey, sValue);
        }
    }

    private String getLocalHostName() {
        return "PDA01";
    }

    private String getHostName() {
        return "SALECULATOR";
    }

    public boolean delete() {
        this.loadDefault();
        return this.configfile.delete();
    }

    public void load() {
        this.loadDefault();
        try {
            FileInputStream in = new FileInputStream(this.configfile);
            if (in != null) {
                this.m_propsconfig.load(in);
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            this.loadDefault();
        }
    }

    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.configfile);
        if (out != null) {
            this.m_propsconfig.store(out, "Saleculator PDA. Configuration file.");
            ((OutputStream)out).close();
        }
    }

    private void loadDefault() {
        this.m_propsconfig = new Properties();
        String dirname = System.getProperty("dirname.path");
        dirname = dirname == null ? "./" : dirname;
        this.m_propsconfig.setProperty("db.driverlib", new File(new File(dirname), "lib/mysql-connector-java-5.1.7-bin.jar").getAbsolutePath());
        this.m_propsconfig.setProperty("db.driver", "com.mysql.jdbc.Driver");
        this.m_propsconfig.setProperty("db.URL", "jdbc:mysql://192.168.1.99:3306/SALECULATOR?characterEncoding=utf8");
        this.m_propsconfig.setProperty("db.user", "root");
        this.m_propsconfig.setProperty("db.password", "password");
        this.m_propsconfig.setProperty("db.URL2", "");
        this.m_propsconfig.setProperty("db.user2", "root");
        this.m_propsconfig.setProperty("db.password2", "password");
        this.m_propsconfig.setProperty("db.URL3", "");
        this.m_propsconfig.setProperty("db.user3", "root");
        this.m_propsconfig.setProperty("db.password3", "password");
        this.m_propsconfig.setProperty("machine.hostname", this.getHostName());
        this.m_propsconfig.setProperty("machine.name", this.getLocalHostName());
        this.m_propsconfig.setProperty("machine.receipthost", "");
        this.m_propsconfig.setProperty("machine.keepalive", "false");
        Locale l = Locale.getDefault();
        this.m_propsconfig.setProperty("user.language", "en");
        this.m_propsconfig.setProperty("user.country", "IN");
        this.m_propsconfig.setProperty("user.variant", l.getVariant());
        this.m_propsconfig.setProperty("format.currency", "#0.00");
        this.m_propsconfig.setProperty("swing.defaultlaf", System.getProperty("swing.defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel"));
        this.m_propsconfig.setProperty("font.name", "Default");
        this.m_propsconfig.setProperty("font.style", "Bold");
        this.m_propsconfig.setProperty("font.size", "12");
        this.m_propsconfig.setProperty("machine.printer", "epson:file,/dev/usb/lp0");
        this.m_propsconfig.setProperty("machine.printer.2", "epson:file,/dev/usb/lp0");
        this.m_propsconfig.setProperty("machine.printer.3", "screen");
        this.m_propsconfig.setProperty("machine.printer.4", "screen");
        this.m_propsconfig.setProperty("machine.printer.5", "screen");
        this.m_propsconfig.setProperty("machine.printer.6", "screen");
        this.m_propsconfig.setProperty("machine.display", "screen");
        this.m_propsconfig.setProperty("machine.scale", "Not defined");
        this.m_propsconfig.setProperty("machine.screenmode", "fullscreen");
        this.m_propsconfig.setProperty("machine.ticketsbag", "standard");
        this.m_propsconfig.setProperty("machine.scanner", "Not defined");
        this.m_propsconfig.setProperty("telephone.vendor", "50635");
        this.m_propsconfig.setProperty("telephone.product", "2");
        this.m_propsconfig.setProperty("telephone.device", "1");
        this.m_propsconfig.setProperty("telephone.version", "2");
        this.m_propsconfig.setProperty("payment.gateway", "external");
        this.m_propsconfig.setProperty("payment.magcardreader", "Not defined");
        this.m_propsconfig.setProperty("payment.testmode", "false");
        this.m_propsconfig.setProperty("payment.commerceid", "");
        this.m_propsconfig.setProperty("payment.commercepassword", "password");
        this.m_propsconfig.setProperty("machine.printername", "(Default)");
        this.m_propsconfig.setProperty("paper.receipt.x", "10");
        this.m_propsconfig.setProperty("paper.receipt.y", "10");
        this.m_propsconfig.setProperty("paper.receipt.width", "203");
        this.m_propsconfig.setProperty("paper.receipt.height", "546");
        this.m_propsconfig.setProperty("paper.receipt.mediasizename", "79mm");
        this.m_propsconfig.setProperty("paper.standard.x", "72");
        this.m_propsconfig.setProperty("paper.standard.y", "72");
        this.m_propsconfig.setProperty("paper.standard.width", "451");
        this.m_propsconfig.setProperty("paper.standard.height", "698");
        this.m_propsconfig.setProperty("paper.standard.mediasizename", "A4");
        this.m_propsconfig.setProperty("machine.uniqueinstance", "false");
        this.m_propsconfig.setProperty("Usb.Location", "/flash/");
        this.m_propsconfig.setProperty("Network.Manager", "wicd-client");
        this.m_propsconfig.setProperty("Script.Restart", "shutdown -r now");
        this.m_propsconfig.setProperty("Script.TurnOff", "shutdown -h now");
        this.m_propsconfig.setProperty("Command.MountFlash", "mount -t auto");
        this.m_propsconfig.setProperty("Script.UpdateSoftware", "sh /opt/Saleculator/update.sh");
        this.m_propsconfig.setProperty("PDA.Interval", "0");
        this.m_propsconfig.setProperty("Script.Calculator", "galculator");
        this.m_propsconfig.setProperty("Script.KB", "");
        this.m_propsconfig.setProperty("Script.CMD1", "");
        this.m_propsconfig.setProperty("Script.CMD2", "");
        this.m_propsconfig.setProperty("Script.CMD3", "");
        this.m_propsconfig.setProperty("mail.host", "smtp.gmail.com");
        this.m_propsconfig.setProperty("mail.tls", "true");
        this.m_propsconfig.setProperty("mail.port", "587");
        this.m_propsconfig.setProperty("mail.auth", "true");
        this.m_propsconfig.setProperty("mail.emailaddress", "");
        this.m_propsconfig.setProperty("mail.password", "");
        this.m_propsconfig.setProperty("mail.sendto", "");
        this.m_propsconfig.setProperty("www.address", "www.posics.com");
        this.m_propsconfig.setProperty("TicketProperties", "false");
        this.m_propsconfig.setProperty("Table.Timer", "false");
        this.m_propsconfig.setProperty("Table.AlertAfter", "20");
        this.m_propsconfig.setProperty("Table.Width", "0");
        this.m_propsconfig.setProperty("Table.Height", "0");
        this.m_propsconfig.setProperty("SMS.URL", "http://www.saleculator.com/sumup/saleculatorsms/send");
        this.m_propsconfig.setProperty("KeyPad.Visible", "false");
        this.m_propsconfig.setProperty("NumericPad.Visible", "false");
    }
}

