/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.data.loader.LocalRes;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.ticket.UserInfo;
import com.posics.pos.util.Hashcypher;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppUser {
    private static Logger logger = Logger.getLogger("com.posics.pos.forms.AppUser");
    private static SAXParser m_sp = null;
    private static HashMap<String, String> m_oldclasses;
    private String m_sId;
    private String m_sName;
    private String m_sCard;
    private String m_sPassword;
    private String m_sRole;
    private String m_sRoleName;
    private Icon m_Icon;
    private String[] permittedCats;
    private Set<String> m_apermissions;

    public AppUser(String id, String name, String password, String card, String role, Icon icon, String rolename) {
        this.m_sId = id;
        this.m_sName = name;
        this.m_sPassword = password;
        this.m_sCard = card;
        this.m_sRole = role;
        this.m_Icon = icon;
        this.m_apermissions = null;
        this.m_sRoleName = rolename;
    }

    public Icon getIcon() {
        return this.m_Icon;
    }

    public String getId() {
        return this.m_sId;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setPassword(String sValue) {
        this.m_sPassword = sValue;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public String getRole() {
        return this.m_sRole;
    }

    public String getRoleName() {
        return this.m_sRoleName;
    }

    public String getCard() {
        return this.m_sCard;
    }

    public boolean authenticate() {
        return this.m_sPassword == null || this.m_sPassword.equals("") || this.m_sPassword.startsWith("empty:");
    }

    public boolean authenticate(String sPwd) {
        return Hashcypher.authenticate(sPwd, this.m_sPassword);
    }

    public void fillPermissions(DataLogicSystem dlSystem) {
        this.m_apermissions = new HashSet<String>();
        this.m_apermissions.add("com.posics.pos.forms.JPanelMenu");
        this.m_apermissions.add("Menu.Exit");
        String sRolePermisions = dlSystem.findRolePermissions(this.m_sRole);
        if (sRolePermisions != null) {
            try {
                if (m_sp == null) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    m_sp = spf.newSAXParser();
                }
                m_sp.parse(new InputSource(new StringReader(sRolePermisions)), (DefaultHandler)new ConfigurationHandler());
            }
            catch (ParserConfigurationException ePC) {
                logger.log(Level.WARNING, LocalRes.getIntString("exception.parserconfig"), ePC);
            }
            catch (SAXException eSAX) {
                logger.log(Level.WARNING, LocalRes.getIntString("exception.xmlfile"), eSAX);
            }
            catch (IOException eIO) {
                logger.log(Level.WARNING, LocalRes.getIntString("exception.iofile"), eIO);
            }
        }
        if (sRolePermisions.contains("category.")) {
            String[] permissions = this.m_apermissions.toArray(new String[0]);
            ArrayList<String> cats = new ArrayList<String>();
            for (String s : permissions) {
                String[] s2 = s.split("category.");
                if (s2.length <= 1 || s2[1].length() <= 0) continue;
                cats.add(s2[1]);
            }
            this.permittedCats = cats.toArray(new String[0]);
        } else {
            this.permittedCats = null;
        }
    }

    public boolean hasPermission(String classname) {
        return this.m_apermissions == null ? false : this.m_apermissions.contains(classname);
    }

    public String[] getPermittedCategories() {
        return this.permittedCats;
    }

    public UserInfo getUserInfo() {
        return new UserInfo(this.m_sId, this.m_sName, this.m_sRoleName);
    }

    private static String mapNewClass(String classname) {
        String newclass = m_oldclasses.get(classname);
        return newclass == null ? classname : newclass;
    }

    private static void initOldClasses() {
        m_oldclasses = new HashMap();
        m_oldclasses.put("net.adrianromero.tpv.panelsales.JPanelTicketSales", "com.posics.pos.sales.JPanelTicketSales");
        m_oldclasses.put("net.adrianromero.tpv.panelsales.JPanelTicketEdits", "com.posics.pos.sales.JPanelTicketEdits");
        m_oldclasses.put("net.adrianromero.tpv.panels.JPanelPayments", "com.posics.pos.panels.JPanelPayments");
        m_oldclasses.put("net.adrianromero.tpv.panels.JPanelCloseMoney", "com.posics.pos.panels.JPanelCloseMoney");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportClosedPos", "/com/posics/reports/closedpos.bs");
        m_oldclasses.put("Menu.StockManagement", "com.posics.pos.forms.MenuStockManagement");
        m_oldclasses.put("net.adrianromero.tpv.inventory.ProductsPanel", "com.posics.pos.inventory.ProductsPanel");
        m_oldclasses.put("net.adrianromero.tpv.inventory.ProductsWarehousePanel", "com.posics.pos.inventory.ProductsWarehousePanel");
        m_oldclasses.put("net.adrianromero.tpv.inventory.CategoriesPanel", "com.posics.pos.inventory.CategoriesPanel");
        m_oldclasses.put("net.adrianromero.tpv.panels.JPanelTax", "com.posics.pos.inventory.TaxPanel");
        m_oldclasses.put("net.adrianromero.tpv.inventory.StockDiaryPanel", "com.posics.pos.inventory.StockDiaryPanel");
        m_oldclasses.put("net.adrianromero.tpv.inventory.StockManagement", "com.posics.pos.inventory.StockManagement");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportProducts", "/com/posics/reports/products.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportCatalog", "/com/posics/reports/productscatalog.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportInventory", "/com/posics/reports/inventory.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportInventory2", "/com/posics/reports/inventoryb.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportInventoryBroken", "/com/posics/reports/inventorybroken.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportInventoryDiff", "/com/posics/reports/inventorydiff.bs");
        m_oldclasses.put("Menu.SalesManagement", "com.posics.pos.forms.MenuSalesManagement");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportUserSales", "/com/posics/reports/usersales.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportClosedProducts", "/com/posics/reports/closedproducts.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JReportTaxes", "/com/posics/reports/taxes.bs");
        m_oldclasses.put("net.adrianromero.tpv.reports.JChartSales", "/com/posics/reports/chartsales.bs");
        m_oldclasses.put("Menu.Maintenance", "com.posics.pos.forms.MenuMaintenance");
        m_oldclasses.put("net.adrianromero.tpv.admin.PeoplePanel", "com.posics.pos.admin.PeoplePanel");
        m_oldclasses.put("net.adrianromero.tpv.admin.RolesPanel", "com.posics.pos.admin.RolesPanel");
        m_oldclasses.put("net.adrianromero.tpv.admin.ResourcesPanel", "com.posics.pos.admin.ResourcesPanel");
        m_oldclasses.put("net.adrianromero.tpv.inventory.LocationsPanel", "com.posics.pos.inventory.LocationsPanel");
        m_oldclasses.put("net.adrianromero.tpv.mant.JPanelFloors", "com.posics.pos.mant.JPanelFloors");
        m_oldclasses.put("net.adrianromero.tpv.mant.JPanelPlaces", "com.posics.pos.mant.JPanelPlaces");
        m_oldclasses.put("com.posics.possync.ProductsSync", "com.posics.possync.ProductsSyncCreate");
        m_oldclasses.put("com.posics.possync.OrdersSync", "com.posics.possync.OrdersSyncCreate");
        m_oldclasses.put("Menu.ChangePassword", "Menu.ChangePassword");
        m_oldclasses.put("Menu.Backup", "Menu.Backup");
        m_oldclasses.put("net.adrianromero.tpv.panels.JPanelPrinter", "com.posics.pos.panels.JPanelPrinter");
        m_oldclasses.put("net.adrianromero.tpv.config.JPanelConfiguration", "com.posics.pos.config.JPanelConfiguration");
        m_oldclasses.put("com.posics.pos.reports.JReportCustomers", "/com/posics/reports/customers.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportCustomersB", "/com/posics/reports/customersb.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportClosedPos", "/com/posics/reports/closedpos.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportClosedProducts", "/com/posics/reports/closedproducts.bs");
        m_oldclasses.put("com.posics.pos.reports.JChartSales", "/com/posics/reports/chartsales.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventory", "/com/posics/reports/inventory.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventory2", "/com/posics/reports/inventoryb.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventoryBroken", "/com/posics/reports/inventorybroken.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventoryDiff", "/com/posics/reports/inventorydiff.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportPeople", "/com/posics/reports/people.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportTaxes", "/com/posics/reports/taxes.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportUserSales", "/com/posics/reports/usersales.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportProducts", "/com/posics/reports/products.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportCatalog", "/com/posics/reports/productscatalog.bs");
        m_oldclasses.put("com.posics.pos.panels.JPanelTax", "com.posics.pos.inventory.TaxPanel");
    }

    static {
        AppUser.initOldClasses();
    }

    private class ConfigurationHandler
    extends DefaultHandler {
        private ConfigurationHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("class".equals(qName)) {
                AppUser.this.m_apermissions.add(AppUser.mapNewClass(attributes.getValue("name")));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }
}

