/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.basic.BasicException;
import com.posics.data.loader.Session;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.forms.DriverWrapper;
import com.posics.pos.util.AltEncrypter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class AppViewConnection {
    private AppViewConnection() {
    }

    public static Session createSession(AppProperties props) throws BasicException {
        try {
            if (AppViewConnection.isJavaWebStart()) {
                Class.forName(props.getProperty("db.driver"), true, Thread.currentThread().getContextClassLoader());
            } else {
                URLClassLoader cloader = new URLClassLoader(new URL[]{new File(props.getProperty("db.driverlib")).toURI().toURL()});
                DriverManager.registerDriver(new DriverWrapper((Driver)Class.forName(props.getProperty("db.driver"), true, cloader).newInstance()));
            }
            String sDBUser = props.getProperty("db.user");
            String sDBPassword = props.getProperty("db.password");
            if (sDBUser != null && sDBPassword != null && sDBPassword.startsWith("crypt:")) {
                AltEncrypter cypher = new AltEncrypter("cypherkey" + sDBUser);
                sDBPassword = cypher.decrypt(sDBPassword.substring(6));
            }
            return new Session(props.getProperty("db.URL"), sDBUser, sDBPassword);
        }
        catch (InstantiationException e) {
            throw new BasicException(AppLocal.getIntString("message.databasedrivererror"), e);
        }
        catch (IllegalAccessException eIA) {
            throw new BasicException(AppLocal.getIntString("message.databasedrivererror"), eIA);
        }
        catch (MalformedURLException eMURL) {
            throw new BasicException(AppLocal.getIntString("message.databasedrivererror"), eMURL);
        }
        catch (ClassNotFoundException eCNF) {
            throw new BasicException(AppLocal.getIntString("message.databasedrivererror"), eCNF);
        }
        catch (SQLException eSQL) {
            throw new BasicException(AppLocal.getIntString("message.databaseconnectionerror"), eSQL);
        }
    }

    private static boolean isJavaWebStart() {
        try {
            Class.forName("javax.jnlp.ServiceManager");
            return true;
        }
        catch (ClassNotFoundException ue) {
            return false;
        }
    }
}

