/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactory;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.StringUtils;
import java.io.IOException;

public class BeanFactoryScript
implements BeanFactoryApp {
    private BeanFactory bean = null;
    private String script;

    public BeanFactoryScript(String script) {
        this.script = script;
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        try {
            ScriptEngine eng = ScriptFactory.getScriptEngine("beanshell");
            eng.put("app", app);
            this.bean = (BeanFactory)eng.eval(StringUtils.readResource(this.script));
            if (this.bean == null) {
                this.bean = (BeanFactory)eng.get("bean");
            }
            if (this.bean instanceof BeanFactoryApp) {
                ((BeanFactoryApp)this.bean).init(app);
            }
        }
        catch (ScriptException e) {
            throw new BeanFactoryException(e);
        }
        catch (IOException e) {
            throw new BeanFactoryException(e);
        }
    }

    @Override
    public Object getBean() {
        return this.bean.getBean();
    }
}

