/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataParams;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataResultSet;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.QBFBuilder;
import com.posics.data.loader.SentenceExec;
import com.posics.data.loader.SentenceExecTransaction;
import com.posics.data.loader.SentenceList;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadBasic;
import com.posics.data.loader.SerializerReadBytes;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerReadDouble;
import com.posics.data.loader.SerializerReadImage;
import com.posics.data.loader.SerializerReadInteger;
import com.posics.data.loader.SerializerReadString;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteBasic;
import com.posics.data.loader.SerializerWriteBasicExt;
import com.posics.data.loader.SerializerWriteBuilder;
import com.posics.data.loader.SerializerWriteParams;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.data.loader.TableDefinition;
import com.posics.data.loader.Transaction;
import com.posics.data.model.Field;
import com.posics.data.model.Row;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.BeanFactoryDataSingle;
import com.posics.pos.inventory.AttributeSetInfo;
import com.posics.pos.inventory.LocationInfo;
import com.posics.pos.inventory.MaterialProdInfo;
import com.posics.pos.inventory.MovementReason;
import com.posics.pos.inventory.TaxCategoryInfo;
import com.posics.pos.inventory.TaxCustCategoryInfo;
import com.posics.pos.mant.AccountheadInfo;
import com.posics.pos.mant.BankInfo;
import com.posics.pos.mant.FloorsInfo;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoCurrency;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.sales.delivery.DriverInfo;
import com.posics.pos.suppliers.SupplierInfoExt;
import com.posics.pos.ticket.CategoryInfo;
import com.posics.pos.ticket.FindTicketsInfo;
import com.posics.pos.ticket.ProductInfoBasic;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TariffInfo;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.ticket.TicketTaxInfo;
import com.posics.pos.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class DataLogicSales
extends BeanFactoryDataSingle {
    protected Session s;
    protected Datas[] auxiliarDatas;
    protected Datas[] stockdiaryDatas = new Datas[]{Datas.STRING, Datas.TIMESTAMP, Datas.INT, Datas.STRING, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.STRING};
    protected Datas[] paymenttabledatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.STRING, Datas.STRING};
    protected Datas[] stockdatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE};
    protected Datas[] materialDatas;
    protected Datas[] subgroupDatas;
    protected Datas[] tariffareaDatas;
    protected Datas[] tariffprodDatas;
    protected Row productsRow;
    protected Datas[] materialrequestDatas;
    protected Datas[] materialrequestlinesDatas;

    public DataLogicSales() {
        this.auxiliarDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING};
        this.materialDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.BOOLEAN, Datas.BOOLEAN, Datas.DOUBLE, Datas.DOUBLE, Datas.STRING, Datas.STRING, Datas.IMAGE, Datas.DOUBLE, Datas.DOUBLE, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.BYTES};
        this.subgroupDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.IMAGE};
        this.tariffareaDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.INT};
        this.tariffprodDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.DOUBLE};
        this.materialrequestDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.TIMESTAMP, Datas.INT, Datas.TIMESTAMP};
        this.materialrequestlinesDatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.INT};
        this.productsRow = new Row(new Field("ID", Datas.STRING, Formats.STRING), new Field(AppLocal.getIntString("label.prodref"), Datas.STRING, Formats.STRING, true, true, true), new Field(AppLocal.getIntString("label.prodbarcode"), Datas.STRING, Formats.STRING, false, true, true), new Field(AppLocal.getIntString("label.prodname"), Datas.STRING, Formats.STRING, true, true, true), new Field("ISCOM", Datas.BOOLEAN, Formats.BOOLEAN), new Field("ISSCALE", Datas.BOOLEAN, Formats.BOOLEAN), new Field(AppLocal.getIntString("label.prodpricebuy"), Datas.DOUBLE, Formats.CURRENCY, false, true, true), new Field(AppLocal.getIntString("label.prodpricesell"), Datas.DOUBLE, Formats.CURRENCY, false, true, true), new Field(AppLocal.getIntString("label.prodcategory"), Datas.STRING, Formats.STRING, false, false, true), new Field(AppLocal.getIntString("label.taxcategory"), Datas.STRING, Formats.STRING, false, false, true), new Field(AppLocal.getIntString("label.attributeset"), Datas.STRING, Formats.STRING, false, false, true), new Field("IMAGE", Datas.IMAGE, Formats.NULL), new Field("STOCKCOST", Datas.DOUBLE, Formats.CURRENCY), new Field("STOCKVOLUME", Datas.DOUBLE, Formats.DOUBLE), new Field("ISCATALOG", Datas.BOOLEAN, Formats.BOOLEAN), new Field("CATORDER", Datas.INT, Formats.INT), new Field("PROPERTIES", Datas.BYTES, Formats.NULL));
    }

    @Override
    public void init(Session s) {
        this.s = s;
    }

    public final Row getProductsRow() {
        return this.productsRow;
    }

    public final String getResource(String res) {
        try {
            PreparedSentence m_resourcebytes = new PreparedSentence(this.s, "SELECT CONTENT FROM RESOURCES WHERE NAME LIKE ?", SerializerWriteString.INSTANCE, SerializerReadBytes.INSTANCE);
            byte[] resource = (byte[])m_resourcebytes.find((Object)res);
            return Formats.BYTEA.formatValue(resource);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final String getNextBarcode() throws BasicException {
        StaticSentence m_next = new StaticSentence(this.s, "SELECT MAX(CONVERT(CODE,UNSIGNED))+1 FROM PRODUCTS", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        return m_next.find().toString();
    }

    public final ProductInfoExt getProductInfo(String id) throws BasicException {
        return (ProductInfoExt)new PreparedSentence(this.s, "SELECT ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, TAXCAT, CATEGORY, ATTRIBUTESET_ID, IMAGE, ATTRIBUTES, INCAT, CATORDER FROM PRODUCTS WHERE ID = ?", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)id);
    }

    public final ProductInfoExt getProductInfoByCode(String sCode) throws BasicException {
        return (ProductInfoExt)new PreparedSentence(this.s, "SELECT ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, TAXCAT, CATEGORY, ATTRIBUTESET_ID, IMAGE, ATTRIBUTES, INCAT, CATORDER FROM PRODUCTS WHERE CODE = ?", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)sCode);
    }

    public final ProductInfoExt getProductInfoByName(String sName) throws BasicException {
        return (ProductInfoExt)new PreparedSentence(this.s, "SELECT ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, TAXCAT, CATEGORY, ATTRIBUTESET_ID, IMAGE, ATTRIBUTES, INCAT, CATORDER FROM PRODUCTS WHERE NAME = ?", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)sName);
    }

    public final CategoryInfo getCategoryByID(String sID) throws BasicException {
        return (CategoryInfo)new PreparedSentence(this.s, "SELECT ID, NAME, NULL FROM CATEGORIES WHERE ID = ?", SerializerWriteString.INSTANCE, CategoryInfo.getSerializerRead()).find((Object)sID);
    }

    public final CategoryInfo getCategoryByName(String sName) throws BasicException {
        return (CategoryInfo)new PreparedSentence(this.s, "SELECT ID, NAME, NULL FROM CATEGORIES WHERE NAME = ?", SerializerWriteString.INSTANCE, CategoryInfo.getSerializerRead()).find((Object)sName);
    }

    public final ProductInfoExt getProductInfoByReference(String sReference) throws BasicException {
        return (ProductInfoExt)new PreparedSentence(this.s, "SELECT ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, TAXCAT, CATEGORY, ATTRIBUTESET_ID, IMAGE, ATTRIBUTES, INCAT, CATORDER FROM PRODUCTS WHERE REFERENCE = ?", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)sReference);
    }

    public final List<CategoryInfo> getRootCategories() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, IMAGE FROM CATEGORIES WHERE ID NOT LIKE '-1' AND PARENTID IS NULL ORDER BY NAME", null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<CategoryInfo> getRootCategories(String[] cats) throws BasicException {
        if (cats != null) {
            String catlist = "";
            for (String s : cats) {
                catlist = catlist + "'" + s + "',";
            }
            if (catlist.length() > 0) {
                catlist = catlist.substring(0, catlist.length() - 1);
                catlist = " (" + catlist + ") ";
                return new PreparedSentence(this.s, "SELECT ID, NAME, IMAGE FROM CATEGORIES WHERE ID >= 0 AND PARENTID IS NULL AND NAME IN " + catlist + " ORDER BY NAME", null, CategoryInfo.getSerializerRead()).list();
            }
            return this.getRootCategories();
        }
        return this.getRootCategories();
    }

    public final List<CategoryInfo> getSubcategories(String category) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, IMAGE FROM CATEGORIES WHERE PARENTID = ? ORDER BY NAME", SerializerWriteString.INSTANCE, CategoryInfo.getSerializerRead()).list((Object)category);
    }

    public List<ProductInfoExt> getProductCatalog(String category) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.TAXCAT, P.CATEGORY, P.ATTRIBUTESET_ID, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P WHERE P.INCAT = 1 AND P.CATEGORY = ? ORDER BY P.CATORDER, P.NAME", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)category);
    }

    public List<ProductInfoExt> getProductCatalogTariff(String category) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.TAXCAT, P.CATEGORY, P.ATTRIBUTESET_ID, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P WHERE  P.CATEGORY = ? ORDER BY P.CATORDER, P.NAME", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)category);
    }

    public List<ProductInfoExt> getProductComments(String id) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.TAXCAT, P.CATEGORY, P.ATTRIBUTESET_ID, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P, PRODUCTS_COM M WHERE P.INCAT = 1 AND P.ID = M.PRODUCT2 AND M.PRODUCT = ? AND P.ISCOM = " + this.s.DB.TRUE() + " ORDER BY P.CATORDER, P.NAME", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)id);
    }

    public final SentenceList getProductList() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.TAXCAT, P.CATEGORY, P.ATTRIBUTESET_ID, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS AS P JOIN CATEGORIES C ON P.CATEGORY = C.ID AND C.ID NOT LIKE '-1' AND C.ID NOT LIKE '-2' AND (C.PARENTID IS NULL OR (C.PARENTID NOT LIKE '-1' AND C.PARENTID NOT LIKE '-2')) AND ?(QBF_FILTER) ORDER BY REFERENCE", new String[]{"P.NAME", "P.PRICEBUY", "P.PRICESELL", "P.CATEGORY", "P.CODE", "REFERENCE"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), ProductInfoExt.getSerializerRead());
    }

    public SentenceList getProductListNormal() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, TAXCAT, CATEGORY, ATTRIBUTESET_ID, IMAGE, ATTRIBUTES, INCAT, CATORDER FROM PRODUCTS WHERE ISCOM = " + this.s.DB.FALSE() + " AND ?(QBF_FILTER) ORDER BY REFERENCE", new String[]{"NAME", "PRICEBUY", "PRICESELL", "CATEGORY", "CODE", "REFERENCE"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), ProductInfoExt.getSerializerRead());
    }

    public SentenceList getProductListAuxiliar() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, TAXCAT, CATEGORY, ATTRIBUTESET_ID, IMAGE, ATTRIBUTES, INCAT, CATORDER FROM PRODUCTS WHERE ISCOM = " + this.s.DB.TRUE() + " AND ?(QBF_FILTER) ORDER BY REFERENCE", new String[]{"NAME", "PRICEBUY", "PRICESELL", "CATEGORY", "CODE", "REFERENCE"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), ProductInfoExt.getSerializerRead());
    }

    public SentenceList getTicketsList() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT T.TICKETID, T.TICKETTYPE, R.DATENEW, P.NAME, C.NAME, SUM(PM.TOTAL), T.ID FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PAYMENTS PM ON R.ID = PM.RECEIPT LEFT OUTER JOIN CUSTOMERS C ON C.ID = T.CUSTOMER LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE ?(QBF_FILTER) GROUP BY T.ID, T.TICKETID, T.TICKETTYPE, R.DATENEW, P.NAME, C.NAME ORDER BY R.DATENEW DESC, T.TICKETID", new String[]{"T.TICKETID", "T.TICKETTYPE", "PM.TOTAL", "R.DATENEW", "R.DATENEW", "P.NAME", "C.NAME", "C.SEARCHKEY"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.INT, Datas.OBJECT, Datas.INT, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.TIMESTAMP, Datas.OBJECT, Datas.TIMESTAMP, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), (SerializerRead)new SerializerReadClass(FindTicketsInfo.class));
    }

    public SentenceList getTicketsList(String receipthost) {
        return new StaticSentence(this.s, new QBFBuilder("SELECT T.TICKETID, T.TICKETTYPE, R.DATENEW, P.NAME, C.NAME, SUM(PM.TOTAL), T.ID FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PAYMENTS PM ON R.ID = PM.RECEIPT LEFT OUTER JOIN CUSTOMERS C ON C.ID = T.CUSTOMER LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.HOST='" + receipthost + "' AND ?(QBF_FILTER) GROUP BY T.ID, T.TICKETID, T.TICKETTYPE, R.DATENEW, P.NAME, C.NAME ORDER BY R.DATENEW DESC, T.TICKETID", new String[]{"T.TICKETID", "T.TICKETTYPE", "PM.TOTAL", "R.DATENEW", "R.DATENEW", "P.NAME", "C.NAME", "C.SEARCHKEY"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.INT, Datas.OBJECT, Datas.INT, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.TIMESTAMP, Datas.OBJECT, Datas.TIMESTAMP, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), (SerializerRead)new SerializerReadClass(FindTicketsInfo.class));
    }

    public final SentenceList getUserList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM PEOPLE ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxCategoryInfo(dr.getString(1), dr.getString(2));
            }
        });
    }

    public final SentenceList getTaxList() {
        return new StaticSentence(this.s, "SELECT ID, NAME, CATEGORY, CUSTCATEGORY, PARENTID, RATE, RATECASCADE, RATEORDER FROM TAXES ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getString(4), dr.getString(5), dr.getDouble(6), dr.getBoolean(7), dr.getInt(8));
            }
        });
    }

    public final SentenceList getProductsList() {
        return new StaticSentence(this.s, "SELECT P.ID,P.CODE, P.NAME FROM PRODUCTS P, CATEGORIES CAT WHERE P.INCAT=1 AND CAT.ID=P.CATEGORY AND CAT.ID NOT LIKE '-1' AND CAT.ID NOT LIKE '-2' AND (CAT.PARENTID IS NULL OR (CAT.PARENTID NOT LIKE '-1' AND CAT.PARENTID NOT LIKE '-2')) ORDER BY P.NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new ProductInfoBasic(dr.getString(1), dr.getString(2), dr.getString(3));
            }
        });
    }

    public final SentenceList getProductsListWithMaterials() {
        return new StaticSentence(this.s, "SELECT P.ID,P.CODE, P.NAME FROM PRODUCTS P ORDER BY P.NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new ProductInfoBasic(dr.getString(1), dr.getString(2), dr.getString(3));
            }
        });
    }

    public final SentenceList getCategoriesList(boolean isMaterials) {
        if (!isMaterials) {
            return new StaticSentence(this.s, "SELECT ID, NAME, IMAGE FROM CATEGORIES WHERE ID NOT LIKE '-1' AND ID NOT LIKE '-2' AND (PARENTID IS NULL OR (PARENTID NOT LIKE '-1' AND PARENTID NOT LIKE '-2')) ORDER BY NAME", null, CategoryInfo.getSerializerRead());
        }
        return new StaticSentence(this.s, "SELECT ID, NAME, IMAGE FROM CATEGORIES ORDER BY NAME", null, CategoryInfo.getSerializerRead());
    }

    public final SentenceList getTaxCustCategoriesList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM TAXCUSTCATEGORIES ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxCustCategoryInfo(dr.getString(1), dr.getString(2));
            }
        });
    }

    public final SentenceList getTaxCategoriesList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM TAXCATEGORIES ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new TaxCategoryInfo(dr.getString(1), dr.getString(2));
            }
        });
    }

    public final SentenceList getAttributeSetList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM ATTRIBUTESET ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new AttributeSetInfo(dr.getString(1), dr.getString(2));
            }
        });
    }

    public final SentenceList getLocationsList() {
        return new StaticSentence(this.s, "SELECT ID, NAME, ADDRESS FROM LOCATIONS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(LocationInfo.class));
    }

    public final SentenceList getFloorsList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM FLOORS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(FloorsInfo.class));
    }

    public final SentenceList getAccountheadsList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM ACCOUNTHEADS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(AccountheadInfo.class));
    }

    public final SentenceList getBanksList() {
        return new StaticSentence(this.s, "SELECT ID, NAME, CODE FROM BANKS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(BankInfo.class));
    }

    public CustomerInfoExt findCustomerExt(String card) throws BasicException {
        return (CustomerInfoExt)new PreparedSentence(this.s, "SELECT C.ID, C.TAXID, C.SEARCHKEY, C.NAME, C.CARD, C.TAXCATEGORY, C.NOTES, C.MAXDEBT, C.VISIBLE, C.CURDATE, C.CURDEBT, C.FIRSTNAME, C.LASTNAME, C.EMAIL, C.PHONE, C.PHONE2, C.FAX, C.ADDRESS, C.ADDRESS2, C.POSTAL, C.CITY, C.REGION, C.COUNTRY, C.POINTS, C.ADVANCE, C.ADVANCEDATE  FROM CUSTOMERS C WHERE C.CARD = ? AND C.VISIBLE = " + this.s.DB.TRUE(), SerializerWriteString.INSTANCE, new CustomerExtRead()).find((Object)card);
    }

    public SupplierInfoExt findSupplierExt(String card) throws BasicException {
        return (SupplierInfoExt)new PreparedSentence(this.s, "SELECT C.ID, C.TAXID, C.SEARCHKEY, C.NAME, C.CARD, C.TAXCATEGORY, C.NOTES, C.MAXDEBT, C.VISIBLE, C.CURDATE, C.CURDEBT, C.FIRSTNAME, C.LASTNAME, C.EMAIL, C.PHONE, C.PHONE2, C.FAX, C.ADDRESS, C.ADDRESS2, C.POSTAL, C.CITY, C.REGION, C.COUNTRY  FROM SUPPLIERS C WHERE C.CARD = ? AND C.VISIBLE = " + this.s.DB.TRUE(), SerializerWriteString.INSTANCE, new SupplierExtRead()).find((Object)card);
    }

    public CustomerInfoExt loadCustomerExt(String id) throws BasicException {
        return (CustomerInfoExt)new PreparedSentence(this.s, "SELECT C.ID, C.TAXID, C.SEARCHKEY, C.NAME, C.CARD, C.TAXCATEGORY, C.NOTES, C.MAXDEBT, C.VISIBLE, C.CURDATE, C.CURDEBT, C.FIRSTNAME, C.LASTNAME, C.EMAIL, C.PHONE, C.PHONE2, C.FAX, C.ADDRESS, C.ADDRESS2, C.POSTAL, C.CITY, C.REGION, C.COUNTRY, C.POINTS, C.ADVANCE, C.ADVANCEDATE  FROM CUSTOMERS C WHERE C.ID = ?", SerializerWriteString.INSTANCE, new CustomerExtRead()).find((Object)id);
    }

    public CustomerInfoExt loadCustomerExt2(String id) throws BasicException {
        return (CustomerInfoExt)new PreparedSentence(this.s, "SELECT C.ID, C.TAXID, C.SEARCHKEY, C.NAME, C.CARD, C.TAXCATEGORY, C.NOTES, C.MAXDEBT, C.VISIBLE, C.CURDATE, C.CURDEBT, C.FIRSTNAME, C.LASTNAME, C.EMAIL, C.PHONE, C.PHONE2, C.FAX, C.ADDRESS, C.ADDRESS2, C.POSTAL, C.CITY, C.REGION, C.COUNTRY, C.POINTS, C.ADVANCE, C.ADVANCEDATE  FROM CUSTOMERS C WHERE C.SEARCHKEY = ? OR PHONE = " + id + " OR PHONE2 = " + id, SerializerWriteString.INSTANCE, new CustomerExtRead()).find((Object)id);
    }

    public final TicketInfo geCustomerLastOrder(final String custid) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, T.CUSTOMER, T.SUPPLIER, ROLES.NAME AS ROLENAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID JOIN ROLES ON ROLES.ID=P.ROLE WHERE T.CUSTOMER = ? ORDER BY R.DATENEW DESC LIMIT 1", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, custid);
            }
        });
        if (ticket != null) {
            String customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == null ? null : this.loadCustomerExt(customerid));
            ticket.setLines(new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.ATTRIBUTESETINSTANCE_ID, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ? ORDER BY L.LINE", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket.getId()));
            ticket.setPayments(new PreparedSentence(this.s, "SELECT PAYMENT, TOTAL, TRANSID FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(PaymentInfoTicket.class)).list((Object)ticket.getId()));
        }
        return ticket;
    }

    public final TicketInfo getReceipt(final String receiptid) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, T.CUSTOMER, T.SUPPLIER, ROLES.NAME AS ROLENAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID JOIN ROLES ON ROLES.ID=P.ROLE WHERE T.ID = ? ORDER BY R.DATENEW DESC ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, receiptid);
            }
        });
        if (ticket != null) {
            String customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == null ? null : this.loadCustomerExt(customerid));
            ticket.setLines(new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.ATTRIBUTESETINSTANCE_ID, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ? ORDER BY L.LINE", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket.getId()));
            ticket.setPayments(new PreparedSentence(this.s, "SELECT PAYMENT, TOTAL, TRANSID FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(PaymentInfoTicket.class)).list((Object)ticket.getId()));
        }
        return ticket;
    }

    public SupplierInfoExt loadSupplierExt(String id) throws BasicException {
        return (SupplierInfoExt)new PreparedSentence(this.s, "SELECT C.ID, C.TAXID, C.SEARCHKEY, C.NAME, C.CARD, C.TAXCATEGORY, C.NOTES, C.MAXDEBT, C.VISIBLE, C.CURDATE, C.CURDEBT, C.FIRSTNAME, C.LASTNAME, C.EMAIL, C.PHONE, C.PHONE2, C.FAX, C.ADDRESS, C.ADDRESS2, C.POSTAL, C.CITY, C.REGION, C.COUNTRY  FROM SUPPLIERS C WHERE C.ID = ?", SerializerWriteString.INSTANCE, new SupplierExtRead()).find((Object)id);
    }

    public final boolean isCashActive(String id) throws BasicException {
        return new PreparedSentence(this.s, "SELECT MONEY FROM CLOSEDCASH WHERE DATEEND IS NULL AND MONEY = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE).find((Object)id) != null;
    }

    public final TicketInfo loadTicket(final int tickettype, final int ticketid) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, T.CUSTOMER, T.SUPPLIER, ROLES.NAME AS ROLENAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID JOIN ROLES ON ROLES.ID=P.ROLE WHERE T.TICKETTYPE = ? AND T.TICKETID = ?", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, tickettype);
                this.setInt(2, ticketid);
            }
        });
        if (ticket != null) {
            String customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == null ? null : this.loadCustomerExt(customerid));
            ticket.setLines(new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.ATTRIBUTESETINSTANCE_ID, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ? ORDER BY L.LINE", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket.getId()));
            ticket.setPayments(new PreparedSentence(this.s, "SELECT PAYMENT, TOTAL, TRANSID FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(PaymentInfoTicket.class)).list((Object)ticket.getId()));
        }
        return ticket;
    }

    public final TicketInfo loadTicket(final int tickettype, final int ticketid, final String receipthost) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, T.CUSTOMER, T.SUPPLIER, ROLES.NAME AS ROLENAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID JOIN ROLES ON ROLES.ID=P.ROLE WHERE T.TICKETTYPE = ? AND T.TICKETID = ? AND T.HOST = ?", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, tickettype);
                this.setInt(2, ticketid);
                this.setString(3, receipthost);
            }
        });
        if (ticket != null) {
            String customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == null ? null : this.loadCustomerExt(customerid));
            ticket.setLines(new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.ATTRIBUTESETINSTANCE_ID, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ? ORDER BY L.LINE", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket.getId()));
            ticket.setPayments(new PreparedSentence(this.s, "SELECT PAYMENT, TOTAL, TRANSID FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(PaymentInfoTicket.class)).list((Object)ticket.getId()));
        }
        return ticket;
    }

    public final boolean isReceiptReceived(String id) throws BasicException {
        return new PreparedSentence(this.s, "SELECT REFERENCE FROM PURCHASEINVOICE WHERE REFERENCE = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE).find((Object)id) != null;
    }

    public final void updateReceiveStatus(final String ticketid) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS SET RECEIVED = 1 WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticketid);
            }
        });
    }

    public final TicketInfo loadLastTicket() throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, T.CUSTOMER, T.SUPPLIER, ROLES.NAME AS ROLENAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID JOIN ROLES ON ROLES.ID=P.ROLE WHERE T.TICKETTYPE = ? AND T.TICKETID = (SELECT ID FROM TICKETSNUM)", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, 0);
            }
        });
        if (ticket != null) {
            String customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == null ? null : this.loadCustomerExt(customerid));
            ticket.setLines(new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.ATTRIBUTESETINSTANCE_ID, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ? ORDER BY L.LINE", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket.getId()));
            ticket.setPayments(new PreparedSentence(this.s, "SELECT PAYMENT, TOTAL, TRANSID FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(PaymentInfoTicket.class)).list((Object)ticket.getId()));
        }
        return ticket;
    }

    public final TicketInfo loadTicket(final String ticketid) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, T.CUSTOMER, T.SUPPLIER, ROLES.NAME AS ROLENAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID JOIN ROLES ON ROLES.ID=P.ROLE WHERE T.ID LIKE ?", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticketid);
            }
        });
        if (ticket != null) {
            String customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == null ? null : this.loadCustomerExt(customerid));
            ticket.setLines(new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.ATTRIBUTESETINSTANCE_ID, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ? ORDER BY L.LINE", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket.getId()));
            ticket.setPayments(new PreparedSentence(this.s, "SELECT PAYMENT, TOTAL, TRANSID FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(PaymentInfoTicket.class)).list((Object)ticket.getId()));
        }
        return ticket;
    }

    public final void settlePayment(final TicketInfo ticket) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                PreparedSentence olddeb = new PreparedSentence(DataLogicSales.this.s, "SELECT P.TOTAL FROM PAYMENTS P WHERE P.RECEIPT=? AND P.PAYMENT = 'debt' ", SerializerWriteString.INSTANCE, SerializerReadDouble.INSTANCE);
                final Double ddt = (Double)olddeb.find((Object)ticket.getId());
                PreparedSentence debcustomer = new PreparedSentence(DataLogicSales.this.s, "SELECT CUSTOMER FROM TICKETS WHERE ID=? ", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
                final String debcus = (String)debcustomer.find((Object)ticket.getId());
                if (ddt != null && debcus != null) {
                    new PreparedSentence(DataLogicSales.this.s, "UPDATE CUSTOMERS C SET C.CURDEBT = C.CURDEBT - ?, CURDATE=? WHERE C.ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, ddt);
                            this.setTimestamp(2, new Date());
                            this.setString(3, debcus);
                        }
                    });
                    if (ticket.getCustomerId().equals(debcus)) {
                        ticket.getCustomer().updateCurDebt(-ddt.doubleValue(), ticket.getDate());
                    }
                }
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                PreparedSentence paymentinsert = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL, TRANSID, RETURNMSG) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
                for (final PaymentInfo p : ticket.getPayments()) {
                    paymentinsert.exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, UUID.randomUUID().toString());
                            this.setString(2, ticket.getId());
                            this.setString(3, p.getName());
                            this.setDouble(4, p.getTotal());
                            this.setString(5, p.getTransactionID());
                            this.setBytes(6, (byte[])Formats.BYTEA.parseValue(ticket.getReturnMessage()));
                        }
                    });
                    if (!"debt".equals(p.getName()) && !"debtpaid".equals(p.getName())) continue;
                    new PreparedSentence(DataLogicSales.this.s, "UPDATE TICKETS SET CUSTOMER =? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, ticket.getCustomerId());
                            this.setString(2, ticket.getId());
                        }
                    });
                    ticket.getCustomer().updateCurDebt(p.getTotal(), ticket.getDate());
                    DataLogicSales.this.getDebtUpdate().exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, ticket.getCustomer().getCurdebt());
                            this.setTimestamp(2, ticket.getCustomer().getCurdate());
                            this.setString(3, ticket.getCustomer().getId());
                        }
                    });
                }
                return null;
            }
        };
        t.execute();
        Runtime rtgc = Runtime.getRuntime();
        rtgc.gc();
    }

    public final void settlePayment2(final TicketInfo ticket, final String activecash, final String userid) throws BasicException {
        Object[] debtpayments = (Object[])new StaticSentence(this.s, "SELECT SUM(TOTAL) FROM PAYMENTS WHERE RECEIPT LIKE ? AND PAYMENT LIKE 'debt'", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)ticket.getId());
        if (debtpayments[0] != null) {
            final Double totaldebt = (Double)debtpayments[0];
            Transaction t = new Transaction(this.s){

                public Object transact() throws BasicException {
                    final String receiptid = UUID.randomUUID().toString();
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO RECEIPTS (ID, MONEY, DATENEW, ATTRIBUTES, ACCOUNTHEAD) VALUES (?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, receiptid);
                            this.setString(2, activecash);
                            this.setTimestamp(3, new Date());
                            this.setBytes(4, null);
                            this.setString(5, "1");
                        }
                    });
                    PreparedSentence paymentinsert = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL, TRANSID, RETURNMSG) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
                    paymentinsert.exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, UUID.randomUUID().toString());
                            this.setString(2, receiptid);
                            this.setString(3, "debtpaid");
                            this.setDouble(4, totaldebt * -1.0);
                            this.setString(5, null);
                            this.setBytes(6, (byte[])Formats.BYTEA.parseValue("OK"));
                        }
                    });
                    paymentinsert.exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, UUID.randomUUID().toString());
                            this.setString(2, receiptid);
                            this.setString(3, "cash");
                            this.setDouble(4, totaldebt);
                            this.setString(5, null);
                            this.setBytes(6, (byte[])Formats.BYTEA.parseValue("OK"));
                        }
                    });
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO TICKETS (ID, TICKETTYPE, TICKETID, PERSON, CUSTOMER, SUPPLIER) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, receiptid);
                            this.setInt(2, 2);
                            this.setInt(3, (int)DataLogicSales.this.getNextTicketPaymentIndex());
                            this.setString(4, userid);
                            this.setString(5, ticket.getCustomerId());
                            this.setString(6, null);
                        }
                    });
                    new PreparedSentence(DataLogicSales.this.s, "UPDATE CUSTOMERS C SET C.CURDEBT = C.CURDEBT - ? WHERE C.ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, totaldebt);
                            this.setString(2, ticket.getCustomerId());
                        }
                    });
                    return null;
                }
            };
            t.execute();
            Runtime rtgc = Runtime.getRuntime();
            rtgc.gc();
        }
    }

    public final void saveTicket(final TicketInfo ticket, final String location, final String receipthost) throws BasicException {
        Transaction t1 = new Transaction(this.s){

            public Object transact() throws BasicException {
                CustomerInfoExt customerInfoExt;
                if (ticket.getTicketId() == 0) {
                    switch (ticket.getTicketType()) {
                        case 0: {
                            if (!"".equals(receipthost)) {
                                ticket.setTicketId(DataLogicSales.this.getNextTicketIndex(receipthost));
                                break;
                            }
                            ticket.setTicketId(DataLogicSales.this.getNextTicketIndex());
                            break;
                        }
                        case 1: {
                            if (!"".equals(receipthost)) {
                                ticket.setTicketId(DataLogicSales.this.getNextTicketRefundIndex(receipthost));
                                break;
                            }
                            ticket.setTicketId(DataLogicSales.this.getNextTicketRefundIndex());
                            break;
                        }
                        case 2: {
                            if (!"".equals(receipthost)) {
                                ticket.setTicketId(DataLogicSales.this.getNextTicketPaymentIndex(receipthost));
                                break;
                            }
                            ticket.setTicketId(DataLogicSales.this.getNextTicketPaymentIndex());
                            break;
                        }
                        case 3: {
                            if (!"".equals(receipthost)) {
                                ticket.setTicketId(DataLogicSales.this.getNextTicketSupplierIndex(receipthost));
                                break;
                            }
                            ticket.setTicketId(DataLogicSales.this.getNextTicketSupplierIndex());
                            break;
                        }
                        default: {
                            throw new BasicException();
                        }
                    }
                }
                new PreparedSentence(DataLogicSales.this.s, "INSERT INTO RECEIPTS (ID, MONEY, DATENEW, ATTRIBUTES, ACCOUNTHEAD) VALUES (?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, ticket.getId());
                        this.setString(2, ticket.getActiveCash());
                        this.setTimestamp(3, ticket.getDate());
                        try {
                            ByteArrayOutputStream o = new ByteArrayOutputStream();
                            ticket.getProperties().storeToXML((OutputStream)o, "Saleculator PDA", "UTF-8");
                            this.setBytes(4, o.toByteArray());
                        }
                        catch (IOException e) {
                            this.setBytes(4, null);
                        }
                        if (ticket.getTicketType() == 3) {
                            this.setString(5, "2");
                        } else {
                            this.setString(5, "1");
                        }
                    }
                });
                if (ticket.getProperty("DeliveryOrder") != null && ticket.getProperty("Driver") == null) {
                    new PreparedSentence(DataLogicSales.this.s, "UPDATE DELIVERYORDERS SET RECEIPT =? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, ticket.getId());
                            this.setString(2, ticket.getProperty("DeliveryOrder"));
                        }
                    });
                    new PreparedSentence(DataLogicSales.this.s, "UPDATE CALLS SET STATUS = 2 WHERE ID IN (SELECT CALLID FROM DELIVERYORDERS WHERE ID = ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, ticket.getProperty("DeliveryOrder"));
                        }
                    });
                }
                if (!"".equals(receipthost)) {
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO TICKETS (ID, TICKETTYPE, TICKETID, PERSON, CUSTOMER, SUPPLIER, HOST) VALUES (?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, ticket.getId());
                            this.setInt(2, ticket.getTicketType());
                            this.setInt(3, ticket.getTicketId());
                            this.setString(4, ticket.getUser().getId());
                            this.setString(5, ticket.getCustomerId());
                            this.setString(6, ticket.getSupplierId());
                            this.setString(7, receipthost);
                        }
                    });
                } else {
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO TICKETS (ID, TICKETTYPE, TICKETID, PERSON, CUSTOMER, SUPPLIER) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, ticket.getId());
                            this.setInt(2, ticket.getTicketType());
                            this.setInt(3, ticket.getTicketId());
                            this.setString(4, ticket.getUser().getId());
                            this.setString(5, ticket.getCustomerId());
                            this.setString(6, ticket.getSupplierId());
                        }
                    });
                }
                PreparedSentence ticketlineinsert = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO TICKETLINES (TICKET, LINE, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS, PRICE, TAXID, ATTRIBUTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteBuilder.INSTANCE);
                for (TicketLineInfo ticketLineInfo : ticket.getLines()) {
                    ticketlineinsert.exec((Object)ticketLineInfo);
                    if (ticketLineInfo.getProductID() == null) continue;
                    List<MaterialProdInfo> list = DataLogicSales.this.getMaterialsProd(ticketLineInfo.getProductID(), null);
                    if (list.isEmpty()) {
                        DataLogicSales.this.getStockDiaryInsert().exec(UUID.randomUUID().toString(), ticket.getDate(), ticketLineInfo.getMultiply() < 0.0 ? MovementReason.IN_REFUND.getKey() : MovementReason.OUT_SALE.getKey(), location, ticketLineInfo.getProductID(), ticketLineInfo.getProductAttSetInstId(), -ticketLineInfo.getMultiply(), ticketLineInfo.getSalePrice());
                        continue;
                    }
                    for (MaterialProdInfo m : list) {
                        DataLogicSales.this.getStockDiaryInsert().exec(UUID.randomUUID().toString(), ticket.getDate(), ticketLineInfo.getMultiply() < 0.0 ? MovementReason.IN_REFUND.getKey() : MovementReason.OUT_SALE.getKey(), location, m.getID(), ticketLineInfo.getProductAttSetInstId(), -(ticketLineInfo.getMultiply() * m.getAmount()), m.getPriceBuy());
                    }
                }
                PreparedSentence paymentinsert = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL, TRANSID, RETURNMSG) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
                for (final PaymentInfo paymentInfo : ticket.getPayments()) {
                    paymentinsert.exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, UUID.randomUUID().toString());
                            this.setString(2, ticket.getId());
                            this.setString(3, paymentInfo.getName());
                            this.setDouble(4, paymentInfo.getTotal());
                            this.setString(5, paymentInfo.getTransactionID());
                            this.setBytes(6, (byte[])Formats.BYTEA.parseValue(ticket.getReturnMessage()));
                        }
                    });
                    if ("debt".equals(paymentInfo.getName()) || "debtpaid".equals(paymentInfo.getName())) {
                        if (ticket.getCustomer() == null) continue;
                        ticket.getCustomer().updateCurDebt(paymentInfo.getTotal(), ticket.getDate());
                        DataLogicSales.this.getDebtUpdate().exec((Object)new DataParams(){

                            @Override
                            public void writeValues() throws BasicException {
                                this.setDouble(1, ticket.getCustomer().getCurdebt());
                                this.setTimestamp(2, ticket.getCustomer().getCurdate());
                                this.setString(3, ticket.getCustomer().getId());
                            }
                        });
                        continue;
                    }
                    if ("advance".equals(paymentInfo.getName()) || "advancepaid".equals(paymentInfo.getName())) {
                        ticket.getCustomer().updateCurAdvance(paymentInfo.getTotal(), ticket.getDate());
                        DataLogicSales.this.getAdvanceUpdate().exec((Object)new DataParams(){

                            @Override
                            public void writeValues() throws BasicException {
                                this.setDouble(1, ticket.getCustomer().getCurAdvance());
                                this.setTimestamp(2, ticket.getCustomer().getAdvanceDate());
                                this.setString(3, ticket.getCustomer().getId());
                            }
                        });
                        continue;
                    }
                    if (ticket.getTicketType() == 3) {
                        ticket.getSupplier().updateCurDebt(paymentInfo.getTotal(), ticket.getDate());
                        DataLogicSales.this.getCreditUpdate().exec((Object)new DataParams(){

                            @Override
                            public void writeValues() throws BasicException {
                                this.setDouble(1, ticket.getSupplier().getCurcredit());
                                this.setTimestamp(2, ticket.getSupplier().getCurdate());
                                this.setString(3, ticket.getSupplier().getId());
                            }
                        });
                        continue;
                    }
                    if ("pointsin".equals(paymentInfo.getName())) {
                        ticket.getCustomer().setPoints(ticket.getCustomer().getPoints() - paymentInfo.getTotal());
                        DataLogicSales.this.getPointsUpdate().exec((Object)new DataParams(){

                            @Override
                            public void writeValues() throws BasicException {
                                this.setDouble(1, paymentInfo.getTotal());
                                this.setString(2, ticket.getCustomer().getId());
                            }
                        });
                        continue;
                    }
                    if (!"currency".equals(paymentInfo.getName())) continue;
                    final PaymentInfoCurrency pc = (PaymentInfoCurrency)paymentInfo;
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, UUID.randomUUID().toString());
                            this.setString(2, ticket.getId());
                            this.setString(3, "currencychange");
                            this.setDouble(4, pc.getChange() * -1.0);
                        }
                    });
                }
                PreparedSentence preparedSentence = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO TAXLINES (ID, RECEIPT, TAXID, BASE, AMOUNT)  VALUES (?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
                if (ticket.getTaxes() != null) {
                    for (final TicketTaxInfo tickettax : ticket.getTaxes()) {
                        preparedSentence.exec((Object)new DataParams(){

                            @Override
                            public void writeValues() throws BasicException {
                                this.setString(1, UUID.randomUUID().toString());
                                this.setString(2, ticket.getId());
                                this.setString(3, tickettax.getTaxInfo().getId());
                                this.setDouble(4, tickettax.getSubTotal());
                                this.setDouble(5, tickettax.getTax());
                            }
                        });
                    }
                }
                if (ticket.getCustomerId() != null && (customerInfoExt = ticket.getCustomer()).getPointsEarned() > 0.0) {
                    PreparedSentence updatepoints = new PreparedSentence(DataLogicSales.this.s, "UPDATE CUSTOMERS SET POINTS = ? WHERE ID = ?", SerializerWriteParams.INSTANCE);
                    updatepoints.exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, ticket.getCustomer().getTotalPoints());
                            this.setString(2, ticket.getCustomerId());
                        }
                    });
                }
                return null;
            }
        };
        t1.execute();
        Runtime rtgc = Runtime.getRuntime();
        rtgc.gc();
    }

    public final void deleteTicket(final TicketInfo ticket, final String location) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                Date d = new Date();
                for (int i = 0; i < ticket.getLinesCount(); ++i) {
                    if (ticket.getLine(i).getProductID() == null) continue;
                    DataLogicSales.this.getStockDiaryInsert().exec(UUID.randomUUID().toString(), d, ticket.getLine(i).getMultiply() >= 0.0 ? MovementReason.IN_REFUND.getKey() : MovementReason.OUT_SALE.getKey(), location, ticket.getLine(i).getProductID(), ticket.getLine(i).getProductAttSetInstId(), new Double(ticket.getLine(i).getMultiply()), new Double(ticket.getLine(i).getPrice()));
                }
                for (PaymentInfo p : ticket.getPayments()) {
                    if (!"debt".equals(p.getName()) && !"debtpaid".equals(p.getName())) continue;
                    ticket.getCustomer().updateCurDebt(-p.getTotal(), ticket.getDate());
                    DataLogicSales.this.getDebtUpdate().exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, ticket.getCustomer().getCurdebt());
                            this.setTimestamp(2, ticket.getCustomer().getCurdate());
                            this.setString(3, ticket.getCustomer().getId());
                        }
                    });
                }
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM TAXLINES WHERE RECEIPT = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM TICKETLINES WHERE TICKET = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM TICKETS WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM DELIVERYORDERS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                new StaticSentence(DataLogicSales.this.s, "DELETE FROM RECEIPTS WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
                return null;
            }
        };
        t.execute();
    }

    public final Integer getNextTicketIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM").find((Object)"OUTLET1");
    }

    public final Integer getNextTicketIndex(String host) throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM", host).find();
    }

    public final Integer getNextTicketRefundIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_REFUND").find();
    }

    public final Integer getNextTicketRefundIndex(String host) throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_REFUND", host).find();
    }

    public final Integer getNextTicketPaymentIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_PAYMENT").find();
    }

    public final Integer getNextTicketPaymentIndex(String host) throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_PAYMENT", host).find();
    }

    public final Integer getNextTicketSupplierIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_SUPPLIER").find();
    }

    public final Integer getNextTicketSupplierIndex(String host) throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_SUPPLIER", host).find();
    }

    public final SentenceList getProductCatQBF() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.CATEGORY, P.TAXCAT, P.ATTRIBUTESET_ID, P.IMAGE, P.STOCKCOST, P.STOCKVOLUME, CASE WHEN P.INCAT=0 THEN " + this.s.DB.FALSE() + " ELSE " + this.s.DB.TRUE() + " END, P.CATORDER, P.ATTRIBUTES FROM PRODUCTS P WHERE ?(QBF_FILTER) ORDER BY P.REFERENCE", new String[]{"P.NAME", "P.PRICEBUY", "P.PRICESELL", "P.CATEGORY", "P.CODE"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), this.productsRow.getSerializerRead());
    }

    public final SentenceExec getProductCatInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                Object[] values = (Object[])params;
                int i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PRODUCTS (ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, ATTRIBUTESET_ID, IMAGE, STOCKCOST, STOCKVOLUME, ATTRIBUTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.productsRow.getDatas(), new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16})).exec(params);
                if (i > 0) {
                    i = DataLogicSales.this.auxMaterialProd(values, DataLogicSales.this.s);
                }
                return i;
            }
        };
    }

    public final String insertProduct(final ProductInfoExt pro) {
        try {
            int i = new PreparedSentence(this.s, "INSERT INTO PRODUCTS (ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, CATEGORY, TAXCAT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, pro.getID());
                    this.setString(2, pro.getReference());
                    this.setString(3, pro.getCode());
                    this.setString(4, pro.getName());
                    this.setBoolean(5, pro.isCom());
                    this.setBoolean(6, pro.isScale());
                    this.setDouble(7, pro.getPriceBuy());
                    this.setDouble(8, pro.getPriceSell());
                    this.setString(9, pro.getCategoryID());
                    this.setString(10, pro.getTaxCategoryID());
                }
            });
            return "1";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public final String insertCategory(final CategoryInfo cat) {
        try {
            int i = new PreparedSentence(this.s, "INSERT INTO CATEGORIES (ID, NAME) VALUES (?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, cat.getID());
                    this.setString(2, cat.getName());
                }
            });
            return "1";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private int auxMaterialProd(Object params, Session s) throws BasicException {
        Object[] values = (Object[])params;
        int i = 1;
        new PreparedSentence(s, "DELETE FROM PRODUCTS_MAT WHERE PRODUCT = ?", new SerializerWriteBasicExt(this.subgroupDatas, new int[]{0})).exec(params);
        int size = (Integer)values[17];
        int cont = 18;
        for (int e = 0; e < size && i > 0; ++e) {
            Object[] sparams = new Object[]{values[0], values[cont++], values[cont++]};
            i = new PreparedSentence(s, "INSERT INTO PRODUCTS_MAT (PRODUCT, MATERIAL, AMOUNT) VALUES (?, ?, ?)", new SerializerWriteBasicExt(new Datas[]{Datas.STRING, Datas.STRING, Datas.DOUBLE}, new int[]{0, 1, 2})).exec(sparams);
        }
        return i;
    }

    public final SentenceExec getProductCatUpdate() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                Object[] values = (Object[])params;
                int i = new PreparedSentence(DataLogicSales.this.s, "UPDATE PRODUCTS SET ID = ?, REFERENCE = ?, CODE = ?, NAME = ?, ISCOM = ?, ISSCALE = ?, PRICEBUY = ?, PRICESELL = ?, CATEGORY = ?, TAXCAT = ?, ATTRIBUTESET_ID = ?, IMAGE = ?, STOCKCOST = ?, STOCKVOLUME = ?, ATTRIBUTES = ?, INCAT = ?, CATORDER = ? WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.productsRow.getDatas(), new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 14, 15, 0})).exec(params);
                if (i > 0) {
                    i = DataLogicSales.this.auxMaterialProd(values, DataLogicSales.this.s);
                }
                return i;
            }
        };
    }

    public final SentenceExec getProductCatDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicSales.this.s, "DELETE FROM PRODUCTS_MAT WHERE PRODUCT = ?", new SerializerWriteBasicExt(DataLogicSales.this.productsRow.getDatas(), new int[]{0})).exec(params);
                return new PreparedSentence(DataLogicSales.this.s, "DELETE FROM PRODUCTS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.productsRow.getDatas(), new int[]{0})).exec(params);
            }
        };
    }

    public final SentenceExec getDebtUpdate() {
        return new PreparedSentence(this.s, "UPDATE CUSTOMERS SET CURDEBT = ?, CURDATE = ? WHERE ID LIKE ?", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec getAdvanceUpdate() {
        return new PreparedSentence(this.s, "UPDATE CUSTOMERS SET ADVANCE = ?, ADVANCEDATE = ? WHERE ID LIKE ?", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec getCreditUpdate() {
        return new PreparedSentence(this.s, "UPDATE SUPPLIERS SET CURDEBT = ?, CURDATE = ? WHERE ID LIKE ?", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec getPointsUpdate() {
        return new PreparedSentence(this.s, "UPDATE CUSTOMERS SET POINTS = POINTS - ? WHERE ID LIKE ?", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec getPurchaseInvoiceInsert() {
        return new PreparedSentence(this.s, "INSERT INTO PURCHASEINVOICE (ID, REFERENCE, SUPPLIERID, DELIVERYDATE, CREATEDBY, CREATEDDATE, STATUS) VALUES(?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec getPurchaseInvoiceLineInsert() {
        return new PreparedSentence(this.s, "INSERT INTO PURCHASEINVOICELINES (ID, PIID, PRODUCT, QUANTITY, UNITPRICE, TAXID) VALUES(?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec getPurchaseInvoiceTaxInsert() {
        return new PreparedSentence(this.s, "INSERT INTO PURCHASEINVOICETAXES (ID, PIID, TAXID, BASEAMOUNT, TAXAMOUNT) VALUES(?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec updatePriceBuy() {
        return new PreparedSentence(this.s, "UPDATE PRODUCTS SET PRICEBUY = ? WHERE ID = ?", SerializerWriteParams.INSTANCE);
    }

    public final SentenceExec updateProductCost() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int updateresult = new PreparedSentence(DataLogicSales.this.s, "UPDATE PRODUCT_COST SET COST = ? WHERE LOCATION = ? AND PRODUCT = ?", SerializerWriteParams.INSTANCE).exec(params);
                if (updateresult == 0) {
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PRODUCT_COST (COST, LOCATION, PRODUCT) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE).exec(params);
                }
                return 1;
            }
        };
    }

    public final SentenceExec getStockDiaryInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int updateresult;
                Object[] objtmp = (Object[])params;
                int n = updateresult = ((Object[])params)[5] == null ? new PreparedSentence(DataLogicSales.this.s, "UPDATE STOCKCURRENT SET UNITS = (UNITS + ?) WHERE LOCATION = ? AND PRODUCT = ? AND ATTRIBUTESETINSTANCE_ID IS NULL", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{6, 3, 4})).exec(params) : new PreparedSentence(DataLogicSales.this.s, "UPDATE STOCKCURRENT SET UNITS = (UNITS + ?) WHERE LOCATION = ? AND PRODUCT = ? AND ATTRIBUTESETINSTANCE_ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{6, 3, 4, 5})).exec(params);
                if (updateresult == 0) {
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO STOCKCURRENT (LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS) VALUES (?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{3, 4, 5, 6})).exec(params);
                }
                if (objtmp.length > 8 && objtmp[8] != null) {
                    final SupplierInfoExt supplier = (SupplierInfoExt)objtmp[8];
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO STOCKDIARY (ID, DATENEW, REASON, LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS, PRICE, SUPPLIER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, '" + supplier.getId() + "')", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{0, 1, 2, 3, 4, 5, 6, 7})).exec(params);
                    final Date curdate = (Date)objtmp[1];
                    int n2 = new PreparedSentence(DataLogicSales.this.s, "UPDATE SUPPLIERS SET CURDEBT = ?, CURDATE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, supplier.getCurcredit());
                            this.setTimestamp(2, curdate);
                            this.setString(3, supplier.getId());
                        }
                    });
                } else {
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO STOCKDIARY (ID, DATENEW, REASON, LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS, PRICE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{0, 1, 2, 3, 4, 5, 6, 7})).exec(params);
                }
                return 1;
            }
        };
    }

    public final SentenceExec getMaterialRequestInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO MATERIALREQUESTS(ID, LOCATION, CREATEDBY, CREATEDDATE, REQUESTSTATUS, REQUIREDON) VALUES (?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.materialrequestDatas, new int[]{0, 1, 2, 3, 4, 5})).exec(params);
                return i;
            }
        };
    }

    public final SentenceExec getMaterialRequestLinesInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO MATERIALREQUESTLINES(ID, MATERIALREQUEST, PRODUCT, QUANTITY, LINESTATUS) VALUES (?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.materialrequestlinesDatas, new int[]{0, 1, 2, 3, 4})).exec(params);
                return i;
            }
        };
    }

    public final SentenceExec getStockDiaryDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int updateresult;
                int n = updateresult = ((Object[])params)[5] == null ? new PreparedSentence(DataLogicSales.this.s, "UPDATE STOCKCURRENT SET UNITS = (UNITS - ?) WHERE LOCATION = ? AND PRODUCT = ? AND ATTRIBUTESETINSTANCE_ID IS NULL", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{6, 3, 4})).exec(params) : new PreparedSentence(DataLogicSales.this.s, "UPDATE STOCKCURRENT SET UNITS = (UNITS - ?) WHERE LOCATION = ? AND PRODUCT = ? AND ATTRIBUTESETINSTANCE_ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{6, 3, 4, 5})).exec(params);
                if (updateresult == 0) {
                    new PreparedSentence(DataLogicSales.this.s, "INSERT INTO STOCKCURRENT (LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS) VALUES (?, ?, ?, -(?))", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{3, 4, 5, 6})).exec(params);
                }
                new PreparedSentence(DataLogicSales.this.s, "DELETE FROM STOCKDIARY WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.stockdiaryDatas, new int[]{0})).exec(params);
                Object[] objtmp = (Object[])params;
                if (objtmp.length >= 13 && objtmp[13] != null) {
                    final Date curdate = (Date)objtmp[1];
                    Double curdebt = (Double)objtmp[6] * (Double)objtmp[7];
                    String supplier = (String)objtmp[13];
                    final SupplierInfoExt suppl = DataLogicSales.this.loadSupplierExt(supplier);
                    suppl.updateCurDebt(-curdebt.doubleValue(), curdate);
                    int n2 = new PreparedSentence(DataLogicSales.this.s, "UPDATE SUPPLIERS SET CURDEBT = ?, CURDATE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setDouble(1, suppl.getCurcredit());
                            this.setTimestamp(2, curdate);
                            this.setString(3, suppl.getId());
                        }
                    });
                }
                return 1;
            }
        };
    }

    public final SentenceExec getPaymentMovementInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicSales.this.s, "INSERT INTO RECEIPTS (ID, MONEY, DATENEW, ACCOUNTHEAD) VALUES (?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{0, 1, 2, 6})).exec(params);
                return new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL, NOTES) VALUES (?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{3, 0, 4, 5, 7})).exec(params);
            }
        };
    }

    public final SentenceExec getPaymentMovementDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicSales.this.s, "DELETE FROM PAYMENTS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{3})).exec(params);
                return new PreparedSentence(DataLogicSales.this.s, "DELETE FROM RECEIPTS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{0})).exec(params);
            }
        };
    }

    public final double findProductStock(String warehouse, String id, String attsetinstid) throws BasicException {
        PreparedSentence p = attsetinstid == null ? new PreparedSentence(this.s, "SELECT UNITS FROM STOCKCURRENT WHERE LOCATION = ? AND PRODUCT = ? AND ATTRIBUTESETINSTANCE_ID IS NULL", new SerializerWriteBasic(Datas.STRING, Datas.STRING), SerializerReadDouble.INSTANCE) : new PreparedSentence(this.s, "SELECT UNITS FROM STOCKCURRENT WHERE LOCATION = ? AND PRODUCT = ? AND ATTRIBUTESETINSTANCE_ID = ?", new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.STRING), SerializerReadDouble.INSTANCE);
        Double d = (Double)p.find(warehouse, id, attsetinstid);
        return d == null ? 0.0 : d;
    }

    public final SentenceExec getCatalogCategoryAdd() {
        return new StaticSentence(this.s, "UPDATE PRODUCTS SET INCAT=1 WHERE CATEGORY = ?", SerializerWriteString.INSTANCE);
    }

    public final SentenceExec getCatalogCategoryDel() {
        return new StaticSentence(this.s, "UPDATE PRODUCTS SET INCAT=0 WHERE CATEGORY = ?", SerializerWriteString.INSTANCE);
    }

    public final TableDefinition getTableCategories() {
        return new TableDefinition(this.s, "CATEGORIES", new String[]{"ID", "NAME", "PARENTID", "IMAGE"}, new String[]{"ID", AppLocal.getIntString("Label.Name"), "", AppLocal.getIntString("label.image")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.IMAGE}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.NULL}, new int[]{0}, "NAME");
    }

    public final TableDefinition getTableTaxes() {
        return new TableDefinition(this.s, "TAXES", new String[]{"ID", "NAME", "CATEGORY", "CUSTCATEGORY", "PARENTID", "RATE", "RATECASCADE", "RATEORDER"}, new String[]{"ID", AppLocal.getIntString("Label.Name"), AppLocal.getIntString("label.taxcategory"), AppLocal.getIntString("label.custtaxcategory"), AppLocal.getIntString("label.taxparent"), AppLocal.getIntString("label.dutyrate"), AppLocal.getIntString("label.cascade"), AppLocal.getIntString("label.order")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.BOOLEAN, Datas.INT}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.PERCENT, Formats.BOOLEAN, Formats.INT}, new int[]{0});
    }

    public final TableDefinition getTableTaxCustCategories() {
        return new TableDefinition(this.s, "TAXCUSTCATEGORIES", new String[]{"ID", "NAME"}, new String[]{"ID", AppLocal.getIntString("Label.Name")}, new Datas[]{Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public final TableDefinition getTableTaxCategories() {
        return new TableDefinition(this.s, "TAXCATEGORIES", new String[]{"ID", "NAME"}, new String[]{"ID", AppLocal.getIntString("Label.Name")}, new Datas[]{Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public final TableDefinition getTableLocations() {
        return new TableDefinition(this.s, "LOCATIONS", new String[]{"ID", "NAME", "ADDRESS"}, new String[]{"ID", AppLocal.getIntString("label.locationname"), AppLocal.getIntString("label.locationaddress")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public final TableDefinition getTableBanks() {
        return new TableDefinition(this.s, "BANKS", new String[]{"ID", "NAME", "CODE"}, new String[]{"ID", AppLocal.getIntString("bank.name"), AppLocal.getIntString("bank.code")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public final TableDefinition getTableAccountHeads() {
        return new TableDefinition(this.s, "ACCOUNTHEADS", new String[]{"ID", "NAME"}, new String[]{"ID", AppLocal.getIntString("accounthead.name")}, new Datas[]{Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING}, new int[]{0}, "LOWER(NAME) ");
    }

    public final TableDefinition getTableDrivers() {
        return new TableDefinition(this.s, "DRIVERS", new String[]{"ID", "DRIVERNAME", "CODE"}, new String[]{"ID", AppLocal.getIntString("driver.name"), AppLocal.getIntString("driver.code")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public final List<DriverInfo> getDrivers() throws BasicException {
        return new StaticSentence(this.s, "SELECT ID, DRIVERNAME, CODE FROM DRIVERS ORDER BY DRIVERNAME", null, (SerializerRead)new SerializerReadClass(DriverInfo.class)).list();
    }

    public final double getStock(String loc, String prodid) throws BasicException {
        StaticSentence bsentence = loc == null ? new StaticSentence(this.s, "SELECT SUM(UNITS) FROM STOCKCURRENT WHERE PRODUCT = '" + prodid + "'", null, SerializerReadInteger.INSTANCE) : new StaticSentence(this.s, "SELECT UNITS FROM STOCKCURRENT WHERE LOCATION='" + loc + "' AND PRODUCT = '" + prodid + "'", null, SerializerReadInteger.INSTANCE);
        DataResultSet ds = bsentence.openExec(this);
        double rcount = 0.0;
        if (ds != null && ds.next()) {
            rcount = ds.getCurrent() != null ? Double.parseDouble(ds.getCurrent().toString()) : 0.0;
        }
        return rcount;
    }

    public final double getCost(String loc, String prodid) throws BasicException {
        StaticSentence bsentence = loc == null ? new StaticSentence(this.s, "SELECT PRICEBUY FROM PRODUCTS WHERE ID = '" + prodid + "'", null, SerializerReadInteger.INSTANCE) : new StaticSentence(this.s, "SELECT COST FROM PRODUCT_COST WHERE LOCATION='" + loc + "' AND PRODUCT = '" + prodid + "'", null, SerializerReadInteger.INSTANCE);
        DataResultSet ds = bsentence.openExec(this);
        double rcount = 0.0;
        if (ds != null && ds.next()) {
            rcount = ds.getCurrent() != null ? Double.parseDouble(ds.getCurrent().toString()) : 0.0;
        }
        return rcount;
    }

    public final void savePrice(double price, String prodid) throws BasicException {
        Object[] values = new Object[]{price, prodid};
        Datas[] datas = new Datas[]{Datas.DOUBLE, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET PRICESELL =? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
        StringUtils.m_blIsPriceEdited = true;
    }

    public final void insertDeliveryOrderStandard(String id, String driver, String receipt) throws BasicException {
        Object[] values = new Object[]{id, driver, receipt};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "INSERT INTO DELIVERYORDERS (ID, DRIVERID, RECEIPT) VALUES (?, ?, ?);", new SerializerWriteBasicExt(datas, new int[]{0, 1, 2})).exec(values);
    }

    public final void updateCallStatus(int status, String callid) throws BasicException {
        Object[] values = new Object[]{status, callid};
        Datas[] datas = new Datas[]{Datas.INT, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE CALLS SET STATUS=? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
    }

    public final void updateDeliveryDriver(String driver, String deliveryid) throws BasicException {
        Object[] values = new Object[]{driver, deliveryid};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE DELIVERYORDERS SET DRIVERID=? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
    }

    public final void updateDeliveryDriverAndReceipt(String deliveryid, String driver, String receipt) throws BasicException {
        Object[] values = new Object[]{deliveryid, driver, receipt};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE DELIVERYORDERS SET DRIVERID=?, RECEIPT=? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{1, 2, 0})).exec(values);
    }

    public final void updateDeliveryAndReceipt(String deliveryid, String receipt) throws BasicException {
        Object[] values = new Object[]{deliveryid, receipt};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE DELIVERYORDERS SET RECEIPT=? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{1, 0})).exec(values);
    }

    public final TableDefinition getTableUnits() {
        return new TableDefinition(this.s, "UNITS", new String[]{"ID", "NAME", "SYMBOL"}, new String[]{"ID", AppLocal.getIntString("Label.Name"), AppLocal.getIntString("label.symbol")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public final SentenceList getUnitsList() {
        return new StaticSentence(this.s, "SELECT ID, NAME, SYMBOL FROM UNITS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(FloorsInfo.class));
    }

    public final SentenceList getMaterialQBF() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT DISTINCT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.CATEGORY, P.TAXCAT, P.IMAGE, P.STOCKCOST, P.STOCKVOLUME, MU.UNIT, MU.AMOUNT, MU.PRICEBUY, P.ATTRIBUTES FROM PRODUCTS P JOIN CATEGORIES C ON C.ID = P.CATEGORY LEFT OUTER JOIN MATERIALS_UNITS MU ON P.ID = MU.MATERIAL LEFT OUTER JOIN PRODUCTS_MAT PM ON P.ID = PM.MATERIAL WHERE (C.ID LIKE '-1' OR C.PARENTID LIKE '-1') AND ?(QBF_FILTER) ORDER BY P.NAME", new String[]{"P.NAME", "P.PRICEBUY", "PM.PRODUCT"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.STRING), (SerializerRead)new SerializerReadBasic(this.materialDatas));
    }

    public final SentenceExec getMaterialInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PRODUCTS (ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, IMAGE, STOCKCOST, STOCKVOLUME, ATTRIBUTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16})).exec(params);
                if (i > 0) {
                    i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO MATERIALS_UNITS (MATERIAL, UNIT, AMOUNT, PRICEBUY) VALUES (?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0, 13, 14, 15})).exec(params);
                }
                return i;
            }
        };
    }

    public final SentenceExec getMaterialUpdate() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                int i = new PreparedSentence(DataLogicSales.this.s, "UPDATE PRODUCTS SET ID = ?, REFERENCE = ?, CODE = ?, NAME = ?, ISSCALE = ?, PRICEBUY = ?, TAXCAT = ?, IMAGE = ?, STOCKCOST = ?, STOCKVOLUME = ?, ATTRIBUTES = ? WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0, 1, 2, 3, 5, 6, 9, 10, 11, 12, 16, 0})).exec(params);
                if (i > 0 && (i = new PreparedSentence(DataLogicSales.this.s, "UPDATE MATERIALS_UNITS SET MATERIAL = ?, UNIT = ?, AMOUNT = ?, PRICEBUY = ? WHERE MATERIAL = ?", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0, 13, 14, 15, 0})).exec(params)) == 0) {
                    i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO MATERIALS_UNITS (MATERIAL, UNIT, AMOUNT, PRICEBUY) VALUES (?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0, 13, 14, 15})).exec(params);
                }
                return i;
            }
        };
    }

    public final SentenceExec getMaterialDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicSales.this.s, "DELETE FROM MATERIALS_UNITS WHERE MATERIAL = ?", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0})).exec(params);
                return new PreparedSentence(DataLogicSales.this.s, "DELETE FROM PRODUCTS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.materialDatas, new int[]{0})).exec(params);
            }
        };
    }

    public final List<MaterialProdInfo> getMaterialsProd(String prodID, String catID) throws BasicException {
        String sAmount = "1 AS AMOUNT";
        String sWhere = "";
        String param = "";
        if (prodID != null && !prodID.equals("")) {
            sAmount = "PM.AMOUNT";
            sWhere = "WHERE PM.PRODUCT = ? ";
            param = prodID;
        } else if (catID != null && !catID.equals("")) {
            sAmount = "PM.AMOUNT";
            sWhere = "WHERE P.CATEGORY = ? ";
            param = catID;
        }
        if ("".equals(sWhere)) {
            return new StaticSentence(this.s, "SELECT DISTINCT P.ID, P.NAME, P.PRICEBUY, " + sAmount + ", U.NAME FROM PRODUCTS P JOIN CATEGORIES CAT ON P.CATEGORY = CAT.ID LEFT OUTER JOIN PRODUCTS_MAT PM ON P.ID = PM.MATERIAL LEFT JOIN MATERIALS_UNITS MU ON MU.MATERIAL = P.ID LEFT JOIN UNITS U ON MU.UNIT = U.ID  ORDER BY P.NAME", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(MaterialProdInfo.class)).list();
        }
        if (prodID != null && !prodID.equals("")) {
            return new PreparedSentence(this.s, "SELECT DISTINCT P.ID, P.NAME, P.PRICEBUY, " + sAmount + ", U.NAME FROM PRODUCTS P JOIN CATEGORIES CAT ON P.CATEGORY = CAT.ID LEFT OUTER JOIN PRODUCTS_MAT PM ON P.ID = PM.MATERIAL LEFT JOIN MATERIALS_UNITS MU ON MU.MATERIAL = P.ID LEFT JOIN UNITS U ON MU.UNIT = U.ID " + sWhere + " ORDER BY P.NAME", SerializerWriteString.INSTANCE, new SerializerReadClass(MaterialProdInfo.class)).list((Object)param);
        }
        return new PreparedSentence(this.s, "SELECT DISTINCT P.ID, P.NAME, P.PRICEBUY, 1, 1 FROM PRODUCTS P  " + sWhere + " ORDER BY P.NAME", SerializerWriteString.INSTANCE, new SerializerReadClass(MaterialProdInfo.class)).list((Object)param);
    }

    public final List<CategoryInfo> getCategoryMaterial() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, IMAGE FROM CATEGORIES WHERE ID LIKE '-1' OR PARENTID LIKE '-1' ", null, CategoryInfo.getSerializerRead()).list();
    }

    public final SentenceList getSingleProductCatQBF() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.CATEGORY, P.TAXCAT, P.ATTRIBUTESET_ID, P.IMAGE, P.STOCKCOST, P.STOCKVOLUME, NOT (P.INCAT=0), P.CATORDER, P.ATTRIBUTES FROM PRODUCTS P JOIN CATEGORIES CAT ON P.CATEGORY = CAT.ID WHERE CAT.ID NOT LIKE '-1' AND CAT.ID NOT LIKE '-2' AND (CAT.PARENTID IS NULL OR (CAT.PARENTID NOT LIKE '-1' AND CAT.PARENTID NOT LIKE '-2')) AND ?(QBF_FILTER) ORDER BY P.NAME", new String[]{"P.NAME", "P.PRICEBUY", "P.PRICESELL", "P.CATEGORY", "P.CODE"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.DOUBLE, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), this.productsRow.getSerializerRead());
    }

    public final SentenceList getMaterialList() {
        return new StaticSentence(this.s, "SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.TAXCAT, T.NAME, P.CATEGORY, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P JOIN CATEGORIES CAT ON P.CATEGORY = CAT.ID LEFT OUTER JOIN TAXCATEGORIES T ON P.TAXCAT = T.ID WHERE CAT.ID LIKE '-1' OR CAT.PARENTID LIKE '-1' ORDER BY P.NAME", null, ProductInfoExt.getSerializerRead());
    }

    public final List<ProductInfoExt> getProductStockable(String category) throws BasicException {
        return new PreparedSentence(this.s, "SELECT DISTINCT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, P.PRICESELL, P.TAXCAT, T.NAME, T.RATE, P.CATEGORY, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P LEFT OUTER JOIN TAXES T ON P.TAXCAT = T.ID LEFT OUTER JOIN CATEGORIES C ON P.CATEGORY = C.ID WHERE P.ID NOT IN (SELECT DISTINCT PRODUCT FROM PRODUCTS_MAT) AND P.CATEGORY = ? ORDER BY P.CATEGORY, P.NAME", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)category);
    }

    public final TableDefinition getTableTariffAreas() {
        return new TableDefinition(this.s, "TARIFFAREAS", new String[]{"ID", "NAME", "TARIFFORDER"}, new String[]{"ID", AppLocal.getIntString("Label.Name"), AppLocal.getIntString("label.prodorder")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.INT}, new Formats[]{Formats.STRING, Formats.STRING, Formats.INT}, new int[]{0});
    }

    public final List<ProductInfoExt> getTariffProds(String area) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, TAP.PRICESELL, P.TAXCAT, P.CATEGORY, P.ATTRIBUTESET_ID, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P  LEFT OUTER JOIN TARIFFAREAS_PROD TAP ON P.ID = TAP.PRODUCTID  LEFT OUTER JOIN TARIFFAREAS TA ON TA.ID = TAP.TARIFFID WHERE TA.ID = ? ORDER BY P.NAME", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)area);
    }

    public final List<ProductInfoExt> getTariffByProdIds(String area, String prodId) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.ID, P.REFERENCE, P.CODE, P.NAME, P.ISCOM, P.ISSCALE, P.PRICEBUY, TAP.PRICESELL, P.TAXCAT, P.CATEGORY, P.ATTRIBUTESET_ID, P.IMAGE, P.ATTRIBUTES, P.INCAT, P.CATORDER FROM PRODUCTS P  LEFT OUTER JOIN TARIFFAREAS_PROD TAP ON P.ID = TAP.PRODUCTID  LEFT OUTER JOIN TARIFFAREAS TA ON TA.ID = TAP.TARIFFID WHERE TA.ID = ? AND TAP.PRODUCTID IN (" + prodId + ") ORDER BY P.NAME", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)area);
    }

    public final SentenceExec getTariffAreaInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                Object[] values = (Object[])params;
                int i = new PreparedSentence(DataLogicSales.this.s, "INSERT INTO TARIFFAREAS (ID, NAME, TARIFFORDER) VALUES (?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.tariffareaDatas, new int[]{0, 1, 2})).exec(params);
                if (i > 0) {
                    i = DataLogicSales.this.auxTariffArea(values, DataLogicSales.this.s);
                }
                return i;
            }
        };
    }

    public final SentenceExec getTariffAreaUpdate() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                Object[] values = (Object[])params;
                int i = new PreparedSentence(DataLogicSales.this.s, "UPDATE TARIFFAREAS SET NAME = ?, TARIFFORDER = ? WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.tariffareaDatas, new int[]{1, 2, 0})).exec(params);
                if (i > 0) {
                    i = DataLogicSales.this.auxTariffArea(values, DataLogicSales.this.s);
                }
                return i;
            }
        };
    }

    private int auxTariffArea(Object params, Session s) throws BasicException {
        Object[] values = (Object[])params;
        int i = 1;
        new PreparedSentence(s, "DELETE FROM TARIFFAREAS_PROD WHERE TARIFFID = ?", new SerializerWriteBasicExt(this.tariffprodDatas, new int[]{0})).exec(params);
        int ssize = (Integer)values[3];
        int cont = 4;
        for (int e = 0; e < ssize && i > 0; ++e) {
            Object[] sparams = new Object[]{values[0], values[cont], values[cont + 1]};
            i = new PreparedSentence(s, "INSERT INTO TARIFFAREAS_PROD (TARIFFID, PRODUCTID, PRICESELL) VALUES (?, ?, ?)", new SerializerWriteBasicExt(this.tariffprodDatas, new int[]{0, 1, 2})).exec(sparams);
            cont += 2;
        }
        return i;
    }

    public final SentenceExec getTariffAreaDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                return new PreparedSentence(DataLogicSales.this.s, "DELETE FROM TARIFFAREAS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.productsRow.getDatas(), new int[]{0})).exec(params);
            }
        };
    }

    public final List<TariffInfo> getTariffAreaList() throws BasicException {
        return new StaticSentence(this.s, "SELECT ID, NAME, TARIFFORDER FROM TARIFFAREAS ORDER BY TARIFFORDER", null, (SerializerRead)new SerializerReadClass(TariffInfo.class)).list();
    }

    public final BufferedImage getProductImage(String pid) {
        try {
            PreparedSentence m_resourcebytes = new PreparedSentence(this.s, "SELECT IMAGE FROM PRODUCTS WHERE ID LIKE ?", SerializerWriteString.INSTANCE, SerializerReadImage.INSTANCE);
            BufferedImage img = (BufferedImage)m_resourcebytes.find((Object)pid);
            return img;
        }
        catch (BasicException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static class SupplierExtRead
    implements SerializerRead {
        protected SupplierExtRead() {
        }

        @Override
        public Object readValues(DataRead dr) throws BasicException {
            SupplierInfoExt c = new SupplierInfoExt(dr.getString(1));
            c.setTaxid(dr.getString(2));
            c.setSearchkey(dr.getString(3));
            c.setName(dr.getString(4));
            c.setCard(dr.getString(5));
            c.setTaxSupplierID(dr.getString(6));
            c.setNotes(dr.getString(7));
            c.setMaxdebt(dr.getDouble(8));
            c.setVisible(dr.getBoolean(9));
            c.setCurdate(dr.getTimestamp(10));
            c.setCurdebt(dr.getDouble(11));
            c.setFirstname(dr.getString(12));
            c.setLastname(dr.getString(13));
            c.setEmail(dr.getString(14));
            c.setPhone(dr.getString(15));
            c.setPhone2(dr.getString(16));
            c.setFax(dr.getString(17));
            c.setAddress(dr.getString(18));
            c.setAddress2(dr.getString(19));
            c.setPostal(dr.getString(20));
            c.setCity(dr.getString(21));
            c.setRegion(dr.getString(22));
            c.setCountry(dr.getString(23));
            return c;
        }
    }

    protected static class CustomerExtRead
    implements SerializerRead {
        protected CustomerExtRead() {
        }

        @Override
        public Object readValues(DataRead dr) throws BasicException {
            CustomerInfoExt c = new CustomerInfoExt(dr.getString(1));
            c.setTaxid(dr.getString(2));
            c.setSearchkey(dr.getString(3));
            c.setName(dr.getString(4));
            c.setCard(dr.getString(5));
            c.setTaxCustomerID(dr.getString(6));
            c.setNotes(dr.getString(7));
            c.setMaxdebt(dr.getDouble(8));
            c.setVisible(dr.getBoolean(9));
            c.setCurdate(dr.getTimestamp(10));
            c.setCurdebt(dr.getDouble(11));
            c.setFirstname(dr.getString(12));
            c.setLastname(dr.getString(13));
            c.setEmail(dr.getString(14));
            c.setPhone(dr.getString(15));
            c.setPhone2(dr.getString(16));
            c.setFax(dr.getString(17));
            c.setAddress(dr.getString(18));
            c.setAddress2(dr.getString(19));
            c.setPostal(dr.getString(20));
            c.setCity(dr.getString(21));
            c.setRegion(dr.getString(22));
            c.setCountry(dr.getString(23));
            c.setPoints(dr.getDouble(24));
            c.setCurAdvance(dr.getDouble(25));
            c.setAdvanceDate(dr.getTimestamp(26));
            return c;
        }
    }
}

