/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.basic.BasicException;
import com.posics.beans.RoundedBorder;
import com.posics.data.gui.JMessageDialog;
import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppUser;
import com.posics.pos.forms.AppUserView;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelMenu;
import com.posics.pos.forms.JPanelNull;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.forms.JRootApp;
import com.posics.pos.forms.MenuDefinition;
import com.posics.pos.forms.MenuExecAction;
import com.posics.pos.forms.MenuPanelAction;
import com.posics.pos.forms.ProcessAction;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.Backup;
import com.posics.pos.util.Hashcypher;
import com.posics.pos.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class JPrincipalApp
extends JPanel
implements AppUserView {
    private static Logger logger = Logger.getLogger("com.posics.pos.forms.JPrincipalApp");
    private JRootApp m_appview;
    private AppUser m_appuser;
    private DataLogicSystem m_dlSystem;
    private JButton m_principalnotificator;
    private JPanelView m_jLastView;
    private Action m_actionfirst;
    private Map<String, JPanelView> m_aPreparedViews;
    private Map<String, JPanelView> m_aCreatedViews;
    private Icon menu_open;
    private Icon menu_close;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel m_jPanelContainer;
    private JScrollPane m_jPanelLeft;
    private JPanel m_jPanelRight;
    private JPanel m_jPanelTitle;
    private JLabel m_jTitle;

    public JPrincipalApp(JRootApp appview, AppUser appuser) {
        this.m_appview = appview;
        this.m_appuser = appuser;
        this.m_dlSystem = (DataLogicSystem)this.m_appview.getBean("com.posics.pos.forms.DataLogicSystem");
        this.m_appuser.fillPermissions(this.m_dlSystem);
        this.m_actionfirst = null;
        this.m_jLastView = null;
        this.m_aPreparedViews = new HashMap<String, JPanelView>();
        this.m_aCreatedViews = new HashMap<String, JPanelView>();
        this.initComponents();
        this.jPanel2.add(Box.createVerticalStrut(50), 0);
        this.applyComponentOrientation(appview.getComponentOrientation());
        this.m_principalnotificator = new JButton();
        this.m_principalnotificator.applyComponentOrientation(this.getComponentOrientation());
        this.m_principalnotificator.setText(this.m_appuser.getName());
        this.m_principalnotificator.setIcon(this.m_appuser.getIcon());
        this.m_principalnotificator.setFocusable(false);
        this.m_principalnotificator.revalidate();
        this.m_principalnotificator.repaint();
        this.m_principalnotificator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPrincipalApp.this.m_appview.closeAppView();
            }
        });
        if (this.jButton1.getComponentOrientation().isLeftToRight()) {
            this.menu_open = new ImageIcon(this.getClass().getResource("/com/posics/images/menu-right.png"));
            this.menu_close = new ImageIcon(this.getClass().getResource("/com/posics/images/menu-left.png"));
        } else {
            this.menu_open = new ImageIcon(this.getClass().getResource("/com/posics/images/menu-left.png"));
            this.menu_close = new ImageIcon(this.getClass().getResource("/com/posics/images/menu-right.png"));
        }
        this.assignMenuButtonIcon();
        this.m_jPanelTitle.setBorder(RoundedBorder.createGradientBorder());
        this.m_jPanelTitle.setVisible(false);
        this.m_jPanelContainer.add((Component)new JPanel(), "<NULL>");
        this.showView("<NULL>");
        try {
            this.m_jPanelLeft.setViewportView(this.getScriptMenu(this.m_dlSystem.getResourceAsText("Menu.PDA")));
        }
        catch (ScriptException e) {
            logger.log(Level.SEVERE, "Cannot read Menu.PDA resource. Trying defaut menu.", e);
            try {
                this.m_jPanelLeft.setViewportView(this.getScriptMenu(StringUtils.readResource("/com/posics/pos/templates/Menu.PDA.txt")));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Cannot read default menu", ex);
            }
            catch (ScriptException es) {
                logger.log(Level.SEVERE, "Cannot read default menu", es);
            }
        }
        this.jButton1.setMnemonic(44);
        this.setMenuVisible(false);
    }

    private Component getScriptMenu(String menutext) throws ScriptException {
        ScriptMenu menu = new ScriptMenu();
        ScriptEngine eng = ScriptFactory.getScriptEngine("beanshell");
        eng.put("menu", menu);
        eng.eval(menutext);
        return menu.getTaskPane();
    }

    private void assignMenuButtonIcon() {
        this.jButton1.setIcon(this.m_jPanelLeft.isVisible() ? this.menu_close : this.menu_open);
    }

    private void setMenuVisible(boolean value) {
        this.m_jPanelLeft.setVisible(value);
        this.assignMenuButtonIcon();
        this.revalidate();
    }

    public JComponent getNotificator() {
        return this.m_principalnotificator;
    }

    public void activate() {
        if (this.m_actionfirst != null) {
            this.m_actionfirst.actionPerformed(null);
            this.m_actionfirst = null;
        }
    }

    public boolean deactivate() {
        if (this.m_jLastView == null) {
            return true;
        }
        if (this.m_jLastView.deactivate()) {
            this.m_jLastView = null;
            this.showView("<NULL>");
            return true;
        }
        return false;
    }

    private void showView(String sView) {
        CardLayout cl = (CardLayout)this.m_jPanelContainer.getLayout();
        cl.show(this.m_jPanelContainer, sView);
    }

    @Override
    public AppUser getUser() {
        return this.m_appuser;
    }

    @Override
    public void showTask(String sTaskClass) {
        this.m_appview.waitCursorBegin();
        if (this.m_appuser.hasPermission(sTaskClass)) {
            JPanelView m_jMyView = this.m_aCreatedViews.get(sTaskClass);
            if (this.m_jLastView == null || m_jMyView != this.m_jLastView && this.m_jLastView.deactivate()) {
                if (m_jMyView == null) {
                    m_jMyView = this.m_aPreparedViews.get(sTaskClass);
                    if (m_jMyView == null) {
                        try {
                            m_jMyView = (JPanelView)this.m_appview.getBean(sTaskClass);
                        }
                        catch (BeanFactoryException e) {
                            m_jMyView = new JPanelNull(this.m_appview, e);
                        }
                    }
                    m_jMyView.getComponent().applyComponentOrientation(this.getComponentOrientation());
                    this.m_jPanelContainer.add((Component)m_jMyView.getComponent(), sTaskClass);
                    this.m_aCreatedViews.put(sTaskClass, m_jMyView);
                }
                try {
                    m_jMyView.activate();
                }
                catch (BasicException e) {
                    JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.notactive"), e));
                }
                this.m_jLastView = m_jMyView;
                this.showView(sTaskClass);
                String sTitle = m_jMyView.getTitle();
                this.m_jPanelTitle.setVisible(sTitle != null);
                this.m_jTitle.setText(sTitle);
                this.setMenuVisible(false);
            }
        } else {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.notpermissions")));
        }
        this.m_appview.waitCursorEnd();
    }

    @Override
    public void executeTask(String sTaskClass) {
        this.m_appview.waitCursorBegin();
        if (this.m_appuser.hasPermission(sTaskClass)) {
            try {
                ProcessAction myProcess = (ProcessAction)this.m_appview.getBean(sTaskClass);
                try {
                    MessageInf m = myProcess.execute();
                    if (m != null) {
                        JMessageDialog.showMessage(this, m);
                    }
                }
                catch (BasicException eb) {
                    JMessageDialog.showMessage(this, new MessageInf(eb));
                }
            }
            catch (BeanFactoryException e) {
                JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("Label.LoadError"), e));
            }
        } else {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.notpermissions")));
        }
        this.m_appview.waitCursorEnd();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.m_jPanelLeft = new JScrollPane();
        this.m_jPanelRight = new JPanel();
        this.m_jPanelTitle = new JPanel();
        this.m_jTitle = new JLabel();
        this.m_jPanelContainer = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setMargin(new Insets(14, 2, 14, 2));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPrincipalApp.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jPanel1.add((Component)this.jPanel2, "After");
        this.jPanel1.add((Component)this.m_jPanelLeft, "Center");
        this.add((Component)this.jPanel1, "Before");
        this.m_jPanelRight.setLayout(new BorderLayout());
        this.m_jPanelTitle.setLayout(new BorderLayout());
        this.m_jTitle.setFont(new Font("SansSerif", 1, 18));
        this.m_jTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.m_jPanelTitle.add((Component)this.m_jTitle, "North");
        this.m_jPanelRight.add((Component)this.m_jPanelTitle, "North");
        this.m_jPanelContainer.setLayout(new CardLayout());
        this.m_jPanelRight.add((Component)this.m_jPanelContainer, "Center");
        this.add((Component)this.m_jPanelRight, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setMenuVisible(!this.m_jPanelLeft.isVisible());
    }

    private class UpdateSoftware
    extends AbstractAction {
        public UpdateSoftware(String icon, String keytext) {
            this.putValue("SmallIcon", new ImageIcon(JPrincipalApp.class.getResource(icon)));
            this.putValue("Name", AppLocal.getIntString(keytext));
            this.putValue("taskname", keytext);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Backup.updateSoftware(JPrincipalApp.this);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    private class ChangePasswordAction
    extends AbstractAction {
        public ChangePasswordAction(String icon, String keytext) {
            this.putValue("SmallIcon", new ImageIcon(JPrincipalApp.class.getResource(icon)));
            this.putValue("Name", AppLocal.getIntString(keytext));
            this.putValue("taskname", keytext);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String sNewPassword = Hashcypher.changePassword(JPrincipalApp.this, JPrincipalApp.this.m_appuser.getPassword());
            if (sNewPassword != null) {
                try {
                    JPrincipalApp.this.m_dlSystem.execChangePassword(new Object[]{sNewPassword, JPrincipalApp.this.m_appuser.getId()});
                    JPrincipalApp.this.m_appuser.setPassword(sNewPassword);
                }
                catch (BasicException e) {
                    JMessageDialog.showMessage(JPrincipalApp.this, new MessageInf(-33554432, AppLocal.getIntString("message.cannotchangepassword")));
                }
            }
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction(String icon, String keytext) {
            this.putValue("SmallIcon", new ImageIcon(JPrincipalApp.class.getResource(icon)));
            this.putValue("Name", AppLocal.getIntString(keytext));
            this.putValue("taskname", keytext);
            this.putValue("MnemonicKey", 88);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JPrincipalApp.this.m_appview.closeAppView();
        }
    }

    public class ScriptSubmenu {
        private MenuDefinition menudef;

        private ScriptSubmenu(String key) {
            this.menudef = new MenuDefinition(key);
        }

        public void addTitle(String key) {
            this.menudef.addMenuTitle(key);
        }

        public void addPanel(String icon, String key, String classname) {
            this.menudef.addMenuItem(new MenuPanelAction(JPrincipalApp.this.m_appview, icon, key, classname));
        }

        public void addExecution(String icon, String key, String classname) {
            this.menudef.addMenuItem(new MenuExecAction(JPrincipalApp.this.m_appview, icon, key, classname));
        }

        public ScriptSubmenu addSubmenu(String icon, String key, String classname) {
            ScriptSubmenu submenu = new ScriptSubmenu(key);
            JPrincipalApp.this.m_aPreparedViews.put(classname, new JPanelMenu(submenu.getMenuDefinition()));
            this.menudef.addMenuItem(new MenuPanelAction(JPrincipalApp.this.m_appview, icon, key, classname));
            return submenu;
        }

        public void addChangePasswordAction() {
            this.menudef.addMenuItem(new ChangePasswordAction("/com/posics/images/password22.png", "Menu.ChangePassword"));
        }

        public void addUpdateSoftware() {
            this.menudef.addMenuItem(new UpdateSoftware("/com/posics/images/updatesoftware.png", "Menu.UpdateSoftware"));
        }

        public void addExitAction() {
            this.menudef.addMenuItem(new ExitAction("/com/posics/images/gohome.png", "Menu.Exit"));
        }

        public MenuDefinition getMenuDefinition() {
            return this.menudef;
        }
    }

    public class ScriptGroup {
        private JXTaskPane taskGroup = new JXTaskPane();

        private ScriptGroup(String key) {
            this.taskGroup.applyComponentOrientation(JPrincipalApp.this.getComponentOrientation());
            this.taskGroup.setFocusable(false);
            this.taskGroup.setRequestFocusEnabled(false);
            this.taskGroup.setTitle(AppLocal.getIntString(key));
            this.taskGroup.setVisible(false);
        }

        public void addPanel(String icon, String key, String classname) {
            this.addAction(new MenuPanelAction(JPrincipalApp.this.m_appview, icon, key, classname));
        }

        public void addExecution(String icon, String key, String classname) {
            this.addAction(new MenuExecAction(JPrincipalApp.this.m_appview, icon, key, classname));
        }

        public ScriptSubmenu addSubmenu(String icon, String key, String classname) {
            ScriptSubmenu submenu = new ScriptSubmenu(key);
            JPrincipalApp.this.m_aPreparedViews.put(classname, new JPanelMenu(submenu.getMenuDefinition()));
            this.addAction(new MenuPanelAction(JPrincipalApp.this.m_appview, icon, key, classname));
            return submenu;
        }

        public void addChangePasswordAction() {
            this.addAction(new ChangePasswordAction("/com/posics/images/password22.png", "Menu.ChangePassword"));
        }

        public void addUpdateSoftware() {
            this.addAction(new UpdateSoftware("/com/posics/images/updatesoftware.png", "Menu.UpdateSoftware"));
        }

        public void addExitAction() {
            this.addAction(new ExitAction("/com/posics/images/gohome.png", "Menu.Exit"));
        }

        private void addAction(Action act) {
            if (JPrincipalApp.this.m_appuser.hasPermission((String)act.getValue("taskname"))) {
                JButton btn = new JButton(act);
                btn.setHorizontalAlignment(2);
                Component c = this.taskGroup.add((Component)btn);
                c.applyComponentOrientation(JPrincipalApp.this.getComponentOrientation());
                c.setFocusable(false);
                this.taskGroup.setVisible(true);
                if (JPrincipalApp.this.m_actionfirst == null) {
                    JPrincipalApp.this.m_actionfirst = act;
                }
            }
        }

        public JXTaskPane getTaskGroup() {
            return this.taskGroup;
        }
    }

    public class ScriptMenu {
        private JXTaskPaneContainer taskPane = new JXTaskPaneContainer();

        private ScriptMenu() {
            this.taskPane.applyComponentOrientation(JPrincipalApp.this.getComponentOrientation());
        }

        public ScriptGroup addGroup(String key) {
            ScriptGroup group = new ScriptGroup(key);
            this.taskPane.add(group.getTaskGroup());
            return group;
        }

        public JXTaskPaneContainer getTaskPane() {
            return this.taskPane;
        }
    }
}

