/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.basic.BasicException;
import com.posics.beans.JPasswordPanel;
import com.posics.beans.JPinEvent;
import com.posics.beans.JPinEventListener;
import com.posics.data.gui.JMessageDialog;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.BatchSentenceResource;
import com.posics.data.loader.Session;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.forms.AppUser;
import com.posics.pos.forms.AppUserView;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.AppViewConnection;
import com.posics.pos.forms.BeanFactory;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.BeanFactoryObj;
import com.posics.pos.forms.BeanFactoryScript;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPrincipalApp;
import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.scale.DeviceScale;
import com.posics.pos.util.Backup;
import com.posics.pos.util.Battery;
import com.posics.pos.util.BatteryObservable;
import com.posics.pos.util.BatteryState;
import com.posics.pos.util.ClockObservable;
import com.posics.pos.util.ConnectionObservable;
import com.posics.pos.util.InternetConnectionState;
import com.posics.pos.util.NetworkPrinterConnectionObservable;
import com.posics.pos.util.NetworkPrinterConnectionState;
import com.posics.pos.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JRootApp
extends JPanel
implements AppView {
    private AppProperties m_props;
    private Session session;
    private DataLogicSystem m_dlSystem;
    private Properties m_propsdb = null;
    private int m_iActiveCashToken;
    private String m_sActiveCashIndex;
    private int m_iActiveCashSequence;
    private int m_iActiveCashOrderNumber;
    private int m_iActiveCashPrintCount;
    private Double m_dActiveCashActual;
    private Double m_dActiveCardActual;
    private String m_sActiveCashNotes;
    private Date m_dActiveCashDateStart;
    private Date m_dActiveCashDateEnd;
    private String m_sInventoryLocation;
    private String m_sReceiptHost;
    private StringBuffer inputtext;
    private DeviceScale m_Scale;
    private DeviceTicket m_TP;
    private TicketParser m_TTP;
    private Map<String, BeanFactory> m_aBeanFactories = new HashMap<String, BeanFactory>();
    private JPrincipalApp m_principalapp = null;
    private static HashMap<String, String> m_oldclasses;
    private static DateFormat m_dateformat;
    private static DateFormat m_timeformat;
    private Timer m_jtimer;
    private Date m_dCurrentDate;
    ConnectionObservable observableConnection;
    NetworkPrinterConnectionObservable observableConnectionNetworkPrinter;
    ClockObservable observableClock;
    BatteryObservable observableBattery;
    InternetConnectionObserver internetConnectionObserver;
    NetworkPrinterConnectionObserver networkPrinterConnectionObserver;
    ClockObserver clockObserver;
    BatteryObserver batteryObserver;
    AppConfig config;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel10;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JPasswordPanel jPasswordDialog1;
    private JLabel m_jBattery;
    private JButton m_jCMD1;
    private JButton m_jCMD2;
    private JButton m_jCMD3;
    private JButton m_jCalc;
    private JLabel m_jCalendar;
    private JButton m_jClose;
    private JLabel m_jHost;
    private JButton m_jKB;
    private JLabel m_jLblTitle;
    private JLabel m_jNetworkPrinterStatus;
    private JButton m_jOnline;
    private JPanel m_jPanelContainer;
    private JPanel m_jPanelDown;
    private JPanel m_jPanelLogin;
    private JPanel m_jPanelTitle;
    private JButton m_jRestart;
    private JPanel panelTask;
    private JLabel poweredby;

    public JRootApp() {
        this.initComponents();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initApp(AppProperties props) {
        String url;
        String sWareHouse;
        block28: {
            this.m_props = props;
            this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            try {
                this.session = AppViewConnection.createSession(this.m_props);
            }
            catch (BasicException e) {
                JMessageDialog.showMessage(this, new MessageInf(-16777216, e.getMessage(), e));
                String dburl2 = props.getProperty("db.URL2");
                if (dburl2 != null && dburl2.trim().length() > 0 && JOptionPane.showConfirmDialog(this, "Do you want to connect to the database " + dburl2 + "?", AppLocal.getIntString("message.title"), 0, 3) == 0) {
                    String dbuser2 = props.getProperty("db.user2");
                    String dbpwd2 = props.getProperty("db.password2");
                    this.m_props.setProperty("db.URL", dburl2);
                    this.m_props.setProperty("db.user", dbuser2);
                    this.m_props.setProperty("db.password", dbpwd2);
                    try {
                        this.session = AppViewConnection.createSession(this.m_props);
                    }
                    catch (BasicException e2) {
                        JMessageDialog.showMessage(this, new MessageInf(-16777216, e2.getMessage(), e2));
                        String dburl3 = props.getProperty("db.URL3");
                        if (dburl3 != null && dburl3.trim().length() > 0 && JOptionPane.showConfirmDialog(this, "Do you want to connect to the database " + dburl3 + "?", AppLocal.getIntString("message.title"), 0, 3) == 0) {
                            String dbuser3 = props.getProperty("db.user3");
                            String dbpwd3 = props.getProperty("db.password3");
                            this.m_props.setProperty("db.URL", dburl3);
                            this.m_props.setProperty("db.user", dbuser3);
                            this.m_props.setProperty("db.password", dbpwd3);
                            try {
                                this.session = AppViewConnection.createSession(this.m_props);
                                break block28;
                            }
                            catch (BasicException e3) {
                                JMessageDialog.showMessage(this, new MessageInf(-16777216, e3.getMessage(), e3));
                                return false;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
        }
        this.m_dlSystem = (DataLogicSystem)this.getBean("com.posics.pos.forms.DataLogicSystem");
        String sDBVersion = this.readDataBaseVersion();
        if (!"1.0".equals(sDBVersion)) {
            String sScript;
            String string = sScript = sDBVersion == null ? this.m_dlSystem.getInitScript() + "-create.sql" : this.m_dlSystem.getInitScript() + "-upgrade-" + sDBVersion + ".sql";
            if (JRootApp.class.getResource(sScript) == null) {
                JMessageDialog.showMessage(this, new MessageInf(-16777216, sDBVersion == null ? AppLocal.getIntString("message.databasenotsupported", this.session.DB.getName()) : AppLocal.getIntString("message.noupdatescript")));
                this.session.close();
                return false;
            }
            if (JOptionPane.showConfirmDialog(this, AppLocal.getIntString(sDBVersion == null ? "message.createdatabase" : "message.updatedatabase"), AppLocal.getIntString("message.title"), 0, 3) != 0) {
                this.session.close();
                return false;
            }
            try {
                BatchSentenceResource bsentence = new BatchSentenceResource(this.session, sScript);
                bsentence.putParameter("APP_ID", Matcher.quoteReplacement("SaleculatorPDA"));
                bsentence.putParameter("APP_NAME", Matcher.quoteReplacement("Saleculator PDA"));
                bsentence.putParameter("APP_VERSION", Matcher.quoteReplacement("1.0"));
                List l = bsentence.list();
                if (l.size() > 0) {
                    JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("Database.ScriptWarning"), l.toArray(new Throwable[l.size()])));
                }
            }
            catch (BasicException e) {
                JMessageDialog.showMessage(this, new MessageInf(-16777216, AppLocal.getIntString("Database.ScriptError"), e));
                this.session.close();
                return false;
            }
        }
        this.m_propsdb = this.m_dlSystem.getResourceAsProperties(this.m_props.getHost() + "/properties");
        try {
            Object[] valcash;
            String sActiveCashIndex = this.m_propsdb.getProperty("activecash");
            Object[] objectArray = valcash = sActiveCashIndex == null ? null : this.m_dlSystem.findActiveCash(sActiveCashIndex);
            if (valcash == null || !this.m_props.getHost().equals(valcash[0])) {
                this.setActiveCash(UUID.randomUUID().toString(), this.m_dlSystem.getSequenceCash(this.m_props.getHost()) + 1, new Date(), null, null, null, null, 0);
                this.setActiveCashToken(1);
                this.setActiveCashOrderNumber(1);
                this.m_dlSystem.execInsertCash(new Object[]{this.getActiveCashIndex(), this.m_props.getHost(), this.getActiveCashSequence(), this.getActiveCashDateStart(), this.getActiveCashDateEnd()});
                this.m_dlSystem.execInsertOrderNumber(new Object[]{1, this.getActiveCashIndex()});
            } else {
                this.setActiveCash(sActiveCashIndex, (Integer)valcash[1], (Date)valcash[2], (Date)valcash[3], (Double)valcash[4], (Double)valcash[5], (String)valcash[6], (Integer)valcash[7]);
                this.setActiveCashToken(this.m_dlSystem.getSequenceToken(sActiveCashIndex));
                this.setActiveCashOrderNumber(this.m_dlSystem.getNextOrderNumber(this.getActiveCashIndex()));
            }
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotclosecash"), e);
            msg.show(this);
            this.session.close();
            return false;
        }
        this.m_sInventoryLocation = this.m_propsdb.getProperty("location");
        if (this.m_sInventoryLocation == null) {
            this.m_sInventoryLocation = "0";
            this.m_propsdb.setProperty("location", this.m_sInventoryLocation);
            this.m_dlSystem.setResourceAsProperties(this.m_props.getHost() + "/properties", this.m_propsdb);
        }
        this.m_sReceiptHost = this.m_props.getReceiptHost();
        this.m_TP = new DeviceTicket(this, this.m_props);
        this.config = new AppConfig(new String[0]);
        this.config.load();
        this.m_TTP = new TicketParser(this.getDeviceTicket(), this.m_dlSystem);
        this.printerStart();
        this.m_Scale = new DeviceScale(this, this.m_props);
        BufferedImage imgicon = this.m_dlSystem.getResourceAsImage("Window.Logo");
        this.m_jLblTitle.setIcon(imgicon == null ? null : new ImageIcon(imgicon));
        this.m_jLblTitle.setText(this.m_dlSystem.getResourceAsText("Window.Title"));
        try {
            sWareHouse = this.m_dlSystem.findLocationName(this.m_sInventoryLocation);
        }
        catch (BasicException e) {
            sWareHouse = null;
        }
        try {
            url = this.session.getURL();
            String[] db = url.split("://");
            if (db.length == 2) {
                url = db[1];
            }
        }
        catch (SQLException e) {
            url = "";
        }
        this.m_jHost.setText("<html>" + this.m_props.getMachineName() + " - " + this.m_props.getHost() + " - " + sWareHouse + "<br>" + url);
        this.jPasswordDialog1.addJPinEventListener(new JPinEventListener(){

            @Override
            public void pinEntered(JPinEvent e) {
                JRootApp.this.checkPin(e.getPin());
            }
        });
        this.showLogin();
        this.showDateTime();
        this.observableConnection = new ConnectionObservable();
        this.observableConnectionNetworkPrinter = new NetworkPrinterConnectionObservable();
        this.observableClock = new ClockObservable();
        this.observableBattery = new BatteryObservable();
        this.internetConnectionObserver = new InternetConnectionObserver(this.observableConnection);
        this.networkPrinterConnectionObserver = new NetworkPrinterConnectionObserver(this.observableConnectionNetworkPrinter);
        this.clockObserver = new ClockObserver(this.observableClock);
        this.batteryObserver = new BatteryObserver(this.observableBattery);
        this.showOnlineStatus();
        this.showCommandButtons();
        if (StringUtils.networkprinterpool.size() > 0) {
            this.m_jNetworkPrinterStatus.setVisible(true);
        } else {
            this.m_jNetworkPrinterStatus.setVisible(false);
        }
        this.m_jClose.setMnemonic(79);
        this.m_jRestart.setMnemonic(82);
        if (StringUtils.m_blIsDemo) {
            this.jLabel2.setText("PDA v1.0 u20 DEMO");
        } else {
            this.jLabel2.setText("PDA v1.0 u20");
        }
        this.m_jBattery.setVisible(false);
        return true;
    }

    private void showDateTime() {
        this.m_dCurrentDate = new Date();
        this.m_jCalendar.setText("<html>" + m_dateformat.format(this.m_dCurrentDate) + "<br>" + m_timeformat.format(this.m_dCurrentDate));
    }

    private void showBatteryStatus(Battery bat) {
        if (!this.m_jBattery.isVisible()) {
            this.m_jBattery.setVisible(true);
        }
        if (bat.getRemainingCharge() < 25) {
            if (bat.isCharging()) {
                this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery1p.png")));
            } else {
                this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery1p.png")));
            }
        } else if (bat.getRemainingCharge() < 50) {
            if (bat.isCharging()) {
                this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery2p.png")));
            } else {
                this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery2.png")));
            }
        } else if (bat.getRemainingCharge() < 75) {
            if (bat.isCharging()) {
                this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery3p.png")));
            } else {
                this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery3.png")));
            }
        } else if (bat.isCharging()) {
            this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery4p.png")));
        } else {
            this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery4.png")));
        }
    }

    private void showCommandButtons() {
        try {
            String strScript = this.config.getProperty("Script.Calculator");
            if (strScript.trim().length() == 0) {
                this.m_jCalc.setVisible(false);
            }
            if ((strScript = this.config.getProperty("Script.KB")).trim().length() == 0) {
                this.m_jKB.setVisible(false);
            }
            if ((strScript = this.config.getProperty("Script.CMD1")).trim().length() == 0) {
                this.m_jCMD1.setVisible(false);
            }
            if ((strScript = this.config.getProperty("Script.CMD2")).trim().length() == 0) {
                this.m_jCMD2.setVisible(false);
            }
            if ((strScript = this.config.getProperty("Script.CMD3")).trim().length() == 0) {
                this.m_jCMD3.setVisible(false);
            }
            if ((strScript = this.config.getProperty("TicketProperties")) != null && strScript.trim().toLowerCase().equals("true")) {
                StringUtils.m_blTicketProperties = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Script Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void showOnlineStatus() {
        if (this.isOnline()) {
            this.m_jOnline.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/online.png")));
            StringUtils.m_blIsOnline = true;
        } else {
            this.m_jOnline.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/offline.png")));
            StringUtils.m_blIsOnline = false;
        }
        this.m_jOnline.repaint();
    }

    @Override
    public boolean isOnline() {
        return this.observableConnection.isInternetConnectionAvailable();
    }

    private String readDataBaseVersion() {
        try {
            return this.m_dlSystem.findVersion();
        }
        catch (BasicException ed) {
            return null;
        }
    }

    public void tryToClose() {
        if (this.closeAppView()) {
            this.m_TP.getDeviceDisplay().clearVisor();
            this.session.close();
            String turnoffScript = this.m_props.getProperty("Script.TurnOff");
            String OS = System.getProperty("os.name").toLowerCase();
            if (turnoffScript.equals("") || !OS.contains("nix") && !OS.contains("nux") && !OS.contains("aix")) {
                try {
                    SwingUtilities.getWindowAncestor(this).dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "System shutdown failed:" + e.toString() + " - Please press Power Switch to Turn Off.", "Turn Off", 0);
                }
            } else {
                Runtime runtime = Runtime.getRuntime();
                try {
                    Process process = runtime.exec(turnoffScript);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "System shutdown failed:" + e.toString() + " - Please press Power Switch to Turn Off.", "Turn Off", 0);
                }
            }
        }
    }

    public void tryToRestart() {
        if (this.closeAppView()) {
            this.m_TP.getDeviceDisplay().clearVisor();
            this.session.close();
            Backup.restartApplication(this);
        }
    }

    @Override
    public DeviceTicket getDeviceTicket() {
        return this.m_TP;
    }

    public DeviceScale getDeviceScale() {
        return this.m_Scale;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getInventoryLocation() {
        return this.m_sInventoryLocation;
    }

    @Override
    public String getReceiptHost() {
        return this.m_sReceiptHost;
    }

    @Override
    public void setInventoryLocation(String location) {
        this.m_sInventoryLocation = location;
    }

    @Override
    public String getActiveCashIndex() {
        return this.m_sActiveCashIndex;
    }

    @Override
    public int getActiveCashSequence() {
        return this.m_iActiveCashSequence;
    }

    @Override
    public int getActiveCashToken() {
        return this.m_iActiveCashToken;
    }

    public int getActiveCashOrderNumber() {
        return this.m_iActiveCashOrderNumber;
    }

    @Override
    public Date getActiveCashDateStart() {
        return this.m_dActiveCashDateStart;
    }

    @Override
    public Date getActiveCashDateEnd() {
        return this.m_dActiveCashDateEnd;
    }

    @Override
    public void setActiveCashToken(int token) {
        this.m_iActiveCashToken = token;
    }

    public void setActiveCashOrderNumber(int token) {
        this.m_iActiveCashOrderNumber = token;
    }

    public int getActiveCashPrintCount() {
        return this.m_iActiveCashPrintCount;
    }

    @Override
    public void setActiveCash(String sIndex, int iSeq, Date dStart, Date dEnd, Double actual, Double actualcard, String notes, int printCount) {
        this.m_sActiveCashIndex = sIndex;
        this.m_iActiveCashSequence = iSeq;
        this.m_dActiveCashDateStart = dStart;
        this.m_dActiveCashDateEnd = dEnd;
        this.m_dActiveCashActual = actual;
        this.m_dActiveCardActual = actualcard;
        this.m_sActiveCashNotes = notes;
        this.m_iActiveCashPrintCount = printCount;
        this.m_propsdb.setProperty("activecash", this.m_sActiveCashIndex);
        this.m_dlSystem.setResourceAsProperties(this.m_props.getHost() + "/properties", this.m_propsdb);
    }

    @Override
    public AppProperties getProperties() {
        return this.m_props;
    }

    @Override
    public Object getBean(String beanfactory) throws BeanFactoryException {
        BeanFactory bf = this.m_aBeanFactories.get(beanfactory = JRootApp.mapNewClass(beanfactory));
        if (bf == null) {
            if (beanfactory.startsWith("/")) {
                bf = new BeanFactoryScript(beanfactory);
            } else {
                try {
                    Class<?> bfclass = Class.forName(beanfactory);
                    if (BeanFactory.class.isAssignableFrom(bfclass)) {
                        bf = (BeanFactory)bfclass.newInstance();
                    } else {
                        Constructor<?> constMyView = bfclass.getConstructor(AppView.class);
                        Object bean = constMyView.newInstance(this);
                        bf = new BeanFactoryObj(bean);
                    }
                }
                catch (Exception e) {
                    throw new BeanFactoryException(e);
                }
            }
            this.m_aBeanFactories.put(beanfactory, bf);
            if (bf instanceof BeanFactoryApp) {
                ((BeanFactoryApp)bf).init(this);
            }
        }
        return bf.getBean();
    }

    private static String mapNewClass(String classname) {
        String newclass = m_oldclasses.get(classname);
        return newclass == null ? classname : newclass;
    }

    private static void initOldClasses() {
        m_oldclasses = new HashMap();
        m_oldclasses.put("com.posics.pos.reports.JReportCustomers", "/com/posics/reports/customers.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportCustomersB", "/com/posics/reports/customersb.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportClosedPos", "/com/posics/reports/closedpos.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportClosedProducts", "/com/posics/reports/closedproducts.bs");
        m_oldclasses.put("com.posics.pos.reports.JChartSales", "/com/posics/reports/chartsales.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventory", "/com/posics/reports/inventory.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventory2", "/com/posics/reports/inventoryb.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventoryBroken", "/com/posics/reports/inventorybroken.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportInventoryDiff", "/com/posics/reports/inventorydiff.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportPeople", "/com/posics/reports/people.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportTaxes", "/com/posics/reports/taxes.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportUserSales", "/com/posics/reports/usersales.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportProducts", "/com/posics/reports/products.bs");
        m_oldclasses.put("com.posics.pos.reports.JReportCatalog", "/com/posics/reports/productscatalog.bs");
        m_oldclasses.put("com.posics.pos.panels.JPanelTax", "com.posics.pos.inventory.TaxPanel");
    }

    @Override
    public void waitCursorBegin() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void waitCursorEnd() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public AppUserView getAppUserView() {
        return this.m_principalapp;
    }

    private void printerStart() {
        String sresource = this.m_dlSystem.getResourceAsXML("Printer.Start");
        if (sresource == null) {
            this.m_TP.getDeviceDisplay().writeVisor("Saleculator PDA", "1.0");
        } else {
            try {
                this.m_TTP.printTicket(sresource);
            }
            catch (TicketPrinterException eTP) {
                this.m_TP.getDeviceDisplay().writeVisor("Saleculator PDA", "1.0");
            }
        }
    }

    private void checkPin(String pin) {
        try {
            boolean pinok = false;
            List people = this.m_dlSystem.listPeopleVisible();
            for (int i = 0; i < people.size(); ++i) {
                AppUser user;
                if (people.get(i).getClass() != AppUser.class || (user = (AppUser)people.get(i)).getPassword() == null || !user.authenticate(pin)) continue;
                pinok = true;
                try {
                    if (!this.m_props.getMachineName().equals(this.m_props.getHost())) {
                        Object[] valcash;
                        this.m_dlSystem.resetResourcesCache();
                        this.m_propsdb = this.m_dlSystem.getResourceAsProperties(this.m_props.getHost() + "/properties");
                        String sActiveCashIndex = this.m_propsdb.getProperty("activecash");
                        Object[] objectArray = valcash = sActiveCashIndex == null ? null : this.m_dlSystem.findActiveCash(sActiveCashIndex);
                        if (valcash == null || !this.m_props.getHost().equals(valcash[0])) {
                            this.setActiveCash(UUID.randomUUID().toString(), this.m_dlSystem.getSequenceCash(this.m_props.getHost()) + 1, new Date(), null, null, null, null, 0);
                            this.m_dlSystem.execInsertCash(new Object[]{this.getActiveCashIndex(), this.m_props.getHost(), this.getActiveCashSequence(), this.getActiveCashDateStart(), this.getActiveCashDateEnd()});
                            this.setActiveCashToken(this.m_dlSystem.getSequenceToken(this.getActiveCashIndex()));
                            this.setActiveCashOrderNumber(this.m_dlSystem.getNextOrderNumber(sActiveCashIndex));
                        } else {
                            this.setActiveCash(sActiveCashIndex, (Integer)valcash[1], (Date)valcash[2], (Date)valcash[3], (Double)valcash[4], (Double)valcash[5], (String)valcash[6], (Integer)valcash[7]);
                            this.setActiveCashToken(this.m_dlSystem.getSequenceToken(sActiveCashIndex));
                            this.setActiveCashOrderNumber(this.m_dlSystem.getNextOrderNumber(sActiveCashIndex));
                        }
                    }
                }
                catch (Exception e) {
                    MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotclosecash"), e);
                    msg.show(this);
                    this.session.close();
                }
                this.openAppView(user);
            }
            if (!pinok) {
                this.jPasswordDialog1.resetPassword();
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.BadPassword"));
                msg.show(this);
            }
        }
        catch (BasicException ee) {
            ee.printStackTrace();
        }
    }

    private void showView(String view) {
        CardLayout cl = (CardLayout)this.m_jPanelContainer.getLayout();
        cl.show(this.m_jPanelContainer, view);
    }

    private void openAppView(AppUser user) {
        if (this.closeAppView()) {
            this.m_principalapp = new JPrincipalApp(this, user);
            this.jPanel3.add(this.m_principalapp.getNotificator());
            this.jPanel3.revalidate();
            this.jPanel3.repaint();
            this.m_jPanelContainer.add((Component)this.m_principalapp, "_" + this.m_principalapp.getUser().getId());
            this.showView("_" + this.m_principalapp.getUser().getId());
            this.m_principalapp.activate();
        }
    }

    public boolean closeAppView() {
        if (this.m_principalapp == null) {
            return true;
        }
        if (!this.m_principalapp.deactivate()) {
            return false;
        }
        this.jPanel3.remove(this.m_principalapp.getNotificator());
        this.jPanel3.revalidate();
        this.jPanel3.repaint();
        this.m_jPanelContainer.remove(this.m_principalapp);
        this.m_principalapp = null;
        this.showLogin();
        return true;
    }

    private void showLogin() {
        this.showView("login");
        this.printerStart();
        this.inputtext = new StringBuffer();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JRootApp.this.jPasswordDialog1.setActive();
            }
        });
    }

    private void processKey(char c) {
        if (c == '\n') {
            AppUser user = null;
            try {
                user = this.m_dlSystem.findPeopleByCard(this.inputtext.toString());
            }
            catch (BasicException e) {
                e.printStackTrace();
            }
            if (user == null) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.nocard"));
                msg.show(this);
            } else {
                this.openAppView(user);
            }
            this.inputtext = new StringBuffer();
        }
    }

    private void initComponents() {
        this.m_jPanelTitle = new JPanel();
        this.m_jLblTitle = new JLabel();
        this.poweredby = new JLabel();
        this.jLabel2 = new JLabel();
        this.m_jPanelContainer = new JPanel();
        this.m_jPanelLogin = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jPasswordDialog1 = new JPasswordPanel();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel10 = new JPanel();
        this.m_jClose = new JButton();
        this.m_jRestart = new JButton();
        this.m_jPanelDown = new JPanel();
        this.panelTask = new JPanel();
        this.m_jCalendar = new JLabel();
        this.m_jBattery = new JLabel();
        this.m_jHost = new JLabel();
        this.m_jOnline = new JButton();
        this.m_jNetworkPrinterStatus = new JLabel();
        this.m_jCalc = new JButton();
        this.m_jKB = new JButton();
        this.m_jCMD1 = new JButton();
        this.m_jCMD2 = new JButton();
        this.m_jCMD3 = new JButton();
        this.jPanel3 = new JPanel();
        this.setPreferredSize(new Dimension(1024, 768));
        this.setLayout(new BorderLayout());
        this.m_jPanelTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("Button.darkShadow")));
        this.m_jPanelTitle.setLayout(new BorderLayout());
        this.m_jLblTitle.setHorizontalAlignment(0);
        this.m_jLblTitle.setText("Window.Title");
        this.m_jPanelTitle.add((Component)this.m_jLblTitle, "Center");
        this.poweredby.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/poweredby.png")));
        this.poweredby.setAlignmentY(0.0f);
        this.poweredby.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.poweredby.setMaximumSize(new Dimension(33, 33));
        this.poweredby.setMinimumSize(new Dimension(33, 33));
        this.poweredby.setPreferredSize(new Dimension(40, 33));
        this.m_jPanelTitle.add((Component)this.poweredby, "After");
        this.jLabel2.setPreferredSize(new Dimension(142, 34));
        this.m_jPanelTitle.add((Component)this.jLabel2, "Before");
        this.add((Component)this.m_jPanelTitle, "North");
        this.m_jPanelContainer.setLayout(new CardLayout());
        this.m_jPanelLogin.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jPanel6.setBackground(new Color(51, 51, 51));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/logo.png")));
        this.jLabel3.setAlignmentX(0.5f);
        this.jLabel3.setHorizontalTextPosition(0);
        this.jLabel3.setMaximumSize(new Dimension(800, 1024));
        this.jLabel3.setMinimumSize(new Dimension(645, 200));
        this.jLabel3.setVerticalTextPosition(3);
        this.jPanel6.add(this.jLabel3);
        this.jPanel4.add(this.jPanel6);
        this.jPanel9.setBackground(new Color(51, 51, 51));
        this.jPanel9.add(this.jPasswordDialog1);
        this.jPanel4.add(this.jPanel9);
        this.jPanel7.setBackground(new Color(51, 51, 51));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("<html><center>Copyright \u00a9 2014 Posics<br>http://www.saleculator.com<br><br>For getting help on using this software please visit http://help.saleculator.com<br>Or you can email to support@saleculator.com<br></center>");
        this.jLabel1.setAlignmentX(0.5f);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setMaximumSize(new Dimension(800, 1024));
        this.jLabel1.setVerticalTextPosition(3);
        this.jPanel7.add(this.jLabel1);
        this.jPanel4.add(this.jPanel7);
        this.jPanel10.setBackground(new Color(51, 51, 51));
        this.m_jClose.setBackground(new Color(102, 102, 102));
        this.m_jClose.setForeground(new Color(255, 255, 255));
        this.m_jClose.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/exit.png")));
        this.m_jClose.setText(AppLocal.getIntString("Button.Close"));
        this.m_jClose.setBorder(null);
        this.m_jClose.setFocusPainted(false);
        this.m_jClose.setFocusable(false);
        this.m_jClose.setPreferredSize(new Dimension(115, 35));
        this.m_jClose.setRequestFocusEnabled(false);
        this.m_jClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jCloseActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.m_jClose);
        this.m_jRestart.setBackground(new Color(102, 102, 102));
        this.m_jRestart.setForeground(new Color(255, 255, 255));
        this.m_jRestart.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/restart.png")));
        this.m_jRestart.setText(AppLocal.getIntString("Button.Restart"));
        this.m_jRestart.setBorder(null);
        this.m_jRestart.setFocusPainted(false);
        this.m_jRestart.setFocusable(false);
        this.m_jRestart.setPreferredSize(new Dimension(115, 35));
        this.m_jRestart.setRequestFocusEnabled(false);
        this.m_jRestart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jRestartActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.m_jRestart);
        this.jPanel4.add(this.jPanel10);
        this.m_jPanelLogin.add((Component)this.jPanel4, "Center");
        this.m_jPanelContainer.add((Component)this.m_jPanelLogin, "login");
        this.add((Component)this.m_jPanelContainer, "Center");
        this.m_jPanelDown.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("Button.darkShadow")));
        this.m_jPanelDown.setLayout(new BorderLayout());
        this.m_jCalendar.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/clock.png")));
        this.m_jCalendar.setText("*Calendar");
        this.panelTask.add(this.m_jCalendar);
        this.m_jBattery.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/battery.png")));
        this.panelTask.add(this.m_jBattery);
        this.m_jHost.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/display.png")));
        this.m_jHost.setText("*Hostname");
        this.panelTask.add(this.m_jHost);
        this.m_jOnline.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/offline.png")));
        this.m_jOnline.setFocusPainted(false);
        this.m_jOnline.setFocusable(false);
        this.m_jOnline.setPreferredSize(new Dimension(36, 36));
        this.m_jOnline.setRequestFocusEnabled(false);
        this.m_jOnline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jOnlineActionPerformed(evt);
            }
        });
        this.panelTask.add(this.m_jOnline);
        this.m_jNetworkPrinterStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/nwprinteroffline.png")));
        this.panelTask.add(this.m_jNetworkPrinterStatus);
        this.m_jCalc.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/calculator.png")));
        this.m_jCalc.setFocusPainted(false);
        this.m_jCalc.setFocusable(false);
        this.m_jCalc.setPreferredSize(new Dimension(36, 36));
        this.m_jCalc.setRequestFocusEnabled(false);
        this.m_jCalc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jCalcActionPerformed(evt);
            }
        });
        this.panelTask.add(this.m_jCalc);
        this.m_jKB.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/keyboard.png")));
        this.m_jKB.setFocusPainted(false);
        this.m_jKB.setFocusable(false);
        this.m_jKB.setPreferredSize(new Dimension(36, 36));
        this.m_jKB.setRequestFocusEnabled(false);
        this.m_jKB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jKBActionPerformed(evt);
            }
        });
        this.panelTask.add(this.m_jKB);
        this.m_jCMD1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/exe.png")));
        this.m_jCMD1.setFocusPainted(false);
        this.m_jCMD1.setFocusable(false);
        this.m_jCMD1.setPreferredSize(new Dimension(36, 36));
        this.m_jCMD1.setRequestFocusEnabled(false);
        this.m_jCMD1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jCMD1ActionPerformed(evt);
            }
        });
        this.panelTask.add(this.m_jCMD1);
        this.m_jCMD2.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/exe.png")));
        this.m_jCMD2.setFocusPainted(false);
        this.m_jCMD2.setFocusable(false);
        this.m_jCMD2.setPreferredSize(new Dimension(36, 36));
        this.m_jCMD2.setRequestFocusEnabled(false);
        this.m_jCMD2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jCMD2ActionPerformed(evt);
            }
        });
        this.panelTask.add(this.m_jCMD2);
        this.m_jCMD3.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/exe.png")));
        this.m_jCMD3.setFocusPainted(false);
        this.m_jCMD3.setFocusable(false);
        this.m_jCMD3.setPreferredSize(new Dimension(36, 36));
        this.m_jCMD3.setRequestFocusEnabled(false);
        this.m_jCMD3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRootApp.this.m_jCMD3ActionPerformed(evt);
            }
        });
        this.panelTask.add(this.m_jCMD3);
        this.m_jPanelDown.add((Component)this.panelTask, "Before");
        this.jPanel3.setLayout(new BorderLayout());
        this.m_jPanelDown.add((Component)this.jPanel3, "After");
        this.add((Component)this.m_jPanelDown, "South");
    }

    private void m_jCloseActionPerformed(ActionEvent evt) {
        this.tryToClose();
    }

    private void m_jRestartActionPerformed(ActionEvent evt) {
        this.tryToRestart();
    }

    private void m_jKBActionPerformed(ActionEvent evt) {
        try {
            String strScript = this.config.getProperty("Script.KB");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Script Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void m_jCMD1ActionPerformed(ActionEvent evt) {
        try {
            String strScript = this.config.getProperty("Script.CMD1");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Script Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void m_jCMD2ActionPerformed(ActionEvent evt) {
        try {
            String strScript = this.config.getProperty("Script.CMD2");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Script Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void m_jCalcActionPerformed(ActionEvent evt) {
        try {
            String strScript = this.config.getProperty("Script.Calculator");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Script Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void m_jCMD3ActionPerformed(ActionEvent evt) {
        try {
            String strScript = this.config.getProperty("Script.CMD3");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Script Failed:" + e.toString(), "Saleculator", 0);
        }
    }

    private void m_jOnlineActionPerformed(ActionEvent evt) {
        try {
            String strScript = this.config.getProperty("Network.Manager");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Network manager failed:" + e.toString(), "Saleculator", 0);
        }
    }

    static {
        m_dateformat = new SimpleDateFormat("dd/MM/yyyy");
        m_timeformat = new SimpleDateFormat("hh:mm");
        JRootApp.initOldClasses();
    }

    public class BatteryObserver
    implements Observer {
        public BatteryObserver(BatteryObservable timeConnection) {
            timeConnection.addObserver(this);
            new Thread(timeConnection).start();
        }

        @Override
        public void update(Observable batConnection, Object state) {
            BatteryState bat = (BatteryState)state;
            if (bat.getStatus() != null) {
                JRootApp.this.showBatteryStatus(bat.getStatus());
            } else {
                System.err.println("No battery info");
                JRootApp.this.m_jBattery.setVisible(false);
                JRootApp.this.observableBattery.deleteObservers();
            }
        }
    }

    public class ClockObserver
    implements Observer {
        public ClockObserver(ClockObservable timeConnection) {
            timeConnection.addObserver(this);
            new Thread(timeConnection).start();
        }

        @Override
        public void update(Observable timeConnection, Object state) {
            JRootApp.this.showDateTime();
        }
    }

    public class NetworkPrinterConnectionObserver
    implements Observer {
        public NetworkPrinterConnectionObserver(NetworkPrinterConnectionObservable printerConnection) {
            printerConnection.addObserver(this);
            new Thread(printerConnection).start();
        }

        @Override
        public void update(Observable printerConnection, Object state) {
            NetworkPrinterConnectionState connectionState = (NetworkPrinterConnectionState)state;
            if (connectionState.getState()) {
                JRootApp.this.m_jNetworkPrinterStatus.setVisible(false);
            } else {
                JRootApp.this.m_jNetworkPrinterStatus.setVisible(true);
            }
        }
    }

    public class InternetConnectionObserver
    implements Observer {
        public InternetConnectionObserver(ConnectionObservable internetConnection) {
            internetConnection.addObserver(this);
            new Thread(internetConnection).start();
        }

        @Override
        public void update(Observable internetConnection, Object state) {
            InternetConnectionState connectionState = (InternetConnectionState)state;
            StringUtils.m_blIsOnline = connectionState.getState();
            JRootApp.this.showOnlineStatus();
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JRootApp.this.m_jtimer.stop();
                JRootApp.this.showDateTime();
                JRootApp.this.showOnlineStatus();
                JRootApp.this.m_jtimer.start();
            }
            catch (Exception e) {
                JRootApp.this.m_jtimer.restart();
            }
        }
    }
}

