/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.pos.config.JFrmConfig;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.forms.JRootApp;
import com.posics.pos.instance.AppMessage;
import com.posics.pos.instance.InstanceManager;
import com.posics.pos.util.Backup;
import com.posics.pos.util.DatabaseDialog;
import com.posics.pos.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;

public class JRootKiosk
extends JFrame
implements AppMessage {
    private InstanceManager m_instmanager = null;
    private JRootApp m_rootapp;
    private AppProperties m_props;

    public JRootKiosk() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.initComponents();
    }

    public void initFrame(AppProperties props) {
        this.m_props = props;
        this.m_rootapp = new JRootApp();
        if (this.m_rootapp.initApp(this.m_props)) {
            if ("true".equals(props.getProperty("machine.uniqueinstance"))) {
                try {
                    this.m_instmanager = new InstanceManager(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.add((Component)this.m_rootapp, "Center");
            this.setTitle("Saleculator PDA - 1.0");
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(0, 0, d.width, d.height);
            this.setVisible(true);
        } else {
            DatabaseDialog act = new DatabaseDialog(this, true);
            act.pack();
            act.setSize(200, 200);
            act.setLocationRelativeTo(act.getParent());
            act.setVisible(true);
            switch (act.ACTSTATUS) {
                case 1: {
                    Backup.turnoff(this);
                    break;
                }
                case 2: {
                    Backup.restartApplication(this);
                    break;
                }
                case 3: {
                    new JFrmConfig(StringUtils.config).setVisible(true);
                    break;
                }
                default: {
                    System.exit(0);
                }
            }
        }
    }

    @Override
    public void restoreWindow() throws RemoteException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JRootKiosk.this.getExtendedState() == 1) {
                    JRootKiosk.this.setExtendedState(0);
                }
                JRootKiosk.this.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                JRootKiosk.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                JRootKiosk.this.formWindowClosing(evt);
            }
        });
    }

    private void formWindowClosing(WindowEvent evt) {
        this.m_rootapp.tryToClose();
    }

    private void formWindowClosed(WindowEvent evt) {
        System.exit(0);
    }
}

