/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.forms;

import com.posics.format.Formats;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.JRootFrame;
import com.posics.pos.forms.JRootKiosk;
import com.posics.pos.instance.InstanceQuery;
import com.posics.pos.util.ActivationCheck;
import com.posics.pos.util.Backup;
import com.posics.pos.util.StringUtils;
import java.awt.EventQueue;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;

public class StartPOS {
    private static Logger logger = Logger.getLogger("com.posics.pos.forms.StartPOS");

    private StartPOS() {
    }

    public static boolean registerApp() {
        InstanceQuery i = null;
        try {
            i = new InstanceQuery();
            i.getAppMessage().restoreWindow();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!StartPOS.registerApp()) {
                    System.exit(1);
                }
                AppConfig config = new AppConfig(args);
                config.load();
                StringUtils.config = config;
                if (!ActivationCheck.doCheck()) {
                    Backup.turnoff(null);
                }
                StringUtils.m_blIsActivated = true;
                String slang = config.getProperty("user.language");
                String scountry = config.getProperty("user.country");
                String svariant = config.getProperty("user.variant");
                if (slang != null && !slang.equals("") && scountry != null && svariant != null) {
                    Locale.setDefault(new Locale(slang, scountry, svariant));
                }
                Formats.setIntegerPattern(config.getProperty("format.integer"));
                Formats.setDoublePattern(config.getProperty("format.double"));
                Formats.setCurrencyPattern(config.getProperty("format.currency"));
                Formats.setPercentPattern(config.getProperty("format.percent"));
                Formats.setDatePattern(config.getProperty("format.date"));
                Formats.setTimePattern(config.getProperty("format.time"));
                Formats.setDateTimePattern(config.getProperty("format.datetime"));
                try {
                    Object laf = Class.forName(config.getProperty("swing.defaultlaf")).newInstance();
                    if (laf instanceof LookAndFeel) {
                        UIManager.setLookAndFeel((LookAndFeel)laf);
                    } else if (laf instanceof SubstanceSkin) {
                        SubstanceLookAndFeel.setSkin((SubstanceSkin)((SubstanceSkin)laf));
                    }
                    int fontstyle = 0;
                    if (config.getProperty("font.style").equals("Bold")) {
                        fontstyle = 1;
                    }
                    if (!config.getProperty("font.name").equals("Default")) {
                        StartPOS.setUIFont(new FontUIResource(config.getProperty("font.name"), fontstyle, Integer.parseInt(config.getProperty("font.size"))));
                    } else {
                        FontUIResource defaultFont = (FontUIResource)UIManager.getDefaults().getFont("Label.font");
                        StartPOS.setUIFont(new FontUIResource(defaultFont.getName(), fontstyle, Integer.parseInt(config.getProperty("font.size"))));
                    }
                }
                catch (Exception laf) {
                    // empty catch block
                }
                String screenmode = config.getProperty("machine.screenmode");
                if ("fullscreen".equals(screenmode)) {
                    JRootKiosk rootkiosk = new JRootKiosk();
                    rootkiosk.initFrame(config);
                } else {
                    JRootFrame rootframe = new JRootFrame();
                    rootframe.initFrame(config);
                }
            }
        });
    }
}

