/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.format.Formats;
import com.posics.pos.inventory.InventoryLine;
import com.posics.pos.inventory.LocationInfo;
import com.posics.pos.inventory.MovementReason;
import com.posics.pos.util.StringUtils;
import java.util.Date;
import java.util.List;

public class InventoryRecord {
    private Date m_dDate;
    private MovementReason m_reason;
    private LocationInfo m_locationOri;
    private List<InventoryLine> m_invlines;
    private String m_supplier;
    private String m_suppliername;

    public InventoryRecord(Date d, MovementReason reason, LocationInfo location, List<InventoryLine> invlines, String supplier, String suppliername) {
        this.m_dDate = d;
        this.m_reason = reason;
        this.m_locationOri = location;
        this.m_invlines = invlines;
        this.m_supplier = supplier;
        this.m_suppliername = suppliername;
    }

    public Date getDate() {
        return this.m_dDate;
    }

    public MovementReason getReason() {
        return this.m_reason;
    }

    public LocationInfo getLocation() {
        return this.m_locationOri;
    }

    public String getSupplier() {
        return this.m_supplier;
    }

    public List<InventoryLine> getLines() {
        return this.m_invlines;
    }

    public boolean isInput() {
        return this.m_reason.isInput();
    }

    public double getSubTotal() {
        double dSuma = 0.0;
        for (InventoryLine oLine : this.m_invlines) {
            dSuma += oLine.getSubValue();
        }
        return dSuma;
    }

    public String printDate() {
        return Formats.TIMESTAMP.formatValue(this.m_dDate);
    }

    public String printLocation() {
        return StringUtils.encodeXML(this.m_locationOri.toString());
    }

    public String printReason() {
        return StringUtils.encodeXML(this.m_reason.toString());
    }

    public String printSupplier() {
        return StringUtils.encodeXML(this.m_suppliername.toString());
    }

    public String printSubTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getSubTotal()));
    }
}

