/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.basic.BasicException;
import com.posics.beans.DateUtils;
import com.posics.beans.JCalendarDialog;
import com.posics.beans.JNumberEvent;
import com.posics.beans.JNumberEventListener;
import com.posics.beans.JNumberKeys;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.LocalRes;
import com.posics.data.loader.SentenceExec;
import com.posics.data.loader.SentenceList;
import com.posics.format.Formats;
import com.posics.pos.catalog.CatalogSelector;
import com.posics.pos.catalog.JCatalog;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.inventory.InventoryLine;
import com.posics.pos.inventory.InventoryRecord;
import com.posics.pos.inventory.JInventoryLines;
import com.posics.pos.inventory.LocationInfo;
import com.posics.pos.inventory.MaterialProdInfo;
import com.posics.pos.inventory.MovementReason;
import com.posics.pos.printer.LabelParser;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.sales.JProductAttEdit;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.suppliers.DataLogicSuppliers;
import com.posics.pos.suppliers.JSupplierFinder;
import com.posics.pos.suppliers.SupplierInfo;
import com.posics.pos.suppliers.SupplierInfoExt;
import com.posics.pos.ticket.ProductInfoExt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.layout.GroupLayout;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StockManagement
extends JPanel
implements JPanelView {
    private AppView m_App;
    private DataLogicSystem m_dlSystem;
    private DataLogicSales m_dlSales;
    private TicketParser m_TTP;
    private LabelParser m_LLP;
    private CatalogSelector m_cat;
    private ComboBoxValModel m_ReasonModel;
    private SentenceList m_sentlocations;
    private ComboBoxValModel m_LocationsModel;
    private ComboBoxValModel m_LocationsModelDes;
    private DataLogicSuppliers dlsuppliers;
    private String supplierid;
    private JInventoryLines m_invlines;
    private int NUMBER_STATE = 0;
    private int MULTIPLY = 0;
    private static int DEFAULT = 0;
    private static int ACTIVE = 1;
    private static int DECIMAL = 2;
    private static SAXParser m_sp = null;
    private Properties props;
    private JPanel catcontainer;
    private JButton jEditAttributes;
    private JButton jEditSupplier;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel8;
    private JNumberKeys jNumberKeys;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JButton jPrintLabel;
    private JTextField jTextField1;
    private JTextField jTextLabelCopies;
    private JButton m_jDelete;
    private JButton m_jDown;
    private JButton m_jEnter;
    private JComboBox m_jLocation;
    private JComboBox m_jLocationDes;
    private JButton m_jUp;
    private JButton m_jbtndate;
    private JLabel m_jcodebar;
    private JTextField m_jdate;
    private JComboBox m_jreason;
    private JTextField m_jsupplier;

    public StockManagement(AppView app) {
        this.m_App = app;
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.m_dlSales = (DataLogicSales)this.m_App.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlsuppliers = (DataLogicSuppliers)app.getBean("com.posics.pos.suppliers.DataLogicSuppliers");
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem);
        this.m_LLP = new LabelParser(this.m_App.getDeviceTicket(), this.m_dlSystem);
        this.initComponents();
        this.m_sentlocations = this.m_dlSales.getLocationsList();
        this.m_LocationsModel = new ComboBoxValModel();
        this.m_LocationsModelDes = new ComboBoxValModel();
        this.m_ReasonModel = new ComboBoxValModel();
        this.m_ReasonModel.add(MovementReason.IN_PURCHASE);
        this.m_ReasonModel.add(MovementReason.IN_REFUND);
        this.m_ReasonModel.add(MovementReason.IN_MOVEMENT);
        this.m_ReasonModel.add(MovementReason.IN_PRODUCTION);
        this.m_ReasonModel.add(MovementReason.OUT_SALE);
        this.m_ReasonModel.add(MovementReason.OUT_REFUND);
        this.m_ReasonModel.add(MovementReason.OUT_BREAK);
        this.m_ReasonModel.add(MovementReason.OUT_MOVEMENT);
        this.m_ReasonModel.add(MovementReason.NIL_REQUEST);
        this.m_ReasonModel.add(MovementReason.OUT_CROSSING);
        this.m_jreason.setModel(this.m_ReasonModel);
        this.props = new Properties();
        String sConfigRes = this.m_dlSystem.getResourceAsXML("Ticket.Buttons");
        if (sConfigRes != null) {
            try {
                if (m_sp == null) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    m_sp = spf.newSAXParser();
                }
                m_sp.parse(new InputSource(new StringReader(sConfigRes)), (DefaultHandler)new ConfigurationHandler());
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_cat = new JCatalog(this.m_dlSales, false, false, Integer.parseInt(this.props.getProperty("img-width", "64")), Integer.parseInt(this.props.getProperty("img-height", "54")), false, true, true);
        this.m_cat.getComponent().setPreferredSize(new Dimension(0, 245));
        this.m_cat.addActionListener(new CatalogListener());
        this.catcontainer.add(this.m_cat.getComponent(), "Center");
        this.m_invlines = new JInventoryLines();
        this.jPanel5.add((Component)this.m_invlines, "Center");
        this.supplierid = null;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.StockMovement");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        this.m_cat.loadCatalog();
        List l = this.m_sentlocations.list();
        this.m_LocationsModel = new ComboBoxValModel(l);
        this.m_jLocation.setModel(this.m_LocationsModel);
        this.m_LocationsModelDes = new ComboBoxValModel(l);
        this.m_jLocationDes.setModel(this.m_LocationsModelDes);
        this.stateToInsert();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StockManagement.this.jTextField1.requestFocus();
            }
        });
    }

    public void stateToInsert() {
        this.m_jdate.setText(Formats.TIMESTAMP.formatValue(DateUtils.getTodayMinutes()));
        this.m_ReasonModel.setSelectedItem(MovementReason.IN_PURCHASE);
        this.m_LocationsModel.setSelectedKey(this.m_App.getInventoryLocation());
        this.m_LocationsModelDes.setSelectedKey(this.m_App.getInventoryLocation());
        this.m_invlines.clear();
        this.m_jcodebar.setText(null);
    }

    @Override
    public boolean deactivate() {
        if (this.m_invlines.getCount() > 0) {
            int res = JOptionPane.showConfirmDialog(this, LocalRes.getIntString("message.wannasave"), LocalRes.getIntString("title.editor"), 1, 3);
            if (res == 0) {
                this.saveData();
                return true;
            }
            return res == 1;
        }
        return true;
    }

    private void addLine(ProductInfoExt oProduct, double dpor, double dprice) {
        this.m_invlines.addLine(new InventoryLine(oProduct, dpor, dprice));
    }

    private void deleteLine(int index) {
        if (index < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.m_invlines.deleteLine(index);
        }
    }

    private void incProduct(ProductInfoExt product, double units) {
        MovementReason reason = (MovementReason)this.m_ReasonModel.getSelectedItem();
        this.addLine(product, units, reason.isInput() ? product.getPriceBuy() : product.getPriceSell());
    }

    private void incProductByCode(String sCode) {
        this.incProductByCode(sCode, 1.0);
    }

    private void incProductByCode(String sCode, double dQuantity) {
        try {
            ProductInfoExt oProduct = this.m_dlSales.getProductInfoByCode(sCode);
            if (oProduct == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.incProduct(oProduct, dQuantity);
            }
        }
        catch (BasicException eData) {
            MessageInf msg = new MessageInf(eData);
            msg.show(this);
        }
    }

    private void addUnits(double dUnits) {
        int i = this.m_invlines.getSelectedRow();
        if (i >= 0) {
            InventoryLine inv = this.m_invlines.getLine(i);
            double dunits = inv.getMultiply() + dUnits;
            if (dunits <= 0.0) {
                this.deleteLine(i);
            } else {
                inv.setMultiply(inv.getMultiply() + dUnits);
                this.m_invlines.setLine(i, inv);
            }
        }
    }

    private void setUnits(double dUnits) {
        int i = this.m_invlines.getSelectedRow();
        if (i >= 0) {
            InventoryLine inv = this.m_invlines.getLine(i);
            inv.setMultiply(dUnits);
            this.m_invlines.setLine(i, inv);
        }
    }

    private void setPrice(double dPrice) {
        int i = this.m_invlines.getSelectedRow();
        if (i >= 0) {
            InventoryLine inv = this.m_invlines.getLine(i);
            inv.setPrice(dPrice);
            this.m_invlines.setLine(i, inv);
        }
    }

    private void stateTransition(char cTrans) {
        if (cTrans == '\n') {
            if (this.m_jcodebar.getText() != null) {
                this.incProductByCode(this.m_jcodebar.getText());
                this.m_jcodebar.setText(null);
            }
        } else if (cTrans == '\u007f') {
            this.m_jcodebar.setText(null);
            this.NUMBER_STATE = DEFAULT;
        } else if (cTrans == '*') {
            this.MULTIPLY = ACTIVE;
        } else if (cTrans == '+') {
            if (this.MULTIPLY != DEFAULT && this.NUMBER_STATE != DEFAULT) {
                this.setUnits(Double.parseDouble(this.m_jcodebar.getText()));
                this.m_jcodebar.setText(null);
            } else if (this.m_jcodebar.getText() == null || this.m_jcodebar.getText().equals("")) {
                this.addUnits(1.0);
            } else if (StockManagement.isDouble(this.m_jcodebar.getText())) {
                this.addUnits(Double.parseDouble(this.m_jcodebar.getText()));
                this.m_jcodebar.setText(null);
            }
            this.NUMBER_STATE = DEFAULT;
            this.MULTIPLY = DEFAULT;
        } else if (cTrans == '-') {
            if (this.MULTIPLY != DEFAULT && this.NUMBER_STATE != DEFAULT) {
                this.setPrice(Double.parseDouble(this.m_jcodebar.getText()));
                this.m_jcodebar.setText(null);
            } else if (this.m_jcodebar.getText() == null || this.m_jcodebar.getText().equals("")) {
                this.addUnits(-1.0);
            } else if (StockManagement.isDouble(this.m_jcodebar.getText())) {
                this.addUnits(-Double.parseDouble(this.m_jcodebar.getText()));
                this.m_jcodebar.setText(null);
            }
            this.NUMBER_STATE = DEFAULT;
            this.MULTIPLY = DEFAULT;
        } else if (cTrans == '.') {
            if (this.m_jcodebar.getText() == null || this.m_jcodebar.getText().equals("")) {
                this.m_jcodebar.setText("0.");
            } else if (this.NUMBER_STATE != DECIMAL) {
                this.m_jcodebar.setText(this.m_jcodebar.getText() + cTrans);
            }
            this.NUMBER_STATE = DECIMAL;
        } else if (cTrans == ' ' || cTrans == '=') {
            if (this.m_invlines.getCount() == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.saveData();
            }
        } else if (Character.isDigit(cTrans)) {
            if (this.m_jcodebar.getText() == null) {
                this.m_jcodebar.setText("" + cTrans);
            } else {
                this.m_jcodebar.setText(this.m_jcodebar.getText() + cTrans);
            }
            if (this.NUMBER_STATE != DECIMAL) {
                this.NUMBER_STATE = ACTIVE;
            }
        } else if (this.MULTIPLY != ACTIVE) {
            if (this.m_jcodebar.getText() == null) {
                this.m_jcodebar.setText("" + cTrans);
            } else {
                this.m_jcodebar.setText(this.m_jcodebar.getText() + cTrans);
            }
            this.NUMBER_STATE = DEFAULT;
        }
    }

    private void saveData() {
        try {
            Date d = (Date)Formats.TIMESTAMP.parseValue(this.m_jdate.getText());
            MovementReason reason = (MovementReason)this.m_ReasonModel.getSelectedItem();
            if (reason == MovementReason.OUT_CROSSING) {
                this.saveData(new InventoryRecord(d, MovementReason.OUT_MOVEMENT, (LocationInfo)this.m_LocationsModel.getSelectedItem(), this.m_invlines.getLines(), this.supplierid, this.m_jsupplier.getText()));
                this.saveData(new InventoryRecord(d, MovementReason.IN_MOVEMENT, (LocationInfo)this.m_LocationsModelDes.getSelectedItem(), this.m_invlines.getLines(), this.supplierid, this.m_jsupplier.getText()));
            } else if (reason == MovementReason.NIL_REQUEST) {
                this.saveRequest(new InventoryRecord(d, MovementReason.IN_MOVEMENT, (LocationInfo)this.m_LocationsModelDes.getSelectedItem(), this.m_invlines.getLines(), this.supplierid, this.m_jsupplier.getText()));
            } else {
                this.saveData(new InventoryRecord(d, reason, (LocationInfo)this.m_LocationsModel.getSelectedItem(), this.m_invlines.getLines(), this.supplierid, this.m_jsupplier.getText()));
            }
            this.stateToInsert();
        }
        catch (BasicException eData) {
            MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotsaveinventorydata"), eData);
            msg.show(this);
        }
    }

    private void saveData(InventoryRecord rec) throws BasicException {
        SentenceExec sent = this.m_dlSales.getStockDiaryInsert();
        for (int i = 0; i < this.m_invlines.getCount(); ++i) {
            InventoryLine inv = rec.getLines().get(i);
            List<MaterialProdInfo> mats = this.m_dlSales.getMaterialsProd(inv.getProductID(), null);
            if (mats.isEmpty()) {
                sent.exec(UUID.randomUUID().toString(), rec.getDate(), rec.getReason().getKey(), rec.getLocation().getID(), inv.getProductID(), inv.getProductAttSetInstId(), rec.getReason().samesignum(inv.getMultiply()), inv.getPrice(), rec.getSupplier());
                continue;
            }
            for (MaterialProdInfo m : mats) {
                sent.exec(UUID.randomUUID().toString(), rec.getDate(), rec.getReason().getKey(), rec.getLocation().getID(), m.getID(), null, rec.getReason().samesignum(inv.getMultiply() * m.getAmount()), inv.getPrice() / m.getAmount(), rec.getSupplier());
            }
        }
        this.printTicket(rec);
        this.supplierid = null;
        this.m_jsupplier.setText(null);
    }

    private void saveRequest(InventoryRecord rec) throws BasicException {
        String mrid = UUID.randomUUID().toString();
        if (this.m_invlines.getCount() > 0) {
            SentenceExec sent = this.m_dlSales.getMaterialRequestInsert();
            LocationInfo li = (LocationInfo)this.m_LocationsModel.getSelectedItem();
            sent.exec(mrid, li.getID(), this.m_App.getAppUserView().getUser().getId(), DateUtils.getTodayMinutes(), 1, rec.getDate());
            SentenceExec sentlines = this.m_dlSales.getMaterialRequestLinesInsert();
            for (int i = 0; i < this.m_invlines.getCount(); ++i) {
                InventoryLine inv = rec.getLines().get(i);
                sentlines.exec(UUID.randomUUID().toString(), mrid, inv.getProductID(), inv.getMultiply(), 1);
            }
        }
    }

    private void printTicket(InventoryRecord invrec) {
        String sresource = this.m_dlSystem.getResourceAsXML("Printer.Inventory");
        if (sresource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("inventoryrecord", invrec);
                this.m_TTP.printTicket(script.eval(sresource).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    public static boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jNumberKeys = new JNumberKeys();
        this.jPanel4 = new JPanel();
        this.m_jEnter = new JButton();
        this.m_jcodebar = new JLabel();
        this.jTextField1 = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.m_jdate = new JTextField();
        this.m_jbtndate = new JButton();
        this.jLabel2 = new JLabel();
        this.m_jreason = new JComboBox();
        this.jLabel8 = new JLabel();
        this.m_jLocation = new JComboBox();
        this.m_jDelete = new JButton();
        this.m_jUp = new JButton();
        this.m_jDown = new JButton();
        this.jPanel5 = new JPanel();
        this.m_jLocationDes = new JComboBox();
        this.jEditAttributes = new JButton();
        this.jLabel10 = new JLabel();
        this.m_jsupplier = new JTextField();
        this.jEditSupplier = new JButton();
        this.jPrintLabel = new JButton();
        this.jTextLabelCopies = new JTextField();
        this.catcontainer = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jNumberKeys.addJNumberEventListener(new JNumberEventListener(){

            @Override
            public void keyPerformed(JNumberEvent evt) {
                StockManagement.this.jNumberKeysKeyPerformed(evt);
            }
        });
        this.jPanel2.add(this.jNumberKeys);
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setLayout(new GridBagLayout());
        this.m_jEnter.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/barcode.png")));
        this.m_jEnter.setFocusPainted(false);
        this.m_jEnter.setFocusable(false);
        this.m_jEnter.setRequestFocusEnabled(false);
        this.m_jEnter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.m_jEnterActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.m_jEnter, gridBagConstraints);
        this.m_jcodebar.setBackground(Color.white);
        this.m_jcodebar.setHorizontalAlignment(4);
        this.m_jcodebar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.m_jcodebar.setOpaque(true);
        this.m_jcodebar.setPreferredSize(new Dimension(135, 30));
        this.m_jcodebar.setRequestFocusEnabled(false);
        this.m_jcodebar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StockManagement.this.m_jcodebarMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.m_jcodebar, gridBagConstraints);
        this.jTextField1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextField1.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextField1.setCaretColor(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextField1.setPreferredSize(new Dimension(1, 1));
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                StockManagement.this.jTextField1KeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jTextField1, gridBagConstraints);
        this.jPanel2.add(this.jPanel4);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.add((Component)this.jPanel1, "East");
        this.jLabel1.setText(AppLocal.getIntString("label.stockdate"));
        this.m_jbtndate.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/date.png")));
        this.m_jbtndate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.m_jbtndateActionPerformed(evt);
            }
        });
        this.jLabel2.setText(AppLocal.getIntString("label.stockreason"));
        this.m_jreason.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.m_jreasonActionPerformed(evt);
            }
        });
        this.jLabel8.setText(AppLocal.getIntString("label.warehouse"));
        this.m_jDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/removeline.png")));
        this.m_jDelete.setFocusPainted(false);
        this.m_jDelete.setFocusable(false);
        this.m_jDelete.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDelete.setRequestFocusEnabled(false);
        this.m_jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.m_jDeleteActionPerformed(evt);
            }
        });
        this.m_jUp.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1uparrow22.png")));
        this.m_jUp.setFocusPainted(false);
        this.m_jUp.setFocusable(false);
        this.m_jUp.setMargin(new Insets(8, 14, 8, 14));
        this.m_jUp.setRequestFocusEnabled(false);
        this.m_jUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.m_jUpActionPerformed(evt);
            }
        });
        this.m_jDown.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1downarrow22.png")));
        this.m_jDown.setFocusPainted(false);
        this.m_jDown.setFocusable(false);
        this.m_jDown.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDown.setRequestFocusEnabled(false);
        this.m_jDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.m_jDownActionPerformed(evt);
            }
        });
        this.jPanel5.setLayout(new BorderLayout());
        this.jEditAttributes.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/properties.png")));
        this.jEditAttributes.setFocusPainted(false);
        this.jEditAttributes.setFocusable(false);
        this.jEditAttributes.setMargin(new Insets(8, 14, 8, 14));
        this.jEditAttributes.setRequestFocusEnabled(false);
        this.jEditAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.jEditAttributesActionPerformed(evt);
            }
        });
        this.jLabel10.setText(AppLocal.getIntString("label.supplier"));
        this.m_jsupplier.setHorizontalAlignment(2);
        this.m_jsupplier.setEnabled(false);
        this.jEditSupplier.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/supplier.png")));
        this.jEditSupplier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.jEditSupplierActionPerformed(evt);
            }
        });
        this.jPrintLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/barcodeprinter.png")));
        this.jPrintLabel.setFocusPainted(false);
        this.jPrintLabel.setFocusable(false);
        this.jPrintLabel.setMargin(new Insets(8, 14, 8, 14));
        this.jPrintLabel.setRequestFocusEnabled(false);
        this.jPrintLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockManagement.this.jPrintLabelActionPerformed(evt);
            }
        });
        this.jTextLabelCopies.setFont(new Font("Tahoma", 0, 14));
        this.jTextLabelCopies.setHorizontalAlignment(0);
        this.jTextLabelCopies.setText("0");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel10, -2, 150, -2).add((Component)this.jLabel8, -2, 150, -2).add((Component)this.jLabel2, -2, 150, -2).add((Component)this.jLabel1, -2, 142, -2)).add(4, 4, 4).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.m_jdate, -2, 200, -2).add((Component)this.m_jreason, -2, 200, -2).add((Component)this.m_jLocation, -2, 200, -2).add((Component)this.m_jsupplier, -2, 200, -2)).add(6, 6, 6).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.m_jbtndate, -2, 40, -2).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jEditSupplier, -2, 40, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1, false).add((Component)this.jTextLabelCopies).add((Component)this.jPrintLabel, -1, -1, Short.MAX_VALUE))).add(1, (Component)this.m_jLocationDes, -2, 200, -2)))).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jPanel5, -2, 410, -2).add(10, 10, 10).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jEditAttributes).add((Component)this.m_jDown).add((Component)this.m_jDelete).add((Component)this.m_jUp)))).add(100, 100, 100)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel1)).add((Component)this.m_jdate, -2, 25, -2).add((Component)this.m_jbtndate)).add(5, 5, 5).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel2)).add((Component)this.m_jreason, -2, 25, -2)).add(5, 5, 5).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel8)).add((Component)this.m_jLocation, -2, 25, -2).add((Component)this.m_jLocationDes, -2, 25, -2)).add(5, 5, 5).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel10)).add((Component)this.m_jsupplier, -2, 25, -2).add((Component)this.jEditSupplier)).add(29, 29, 29).add((Component)this.jPanel5, -2, 190, -2)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.m_jUp).add(8, 8, 8).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.m_jDown).add(8, 8, 8).add((Component)this.m_jDelete)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jTextLabelCopies, -2, 34, -2).addPreferredGap(0).add((Component)this.jPrintLabel))).add(8, 8, 8).add((Component)this.jEditAttributes)))));
        this.add((Component)this.jPanel3, "Center");
        this.catcontainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.catcontainer.setLayout(new BorderLayout());
        this.add((Component)this.catcontainer, "South");
    }

    private void m_jreasonActionPerformed(ActionEvent evt) {
        this.m_jLocationDes.setEnabled(this.m_ReasonModel.getSelectedItem() == MovementReason.OUT_CROSSING);
    }

    private void m_jDownActionPerformed(ActionEvent evt) {
        this.m_invlines.goDown();
    }

    private void m_jUpActionPerformed(ActionEvent evt) {
        this.m_invlines.goUp();
    }

    private void m_jDeleteActionPerformed(ActionEvent evt) {
        this.deleteLine(this.m_invlines.getSelectedRow());
    }

    private void m_jEnterActionPerformed(ActionEvent evt) {
        this.incProductByCode(this.m_jcodebar.getText());
        this.m_jcodebar.setText(null);
    }

    private void m_jbtndateActionPerformed(ActionEvent evt) {
        Date date;
        try {
            date = (Date)Formats.TIMESTAMP.parseValue(this.m_jdate.getText());
        }
        catch (BasicException e) {
            date = null;
        }
        date = JCalendarDialog.showCalendarTime(this, date);
        if (date != null) {
            this.m_jdate.setText(Formats.TIMESTAMP.formatValue(date));
        }
    }

    private void jNumberKeysKeyPerformed(JNumberEvent evt) {
        this.stateTransition(evt.getKey());
    }

    private void jTextField1KeyTyped(KeyEvent evt) {
        this.jTextField1.setText(null);
        this.stateTransition(evt.getKeyChar());
    }

    private void m_jcodebarMouseClicked(MouseEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StockManagement.this.jTextField1.requestFocus();
            }
        });
    }

    private void jEditAttributesActionPerformed(ActionEvent evt) {
        int i = this.m_invlines.getSelectedRow();
        if (i < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                InventoryLine line = this.m_invlines.getLine(i);
                JProductAttEdit attedit = JProductAttEdit.getAttributesEditor(this, this.m_App.getSession());
                attedit.editAttributes(line.getProductAttSetId(), line.getProductAttSetInstId());
                attedit.setVisible(true);
                if (attedit.isOK()) {
                    line.setProductAttSetInstId(attedit.getAttributeSetInst());
                    line.setProductAttSetInstDesc(attedit.getAttributeSetInstDescription());
                    this.m_invlines.setLine(i, line);
                }
            }
            catch (BasicException ex) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindattributes"), ex);
                msg.show(this);
            }
        }
    }

    private void assignSupplier(SupplierInfo suppl) {
        if (suppl == null) {
            this.supplierid = null;
            this.m_jsupplier.setText(null);
        } else {
            this.supplierid = suppl.getId();
            this.m_jsupplier.setText(suppl.getName());
        }
    }

    private void jEditSupplierActionPerformed(ActionEvent evt) {
        JSupplierFinder finder = JSupplierFinder.getSupplierFinder(this, this.dlsuppliers);
        finder.search(null);
        finder.setVisible(true);
        SupplierInfo supplier = finder.getSelectedSupplier();
        if (supplier != null) {
            try {
                SupplierInfoExt c = this.m_dlSales.loadSupplierExt(supplier.getId());
                if (c == null) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindsupplier"));
                    msg.show(this);
                } else {
                    this.assignSupplier(c);
                }
            }
            catch (BasicException ex) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindsupplier"), ex);
                msg.show(this);
            }
        }
    }

    private void jPrintLabelActionPerformed(ActionEvent evt) {
        block13: {
            int i = this.m_invlines.getSelectedRow();
            ProductInfoExt product = null;
            if (i >= 0) {
                InventoryLine inv = this.m_invlines.getLine(i);
                try {
                    product = this.m_dlSales.getProductInfo(inv.getProductID());
                }
                catch (Exception e) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.labelselectproduct"));
                    msg.show(this);
                }
                if (product == null) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.labelselectproduct"));
                    msg.show(this);
                } else {
                    String sresource;
                    String labelFormat = "Printer.Label";
                    if (product.getProperty("label") != null) {
                        labelFormat = product.getProperty("label");
                    }
                    if ((sresource = this.m_dlSystem.getResourceAsXML(labelFormat)) == null) {
                        MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintlabel"));
                        msg.show(this);
                    } else {
                        try {
                            ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                            script.put("product", product);
                            script.put("line", inv);
                            if (Integer.parseInt(this.jTextLabelCopies.getText()) > 0) {
                                this.m_LLP.printLabel(script.eval(sresource).toString(), Integer.parseInt(this.jTextLabelCopies.getText()));
                                break block13;
                            }
                            this.m_LLP.printLabel(script.eval(sresource).toString(), (int)Math.floor(inv.getMultiply() + 0.5));
                        }
                        catch (ScriptException e) {
                            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintlabel"), e);
                            msg.show(this);
                        }
                        catch (TicketPrinterException e) {
                            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintlabel"), e);
                            msg.show(this);
                        }
                    }
                }
            } else {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.labelselectproduct"));
                msg.show(this);
            }
        }
    }

    private class CatalogListener
    implements ActionListener {
        private CatalogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String sQty = StockManagement.this.m_jcodebar.getText();
            if (sQty != null && StockManagement.isDouble(sQty)) {
                Double dQty = Double.valueOf(sQty) == 0.0 ? 1.0 : Double.valueOf(sQty);
                StockManagement.this.incProduct((ProductInfoExt)e.getSource(), dQty);
                StockManagement.this.m_jcodebar.setText(null);
            } else {
                StockManagement.this.incProduct((ProductInfoExt)e.getSource(), 1.0);
            }
        }
    }

    private class ConfigurationHandler
    extends DefaultHandler {
        private ConfigurationHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String value;
            if (!"button".equals(qName) && !"event".equals(qName) && (value = attributes.getValue("value")) != null) {
                StockManagement.this.props.setProperty(qName, attributes.getValue("value"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }
}

