/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.kds;

import com.posics.basic.BasicException;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.kds.JTicketKDS;
import com.posics.pos.kds.KDSTicketInfo;
import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.screen.DevicePrinterPanel;
import com.posics.pos.printer.screen.JTicketContainer;
import com.posics.pos.sales.DataLogicReceipts;
import com.posics.pos.sales.JPanelButtons;
import com.posics.pos.ticket.TicketInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class JPanelMyKDS
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private DataLogicSales m_dlSales = null;
    private DataLogicSystem m_dlSystem = null;
    protected DataLogicCustomers dlCustomers = null;
    private DataLogicReceipts dlReceipts = null;
    private DeviceTicket m_TP;
    private TicketParser m_TTP;
    private AppView m_App;
    protected JPanelButtons m_jbtnconfig;
    private int[] iTicketStatus;
    private Timer m_jtimer;
    private List<KDSTicketInfo> kdstickets;
    private DevicePrinterPanel dp;
    private JScrollPane jp;
    private JViewport jv;
    private JTicketContainer jc;
    private TicketInfo m_ticket;
    private ButtonGroup buttonGroup1;
    private JPanel m_jPanelTicket;

    public JPanelMyKDS() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.m_dlSales = (DataLogicSales)this.m_App.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlReceipts = (DataLogicReceipts)this.m_App.getBean("com.posics.pos.sales.DataLogicReceipts");
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlCustomers = (DataLogicCustomers)this.m_App.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.m_TP = new DeviceTicket();
        this.m_TTP = new TicketParser(this.m_TP, this.m_dlSystem);
        this.m_jPanelTicket.removeAll();
        this.m_jPanelTicket.repaint();
        this.m_jPanelTicket.add((Component)this.m_TP.getDevicePrinter("1").getPrinterComponent(), "Center");
        this.dp = (DevicePrinterPanel)this.m_jPanelTicket.getComponent(0);
        this.jp = (JScrollPane)this.dp.getComponent(0);
        this.jv = (JViewport)this.jp.getComponent(0);
        this.jc = (JTicketContainer)this.jv.getComponent(0);
        this.jc.setBackground(Color.black);
        JScrollBar vertical = this.jp.getVerticalScrollBar();
        InputMap im = vertical.getInputMap(2);
        im.put(KeyStroke.getKeyStroke("DOWN"), "positiveUnitIncrement");
        im.put(KeyStroke.getKeyStroke("UP"), "negativeUnitIncrement");
        im.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "positiveBlockIncrement");
        im.put(KeyStroke.getKeyStroke("PAGE_UP"), "negativeBlockIncrement");
        this.m_jtimer = new Timer(5000, new TimerAction());
        this.m_jtimer.start();
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.MyToken");
    }

    @Override
    public boolean deactivate() {
        this.m_jtimer.stop();
        return true;
    }

    @Override
    public void activate() throws BasicException {
        this.m_jtimer.stop();
        this.loadData();
        this.m_ticket = null;
        this.m_jtimer.restart();
    }

    private void loadData() {
        try {
            int i;
            int comCount = this.jc.getComponentCount();
            int whiteCount = 0;
            int cyanCount = 0;
            for (i = 0; i < comCount; ++i) {
                this.jc.remove(0);
            }
            this.kdstickets = this.dlReceipts.getKDSTickets(this.m_App.getActiveCashIndex(), this.m_App.getAppUserView().getUser().getId());
            if (!this.kdstickets.isEmpty()) {
                this.iTicketStatus = new int[this.kdstickets.size()];
                for (i = 0; i < this.kdstickets.size(); ++i) {
                    JTicketKDS ticket = new JTicketKDS(this.kdstickets.get(i), 54);
                    ticket.setElapsedTime(this.kdstickets.get(i).printElapsedMinutes());
                    if (this.kdstickets.get(i).getStatus() == 2) {
                        ticket.setBackground(Color.cyan);
                        ++cyanCount;
                    } else {
                        ++whiteCount;
                    }
                    if (this.kdstickets.get(i).getElapsedMinutes() > 5L) {
                        ticket.setBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, Color.red));
                    }
                    this.jc.add(ticket);
                }
            }
            this.repaint();
            this.revalidate();
        }
        catch (BasicException basicException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.m_jPanelTicket = new JPanel();
        this.setLayout(new BorderLayout());
        this.m_jPanelTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanelTicket.setAutoscrolls(true);
        this.m_jPanelTicket.setLayout(new BorderLayout());
        this.add((Component)this.m_jPanelTicket, "Center");
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JPanelMyKDS.this.m_jtimer.stop();
                JPanelMyKDS.this.loadData();
                JPanelMyKDS.this.m_jtimer.start();
            }
            catch (Exception e) {
                JPanelMyKDS.this.m_jtimer.restart();
            }
        }
    }
}

