/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.kds;

import com.posics.pos.kds.KDSTicketInfo;
import com.posics.pos.printer.ticket.BasicTicketForKDS;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTicketKDS
extends JPanel {
    private static final int H_GAP = 8;
    private static final int V_GAP = 8;
    private static int COLUMNS = 54;
    private static int LINEWIDTH = COLUMNS * 7;
    private BasicTicketForKDS basict;
    private KDSTicketInfo kdsticket;
    private Map desktophints;
    private JPanel jPanel1;
    private JLabel lblID;
    private JLabel lblTimeElapsed;

    public JTicketKDS(KDSTicketInfo t, int tokenwidth) {
        this.kdsticket = t;
        this.basict = t.getTicket();
        this.desktophints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        COLUMNS = tokenwidth;
        LINEWIDTH = COLUMNS * 7;
        this.initComponents();
    }

    public JTicketKDS(BasicTicketForKDS t) {
        this.basict = t;
        this.desktophints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        this.initComponents();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintBorder(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.desktophints != null) {
            g2d.addRenderingHints(this.desktophints);
        }
        Insets i = this.getInsets();
        g2d.setPaint(new GradientPaint(this.getWidth() - i.left - i.right - 100, this.getHeight() - i.top - i.bottom - 100, this.getBackground(), this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom, new Color(0xF0F0F0), true));
        g2d.fillRect(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
        g.setColor(this.getForeground());
        this.basict.draw(g2d, i.left + 8, i.top + 8, LINEWIDTH);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(LINEWIDTH + 16 + ins.left + ins.right, this.basict.getHeight() + 16 + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setElapsedTime(String elapsed) {
        this.lblTimeElapsed.setText(elapsed + " ");
    }

    public void setID(String ID) {
        this.lblID.setText(ID);
    }

    public KDSTicketInfo getKdsTicket() {
        return this.kdsticket;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblID = new JLabel();
        this.lblTimeElapsed = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setLayout(new GridLayout(1, 0));
        this.lblID.setFont(new Font("Tahoma", 0, 24));
        this.lblID.setForeground(new Color(0, 0, 255));
        this.lblID.setVerticalAlignment(1);
        this.lblID.setMaximumSize(new Dimension(20, 29));
        this.lblID.setMinimumSize(new Dimension(20, 29));
        this.lblID.setPreferredSize(new Dimension(20, 29));
        this.add(this.lblID);
        this.lblTimeElapsed.setFont(new Font("Tahoma", 0, 24));
        this.lblTimeElapsed.setForeground(new Color(0, 0, 255));
        this.lblTimeElapsed.setHorizontalAlignment(11);
        this.lblTimeElapsed.setText("0:00");
        this.lblTimeElapsed.setVerticalAlignment(1);
        this.lblTimeElapsed.setMaximumSize(new Dimension(8000, 29));
        this.lblTimeElapsed.setMinimumSize(new Dimension(80, 29));
        this.lblTimeElapsed.setPreferredSize(new Dimension(80, 29));
        this.add(this.lblTimeElapsed);
    }
}

