/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.kds;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.pos.printer.ticket.BasicTicketForKDS;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class KDSTicketInfo
implements SerializableRead,
Externalizable {
    private static final long serialVersionUID = 7640633837719L;
    private String id;
    private String money;
    private String displayid;
    private BasicTicketForKDS ticket;
    private Date datesent;
    private Date dateattended;
    private Date dateclosed;
    private int status;
    private Date lapsedtime;

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.id = dr.getString(1);
        this.money = dr.getString(2);
        this.displayid = dr.getString(3);
        ObjectInputStream objectIn = null;
        try {
            objectIn = new ObjectInputStream(new ByteArrayInputStream(dr.getBytes(4)));
            this.ticket = (BasicTicketForKDS)objectIn.readObject();
        }
        catch (Exception eData) {
            System.out.println(eData);
        }
        this.datesent = dr.getTimestamp(5);
        this.dateattended = dr.getTimestamp(6);
        this.dateclosed = dr.getTimestamp(7);
        this.status = dr.getInt(8);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.money = (String)in.readObject();
        this.displayid = (String)in.readObject();
        this.ticket = (BasicTicketForKDS)in.readObject();
        this.datesent = (Date)in.readObject();
        this.dateattended = (Date)in.readObject();
        this.dateclosed = (Date)in.readObject();
        this.status = in.readInt();
    }

    public void writeValues(DataWrite dp) throws BasicException {
        dp.setString(1, this.id);
        dp.setString(2, this.money);
        dp.setString(3, this.displayid);
        dp.setObject(4, this.ticket);
        dp.setTimestamp(5, this.datesent);
        dp.setTimestamp(6, this.dateattended);
        dp.setTimestamp(7, this.dateclosed);
        dp.setInt(8, this.status);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.money);
        out.writeObject(this.displayid);
        out.writeObject(this.ticket);
        out.writeObject(this.datesent);
        out.writeObject(this.dateattended);
        out.writeObject(this.dateclosed);
        out.writeInt(this.status);
    }

    public String getTicketId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public String getMoney() {
        return this.money;
    }

    public String getDisplayID() {
        return this.displayid;
    }

    public BasicTicketForKDS getTicket() {
        return this.ticket;
    }

    public String printElapsedMinutes() {
        long tStart = this.datesent.getTime();
        long tEnd = System.currentTimeMillis();
        long tElapsed = tEnd - tStart;
        return String.format("%d:%02d", TimeUnit.MILLISECONDS.toMinutes(tElapsed), TimeUnit.MILLISECONDS.toSeconds(tElapsed) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(tElapsed)));
    }

    public long getElapsedMinutes() {
        long tStart = this.datesent.getTime();
        long tEnd = System.currentTimeMillis();
        long tElapsed = tEnd - tStart;
        return TimeUnit.MILLISECONDS.toMinutes(tElapsed);
    }

    public String printElapsedHours() {
        long tStart = this.datesent.getTime();
        long tEnd = System.currentTimeMillis();
        long tElapsed = tEnd - tStart;
        return String.format("%d:%02d", TimeUnit.MILLISECONDS.toHours(tElapsed), TimeUnit.MILLISECONDS.toMinutes(tElapsed) - TimeUnit.MILLISECONDS.toHours(tElapsed) * 60L);
    }

    public long getElapsedHours() {
        long tStart = this.datesent.getTime();
        long tEnd = System.currentTimeMillis();
        long tElapsed = tEnd - tStart;
        return TimeUnit.MILLISECONDS.toHours(tElapsed);
    }
}

