/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.panels;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteString;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.panels.JProductFinder;
import com.posics.pos.reports.ReportEditorCreator;
import com.posics.pos.ticket.ProductInfoExt;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.EventListenerList;

public class AuxiliarFilter
extends JPanel
implements ReportEditorCreator {
    private ProductInfoExt product;
    private DataLogicSales m_dlSales;
    protected EventListenerList listeners = new EventListenerList();
    private JButton Enter1;
    private JButton Enter2;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField m_jBarcode1;
    private JTextField m_jReference1;
    private JTextField m_jSearch;
    private JButton search;

    public AuxiliarFilter() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) {
        this.m_dlSales = (DataLogicSales)app.getBean("com.posics.pos.forms.DataLogicSales");
    }

    @Override
    public void activate() throws BasicException {
        this.product = null;
        this.m_jSearch.setText(null);
        this.m_jBarcode1.setText(null);
        this.m_jReference1.setText(null);
    }

    @Override
    public SerializerWrite getSerializerWrite() {
        return SerializerWriteString.INSTANCE;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(ActionListener.class, l);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Object createValue() throws BasicException {
        return this.product == null ? null : this.product.getID();
    }

    public ProductInfoExt getProductInfoExt() {
        return this.product;
    }

    private void assignProduct(ProductInfoExt prod) {
        this.product = prod;
        if (this.product == null) {
            this.m_jSearch.setText(null);
            this.m_jBarcode1.setText(null);
            this.m_jReference1.setText(null);
        } else {
            this.m_jSearch.setText(this.product.getReference() + " - " + this.product.getName());
            this.m_jBarcode1.setText(this.product.getCode());
            this.m_jReference1.setText(this.product.getReference());
        }
        this.fireSelectedProduct();
    }

    protected void fireSelectedProduct() {
        EventListener[] l = this.listeners.getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < l.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, 1001, "SELECTED");
            }
            ((ActionListener)l[i]).actionPerformed(e);
        }
    }

    private void assignProductByCode() {
        try {
            ProductInfoExt prod = this.m_dlSales.getProductInfoByCode(this.m_jBarcode1.getText());
            if (prod == null) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.assignProduct(prod);
        }
        catch (BasicException eData) {
            MessageInf msg = new MessageInf(eData);
            msg.show(this);
            this.assignProduct(null);
        }
    }

    private void assignProductByReference() {
        try {
            ProductInfoExt prod = this.m_dlSales.getProductInfoByReference(this.m_jReference1.getText());
            if (prod == null) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.assignProduct(prod);
        }
        catch (BasicException eData) {
            MessageInf msg = new MessageInf(eData);
            msg.show(this);
            this.assignProduct(null);
        }
    }

    private void initComponents() {
        this.jLabel6 = new JLabel();
        this.m_jReference1 = new JTextField();
        this.Enter1 = new JButton();
        this.jLabel7 = new JLabel();
        this.m_jBarcode1 = new JTextField();
        this.Enter2 = new JButton();
        this.m_jSearch = new JTextField();
        this.search = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(AppLocal.getIntString("label.byproduct")));
        this.jLabel6.setText(AppLocal.getIntString("label.prodref"));
        this.m_jReference1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxiliarFilter.this.m_jReference1ActionPerformed(evt);
            }
        });
        this.Enter1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/apply.png")));
        this.Enter1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxiliarFilter.this.Enter1ActionPerformed(evt);
            }
        });
        this.jLabel7.setText(AppLocal.getIntString("label.prodbarcode"));
        this.m_jBarcode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxiliarFilter.this.m_jBarcode1ActionPerformed(evt);
            }
        });
        this.Enter2.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/apply.png")));
        this.Enter2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxiliarFilter.this.Enter2ActionPerformed(evt);
            }
        });
        this.m_jSearch.setEditable(false);
        this.m_jSearch.setFocusable(false);
        this.m_jSearch.setRequestFocusEnabled(false);
        this.search.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/search.png")));
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxiliarFilter.this.searchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jReference1, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Enter1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jBarcode1, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Enter2)).addGroup(layout.createSequentialGroup().addComponent(this.m_jSearch, -2, 378, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.search))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.m_jReference1, -2, 25, -2)).addComponent(this.Enter1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.m_jBarcode1, -2, 25, -2)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.search).addComponent(this.m_jSearch, -2, 25, -2))).addComponent(this.Enter2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void m_jReference1ActionPerformed(ActionEvent evt) {
        this.assignProductByReference();
    }

    private void searchActionPerformed(ActionEvent evt) {
        this.assignProduct(JProductFinder.showMessage(this, this.m_dlSales, 1));
    }

    private void Enter2ActionPerformed(ActionEvent evt) {
        this.assignProductByCode();
    }

    private void Enter1ActionPerformed(ActionEvent evt) {
        this.assignProductByReference();
    }

    private void m_jBarcode1ActionPerformed(ActionEvent evt) {
        this.assignProductByCode();
    }
}

