/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.panels;

import com.posics.basic.BasicException;
import com.posics.beans.DateUtils;
import com.posics.data.gui.MessageInf;
import com.posics.data.user.DirtyManager;
import com.posics.editor.JEditorKeys;
import com.posics.editor.JEditorString;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerDiary;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.customers.JCustomerFinder;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.payment.JPaymentSelect;
import com.posics.pos.payment.JPaymentSelectCustomer;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.reports.JParamsDatesInterval;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JPanelCustomerDebits
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private AppView app;
    private DataLogicCustomers dlcustomers;
    private DataLogicSales dlsales;
    private DataLogicSystem dlsystem;
    private TicketParser ttp;
    private JPaymentSelect paymentdialog;
    private CustomerInfoExt customerext;
    private DirtyManager dirty;
    private List<CustomerDiary> custdiary;
    private JButton btnAdvance;
    private JButton btnCustomer;
    private JButton btnPay;
    private JButton btnPrint;
    private JButton btnSave;
    private JEditorString editorcard;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JEditorKeys m_jKeys;
    private JTextField txtAdvance;
    private JTextField txtAdvanceDate;
    private JTextField txtCard;
    private JTextField txtCurdate;
    private JTextField txtCurdebt;
    private JTextField txtMaxdebt;
    private JTextField txtName;
    private JEditorString txtNotes;
    private JTextField txtTaxId;

    public JPanelCustomerDebits() {
        this.initComponents();
        this.editorcard.addEditorKeys(this.m_jKeys);
        this.txtNotes.addEditorKeys(this.m_jKeys);
        this.dirty = new DirtyManager();
        this.txtNotes.addPropertyChangeListener("Text", this.dirty);
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.app = app;
        this.dlcustomers = (DataLogicCustomers)app.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.dlsales = (DataLogicSales)app.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlsystem = (DataLogicSystem)app.getBean("com.posics.pos.forms.DataLogicSystem");
        this.ttp = new TicketParser(app.getDeviceTicket(), this.dlsystem);
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.CustomerPayment");
    }

    @Override
    public void activate() throws BasicException {
        this.paymentdialog = JPaymentSelectCustomer.getDialog(this);
        this.paymentdialog.init(this.app);
        this.resetCustomer();
        this.editorcard.reset();
        this.editorcard.activate();
    }

    @Override
    public boolean deactivate() {
        if (this.dirty.isDirty()) {
            int res = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannasave"), AppLocal.getIntString("title.editor"), 1, 3);
            if (res == 0) {
                this.save();
                return true;
            }
            return res == 1;
        }
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void editCustomer(CustomerInfoExt customer) {
        this.customerext = customer;
        this.txtTaxId.setText(customer.getTaxid());
        this.txtName.setText(customer.getName());
        this.txtCard.setText(customer.getCard());
        this.txtNotes.reset();
        this.txtNotes.setText(customer.getNotes());
        this.txtMaxdebt.setText(Formats.CURRENCY.formatValue(customer.getMaxdebt()));
        this.txtCurdebt.setText(Formats.CURRENCY.formatValue(customer.getCurdebt()));
        this.txtCurdate.setText(Formats.DATE.formatValue(customer.getCurdate()));
        if (customer.getCurAdvance() != null) {
            this.txtAdvance.setText(Formats.CURRENCY.formatValue(Math.abs(customer.getCurAdvance())));
        } else {
            this.txtAdvance.setText(null);
        }
        this.txtAdvanceDate.setText(Formats.DATE.formatValue(customer.getAdvanceDate()));
        this.txtNotes.setEnabled(true);
        this.dirty.setDirty(false);
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnAdvance.setEnabled(true);
        if (customer.getCurdebt() != null && customer.getCurdebt() > 0.0) {
            this.btnPay.setEnabled(true);
        } else {
            this.btnPay.setEnabled(false);
        }
    }

    private void resetCustomer() {
        this.customerext = null;
        this.txtTaxId.setText(null);
        this.txtName.setText(null);
        this.txtCard.setText(null);
        this.txtNotes.reset();
        this.txtMaxdebt.setText(null);
        this.txtCurdebt.setText(null);
        this.txtCurdate.setText(null);
        this.txtAdvance.setText(null);
        this.txtAdvanceDate.setText(null);
        this.txtNotes.setEnabled(false);
        this.dirty.setDirty(false);
        this.btnSave.setEnabled(false);
        this.btnPay.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.btnAdvance.setEnabled(false);
    }

    private void readCustomer() {
        try {
            CustomerInfoExt customer = this.dlsales.findCustomerExt(this.editorcard.getText());
            if (customer == null) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"));
                msg.show(this);
            } else {
                this.editCustomer(customer);
            }
        }
        catch (BasicException ex) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), ex);
            msg.show(this);
        }
        this.editorcard.reset();
        this.editorcard.activate();
    }

    private void save() {
        this.customerext.setNotes(this.txtNotes.getText());
        try {
            this.dlcustomers.updateCustomerExt(this.customerext);
            this.editCustomer(this.customerext);
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.nosave"), e);
            msg.show(this);
        }
    }

    private void printTicket(String resname, TicketInfo ticket, CustomerInfoExt customer) {
        String resource = this.dlsystem.getResourceAsXML(resname);
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", ticket);
                script.put("customer", customer);
                this.ttp.printTicket(script.eval(resource).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    private void printDiary(String resname, List<CustomerDiary> diary, CustomerInfoExt customer, String datefrom, String dateto) {
        String resource = this.dlsystem.getResourceAsXML(resname);
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("diary", diary);
                script.put("customer", customer);
                script.put("datefrom", datefrom);
                script.put("dateto", dateto);
                this.ttp.printTicket(script.eval(resource).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel6 = new JPanel();
        this.btnCustomer = new JButton();
        this.btnSave = new JButton();
        this.jSeparator1 = new JSeparator();
        this.btnPay = new JButton();
        this.btnAdvance = new JButton();
        this.btnPrint = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel5 = new JPanel();
        this.editorcard = new JEditorString();
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtCard = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtCurdebt = new JTextField();
        this.txtCurdate = new JTextField();
        this.jLabel6 = new JLabel();
        this.txtName = new JTextField();
        this.txtMaxdebt = new JTextField();
        this.txtNotes = new JEditorString();
        this.txtTaxId = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtAdvanceDate = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txtAdvance = new JTextField();
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.btnCustomer.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/kuser.png")));
        this.btnCustomer.setFocusPainted(false);
        this.btnCustomer.setFocusable(false);
        this.btnCustomer.setMargin(new Insets(8, 14, 8, 14));
        this.btnCustomer.setRequestFocusEnabled(false);
        this.btnCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.btnCustomerActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnCustomer);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/filesave.png")));
        this.btnSave.setFocusPainted(false);
        this.btnSave.setFocusable(false);
        this.btnSave.setMargin(new Insets(8, 14, 8, 14));
        this.btnSave.setRequestFocusEnabled(false);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.btnSaveActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnSave);
        this.jPanel6.add(this.jSeparator1);
        this.btnPay.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/greenled.png")));
        this.btnPay.setText(AppLocal.getIntString("button.receivedebt"));
        this.btnPay.setFocusPainted(false);
        this.btnPay.setFocusable(false);
        this.btnPay.setMargin(new Insets(8, 14, 8, 14));
        this.btnPay.setRequestFocusEnabled(false);
        this.btnPay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.btnPayActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnPay);
        this.btnAdvance.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/greenled.png")));
        this.btnAdvance.setText(AppLocal.getIntString("button.receiveadvance"));
        this.btnAdvance.setFocusPainted(false);
        this.btnAdvance.setFocusable(false);
        this.btnAdvance.setMargin(new Insets(8, 14, 8, 14));
        this.btnAdvance.setRequestFocusEnabled(false);
        this.btnAdvance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.btnAdvanceActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnAdvance);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/printer.png")));
        this.btnPrint.setText(AppLocal.getIntString("button.printdiary"));
        this.btnPrint.setFocusPainted(false);
        this.btnPrint.setFocusable(false);
        this.btnPrint.setMargin(new Insets(8, 14, 8, 14));
        this.btnPrint.setRequestFocusEnabled(false);
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.btnPrintActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.btnPrint);
        this.jPanel2.add((Component)this.jPanel6, "Before");
        this.add((Component)this.jPanel2, "First");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.m_jKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.m_jKeysActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.m_jKeys);
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.add((Component)this.editorcard, new GridBagConstraints());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setMargin(new Insets(8, 14, 8, 14));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCustomerDebits.this.jButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel5.add((Component)this.jButton1, gridBagConstraints);
        this.jPanel4.add(this.jPanel5);
        this.jPanel3.add((Component)this.jPanel4, "North");
        this.add((Component)this.jPanel3, "After");
        this.jLabel3.setText(AppLocal.getIntString("label.name"));
        this.jLabel12.setText(AppLocal.getIntString("label.notes"));
        this.jLabel5.setText(AppLocal.getIntString("label.card"));
        this.txtCard.setEditable(false);
        this.txtCard.setFocusable(false);
        this.txtCard.setRequestFocusEnabled(false);
        this.jLabel1.setText(AppLocal.getIntString("label.maxdebt"));
        this.jLabel2.setText(AppLocal.getIntString("label.curdebt"));
        this.txtCurdebt.setEditable(false);
        this.txtCurdebt.setHorizontalAlignment(4);
        this.txtCurdebt.setFocusable(false);
        this.txtCurdebt.setRequestFocusEnabled(false);
        this.txtCurdate.setEditable(false);
        this.txtCurdate.setHorizontalAlignment(0);
        this.txtCurdate.setFocusable(false);
        this.txtCurdate.setRequestFocusEnabled(false);
        this.jLabel6.setText(AppLocal.getIntString("label.curdate"));
        this.txtName.setEditable(false);
        this.txtName.setFocusable(false);
        this.txtName.setRequestFocusEnabled(false);
        this.txtMaxdebt.setEditable(false);
        this.txtMaxdebt.setHorizontalAlignment(4);
        this.txtMaxdebt.setFocusable(false);
        this.txtMaxdebt.setRequestFocusEnabled(false);
        this.txtTaxId.setEditable(false);
        this.txtTaxId.setFocusable(false);
        this.txtTaxId.setRequestFocusEnabled(false);
        this.jLabel7.setText(AppLocal.getIntString("label.taxid"));
        this.txtAdvanceDate.setEditable(false);
        this.txtAdvanceDate.setHorizontalAlignment(0);
        this.txtAdvanceDate.setFocusable(false);
        this.txtAdvanceDate.setRequestFocusEnabled(false);
        this.jLabel8.setText(AppLocal.getIntString("label.advancedate"));
        this.jLabel4.setText(AppLocal.getIntString("label.advancepaid"));
        this.txtAdvance.setEditable(false);
        this.txtAdvance.setHorizontalAlignment(4);
        this.txtAdvance.setFocusable(false);
        this.txtAdvance.setRequestFocusEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 140, -2).addComponent(this.jLabel7, -2, 140, -2).addComponent(this.jLabel5, -2, 140, -2).addComponent(this.jLabel12, -2, 140, -2).addComponent(this.jLabel1, -2, 140, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtTaxId, -2, 240, -2).addComponent(this.txtName, -2, 240, -2).addComponent(this.txtCard, -2, 240, -2).addComponent(this.txtNotes, -2, 270, -2).addComponent(this.txtMaxdebt, -2, 130, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 140, -2).addComponent(this.jLabel6, -2, 140, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtCurdebt, -2, 130, -2).addComponent(this.txtCurdate, -2, 130, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 140, -2).addComponent(this.jLabel8, -2, 140, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtAdvance, -2, 130, -2).addComponent(this.txtAdvanceDate, -2, 130, -2)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel7).addComponent(this.txtTaxId, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.txtName, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel5).addComponent(this.txtCard, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.txtNotes, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.txtMaxdebt, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.txtCurdebt, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel6).addComponent(this.txtCurdate, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.txtAdvance, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel8).addComponent(this.txtAdvanceDate, -2, 25, -2)).addContainerGap()));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.readCustomer();
    }

    private void m_jKeysActionPerformed(ActionEvent evt) {
        this.readCustomer();
    }

    private void btnCustomerActionPerformed(ActionEvent evt) {
        JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlcustomers);
        finder.search(null);
        finder.setVisible(true);
        CustomerInfo customer = finder.getSelectedCustomer();
        if (customer != null) {
            try {
                CustomerInfoExt c = this.dlsales.loadCustomerExt(customer.getId());
                if (c == null) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"));
                    msg.show(this);
                } else {
                    this.editCustomer(c);
                }
            }
            catch (BasicException ex) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), ex);
                msg.show(this);
            }
        }
        this.editorcard.reset();
        this.editorcard.activate();
    }

    private void btnPayActionPerformed(ActionEvent evt) {
        this.paymentdialog.setPrintSelected(true);
        if (this.paymentdialog.showDialog(this.customerext.getCurdebt(), null, "customer")) {
            CustomerInfoExt c;
            MessageInf msg;
            TicketInfo ticket = new TicketInfo();
            ticket.setTicketType(2);
            List<PaymentInfo> payments = this.paymentdialog.getSelectedPayments();
            double total = 0.0;
            for (PaymentInfo p : payments) {
                total += p.getTotal();
            }
            payments.add(new PaymentInfoTicket(-total, "debtpaid"));
            ticket.setPayments(payments);
            ticket.setUser(this.app.getAppUserView().getUser().getUserInfo());
            ticket.setActiveCash(this.app.getActiveCashIndex());
            ticket.setDate(new Date());
            ticket.setCustomer(this.customerext);
            try {
                this.dlsales.saveTicket(ticket, this.app.getInventoryLocation(), this.app.getReceiptHost());
            }
            catch (BasicException eData) {
                msg = new MessageInf(-67108864, AppLocal.getIntString("message.nosaveticket"), eData);
                msg.show(this);
            }
            try {
                c = this.dlsales.loadCustomerExt(this.customerext.getId());
                if (c == null) {
                    msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"));
                    msg.show(this);
                } else {
                    this.editCustomer(c);
                }
            }
            catch (BasicException ex) {
                c = null;
                MessageInf msg2 = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), ex);
                msg2.show(this);
            }
            this.printTicket(this.paymentdialog.isPrintSelected() ? "Printer.CustomerPaid" : "Printer.CustomerPaid2", ticket, c);
        }
        this.editorcard.reset();
        this.editorcard.activate();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        if (this.dirty.isDirty()) {
            this.save();
            this.editorcard.reset();
            this.editorcard.activate();
        }
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        if (this.customerext != null) {
            SimpleDateFormat ts = new SimpleDateFormat("yyyy-MM-dd");
            JParamsDatesInterval paramdates = new JParamsDatesInterval(true);
            paramdates.setStartDate(DateUtils.getToday());
            int result = JOptionPane.showConfirmDialog(this, paramdates, "Please Enter Dates", 2, -1);
            if (result == 0) {
                try {
                    this.custdiary = !paramdates.getStartDate().trim().equals("") && !paramdates.getEndDate().trim().equals("") ? this.dlcustomers.getCustomerDiary(this.customerext.getId(), ts.format(Formats.TIMESTAMP.parseValue(paramdates.getStartDate())), ts.format(Formats.TIMESTAMP.parseValue(paramdates.getEndDate())) + " 23:59:59") : (!paramdates.getStartDate().trim().equals("") ? this.dlcustomers.getCustomerDiary(this.customerext.getId(), ts.format(Formats.TIMESTAMP.parseValue(paramdates.getStartDate())), null) : this.dlcustomers.getCustomerDiary(this.customerext.getId(), null, null));
                    this.printDiary("Printer.CustomerDiary", this.custdiary, this.customerext, paramdates.getStartDate(), paramdates.getEndDate());
                }
                catch (Exception e) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintcustomerdiary"), e);
                    msg.show(this);
                }
            }
        }
    }

    private void btnAdvanceActionPerformed(ActionEvent evt) {
        this.paymentdialog.setPrintSelected(true);
        if (this.paymentdialog.showDialog(100000.0, null, "customer")) {
            CustomerInfoExt c;
            MessageInf msg;
            TicketInfo ticket = new TicketInfo();
            ticket.setTicketType(2);
            List<PaymentInfo> payments = this.paymentdialog.getSelectedPayments();
            double total = 0.0;
            for (PaymentInfo p : payments) {
                total += p.getTotal();
            }
            payments.add(new PaymentInfoTicket(-total, "advancepaid"));
            ticket.setPayments(payments);
            ticket.setUser(this.app.getAppUserView().getUser().getUserInfo());
            ticket.setActiveCash(this.app.getActiveCashIndex());
            ticket.setDate(new Date());
            ticket.setCustomer(this.customerext);
            try {
                this.dlsales.saveTicket(ticket, this.app.getInventoryLocation(), this.app.getReceiptHost());
            }
            catch (BasicException eData) {
                msg = new MessageInf(-67108864, AppLocal.getIntString("message.nosaveticket"), eData);
                msg.show(this);
            }
            try {
                c = this.dlsales.loadCustomerExt(this.customerext.getId());
                if (c == null) {
                    msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"));
                    msg.show(this);
                } else {
                    this.editCustomer(c);
                }
            }
            catch (BasicException ex) {
                c = null;
                MessageInf msg2 = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), ex);
                msg2.show(this);
            }
            this.printTicket(this.paymentdialog.isPrintSelected() ? "Printer.CustomerAdvancePaid" : "Printer.CustomerAdvancePaid2", ticket, c);
        }
        this.editorcard.reset();
        this.editorcard.activate();
    }
}

