/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.payment.PaymentConfiguration;
import com.posics.pos.util.AltEncrypter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class ConfigPaymentPanelLinkPoint
extends JPanel
implements PaymentConfiguration {
    private static File m_fCurrentDirectory = null;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPasswordField jtxtCertificatePass;
    private JTextField jtxtCertificatePath;
    private JTextField jtxtStoreName;

    public ConfigPaymentPanelLinkPoint() {
        this.initComponents();
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        String sCommerceID = config.getProperty("payment.commerceid");
        String sCertificatePass = config.getProperty("payment.certificatePassword");
        String sCertificatePath = config.getProperty("payment.certificatePath");
        if (sCommerceID != null && sCertificatePath != null && sCertificatePass != null && sCertificatePass.startsWith("crypt:")) {
            this.jtxtStoreName.setText(config.getProperty("payment.commerceid"));
            AltEncrypter cypher = new AltEncrypter("cypherkey");
            this.jtxtCertificatePass.setText(cypher.decrypt(config.getProperty("payment.certificatePassword").substring(6)));
            this.jtxtCertificatePath.setText(config.getProperty("payment.certificatePath"));
        }
    }

    @Override
    public void saveProperties(AppConfig config) {
        AltEncrypter cypher = new AltEncrypter("cypherkey");
        config.setProperty("payment.commerceid", this.comboValue(this.jtxtStoreName.getText()));
        config.setProperty("payment.certificatePath", this.comboValue(this.jtxtCertificatePath.getText()));
        config.setProperty("payment.certificatePassword", "crypt:" + cypher.encrypt(new String(this.jtxtCertificatePass.getPassword())));
    }

    private String comboValue(Object value) {
        return value == null ? "" : value.toString();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jtxtStoreName = new JTextField();
        this.jtxtCertificatePass = new JPasswordField();
        this.jtxtCertificatePath = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel1.setText(AppLocal.getIntString("label.storename"));
        this.jLabel3.setText(AppLocal.getIntString("label.certificatepwd"));
        this.jLabel4.setText(AppLocal.getIntString("label.certificatepath"));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/fileopen.png")));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigPaymentPanelLinkPoint.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtxtStoreName, -2, 180, -2).addComponent(this.jtxtCertificatePass, -2, 180, -2).addGroup(layout.createSequentialGroup().addComponent(this.jtxtCertificatePath, -2, 350, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 30, -2))).addContainerGap(103, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtxtStoreName, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtxtCertificatePass, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, 25, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtxtCertificatePath, -2, -1, -2).addComponent(this.jLabel4))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(m_fCurrentDirectory);
        fc.addChoosableFileFilter(new ExtensionsFilter("PKCS12 certificates", "p12"));
        if (fc.showOpenDialog(this) == 0) {
            File selectedFile = fc.getSelectedFile();
            this.jtxtCertificatePath.setText(selectedFile.getAbsolutePath());
            m_fCurrentDirectory = fc.getCurrentDirectory();
        }
    }

    private static class ExtensionsFilter
    extends FileFilter {
        private String message;
        private String[] extensions;

        public ExtensionsFilter(String message, String ... extensions) {
            this.message = message;
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String sFileName = f.getName();
            int ipos = sFileName.lastIndexOf(46);
            if (ipos >= 0) {
                String sExt = sFileName.substring(ipos + 1);
                for (String s : this.extensions) {
                    if (!s.equalsIgnoreCase(sExt)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.message;
        }
    }
}

