/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorCurrencyPositive;
import com.posics.editor.JEditorKeys;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.customers.JCustomerFinder;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.util.RoundUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JPaymentAdvance
extends JPanel
implements JPaymentInterface {
    private JPaymentNotifier notifier;
    private CustomerInfoExt customerext;
    private DataLogicCustomers dlcustomers;
    private DataLogicSales dlsales;
    private double m_dPaid;
    private double m_dTotal;
    private AppView app;
    private JButton btnCustomer;
    private JLabel jLabel12;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTextArea jlblMessage;
    private JEditorKeys m_jKeys;
    private JLabel m_jMoneyEuros;
    private JTextField m_jName;
    private JTextArea m_jNotes;
    private JEditorCurrencyPositive m_jTendered;
    private JTextField txtAdvance;
    private JTextField txtAdvanceDate;

    public JPaymentAdvance(JPaymentNotifier notifier, AppView app) {
        this.notifier = notifier;
        this.app = app;
        this.dlcustomers = (DataLogicCustomers)app.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.dlsales = (DataLogicSales)app.getBean("com.posics.pos.forms.DataLogicSales");
        this.initComponents();
        this.m_jTendered.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jTendered.addEditorKeys(this.m_jKeys);
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        this.customerext = customerext;
        this.m_dTotal = dTotal;
        this.m_jTendered.reset();
        if (customerext == null) {
            this.m_jName.setText(null);
            this.m_jNotes.setText(null);
            this.txtAdvance.setText(null);
            this.txtAdvanceDate.setText(null);
            this.txtAdvance.setText(null);
            this.m_jKeys.setEnabled(false);
            this.m_jTendered.setEnabled(false);
        } else {
            this.m_jName.setText(customerext.getName());
            this.m_jNotes.setText(customerext.getNotes());
            if (customerext.getCurAdvance() != null) {
                this.txtAdvance.setText(Formats.CURRENCY.formatValue(RoundUtils.getValue(Math.abs(customerext.getCurAdvance()))));
            } else {
                this.txtAdvance.setText(null);
            }
            this.txtAdvanceDate.setText(Formats.DATE.formatValue(customerext.getAdvanceDate()));
            if (customerext.getCurAdvance() != null && Math.abs(customerext.getCurAdvance()) > 0.0) {
                this.m_jKeys.setEnabled(true);
                this.m_jTendered.setEnabled(true);
                this.m_jTendered.activate();
            } else {
                this.m_jKeys.setEnabled(false);
                this.m_jTendered.setEnabled(false);
            }
        }
        this.printState();
    }

    @Override
    public PaymentInfo executePayment() {
        return new PaymentInfoTicket(this.m_dPaid, "advance");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void printState() {
        if (this.customerext == null) {
            this.m_jMoneyEuros.setText(null);
            this.jlblMessage.setText(AppLocal.getIntString("message.nocustomernoadvance"));
            this.notifier.setStatus(false, false);
        } else {
            Double value = this.m_jTendered.getDoubleValue();
            this.m_dPaid = value == null || value == 0.0 ? this.m_dTotal : value;
            this.m_jMoneyEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dPaid)));
            if (this.customerext.getCurAdvance() == null || Math.abs(this.customerext.getCurAdvance()) < this.m_dPaid) {
                this.jlblMessage.setText(AppLocal.getIntString("message.customeradvancelow"));
                this.notifier.setStatus(false, false);
            } else {
                this.jlblMessage.setText(null);
                int iCompare = RoundUtils.compare(this.m_dPaid, this.m_dTotal);
                this.notifier.setStatus(this.m_dPaid > 0.0 && iCompare <= 0, iCompare == 0);
            }
        }
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.m_jMoneyEuros = new JLabel();
        this.jLabel3 = new JLabel();
        this.m_jName = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txtAdvance = new JTextField();
        this.jLabel6 = new JLabel();
        this.txtAdvanceDate = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.m_jNotes = new JTextArea();
        this.btnCustomer = new JButton();
        this.jPanel6 = new JPanel();
        this.jlblMessage = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel3 = new JPanel();
        this.m_jTendered = new JEditorCurrencyPositive();
        this.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel4.setLayout(null);
        this.jLabel8.setText(AppLocal.getIntString("label.advance"));
        this.jPanel4.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 100, 14);
        this.m_jMoneyEuros.setBackground(new Color(153, 153, 255));
        this.m_jMoneyEuros.setHorizontalAlignment(4);
        this.m_jMoneyEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyEuros.setOpaque(true);
        this.m_jMoneyEuros.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyEuros);
        this.m_jMoneyEuros.setBounds(120, 20, 150, 25);
        this.jLabel3.setText(AppLocal.getIntString("label.name"));
        this.jPanel4.add(this.jLabel3);
        this.jLabel3.setBounds(20, 70, 100, 14);
        this.m_jName.setEditable(false);
        this.jPanel4.add(this.m_jName);
        this.m_jName.setBounds(120, 70, 150, 20);
        this.jLabel12.setText(AppLocal.getIntString("label.notes"));
        this.jPanel4.add(this.jLabel12);
        this.jLabel12.setBounds(20, 100, 100, 14);
        this.jLabel4.setText(AppLocal.getIntString("label.advancepaid"));
        this.jPanel4.add(this.jLabel4);
        this.jLabel4.setBounds(20, 180, 100, 14);
        this.txtAdvance.setEditable(false);
        this.txtAdvance.setHorizontalAlignment(4);
        this.jPanel4.add(this.txtAdvance);
        this.txtAdvance.setBounds(120, 180, 130, 20);
        this.jLabel6.setText(AppLocal.getIntString("label.advancedate"));
        this.jPanel4.add(this.jLabel6);
        this.jLabel6.setBounds(20, 210, 100, 14);
        this.txtAdvanceDate.setEditable(false);
        this.txtAdvanceDate.setHorizontalAlignment(0);
        this.jPanel4.add(this.txtAdvanceDate);
        this.txtAdvanceDate.setBounds(120, 210, 130, 20);
        this.m_jNotes.setEditable(false);
        this.jScrollPane1.setViewportView(this.m_jNotes);
        this.jPanel4.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(120, 100, 150, 70);
        this.btnCustomer.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/kuser.png")));
        this.btnCustomer.setFocusPainted(false);
        this.btnCustomer.setFocusable(false);
        this.btnCustomer.setMargin(new Insets(8, 14, 8, 14));
        this.btnCustomer.setRequestFocusEnabled(false);
        this.btnCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPaymentAdvance.this.btnCustomerActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnCustomer);
        this.btnCustomer.setBounds(270, 60, 48, 36);
        this.jPanel5.add((Component)this.jPanel4, "Center");
        this.jlblMessage.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.jlblMessage.setEditable(false);
        this.jlblMessage.setLineWrap(true);
        this.jlblMessage.setWrapStyleWord(true);
        this.jlblMessage.setFocusable(false);
        this.jlblMessage.setPreferredSize(new Dimension(300, 72));
        this.jlblMessage.setRequestFocusEnabled(false);
        this.jPanel6.add(this.jlblMessage);
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.add((Component)this.jPanel5, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.add(this.m_jKeys);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.m_jTendered, "Center");
        this.jPanel1.add(this.jPanel3);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.add((Component)this.jPanel2, "East");
    }

    private void btnCustomerActionPerformed(ActionEvent evt) {
        JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlcustomers);
        finder.search(null);
        finder.setVisible(true);
        CustomerInfo customer = finder.getSelectedCustomer();
        if (customer != null) {
            try {
                this.customerext = this.dlsales.loadCustomerExt(customer.getId());
                this.notifier.setCustomer(this.customerext);
                if (this.customerext == null) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"));
                    msg.show(this);
                } else {
                    this.editCustomer(this.customerext);
                }
            }
            catch (BasicException ex) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), ex);
                msg.show(this);
            }
        }
    }

    private void editCustomer(CustomerInfoExt customer) {
        this.customerext = customer;
        this.m_jName.setText(this.customerext.getName());
        this.m_jNotes.setText(this.customerext.getNotes());
        if (this.customerext.getCurAdvance() != null) {
            this.txtAdvance.setText(Formats.CURRENCY.formatValue(Math.abs(this.customerext.getCurAdvance())));
        } else {
            this.txtAdvance.setText(null);
        }
        this.txtAdvanceDate.setText(Formats.DATE.formatValue(this.customerext.getAdvanceDate()));
        this.m_jNotes.setEnabled(true);
        if (this.customerext.getCurAdvance() < 0.0) {
            this.m_jKeys.setEnabled(true);
            this.m_jTendered.setEnabled(true);
            this.m_jTendered.activate();
            this.notifier.setStatus(true, true);
        } else {
            this.m_jKeys.setEnabled(false);
            this.m_jTendered.setEnabled(false);
            this.notifier.setStatus(false, false);
        }
        this.printState();
    }

    private class RecalculateState
    implements PropertyChangeListener {
        private RecalculateState() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPaymentAdvance.this.printState();
        }
    }
}

