/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorCurrencyPositive;
import com.posics.editor.JEditorKeys;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoCash;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.RoundUtils;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JPaymentCashPos
extends JPanel
implements JPaymentInterface {
    private JPaymentNotifier m_notifier;
    private double m_dPaid;
    private double m_dTotal;
    private String m_sService;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JLabel m_jChangeEuros;
    private JEditorKeys m_jKeys;
    private JLabel m_jMoneyEuros;
    private JEditorCurrencyPositive m_jTendered;

    public JPaymentCashPos(JPaymentNotifier notifier, DataLogicSystem dlSystem, String sService) {
        this.m_notifier = notifier;
        this.m_sService = sService;
        this.initComponents();
        this.m_jTendered.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jTendered.addEditorKeys(this.m_jKeys);
        String code = dlSystem.getResourceAsXML("payment.cash");
        if (code != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
                script.put("payment", new ScriptPaymentCash(dlSystem));
                script.eval(code);
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), e);
                msg.show(this);
            }
        }
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        this.m_dTotal = dTotal;
        this.m_jTendered.reset();
        this.m_jTendered.activate();
        this.printState();
    }

    @Override
    public PaymentInfo executePayment() {
        if (this.m_dPaid - this.m_dTotal >= 0.0) {
            return new PaymentInfoCash(this.m_dTotal, this.m_dPaid, this.m_sService);
        }
        return new PaymentInfoCash(this.m_dPaid, this.m_dPaid, this.m_sService);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void printState() {
        Double value = this.m_jTendered.getDoubleValue();
        this.m_dPaid = value == null || value == 0.0 ? this.m_dTotal : value;
        int iCompare = RoundUtils.compare(this.m_dPaid, this.m_dTotal);
        this.m_jMoneyEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dPaid)));
        this.m_jChangeEuros.setText(iCompare > 0 ? Formats.CURRENCY.formatValue(new Double(this.m_dPaid - this.m_dTotal)) : null);
        this.m_notifier.setStatus(this.m_dPaid > 0.0, iCompare >= 0);
        super.repaint();
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jChangeEuros = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.m_jMoneyEuros = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel3 = new JPanel();
        this.m_jTendered = new JEditorCurrencyPositive();
        this.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(0, 100));
        this.jPanel4.setLayout(null);
        this.m_jChangeEuros.setBackground(new Color(153, 153, 255));
        this.m_jChangeEuros.setForeground(new Color(255, 255, 255));
        this.m_jChangeEuros.setHorizontalAlignment(4);
        this.m_jChangeEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jChangeEuros.setOpaque(true);
        this.m_jChangeEuros.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jChangeEuros);
        this.m_jChangeEuros.setBounds(120, 50, 150, 25);
        this.jLabel6.setText(AppLocal.getIntString("Label.ChangeCash"));
        this.jPanel4.add(this.jLabel6);
        this.jLabel6.setBounds(20, 50, 100, 14);
        this.jLabel8.setText(AppLocal.getIntString("Label.InputCash"));
        this.jPanel4.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 100, 14);
        this.m_jMoneyEuros.setBackground(new Color(153, 153, 255));
        this.m_jMoneyEuros.setForeground(new Color(255, 255, 255));
        this.m_jMoneyEuros.setHorizontalAlignment(4);
        this.m_jMoneyEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyEuros.setOpaque(true);
        this.m_jMoneyEuros.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyEuros);
        this.m_jMoneyEuros.setBounds(120, 20, 150, 25);
        this.jPanel5.add((Component)this.jPanel4, "North");
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jPanel5.add((Component)this.jPanel6, "Center");
        this.add((Component)this.jPanel5, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.add(this.m_jKeys);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.m_jTendered, "Center");
        this.jPanel1.add(this.jPanel3);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.add((Component)this.jPanel2, "After");
    }

    private class AddAmount
    implements ActionListener {
        private double amount;

        public AddAmount(double amount) {
            this.amount = amount;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Double tendered = JPaymentCashPos.this.m_jTendered.getDoubleValue();
            if (tendered == null) {
                JPaymentCashPos.this.m_jTendered.setDoubleValue(this.amount);
            } else {
                JPaymentCashPos.this.m_jTendered.setDoubleValue(tendered + this.amount);
            }
            JPaymentCashPos.this.printState();
        }
    }

    public class ScriptPaymentCash {
        private DataLogicSystem dlSystem;
        private ThumbNailBuilder tnbbutton;

        public ScriptPaymentCash(DataLogicSystem dlSystem) {
            this.dlSystem = dlSystem;
            this.tnbbutton = new ThumbNailBuilder(64, 54, dlSystem.getResourceAsImage("/com/posics/pos/templates/payment.icon.cash.png"));
        }

        public void addButton(String image, double amount) {
            JButton btn = new JButton();
            btn.setIcon(new ImageIcon(this.tnbbutton.getThumbNailText(this.dlSystem.getResourceAsImage(image), Formats.CURRENCY.formatValue(amount))));
            btn.setFocusPainted(false);
            btn.setFocusable(false);
            btn.setRequestFocusEnabled(false);
            btn.setHorizontalTextPosition(0);
            btn.setVerticalTextPosition(3);
            btn.setMargin(new Insets(2, 2, 2, 2));
            btn.addActionListener(new AddAmount(amount));
            JPaymentCashPos.this.jPanel6.add(btn);
        }
    }

    private class RecalculateState
    implements PropertyChangeListener {
        private RecalculateState() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPaymentCashPos.this.printState();
        }
    }
}

