/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.basic.BasicException;
import com.posics.beans.JCalendarDialog;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.loader.SentenceList;
import com.posics.editor.JEditorCurrencyPositive;
import com.posics.editor.JEditorKeys;
import com.posics.editor.JEditorStringNumber;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.util.RoundUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JPaymentCheque
extends JPanel
implements JPaymentInterface {
    private JPaymentNotifier m_notifier;
    private double m_dPaid;
    private double m_dTotal;
    private ComboBoxValModel m_BankModel;
    private SentenceList m_sentbank;
    private DataLogicSales m_dlSales;
    private double m_dPaymentTitle;
    private JComboBox jBankNameCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField m_jChequeDate;
    private JEditorStringNumber m_jChequeNumberBox;
    private JEditorKeys m_jKeys;
    private JLabel m_jMoneyEuros;
    private JEditorCurrencyPositive m_jTendered;
    private JButton m_jbtndate;

    public JPaymentCheque(JPaymentNotifier notifier, DataLogicSales dlSales) {
        this.m_notifier = notifier;
        this.initComponents();
        this.m_jTendered.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jTendered.addEditorKeys(this.m_jKeys);
        this.m_jChequeNumberBox.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jChequeNumberBox.addEditorKeys(this.m_jKeys);
        DataLogicSales m_dlSales = null;
        m_dlSales = dlSales;
        this.m_sentbank = m_dlSales.getBanksList();
        this.m_BankModel = new ComboBoxValModel();
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        this.m_dTotal = dTotal;
        this.m_jTendered.reset();
        this.m_jTendered.activate();
        this.m_jChequeNumberBox.reset();
        try {
            this.m_BankModel = new ComboBoxValModel(this.m_sentbank.list());
            this.jBankNameCombo.setModel(this.m_BankModel);
        }
        catch (BasicException basicException) {
            // empty catch block
        }
        this.printState();
    }

    @Override
    public PaymentInfo executePayment() {
        return new PaymentInfoTicket(this.m_jChequeDate.getText(), this.jBankNameCombo.getSelectedItem(), this.m_jChequeNumberBox.getText(), this.m_dPaid, "cheque");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void printState() {
        Double value = this.m_jTendered.getDoubleValue();
        this.m_dPaid = value == null ? this.m_dTotal : value;
        this.m_jMoneyEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dPaid)));
        int iCompare = RoundUtils.compare(this.m_dPaid, this.m_dTotal);
        this.m_notifier.setStatus(this.m_dPaid > 0.0 && iCompare <= 0, iCompare == 0);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel3 = new JPanel();
        this.m_jTendered = new JEditorCurrencyPositive();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.m_jMoneyEuros = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jBankNameCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.m_jChequeDate = new JTextField();
        this.m_jbtndate = new JButton();
        this.m_jChequeNumberBox = new JEditorStringNumber();
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.add(this.m_jKeys);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.m_jTendered, "Center");
        this.jPanel1.add(this.jPanel3);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.add((Component)this.jPanel2, "East");
        this.jPanel4.setLayout(null);
        this.jLabel8.setText(AppLocal.getIntString("Label.InputCash"));
        this.jPanel4.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 100, 14);
        this.m_jMoneyEuros.setBackground(new Color(153, 153, 255));
        this.m_jMoneyEuros.setHorizontalAlignment(4);
        this.m_jMoneyEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyEuros.setOpaque(true);
        this.m_jMoneyEuros.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyEuros);
        this.m_jMoneyEuros.setBounds(120, 20, 150, 25);
        this.jLabel1.setText(AppLocal.getIntString("label.chequenumber"));
        this.jPanel4.add(this.jLabel1);
        this.jLabel1.setBounds(20, 50, 90, 25);
        this.jLabel2.setText(AppLocal.getIntString("label.bankname"));
        this.jPanel4.add(this.jLabel2);
        this.jLabel2.setBounds(20, 80, 90, 25);
        this.jPanel4.add(this.jBankNameCombo);
        this.jBankNameCombo.setBounds(120, 80, 150, 25);
        this.jLabel3.setText(AppLocal.getIntString("label.chequedate"));
        this.jPanel4.add(this.jLabel3);
        this.jLabel3.setBounds(20, 110, 90, 25);
        this.jPanel4.add(this.m_jChequeDate);
        this.m_jChequeDate.setBounds(120, 110, 100, 25);
        this.m_jbtndate.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/1day.png")));
        this.m_jbtndate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPaymentCheque.this.m_jbtndateActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.m_jbtndate);
        this.m_jbtndate.setBounds(230, 110, 40, 25);
        this.jPanel4.add(this.m_jChequeNumberBox);
        this.m_jChequeNumberBox.setBounds(120, 50, 180, 25);
        this.add((Component)this.jPanel4, "Center");
    }

    private void m_jbtndateActionPerformed(ActionEvent evt) {
        Date date;
        try {
            date = (Date)Formats.DATE.parseValue(this.m_jChequeDate.getText());
        }
        catch (BasicException e) {
            date = null;
        }
        date = JCalendarDialog.showCalendarTime(this, date);
        if (date != null) {
            this.m_jChequeDate.setText(Formats.DATE.formatValue(date));
        }
    }

    private class RecalculateState
    implements PropertyChangeListener {
        private RecalculateState() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPaymentCheque.this.printState();
        }
    }
}

