/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorCurrencyPositive;
import com.posics.editor.JEditorKeys;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoCurrency;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.RoundUtils;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JPaymentCurrency
extends JPanel
implements JPaymentInterface {
    private JPaymentNotifier m_notifier;
    private double m_dTicket;
    private double m_dPaid;
    private double m_dPaidCurrency;
    private double m_dTotal;
    private double m_dTotalCurrency;
    private double m_dTendered;
    private double m_dRate;
    private String m_sCurrency;
    private String m_sPaymentTitle;
    private HashMap<String, Integer> m_denomination;
    private JPanel jButtons;
    private JLabel jLabel10;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JLabel m_jChangeCash;
    private JLabel m_jChangeCurrency;
    private JEditorKeys m_jKeys;
    private JLabel m_jMoneyCash;
    private JLabel m_jMoneyCurrency;
    private JLabel m_jMoneyRate;
    private JEditorCurrencyPositive m_jTendered;

    public JPaymentCurrency(JPaymentNotifier notifier, String sPaper, String sTitle, DataLogicSystem dlSystem) {
        this.m_notifier = notifier;
        this.m_sCurrency = sPaper;
        this.m_sPaymentTitle = sTitle;
        this.initComponents();
        this.m_jTendered.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jTendered.addEditorKeys(this.m_jKeys);
        String code = dlSystem.getResourceAsXML("payment.currency");
        if (code != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
                script.put("currency", new ScriptPaymentCurrency(dlSystem));
                script.eval(code);
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), e);
                msg.show(this);
            }
        }
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        this.m_dTotal = dTotal;
        this.m_dTendered = 0.0;
        this.m_denomination = null;
        this.m_jTendered.reset();
        this.m_jTendered.activate();
        this.printState();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public PaymentInfo executePayment() {
        if (this.m_dPaid - this.m_dTotal >= 0.0) {
            return new PaymentInfoCurrency(this.m_dTotal, this.m_dPaid, this.m_dPaidCurrency, this.m_dRate, this.m_sCurrency);
        }
        return new PaymentInfoCurrency(this.m_dPaid, this.m_dPaid, this.m_dPaidCurrency, this.m_dRate, this.m_sCurrency);
    }

    private void printState() {
        Double value = this.m_jTendered.getDoubleValue();
        if (value == null || value == 0.0) {
            this.m_dPaid = this.m_dTotal;
            this.m_dPaidCurrency = this.m_dTotal * this.m_dRate;
        } else {
            this.m_dPaid = value / this.m_dRate;
            this.m_dPaidCurrency = value;
        }
        int iCompare = RoundUtils.compare(this.m_dPaid, this.m_dTotal);
        this.m_jMoneyCurrency.setText(Formats.CURRENCY.formatValue(new Double(this.m_dPaidCurrency)));
        this.m_jMoneyCash.setText(Formats.CURRENCY.formatValue(new Double(this.m_dPaid)));
        this.m_jChangeCurrency.setText(iCompare > 0 ? Formats.CURRENCY.formatValue(new Double(this.m_dPaidCurrency - this.m_dTotal * this.m_dRate)) : null);
        this.m_jChangeCash.setText(iCompare > 0 ? Formats.CURRENCY.formatValue(new Double(this.m_dPaid - this.m_dTotal)) : null);
        this.m_notifier.setStatus(this.m_dPaid > 0.0, iCompare >= 0);
        super.repaint();
    }

    private void SetRate(String currency, double rate) {
        this.m_sCurrency = currency;
        this.m_dRate = rate;
        this.m_dTotalCurrency = this.m_dTotal * this.m_dRate;
        this.m_jMoneyRate.setText(Formats.CURRENCY.formatValue(new Double(rate)));
    }

    private void initComponents() {
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel1 = new JPanel();
        this.m_jTendered = new JEditorCurrencyPositive();
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.m_jMoneyCurrency = new JLabel();
        this.jLabel6 = new JLabel();
        this.m_jMoneyRate = new JLabel();
        this.jLabel7 = new JLabel();
        this.m_jChangeCurrency = new JLabel();
        this.jLabel9 = new JLabel();
        this.m_jChangeCash = new JLabel();
        this.jLabel10 = new JLabel();
        this.m_jMoneyCash = new JLabel();
        this.jButtons = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel12.setLayout(new BoxLayout(this.jPanel12, 1));
        this.jPanel12.add(this.m_jKeys);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.m_jTendered, "Center");
        this.jPanel12.add(this.jPanel1);
        this.jPanel11.add((Component)this.jPanel12, "North");
        this.add((Component)this.jPanel11, "East");
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(0, 150));
        this.jPanel4.setLayout(null);
        this.jLabel8.setText(AppLocal.getIntString("Label.InputCash"));
        this.jPanel4.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 100, 14);
        this.m_jMoneyCurrency.setBackground(new Color(153, 153, 255));
        this.m_jMoneyCurrency.setHorizontalAlignment(4);
        this.m_jMoneyCurrency.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyCurrency.setOpaque(true);
        this.m_jMoneyCurrency.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyCurrency);
        this.m_jMoneyCurrency.setBounds(120, 20, 150, 25);
        this.jLabel6.setText(AppLocal.getIntString("Label.Cash"));
        this.jPanel4.add(this.jLabel6);
        this.jLabel6.setBounds(20, 50, 100, 14);
        this.m_jMoneyRate.setHorizontalAlignment(4);
        this.m_jMoneyRate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyRate.setOpaque(true);
        this.m_jMoneyRate.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyRate);
        this.m_jMoneyRate.setBounds(220, 50, 50, 25);
        this.jLabel7.setText(AppLocal.getIntString("Label.ChangeCash"));
        this.jPanel4.add(this.jLabel7);
        this.jLabel7.setBounds(20, 80, 100, 14);
        this.m_jChangeCurrency.setHorizontalAlignment(4);
        this.m_jChangeCurrency.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jChangeCurrency.setOpaque(true);
        this.m_jChangeCurrency.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jChangeCurrency);
        this.m_jChangeCurrency.setBounds(200, 80, 70, 25);
        this.jLabel9.setText(AppLocal.getIntString("label.currency"));
        this.jPanel4.add(this.jLabel9);
        this.jLabel9.setBounds(200, 110, 70, 14);
        this.m_jChangeCash.setHorizontalAlignment(4);
        this.m_jChangeCash.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jChangeCash.setOpaque(true);
        this.m_jChangeCash.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jChangeCash);
        this.m_jChangeCash.setBounds(120, 80, 70, 25);
        this.jLabel10.setText(AppLocal.getIntString("Label.Cash"));
        this.jPanel4.add(this.jLabel10);
        this.jLabel10.setBounds(120, 110, 70, 14);
        this.m_jMoneyCash.setHorizontalAlignment(4);
        this.m_jMoneyCash.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyCash.setOpaque(true);
        this.m_jMoneyCash.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyCash);
        this.m_jMoneyCash.setBounds(120, 50, 90, 25);
        this.jPanel5.add((Component)this.jPanel4, "North");
        this.jPanel5.add((Component)this.jButtons, "Center");
        this.add((Component)this.jPanel5, "Center");
    }

    private class AddAmount
    implements ActionListener {
        private double amount;

        public AddAmount(double amount) {
            this.amount = amount;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Double tendered = JPaymentCurrency.this.m_jTendered.getDoubleValue();
            if (tendered == null) {
                JPaymentCurrency.this.m_jTendered.setDoubleValue(this.amount);
            } else {
                JPaymentCurrency.this.m_jTendered.setDoubleValue(tendered + this.amount);
            }
            JPaymentCurrency.this.printState();
        }
    }

    public class ScriptPaymentCurrency {
        private DataLogicSystem dlSystem;
        private ThumbNailBuilder tnbbutton;

        public ScriptPaymentCurrency(DataLogicSystem dlSystem) {
            this.dlSystem = dlSystem;
            this.tnbbutton = new ThumbNailBuilder(64, 54, dlSystem.getResourceAsImage("/com/posics/pos/templates/payment.icon.currency.png"));
        }

        public void setRate(String currency, double rate) {
            if (currency.equals(JPaymentCurrency.this.m_sPaymentTitle)) {
                JPaymentCurrency.this.SetRate(currency, rate);
            }
        }

        public void addButton(String currency, String image, double amount) {
            if (currency.equals(JPaymentCurrency.this.m_sPaymentTitle)) {
                JButton btn = new JButton();
                btn.setIcon(new ImageIcon(this.tnbbutton.getThumbNailText(this.dlSystem.getResourceAsImage(image), Formats.CURRENCY.formatValue(amount))));
                btn.setFocusPainted(false);
                btn.setFocusable(false);
                btn.setRequestFocusEnabled(false);
                btn.setHorizontalTextPosition(0);
                btn.setVerticalTextPosition(3);
                btn.setMargin(new Insets(2, 2, 2, 2));
                btn.addActionListener(new AddAmount(amount));
                JPaymentCurrency.this.jButtons.add(btn);
            }
        }
    }

    private class RecalculateState
    implements PropertyChangeListener {
        private RecalculateState() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPaymentCurrency.this.printState();
        }
    }
}

