/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentGateway;
import com.posics.pos.payment.PaymentGatewayFac;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.payment.PaymentPanel;
import com.posics.pos.payment.PaymentPanelFac;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class JPaymentMagcard
extends JPanel
implements JPaymentInterface {
    private PaymentPanel m_cardpanel;
    private PaymentGateway m_paymentgateway;
    private JPaymentNotifier m_notifier;
    private String transaction;
    private JPanel jPanel1;
    private JTextArea jlblMessage;

    public JPaymentMagcard(AppView app, JPaymentNotifier notifier) {
        this.initComponents();
        this.m_notifier = notifier;
        this.m_paymentgateway = PaymentGatewayFac.getPaymentGateway(app.getProperties());
        if (this.m_paymentgateway == null) {
            this.jlblMessage.setText(AppLocal.getIntString("message.nopaymentgateway"));
        } else {
            this.m_cardpanel = PaymentPanelFac.getPaymentPanel(app.getProperties().getProperty("payment.magcardreader"), notifier, app);
            this.add((Component)this.m_cardpanel.getComponent(), "Center");
            this.jlblMessage.setText(null);
        }
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        this.transaction = transID;
        if (this.m_cardpanel == null) {
            this.jlblMessage.setText(AppLocal.getIntString("message.nopaymentgateway"));
            this.m_notifier.setStatus(false, false);
        } else {
            this.jlblMessage.setText(null);
            this.m_cardpanel.activate(this.transaction, dTotal);
        }
    }

    @Override
    public PaymentInfo executePayment() {
        this.jlblMessage.setText(null);
        PaymentInfoMagcard payinfo = this.m_cardpanel.getPaymentInfoMagcard();
        this.m_paymentgateway.execute(payinfo);
        if (payinfo.isPaymentOK()) {
            return payinfo;
        }
        this.jlblMessage.setText(payinfo.getMessage());
        return null;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void setTransaction(String transid) {
        this.transaction = transid;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jlblMessage = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jlblMessage.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.jlblMessage.setEditable(false);
        this.jlblMessage.setLineWrap(true);
        this.jlblMessage.setWrapStyleWord(true);
        this.jlblMessage.setFocusable(false);
        this.jlblMessage.setPreferredSize(new Dimension(300, 72));
        this.jlblMessage.setRequestFocusEnabled(false);
        this.jPanel1.add(this.jlblMessage);
        this.add((Component)this.jPanel1, "South");
    }
}

