/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorCurrencyPositive;
import com.posics.editor.JEditorKeys;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.RoundUtils;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JPaymentPaper
extends JPanel
implements JPaymentInterface {
    private JPaymentNotifier m_notifier;
    private double m_dTicket;
    private double m_dTotal;
    private double m_dTendered;
    private String m_sPaper;
    private String m_sPaymentTitle;
    private HashMap<String, Integer> m_denomination;
    private JPanel jButtons;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JEditorKeys m_jKeys;
    private JLabel m_jMoneyEuros;
    private JEditorCurrencyPositive m_jTendered;

    public JPaymentPaper(JPaymentNotifier notifier, String sPaper, String sTitle, DataLogicSystem dlSystem) {
        this.m_notifier = notifier;
        this.m_sPaper = sPaper;
        this.m_sPaymentTitle = sTitle;
        this.initComponents();
        this.m_jTendered.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jTendered.addEditorKeys(this.m_jKeys);
        String code = dlSystem.getResourceAsXML("payment.voucher");
        if (code != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
                script.put("paperin", new ScriptPaymentPaper(dlSystem));
                script.eval(code);
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), e);
                msg.show(this);
            }
        }
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        this.m_dTotal = dTotal;
        this.m_dTendered = 0.0;
        this.m_denomination = null;
        this.m_jTendered.reset();
        this.m_jTendered.activate();
        this.printState();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public PaymentInfo executePayment() {
        if (this.m_denomination == null) {
            this.m_denomination = new HashMap();
            if (this.m_jTendered.getDoubleValue() == null) {
                this.m_denomination.put(this.m_sPaymentTitle + "##" + this.m_dTotal, 1);
            } else {
                this.m_denomination.put(this.m_sPaymentTitle + "##" + this.m_jTendered.getDoubleValue(), 1);
            }
        }
        return new PaymentInfoTicket(this.m_dTicket, this.m_sPaper, this.m_denomination);
    }

    private void printState() {
        Double value = this.m_jTendered.getDoubleValue();
        this.m_dTicket = this.m_dTendered == 0.0 && value == null ? 0.0 : (this.m_dTendered > 0.0 ? this.m_dTendered : value);
        this.m_jMoneyEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dTicket)));
        int iCompare = RoundUtils.compare(this.m_dTicket, this.m_dTotal);
        this.m_notifier.setStatus(this.m_dTicket > 0.0, iCompare >= 0);
    }

    private void initComponents() {
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel1 = new JPanel();
        this.m_jTendered = new JEditorCurrencyPositive();
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.m_jMoneyEuros = new JLabel();
        this.jButtons = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel12.setLayout(new BoxLayout(this.jPanel12, 1));
        this.jPanel12.add(this.m_jKeys);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.m_jTendered, "Center");
        this.jPanel12.add(this.jPanel1);
        this.jPanel11.add((Component)this.jPanel12, "North");
        this.add((Component)this.jPanel11, "East");
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(0, 100));
        this.jPanel4.setLayout(null);
        this.jLabel8.setText(AppLocal.getIntString("Label.InputCash"));
        this.jPanel4.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 100, 14);
        this.m_jMoneyEuros.setBackground(new Color(153, 153, 255));
        this.m_jMoneyEuros.setHorizontalAlignment(4);
        this.m_jMoneyEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyEuros.setOpaque(true);
        this.m_jMoneyEuros.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyEuros);
        this.m_jMoneyEuros.setBounds(120, 20, 150, 25);
        this.jPanel5.add((Component)this.jPanel4, "North");
        this.jPanel5.add((Component)this.jButtons, "Center");
        this.add((Component)this.jPanel5, "Center");
    }

    private class AddAmount
    implements ActionListener {
        private String voucherName;
        private double amount;

        public AddAmount(String voucherName, double amount) {
            this.voucherName = voucherName;
            this.amount = amount;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Double tendered = 0.0;
            Integer count = 0;
            if (JPaymentPaper.this.m_jTendered.getText().length() > 0) {
                count = Integer.parseInt(JPaymentPaper.this.m_jTendered.getText());
                tendered = this.amount * (double)count.intValue();
            } else {
                tendered = this.amount;
                count = 1;
            }
            String voucher = this.voucherName + "##" + this.amount;
            if (JPaymentPaper.this.m_denomination == null) {
                JPaymentPaper.this.m_denomination = new HashMap();
                JPaymentPaper.this.m_denomination.put(voucher, count);
            } else if (JPaymentPaper.this.m_denomination.get(voucher) == null) {
                JPaymentPaper.this.m_denomination.put(voucher, count);
            } else {
                JPaymentPaper.this.m_denomination.put(voucher, (Integer)JPaymentPaper.this.m_denomination.get(voucher) + count);
            }
            JPaymentPaper.this.m_jTendered.reset();
            JPaymentPaper.this.m_dTendered = JPaymentPaper.this.m_dTendered + tendered;
            JPaymentPaper.this.printState();
        }
    }

    public class ScriptPaymentPaper {
        private DataLogicSystem dlSystem;
        private ThumbNailBuilder tnbbutton;

        public ScriptPaymentPaper(DataLogicSystem dlSystem) {
            this.dlSystem = dlSystem;
            this.tnbbutton = new ThumbNailBuilder(64, 54, dlSystem.getResourceAsImage("/com/posics/pos/templates/payment.icon.voucher.png"));
        }

        public void addButton(String voucherName, String image, double amount) {
            if (voucherName.equals(JPaymentPaper.this.m_sPaymentTitle)) {
                JButton btn = new JButton();
                btn.setIcon(new ImageIcon(this.tnbbutton.getThumbNailText(this.dlSystem.getResourceAsImage(image), Formats.CURRENCY.formatValue(amount))));
                btn.setFocusPainted(false);
                btn.setFocusable(false);
                btn.setRequestFocusEnabled(false);
                btn.setHorizontalTextPosition(0);
                btn.setVerticalTextPosition(3);
                btn.setMargin(new Insets(2, 2, 2, 2));
                btn.addActionListener(new AddAmount(voucherName, amount));
                JPaymentPaper.this.jButtons.add(btn);
            }
        }
    }

    private class RecalculateState
    implements PropertyChangeListener {
        private RecalculateState() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPaymentPaper.this.printState();
        }
    }
}

