/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorCurrencyPositive;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.util.RoundUtils;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JPaymentPoints
extends JPanel
implements JPaymentInterface {
    private JPaymentNotifier m_notifier;
    private CustomerInfoExt customerext;
    private double m_dTicket;
    private double m_dTotal;
    private String m_sPaper;
    private HashMap<String, Integer> m_denomination;
    private double minPurAmount = 0.0;
    private double minPoints = 0.0;
    private double slabAmount = 0.0;
    private double topupPoints = 0.0;
    private double usedPoints = 0.0;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JLabel m_jMoneyEuros;
    private JTextField m_jName;
    private JEditorCurrencyPositive m_jTendered;
    private JTextField txtPoints;
    private JTextField txtPointsEarned;

    public JPaymentPoints(JPaymentNotifier notifier, String sPaper, DataLogicSystem dlSystem) {
        this.m_notifier = notifier;
        this.m_sPaper = sPaper;
        this.initComponents();
        this.m_jTendered.addPropertyChangeListener("Edition", new RecalculateState());
        this.m_jTendered.setVisible(false);
        String code = dlSystem.getResourceAsXML("payment.points");
        if (code != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
                script.put("pointsin", new ScriptPaymentPoints(dlSystem));
                script.eval(code);
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), e);
                msg.show(this);
            }
        }
    }

    @Override
    public void activate(CustomerInfoExt customerext, double dTotal, String transID) {
        int i;
        this.customerext = customerext;
        this.m_dTotal = dTotal;
        this.m_jTendered.reset();
        double points = 0.0;
        if (this.m_dTotal >= this.minPurAmount) {
            points = this.minPoints;
        }
        if (this.m_dTotal - this.minPurAmount >= this.slabAmount) {
            int result = (int)((this.m_dTotal - this.minPurAmount) / this.slabAmount);
            points += (double)result * this.topupPoints;
        }
        if (customerext == null) {
            this.m_jName.setText(null);
            this.txtPoints.setText(null);
            this.txtPointsEarned.setText(Double.toString(points));
            for (i = 0; i < this.jPanel6.getComponentCount(); ++i) {
                Component ctl = this.jPanel6.getComponent(i);
                ctl.setEnabled(false);
            }
        } else {
            customerext.setPointsEarned(points);
            this.m_jName.setText(customerext.getName());
            this.txtPoints.setText(Formats.CURRENCY.formatValue(RoundUtils.getValue(customerext.getPoints() - this.usedPoints)));
            this.txtPointsEarned.setText(Formats.CURRENCY.formatValue(RoundUtils.getValue(customerext.getPointsEarned())));
            for (i = 0; i < this.jPanel6.getComponentCount(); ++i) {
                Component ctl = this.jPanel6.getComponent(i);
                ctl.setEnabled(true);
            }
        }
        this.printState();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public PaymentInfo executePayment() {
        return new PaymentInfoTicket(this.m_dTicket, this.m_sPaper, this.m_denomination);
    }

    public void setTendered(Double tendered) {
        this.usedPoints = tendered;
        this.txtPoints.setText(Formats.CURRENCY.formatValue(RoundUtils.getValue(this.customerext.getPoints() - this.usedPoints)));
    }

    private void printState() {
        Double value = this.m_jTendered.getDoubleValue();
        this.m_dTicket = value == null ? 0.0 : value;
        this.m_jMoneyEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dTicket)));
        int iCompare = RoundUtils.compare(this.m_dTicket, this.m_dTotal);
        this.m_notifier.setStatus(this.m_dTicket > 0.0, iCompare >= 0);
    }

    private void SetValues(double minPurAmount, double minPoints, double slabAmount, double topupPoints) {
        this.minPurAmount = minPurAmount;
        this.minPoints = minPoints;
        this.slabAmount = slabAmount;
        this.topupPoints = topupPoints;
    }

    private void initComponents() {
        this.jPanel11 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.m_jMoneyEuros = new JLabel();
        this.jLabel3 = new JLabel();
        this.m_jName = new JTextField();
        this.txtPoints = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtPointsEarned = new JTextField();
        this.jPanel6 = new JPanel();
        this.m_jTendered = new JEditorCurrencyPositive();
        this.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel12.setLayout(new BoxLayout(this.jPanel12, 1));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel12.add(this.jPanel1);
        this.jPanel11.add((Component)this.jPanel12, "North");
        this.add((Component)this.jPanel11, "East");
        this.jPanel4.setLayout(null);
        this.jLabel8.setText(AppLocal.getIntString("Label.InputCash"));
        this.jPanel4.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 70, 14);
        this.m_jMoneyEuros.setBackground(new Color(153, 153, 255));
        this.m_jMoneyEuros.setHorizontalAlignment(4);
        this.m_jMoneyEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jMoneyEuros.setOpaque(true);
        this.m_jMoneyEuros.setPreferredSize(new Dimension(150, 25));
        this.jPanel4.add(this.m_jMoneyEuros);
        this.m_jMoneyEuros.setBounds(100, 20, 150, 25);
        this.jLabel3.setText(AppLocal.getIntString("label.name"));
        this.jPanel4.add(this.jLabel3);
        this.jLabel3.setBounds(20, 50, 70, 14);
        this.m_jName.setEditable(false);
        this.jPanel4.add(this.m_jName);
        this.m_jName.setBounds(100, 50, 200, 25);
        this.txtPoints.setEditable(false);
        this.txtPoints.setHorizontalAlignment(4);
        this.jPanel4.add(this.txtPoints);
        this.txtPoints.setBounds(100, 80, 130, 25);
        this.jLabel4.setText(AppLocal.getIntString("tab.points"));
        this.jPanel4.add(this.jLabel4);
        this.jLabel4.setBounds(20, 80, 70, 14);
        this.jLabel5.setText(AppLocal.getIntString("label.earned"));
        this.jPanel4.add(this.jLabel5);
        this.jLabel5.setBounds(20, 110, 70, 14);
        this.txtPointsEarned.setEditable(false);
        this.txtPointsEarned.setHorizontalAlignment(4);
        this.jPanel4.add(this.txtPointsEarned);
        this.txtPointsEarned.setBounds(100, 110, 130, 25);
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jPanel4.add(this.jPanel6);
        this.jPanel6.setBounds(0, 150, 530, 150);
        this.m_jTendered.setEnabled(false);
        this.m_jTendered.setFocusable(false);
        this.jPanel4.add(this.m_jTendered);
        this.m_jTendered.setBounds(270, 20, 132, 25);
        this.add((Component)this.jPanel4, "Center");
    }

    private class AddAmount
    implements ActionListener {
        private String voucherName;
        private double amount;

        public AddAmount(String voucherName, double amount) {
            this.voucherName = voucherName;
            this.amount = amount;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Double tendered = JPaymentPoints.this.m_jTendered.getDoubleValue();
            if (tendered == null) {
                tendered = 0.0;
            }
            if (JPaymentPoints.this.customerext.getPoints() >= this.amount + tendered + JPaymentPoints.this.usedPoints) {
                String voucher = this.voucherName + "##" + this.amount;
                if (tendered == 0.0) {
                    JPaymentPoints.this.m_denomination = new HashMap();
                    JPaymentPoints.this.m_denomination.put(voucher, 1);
                    JPaymentPoints.this.m_jTendered.setDoubleValue(this.amount);
                } else {
                    if (JPaymentPoints.this.m_denomination.get(voucher) == null) {
                        JPaymentPoints.this.m_denomination.put(voucher, 1);
                    } else {
                        JPaymentPoints.this.m_denomination.put(voucher, (Integer)JPaymentPoints.this.m_denomination.get(voucher) + 1);
                    }
                    JPaymentPoints.this.m_jTendered.setDoubleValue(tendered + this.amount);
                }
                JPaymentPoints.this.printState();
            }
        }
    }

    public class ScriptPaymentPoints {
        private DataLogicSystem dlSystem;
        private ThumbNailBuilder tnbbutton;

        public ScriptPaymentPoints(DataLogicSystem dlSystem) {
            this.dlSystem = dlSystem;
            this.tnbbutton = new ThumbNailBuilder(64, 54, dlSystem.getResourceAsImage("/com/posics/pos/templates/payment.icon.points.png"));
        }

        public void setValues(double minPurAmount, double minPoints, double slabAmount, double topupPoints) {
            JPaymentPoints.this.SetValues(minPurAmount, minPoints, slabAmount, topupPoints);
        }

        public void addButton(String voucherName, String image, double amount) {
            JButton btn = new JButton();
            btn.setIcon(new ImageIcon(this.tnbbutton.getThumbNailText(this.dlSystem.getResourceAsImage(image), Formats.CURRENCY.formatValue(amount))));
            btn.setFocusPainted(false);
            btn.setFocusable(false);
            btn.setRequestFocusEnabled(false);
            btn.setHorizontalTextPosition(0);
            btn.setVerticalTextPosition(3);
            btn.setMargin(new Insets(2, 2, 2, 2));
            btn.addActionListener(new AddAmount(voucherName, amount));
            JPaymentPoints.this.jPanel6.add(btn);
        }
    }

    private class RecalculateState
    implements PropertyChangeListener {
        private RecalculateState() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPaymentPoints.this.printState();
        }
    }
}

