/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.gui.MessageInf;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.payment.JPaymentAdvance;
import com.posics.pos.payment.JPaymentCashPos;
import com.posics.pos.payment.JPaymentCheque;
import com.posics.pos.payment.JPaymentCurrency;
import com.posics.pos.payment.JPaymentDebt;
import com.posics.pos.payment.JPaymentFree;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentMagcard;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.JPaymentOnline;
import com.posics.pos.payment.JPaymentPaper;
import com.posics.pos.payment.JPaymentPoints;
import com.posics.pos.payment.JPaymentRefund;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoList;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class JPaymentSelect
extends JDialog
implements JPaymentNotifier {
    private PaymentInfoList m_aPaymentInfo;
    private boolean printselected;
    private boolean accepted;
    private AppView app;
    private double m_dTotal;
    private CustomerInfoExt customerext;
    private DataLogicSystem dlSystem;
    private DataLogicSales dlSales;
    private Map<String, JPaymentInterface> payments = new HashMap<String, JPaymentInterface>();
    private String m_sTransactionID;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JButton m_jButtonAdd;
    private JButton m_jButtonCancel;
    private JButton m_jButtonOK;
    private JToggleButton m_jButtonPrint;
    private JButton m_jButtonRemove;
    private JLabel m_jLblRemainingEuros;
    private JLabel m_jLblTotalEuros1;
    private JLabel m_jRemaininglEuros;
    private JTabbedPane m_jTabPayment;
    private JLabel m_jTotalEuros;

    protected JPaymentSelect(Frame parent, boolean modal, ComponentOrientation o) {
        super(parent, modal);
        this.initComponents();
        this.applyComponentOrientation(o);
        this.getRootPane().setDefaultButton(this.m_jButtonOK);
    }

    protected JPaymentSelect(Dialog parent, boolean modal, ComponentOrientation o) {
        super(parent, modal);
        this.initComponents();
        this.applyComponentOrientation(o);
    }

    public void init(AppView app) {
        this.app = app;
        this.dlSystem = (DataLogicSystem)app.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlSales = (DataLogicSales)app.getBean("com.posics.pos.forms.DataLogicSales");
        this.printselected = true;
        this.setLocationRelativeTo(this.getParent());
    }

    public void setPrintSelected(boolean value) {
        this.printselected = value;
    }

    public boolean isPrintSelected() {
        return this.printselected;
    }

    public List<PaymentInfo> getSelectedPayments() {
        return this.m_aPaymentInfo.getPayments();
    }

    public void addFastPayment(double total, String fastPayType) {
        this.m_aPaymentInfo = new PaymentInfoList();
        this.m_dTotal = total;
        if ("debt".equals(fastPayType)) {
            this.m_aPaymentInfo.add(new PaymentInfoTicket(total, "debt"));
        } else if ("magcard".equals(fastPayType)) {
            this.m_aPaymentInfo.add(new PaymentInfoTicket(total, "magcard"));
        } else {
            this.m_aPaymentInfo.add(this.getDefaultPayment(total));
        }
        this.accepted = true;
    }

    public boolean showDialog(double total, CustomerInfoExt customerext, String paymentFor) {
        this.m_aPaymentInfo = new PaymentInfoList();
        this.accepted = false;
        this.m_dTotal = total;
        this.customerext = customerext;
        this.m_jButtonPrint.setSelected(this.printselected);
        this.m_jTotalEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dTotal)));
        String code = paymentFor.equals("refund") ? this.dlSystem.getResourceAsXML("payment.refund.tabs") : (paymentFor.equals("customer") ? this.dlSystem.getResourceAsXML("payment.customer.tabs") : (paymentFor.equals("supplier") ? this.dlSystem.getResourceAsXML("payment.supplier.tabs") : this.dlSystem.getResourceAsXML("payment.receipt.tabs")));
        if (code != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
                script.put("payment", new ScriptPaymentTab());
                script.eval(code);
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), e);
                msg.show(this);
            }
        }
        this.setHeaderVisible(true);
        if (this.m_jTabPayment.getTabCount() == 0) {
            this.m_aPaymentInfo.add(this.getDefaultPayment(total));
            this.accepted = true;
        } else {
            this.getRootPane().setDefaultButton(this.m_jButtonOK);
            this.printState();
            this.setVisible(true);
        }
        this.printselected = this.m_jButtonPrint.isSelected();
        this.m_jTabPayment.removeAll();
        return this.accepted;
    }

    protected abstract void setStatusPanel(boolean var1, boolean var2);

    protected abstract PaymentInfo getDefaultPayment(double var1);

    protected void setOKEnabled(boolean value) {
        this.m_jButtonOK.setEnabled(value);
    }

    protected void setAddEnabled(boolean value) {
        this.m_jButtonAdd.setEnabled(value);
    }

    protected void addTabPayment(JPaymentCreator jpay, String tabTitle, String icon) {
        if (this.app.getAppUserView().getUser().hasPermission(jpay.getKey())) {
            try {
                JPaymentInterface jpayinterface = this.payments.get(tabTitle);
                if (jpayinterface == null) {
                    jpayinterface = jpay.createJPayment(tabTitle);
                    this.payments.put(tabTitle, jpayinterface);
                }
                jpayinterface.getComponent().applyComponentOrientation(this.getComponentOrientation());
                if (icon.length() > 0) {
                    this.m_jTabPayment.addTab(tabTitle, new ImageIcon(this.dlSystem.getResourceAsImage(icon)), jpayinterface.getComponent());
                } else {
                    this.m_jTabPayment.addTab(tabTitle, jpayinterface.getComponent());
                }
            }
            catch (Exception e) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), e);
                msg.show(this);
            }
        }
    }

    protected void setHeaderVisible(boolean value) {
        this.jPanel6.setVisible(value);
    }

    private void printState() {
        this.m_jRemaininglEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dTotal - this.m_aPaymentInfo.getTotal())));
        this.m_jButtonRemove.setEnabled(!this.m_aPaymentInfo.isEmpty());
        this.m_jTabPayment.setSelectedIndex(0);
        ((JPaymentInterface)((Object)this.m_jTabPayment.getSelectedComponent())).activate(this.customerext, this.m_dTotal - this.m_aPaymentInfo.getTotal(), this.m_sTransactionID);
    }

    protected static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JPaymentSelect.getWindow(parent.getParent());
    }

    @Override
    public void setStatus(boolean isPositive, boolean isComplete) {
        this.setStatusPanel(isPositive, isComplete);
    }

    @Override
    public void setCustomer(CustomerInfoExt customer) {
        this.customerext = customer;
    }

    @Override
    public CustomerInfoExt getCustomer() {
        return this.customerext;
    }

    public void setTransactionID(String tID) {
        this.m_sTransactionID = tID;
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.m_jLblTotalEuros1 = new JLabel();
        this.m_jTotalEuros = new JLabel();
        this.jPanel6 = new JPanel();
        this.m_jLblRemainingEuros = new JLabel();
        this.m_jRemaininglEuros = new JLabel();
        this.m_jButtonAdd = new JButton();
        this.m_jButtonRemove = new JButton();
        this.jPanel3 = new JPanel();
        this.m_jTabPayment = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jButtonPrint = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.m_jButtonOK = new JButton();
        this.m_jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("payment.title"));
        this.setResizable(false);
        this.m_jLblTotalEuros1.setText(AppLocal.getIntString("label.totalcash"));
        this.jPanel4.add(this.m_jLblTotalEuros1);
        this.m_jTotalEuros.setBackground(new Color(0, 57, 249));
        this.m_jTotalEuros.setFont(this.m_jTotalEuros.getFont().deriveFont(this.m_jTotalEuros.getFont().getStyle() | 1, this.m_jTotalEuros.getFont().getSize() + 4));
        this.m_jTotalEuros.setForeground(new Color(255, 255, 255));
        this.m_jTotalEuros.setHorizontalAlignment(4);
        this.m_jTotalEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTotalEuros.setOpaque(true);
        this.m_jTotalEuros.setPreferredSize(new Dimension(125, 25));
        this.m_jTotalEuros.setRequestFocusEnabled(false);
        this.jPanel4.add(this.m_jTotalEuros);
        this.jPanel6.setLayout(new FlowLayout(1, 5, 0));
        this.m_jLblRemainingEuros.setText(AppLocal.getIntString("label.remainingcash"));
        this.jPanel6.add(this.m_jLblRemainingEuros);
        this.m_jRemaininglEuros.setBackground(new Color(0, 57, 249));
        this.m_jRemaininglEuros.setFont(this.m_jRemaininglEuros.getFont().deriveFont(this.m_jRemaininglEuros.getFont().getStyle() | 1, this.m_jRemaininglEuros.getFont().getSize() + 4));
        this.m_jRemaininglEuros.setForeground(new Color(255, 255, 255));
        this.m_jRemaininglEuros.setHorizontalAlignment(4);
        this.m_jRemaininglEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jRemaininglEuros.setOpaque(true);
        this.m_jRemaininglEuros.setPreferredSize(new Dimension(125, 25));
        this.m_jRemaininglEuros.setRequestFocusEnabled(false);
        this.jPanel6.add(this.m_jRemaininglEuros);
        this.m_jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/btnplus.png")));
        this.m_jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPaymentSelect.this.m_jButtonAddActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.m_jButtonAdd);
        this.m_jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/btnminus.png")));
        this.m_jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPaymentSelect.this.m_jButtonRemoveActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.m_jButtonRemove);
        this.jPanel4.add(this.jPanel6);
        this.getContentPane().add((Component)this.jPanel4, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.m_jTabPayment.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jTabPayment.setTabPlacement(2);
        this.m_jTabPayment.setFocusable(false);
        this.m_jTabPayment.setRequestFocusEnabled(false);
        this.m_jTabPayment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JPaymentSelect.this.m_jTabPaymentStateChanged(evt);
            }
        });
        this.jPanel3.add((Component)this.m_jTabPayment, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel5.setLayout(new BorderLayout());
        this.m_jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/printer.png")));
        this.m_jButtonPrint.setSelected(true);
        this.m_jButtonPrint.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_jButtonPrint.setFocusPainted(false);
        this.m_jButtonPrint.setFocusable(false);
        this.m_jButtonPrint.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonPrint.setMaximumSize(new Dimension(50, 40));
        this.m_jButtonPrint.setMinimumSize(new Dimension(50, 40));
        this.m_jButtonPrint.setOpaque(true);
        this.m_jButtonPrint.setPreferredSize(new Dimension(50, 40));
        this.m_jButtonPrint.setRequestFocusEnabled(false);
        this.m_jButtonPrint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPaymentSelect.this.m_jButtonPrintItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.m_jButtonPrint);
        this.jPanel2.add(this.jPanel1);
        this.m_jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.m_jButtonOK.setText(AppLocal.getIntString("Button.OK"));
        this.m_jButtonOK.setFocusPainted(false);
        this.m_jButtonOK.setFocusable(false);
        this.m_jButtonOK.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonOK.setRequestFocusEnabled(false);
        this.m_jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPaymentSelect.this.m_jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jButtonOK);
        this.m_jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.m_jButtonCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.m_jButtonCancel.setFocusPainted(false);
        this.m_jButtonCancel.setFocusable(false);
        this.m_jButtonCancel.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonCancel.setRequestFocusEnabled(false);
        this.m_jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPaymentSelect.this.m_jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jButtonCancel);
        this.jPanel5.add((Component)this.jPanel2, "After");
        this.getContentPane().add((Component)this.jPanel5, "South");
        this.setSize(new Dimension(672, 497));
        this.setLocationRelativeTo(null);
    }

    private void m_jButtonRemoveActionPerformed(ActionEvent evt) {
        this.m_aPaymentInfo.removeLast();
        this.printState();
    }

    private void m_jButtonAddActionPerformed(ActionEvent evt) {
        PaymentInfo returnPayment = ((JPaymentInterface)((Object)this.m_jTabPayment.getSelectedComponent())).executePayment();
        if (returnPayment != null) {
            this.m_aPaymentInfo.add(returnPayment);
            this.printState();
        }
    }

    private void m_jTabPaymentStateChanged(ChangeEvent evt) {
        if (this.m_jTabPayment.getSelectedComponent() != null) {
            ((JPaymentInterface)((Object)this.m_jTabPayment.getSelectedComponent())).activate(this.customerext, this.m_dTotal - this.m_aPaymentInfo.getTotal(), this.m_sTransactionID);
            if (this.m_jTabPayment.getSelectedComponent().getClass().getName().endsWith("JPaymentPoints")) {
                List<PaymentInfo> payments = this.getSelectedPayments();
                Double pointstendered = 0.0;
                for (int i = 0; i < payments.size(); ++i) {
                    if (!payments.get(i).getName().equals("pointsin")) continue;
                    pointstendered = pointstendered + payments.get(i).getTotal();
                }
                if (pointstendered > 0.0) {
                    JPaymentPoints jpp = (JPaymentPoints)this.m_jTabPayment.getSelectedComponent();
                    jpp.setTendered(pointstendered);
                }
            }
        }
    }

    private void m_jButtonOKActionPerformed(ActionEvent evt) {
        PaymentInfo returnPayment = ((JPaymentInterface)((Object)this.m_jTabPayment.getSelectedComponent())).executePayment();
        if (returnPayment != null) {
            this.m_aPaymentInfo.add(returnPayment);
            this.accepted = true;
            this.dispose();
        }
    }

    private void m_jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void m_jButtonPrintItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.m_jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/printer24.png")));
        } else if (evt.getStateChange() == 2) {
            this.m_jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/printer24bw.png")));
        }
    }

    public class ScriptPaymentTab {
        public void addPayment(String tabName, String icon, String tabClass) {
            if (tabClass.equals("cash")) {
                JPaymentSelect.this.addTabPayment(new JPaymentCashCreator(), tabName, icon);
            } else if (tabClass.equals("currency")) {
                JPaymentSelect.this.addTabPayment(new JPaymentCurrencyCreator(), tabName, icon);
            } else if (tabClass.equals("online")) {
                JPaymentSelect.this.addTabPayment(new JPaymentOnlineCreator(), tabName, icon);
            } else if (tabClass.equals("cheque")) {
                JPaymentSelect.this.addTabPayment(new JPaymentChequeCreator(), tabName, icon);
            } else if (tabClass.equals("voucher")) {
                JPaymentSelect.this.addTabPayment(new JPaymentPaperCreator(), tabName, icon);
            } else if (tabClass.equals("points")) {
                JPaymentSelect.this.addTabPayment(new JPaymentPointsCreator(), tabName, icon);
                JPaymentPoints jpp = (JPaymentPoints)JPaymentSelect.this.m_jTabPayment.getComponentAt(JPaymentSelect.this.m_jTabPayment.getComponentCount() - 1);
                jpp.activate(JPaymentSelect.this.customerext, JPaymentSelect.this.m_dTotal, JPaymentSelect.this.m_sTransactionID);
            } else if (tabClass.equals("card")) {
                JPaymentSelect.this.addTabPayment(new JPaymentMagcardCreator(), tabName, icon);
            } else if (tabClass.equals("free")) {
                JPaymentSelect.this.addTabPayment(new JPaymentFreeCreator(), tabName, icon);
            } else if (tabClass.equals("debt")) {
                JPaymentSelect.this.addTabPayment(new JPaymentDebtCreator(), tabName, icon);
            } else if (tabClass.equals("advance")) {
                JPaymentSelect.this.addTabPayment(new JPaymentAdvanceCreator(), tabName, icon);
            } else if (tabClass.equals("cashrefund")) {
                JPaymentSelect.this.addTabPayment(new JPaymentCashRefundCreator(), tabName, icon);
            } else if (tabClass.equals("chequerefund")) {
                JPaymentSelect.this.addTabPayment(new JPaymentChequeRefundCreator(), tabName, icon);
            } else if (tabClass.equals("voucherrefund")) {
                JPaymentSelect.this.addTabPayment(new JPaymentPaperRefundCreator(), tabName, icon);
            } else if (tabClass.equals("cardrefund")) {
                JPaymentSelect.this.addTabPayment(new JPaymentMagcardRefundCreator(), tabName, icon);
            }
        }
    }

    public class JPaymentMagcardRefundCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentMagcard(JPaymentSelect.this.app, JPaymentSelect.this);
        }

        @Override
        public String getKey() {
            return "refund.magcard";
        }

        @Override
        public String getLabelKey() {
            return "tab.magcard";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.card.png";
        }
    }

    public class JPaymentPaperRefundCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentRefund(JPaymentSelect.this, "paperout");
        }

        @Override
        public String getKey() {
            return "refund.paper";
        }

        @Override
        public String getLabelKey() {
            return "tab.paper";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.voucher.png";
        }
    }

    public class JPaymentChequeRefundCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentRefund(JPaymentSelect.this, "chequerefund");
        }

        @Override
        public String getKey() {
            return "refund.cheque";
        }

        @Override
        public String getLabelKey() {
            return "tab.chequerefund";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cheque.png";
        }
    }

    public class JPaymentCashRefundCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentRefund(JPaymentSelect.this, "cashrefund");
        }

        @Override
        public String getKey() {
            return "refund.cash";
        }

        @Override
        public String getLabelKey() {
            return "tab.cashrefund";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cash.png";
        }
    }

    public class JPaymentAdvanceCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentAdvance(JPaymentSelect.this, JPaymentSelect.this.app);
        }

        @Override
        public String getKey() {
            return "payment.advance";
        }

        @Override
        public String getLabelKey() {
            return "tab.advance";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.debt.png";
        }
    }

    public class JPaymentDebtCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentDebt(JPaymentSelect.this, JPaymentSelect.this.app);
        }

        @Override
        public String getKey() {
            return "payment.debt";
        }

        @Override
        public String getLabelKey() {
            return "tab.debt";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.debt.png";
        }
    }

    public class JPaymentFreeCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentFree(JPaymentSelect.this);
        }

        @Override
        public String getKey() {
            return "payment.free";
        }

        @Override
        public String getLabelKey() {
            return "tab.free";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.free.png";
        }
    }

    public class JPaymentMagcardCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentMagcard(JPaymentSelect.this.app, JPaymentSelect.this);
        }

        @Override
        public String getKey() {
            return "payment.magcard";
        }

        @Override
        public String getLabelKey() {
            return "tab.magcard";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.card.png";
        }
    }

    public class JPaymentPointsCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentPoints(JPaymentSelect.this, "pointsin", JPaymentSelect.this.dlSystem);
        }

        @Override
        public String getKey() {
            return "payment.points";
        }

        @Override
        public String getLabelKey() {
            return "tab.points";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.points.png";
        }
    }

    public class JPaymentPaperCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentPaper(JPaymentSelect.this, "paperin", paymentTitle, JPaymentSelect.this.dlSystem);
        }

        @Override
        public String getKey() {
            return "payment.paper";
        }

        @Override
        public String getLabelKey() {
            return "tab.paper";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.voucher.png";
        }
    }

    public class JPaymentCreditPaidChequeCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentCheque(JPaymentSelect.this, JPaymentSelect.this.dlSales);
        }

        @Override
        public String getKey() {
            return "payment.cheque";
        }

        @Override
        public String getLabelKey() {
            return "tab.cheque";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cheque.png";
        }
    }

    public class JPaymentChequeCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentCheque(JPaymentSelect.this, JPaymentSelect.this.dlSales);
        }

        @Override
        public String getKey() {
            return "payment.cheque";
        }

        @Override
        public String getLabelKey() {
            return "tab.cheque";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cheque.png";
        }
    }

    public class JPaymentCreditPaidCashCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentCashPos(JPaymentSelect.this, JPaymentSelect.this.dlSystem, "Cash");
        }

        @Override
        public String getKey() {
            return "payment.cash";
        }

        @Override
        public String getLabelKey() {
            return "tab.cash";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cash.png";
        }
    }

    public class JPaymentOnlineCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentOnline(JPaymentSelect.this, "online", paymentTitle);
        }

        @Override
        public String getKey() {
            return "payment.online";
        }

        @Override
        public String getLabelKey() {
            return "tab.online";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.online.png";
        }
    }

    public class JPaymentCurrencyCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentCurrency(JPaymentSelect.this, "currency", paymentTitle, JPaymentSelect.this.dlSystem);
        }

        @Override
        public String getKey() {
            return "payment.currency";
        }

        @Override
        public String getLabelKey() {
            return "tab.currency";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.currency.png";
        }
    }

    public class JPaymentCashCreator
    implements JPaymentCreator {
        @Override
        public JPaymentInterface createJPayment(String paymentTitle) {
            return new JPaymentCashPos(JPaymentSelect.this, JPaymentSelect.this.dlSystem, paymentTitle);
        }

        @Override
        public String getKey() {
            return "payment.cash";
        }

        @Override
        public String getLabelKey() {
            return "tab.cash";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cash.png";
        }
    }

    public static interface JPaymentCreator {
        public JPaymentInterface createJPayment(String var1);

        public String getKey();

        public String getLabelKey();

        public String getIconKey();
    }
}

