/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.loader.LocalRes;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.payment.PaymentGateway;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.util.AltEncrypter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PaymentGatewayAuthorizeNet
implements PaymentGateway {
    private static String ENDPOINTADDRESS;
    private static final String OPERATIONVALIDATE = "AUTH_CAPTURE";
    private static final String OPERATIONREFUND = "CREDIT";
    private static final String APPROVED = "1";
    private String m_sCommerceID;
    private String m_sCommercePassword;
    private boolean m_bTestMode;

    public PaymentGatewayAuthorizeNet(AppProperties props) {
        this.m_sCommerceID = props.getProperty("payment.commerceid");
        AltEncrypter cypher = new AltEncrypter("cypherkey" + props.getProperty("payment.commerceid"));
        this.m_sCommercePassword = cypher.decrypt(props.getProperty("payment.commercepassword").substring(6));
        this.m_bTestMode = Boolean.valueOf(props.getProperty("payment.testmode"));
        ENDPOINTADDRESS = this.m_bTestMode ? "https://test.authorize.net/gateway/transact.dll" : "https://cardpresent.authorize.net/gateway/transact.dll";
    }

    public PaymentGatewayAuthorizeNet() {
    }

    @Override
    public void execute(PaymentInfoMagcard payinfo) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("x_cpversion=1.0");
            sb.append("&x_market_type=2");
            sb.append("&x_device_type=1");
            sb.append("&x_login=");
            sb.append(URLEncoder.encode(this.m_sCommerceID, "UTF-8"));
            sb.append("&x_tran_key=");
            sb.append(URLEncoder.encode(this.m_sCommercePassword, "UTF-8"));
            sb.append("&x_amount=");
            DecimalFormat formatter = new DecimalFormat("0000.00");
            String amount = formatter.format(Math.abs(payinfo.getTotal()));
            sb.append(URLEncoder.encode(amount.replace(',', '.'), "UTF-8"));
            if (payinfo.getTrack1(true) == null) {
                sb.append("&x_card_num=");
                sb.append(URLEncoder.encode(payinfo.getCardNumber(), "UTF-8"));
                sb.append("&x_exp_date=");
                String tmp = payinfo.getExpirationDate();
                sb.append(URLEncoder.encode(tmp, "UTF-8"));
                String[] cc_name = payinfo.getHolderName().split(" ");
                sb.append("&x_first_name=");
                if (cc_name.length > 0) {
                    sb.append(URLEncoder.encode(cc_name[0], "UTF-8"));
                }
                sb.append("&x_last_name=");
                if (cc_name.length > 1) {
                    sb.append(URLEncoder.encode(cc_name[1], "UTF-8"));
                }
            } else {
                sb.append("&x_track1=");
                sb.append(payinfo.getTrack1(false));
                sb.append("&x_track2=");
                sb.append(payinfo.getTrack2(false));
            }
            sb.append("&x_method=CC");
            sb.append("&x_version=3.1");
            sb.append("&x_delim_data=TRUE");
            sb.append("&x_delim_char=|");
            sb.append("&x_relay_response=FALSE");
            sb.append("&x_test_request=");
            sb.append(this.m_bTestMode);
            if (payinfo.getTotal() >= 0.0) {
                sb.append("&x_type=");
                sb.append(OPERATIONVALIDATE);
            } else {
                sb.append("&x_type=");
                sb.append(OPERATIONREFUND);
                sb.append("&x_trans_id=");
                sb.append(payinfo.getTransactionID());
            }
            URL url = new URL(ENDPOINTADDRESS);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(sb.toString().getBytes());
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String returned = in.readLine();
            in.close();
            AuthorizeNetParser anp = new AuthorizeNetParser(returned);
            Map props = anp.splitXML();
            if (anp.getResult().equals(LocalRes.getIntString("button.ok"))) {
                if (APPROVED.equals(props.get("ResponseCode"))) {
                    payinfo.paymentOK((String)props.get("AuthCode"), (String)props.get("TransID"), returned);
                } else {
                    StringBuilder errorLine = new StringBuilder();
                    if (anp.getNumErrors() > 0) {
                        for (int i = 1; i <= anp.getNumErrors(); ++i) {
                            errorLine.append(props.get("ErrorCode" + Integer.toString(i)));
                            errorLine.append(": ");
                            errorLine.append(props.get("ErrorText" + Integer.toString(i)));
                            errorLine.append("\n");
                        }
                    }
                    payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), errorLine.toString());
                }
            } else {
                payinfo.paymentError(anp.getResult(), "");
            }
        }
        catch (UnsupportedEncodingException eUE) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), eUE.getMessage());
        }
        catch (MalformedURLException eMURL) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), eMURL.getMessage());
        }
        catch (IOException e) {
            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), e.getMessage());
        }
    }

    private class AuthorizeNetParser
    extends DefaultHandler {
        private SAXParser m_sp = null;
        private Map props = new HashMap();
        private String text;
        private InputStream is;
        private String result;
        private int numMessages = 0;
        private int numErrors = 0;

        public AuthorizeNetParser(String input) {
            this.is = new ByteArrayInputStream(input.getBytes());
        }

        public Map splitXML() {
            try {
                if (this.m_sp == null) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    this.m_sp = spf.newSAXParser();
                }
                this.m_sp.parse(this.is, (DefaultHandler)this);
            }
            catch (ParserConfigurationException ePC) {
                this.result = LocalRes.getIntString("exception.parserconfig");
            }
            catch (SAXException eSAX) {
                this.result = LocalRes.getIntString("exception.xmlfile");
            }
            catch (IOException eIO) {
                this.result = LocalRes.getIntString("exception.iofile");
            }
            this.result = LocalRes.getIntString("button.ok");
            return this.props;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (qName.equals("ResponseCode")) {
                    this.props.put("ResponseCode", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("ErrorCode")) {
                    ++this.numErrors;
                    this.props.put("ErrorCode" + Integer.toString(this.numErrors), URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("ErrorText")) {
                    this.props.put("ErrorText" + Integer.toString(this.numErrors), URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Code")) {
                    ++this.numMessages;
                    this.props.put("Code" + Integer.toString(this.numMessages), URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Description")) {
                    this.props.put("Description" + Integer.toString(this.numMessages), URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("AuthCode")) {
                    this.props.put("AuthCode", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("AVSResultCode")) {
                    this.props.put("AVSResultCode", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("CVVResultCode")) {
                    this.props.put("CVVResultCode", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("TransID")) {
                    this.props.put("TransID", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("RefTransID")) {
                    this.props.put("RefTransID", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("TransHash")) {
                    this.props.put("TransHash", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("TestMode")) {
                    this.props.put("TestMode", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("UserRef")) {
                    this.props.put("UserRef", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                }
            }
            catch (UnsupportedEncodingException eUE) {
                this.result = eUE.getMessage();
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.text = new String();
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text = new String(ch, start, length);
            }
        }

        public String getResult() {
            return this.result;
        }

        public int getNumErrors() {
            return this.numErrors;
        }

        public int getNumMessages() {
            return this.numMessages;
        }
    }
}

