/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.loader.LocalRes;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.payment.PaymentGateway;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.util.AltEncrypter;
import com.posics.pos.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PaymentGatewayCaixa
implements PaymentGateway {
    private static String ENDPOINTADDRESS;
    private static final String SALE = "A";
    private static final String REFUND = "3";
    private static String SALEAPPROVED;
    private static String REFUNDAPPROVED;
    private String m_sCurrency;
    private String sMerchantCode;
    private String sTerminal;
    private String sCommerceSign;
    private boolean bSha;
    private boolean m_bTestMode;

    public PaymentGatewayCaixa(AppProperties props) {
        AltEncrypter cypher = new AltEncrypter("cypherkey");
        this.sCommerceSign = cypher.decrypt(props.getProperty("payment.commercesign").substring(6));
        this.m_bTestMode = Boolean.valueOf(props.getProperty("payment.testmode"));
        this.m_sCurrency = Locale.getDefault().getCountry().isEmpty() ? Currency.getInstance("EUR").getCurrencyCode() : Currency.getInstance(Locale.getDefault()).getCurrencyCode();
        this.sTerminal = props.getProperty("payment.terminal");
        this.sMerchantCode = props.getProperty("payment.commerceid");
        this.bSha = Boolean.valueOf(props.getProperty("payment.SHA"));
        ENDPOINTADDRESS = this.m_bTestMode ? "https://sis-t.sermepa.es:25443/sis/operaciones" : "https://sis.sermepa.es/sis/realizarPago";
    }

    public PaymentGatewayCaixa() {
    }

    private String createOrderId() {
        Random r = new Random();
        DecimalFormat nf = new DecimalFormat("0000000000");
        return nf.format((long)Math.abs(r.nextInt()) + Math.abs(System.currentTimeMillis()) % 1000000L);
    }

    @Override
    public void execute(PaymentInfoMagcard payinfo) {
        StringBuffer sb = new StringBuffer();
        String currency = "978";
        String xml = "";
        if (this.m_sCurrency.equals("USD")) {
            currency = "840";
        } else if (this.m_sCurrency.equals("GPD")) {
            currency = "826";
        }
        DecimalFormat nf = new DecimalFormat("00");
        String amount = nf.format(Math.abs(payinfo.getTotal()) * 100.0);
        String orderid = this.createOrderId();
        try {
            String firma;
            if (payinfo.getTotal() > 0.0) {
                firma = amount + orderid + this.sMerchantCode + currency + payinfo.getCardNumber() + SALE + this.sCommerceSign;
                xml = "<DATOSENTRADA><DS_Version>0.1</DS_Version><DS_MERCHANT_AMOUNT>" + amount + "</DS_MERCHANT_AMOUNT><DS_MERCHANT_CURRENCY>" + currency + "</DS_MERCHANT_CURRENCY><DS_MERCHANT_ORDER>" + orderid + "</DS_MERCHANT_ORDER><DS_MERCHANT_MERCHANTCODE>" + this.sMerchantCode + "</DS_MERCHANT_MERCHANTCODE><DS_MERCHANT_MERCHANTURL></DS_MERCHANT_MERCHANTURL><DS_MERCHANT_MERCHANTSIGNATURE>" + this.getSHA1(firma) + "</DS_MERCHANT_MERCHANTSIGNATURE><DS_MERCHANT_TERMINAL>" + this.sTerminal + "</DS_MERCHANT_TERMINAL><DS_MERCHANT_TRANSACTIONTYPE>" + SALE + "</DS_MERCHANT_TRANSACTIONTYPE><DS_MERCHANT_PAN>" + payinfo.getCardNumber() + "</DS_MERCHANT_PAN><DS_MERCHANT_EXPIRYDATE>" + payinfo.getExpirationDate() + "</DS_MERCHANT_EXPIRYDATE></DATOSENTRADA>";
            } else {
                firma = amount + payinfo.getTransactionID() + this.sMerchantCode + currency + REFUND + this.sCommerceSign;
                xml = "<DATOSENTRADA><DS_Version>0.1</DS_Version><DS_MERCHANT_AMOUNT>" + amount + "</DS_MERCHANT_AMOUNT><DS_MERCHANT_CURRENCY>" + currency + "</DS_MERCHANT_CURRENCY><DS_MERCHANT_ORDER>" + payinfo.getTransactionID() + "</DS_MERCHANT_ORDER><DS_MERCHANT_MERCHANTCODE>" + this.sMerchantCode + "</DS_MERCHANT_MERCHANTCODE><DS_MERCHANT_MERCHANTURL></DS_MERCHANT_MERCHANTURL><DS_MERCHANT_MERCHANTSIGNATURE>" + this.getSHA1(firma) + "</DS_MERCHANT_MERCHANTSIGNATURE><DS_MERCHANT_TERMINAL>" + this.sTerminal + "</DS_MERCHANT_TERMINAL><DS_MERCHANT_TRANSACTIONTYPE>" + REFUND + "</DS_MERCHANT_TRANSACTIONTYPE></DATOSENTRADA>";
            }
            sb.append("entrada=" + URLEncoder.encode(xml, "UTF-8"));
            URL url = new URL(ENDPOINTADDRESS);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(sb.toString().getBytes());
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String sReturned = in.readLine();
            in.close();
            if (sReturned == null) {
                payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Response empty.");
            } else {
                LaCaixaParser lpp = new LaCaixaParser(sReturned);
                Map props = lpp.splitXML();
                if (lpp.getResult().equals(LocalRes.getIntString("button.ok"))) {
                    if (SALEAPPROVED.equals(props.get("Ds_Response")) || REFUNDAPPROVED.equals(props.get("Ds_Response"))) {
                        payinfo.paymentOK((String)props.get("Ds_AuthorisationCode"), (String)props.get("Ds_Order"), sReturned);
                    } else {
                        String sCode = (String)props.get("Ds_Response");
                        if ("0101".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymentnotauthorised"), "Card date expired");
                        } else if ("0102".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Tarjeta en excepci\u00f3n transitoria o bajo sospecha de fraude.");
                        } else if ("0104".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Operaci\u00f3n no permitida para esa tarjeta o terminal.");
                        } else if ("0116".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Disponible insuficiente.");
                        } else if ("0118".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Tarjeta no registrada.");
                        } else if ("0129".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "CVV2 security code invalid. Amount not supplied or invalid.");
                        } else if ("0180".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Tarjeta ajena al servicio.");
                        } else if ("0184".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Cardholder authentication error.");
                        } else if ("0190".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Denegation of service without reason.");
                        } else if ("0191".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Expiry date invalid.");
                        } else if ("0202".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Tarjeta en excepci\u00f3n transitoria o bajo sospecha de fraude con retirada de tarjeta.");
                        } else if ("0904".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Comercio no registrado en FUC.");
                        } else if ("9912".equals(sCode) || "912".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Emisor no disponible.");
                        } else {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterrorunknown"), "");
                        }
                        sCode = (String)props.get("CODIGO");
                        if ("SIS0054".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymentnotauthorised"), "Pedido repetido.");
                        } else if ("SIS0078".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "M\u00e9todo de pago no disponible para su tarjeta.");
                        } else if ("SIS0093".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Tarjeta no v\u00e1lida.");
                        } else if ("SIS0094".equals(sCode)) {
                            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Error en la llamada al MPI sin controlar.");
                        }
                    }
                } else {
                    payinfo.paymentError(lpp.getResult(), "");
                }
            }
        }
        catch (UnsupportedEncodingException eUE) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), eUE.getMessage());
        }
        catch (MalformedURLException eMURL) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), eMURL.getMessage());
        }
        catch (IOException e) {
            payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), e.getMessage());
        }
    }

    public String getSHA1(String input) {
        byte[] output = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(input.getBytes());
            output = md.digest();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        return StringUtils.byte2hex(output);
    }

    static {
        SALEAPPROVED = "0000";
        REFUNDAPPROVED = "0900";
    }

    public class LaCaixaParser
    extends DefaultHandler {
        private SAXParser m_sp = null;
        private Map props = new HashMap();
        private String text;
        private InputStream is;
        private String result;

        public LaCaixaParser(String in) {
            this.is = new ByteArrayInputStream(in.getBytes());
        }

        public Map splitXML() {
            try {
                if (this.m_sp == null) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    this.m_sp = spf.newSAXParser();
                }
                this.m_sp.parse(this.is, (DefaultHandler)this);
            }
            catch (ParserConfigurationException ePC) {
                this.result = LocalRes.getIntString("exception.parserconfig");
            }
            catch (SAXException eSAX) {
                this.result = LocalRes.getIntString("exception.xmlfile");
            }
            catch (IOException eIO) {
                this.result = LocalRes.getIntString("exception.iofile");
            }
            this.result = LocalRes.getIntString("button.ok");
            return this.props;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (qName.equals("CODIGO")) {
                    this.props.put("CODIGO", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Version")) {
                    this.props.put("Ds_Version", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Amount")) {
                    this.props.put("Ds_Amount", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Currency")) {
                    this.props.put("Ds_Currency", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Order")) {
                    this.props.put("Ds_Order", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Signature")) {
                    this.props.put("Ds_Signature", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Terminal")) {
                    this.props.put("Ds_Terminal", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Response")) {
                    this.props.put("Ds_Response", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_AuthorisationCode")) {
                    this.props.put("Ds_AuthorisationCode", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_TransactionType")) {
                    this.props.put("Ds_TransactionType", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_SecurePayment")) {
                    this.props.put("Ds_SecurePayment", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Language")) {
                    this.props.put("Ds_Language", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_MerchantData")) {
                    this.props.put("Ds_MerchantData", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                } else if (qName.equals("Ds_Card_Country")) {
                    this.props.put("Ds_Card_Country", URLDecoder.decode(this.text, "UTF-8"));
                    this.text = "";
                }
            }
            catch (UnsupportedEncodingException eUE) {
                this.result = eUE.getMessage();
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.text = new String();
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text = new String(ch, start, length);
            }
        }

        public String getResult() {
            return this.result;
        }
    }
}

