/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppProperties;
import com.posics.pos.payment.PaymentGateway;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.util.AltEncrypter;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Security;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

public class PaymentGatewayPayPoint
implements PaymentGateway {
    private static final String ENDPOINTADDRESS = "https://www.secpay.com/java-bin/soap";
    private static final QName OPERATIONVALIDATE = new QName("SECCardService", "validateCardFull");
    private static final QName OPERATIONREFUND = new QName("SECCardService", "refundCardFull");
    private String m_sCommerceID;
    private String m_sCommercePassword;
    private String m_sCurrency;
    private boolean m_bTestMode;

    public PaymentGatewayPayPoint(AppProperties props) {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider((java.security.Provider)new Provider());
        this.m_sCommerceID = props.getProperty("payment.commerceid");
        AltEncrypter cypher = new AltEncrypter("cypherkey" + props.getProperty("payment.commerceid"));
        this.m_sCommercePassword = cypher.decrypt(props.getProperty("payment.commercepassword").substring(6));
        this.m_bTestMode = Boolean.valueOf(props.getProperty("payment.testmode"));
        this.m_sCurrency = Locale.getDefault().getCountry().isEmpty() ? Currency.getInstance("EUR").getCurrencyCode() : Currency.getInstance(Locale.getDefault()).getCurrencyCode();
    }

    public PaymentGatewayPayPoint() {
    }

    @Override
    public void execute(PaymentInfoMagcard payinfo) {
        try {
            Object[] methodParams;
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(ENDPOINTADDRESS);
            if (payinfo.getTotal() > 0.0) {
                call.setOperationName(OPERATIONVALIDATE);
                methodParams = new Object[]{this.m_sCommerceID, this.m_sCommercePassword, payinfo.getTransactionID(), InetAddress.getLocalHost().getHostAddress(), payinfo.getHolderName(), payinfo.getCardNumber(), Double.toString(payinfo.getTotal()), payinfo.getExpirationDate(), "", "", "", "", "", (this.m_bTestMode ? "test_status=true," : "test_status=live,") + "dups=false,currency=" + this.m_sCurrency};
            } else {
                call.setOperationName(OPERATIONREFUND);
                methodParams = new Object[]{this.m_sCommerceID, this.m_sCommercePassword, payinfo.getTransactionID(), Double.toString(Math.abs(payinfo.getTotal())), "secpay", "refund" + payinfo.getTransactionID()};
            }
            String returned = (String)call.invoke(methodParams);
            payinfo.setReturnMessage(returned);
            if (returned == null) {
                payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Response empty.");
            } else {
                HashMap<String, String> props = new HashMap<String, String>();
                StringTokenizer tk = new StringTokenizer(returned, "?&");
                while (tk.hasMoreTokens()) {
                    String sToken = tk.nextToken();
                    int i = sToken.indexOf(61);
                    if (i >= 0) {
                        props.put(URLDecoder.decode(sToken.substring(0, i), "UTF-8"), URLDecoder.decode(sToken.substring(i + 1), "UTF-8"));
                        continue;
                    }
                    props.put(URLDecoder.decode(sToken, "UTF-8"), null);
                }
                if ("true".equals(props.get("valid"))) {
                    payinfo.paymentOK((String)props.get("auth_code"), (String)props.get("trans_id"), returned);
                } else {
                    String sCode = (String)props.get("code");
                    if ("N".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymentnotauthorised"), (String)props.get("message"));
                    } else if ("C".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Communication problem. Trying again later may well work.");
                    } else if ("P:A".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Amount not supplied or invalid.");
                    } else if ("P:X".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Not all mandatory parameters supplied.");
                    } else if ("P:P".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Same payment presented twice.");
                    } else if ("P:S".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Start date invalid.");
                    } else if ("P:E".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Expiry date invalid.");
                    } else if ("P:I".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Issue number invalid.");
                    } else if ("P:C".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Card number fails LUHN check.");
                    } else if ("P:T".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Card type invalid - i.e. does not match card number prefix.");
                    } else if ("P:N".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Customer name not supplied.");
                    } else if ("P:M".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Merchant does not exist or not registered yet.");
                    } else if ("P:B".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Merchant account for card type does not exist.");
                    } else if ("P:D".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Merchant account for this currency does not exist.");
                    } else if ("P:V".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "CVV2 security code mandatory and not supplied / invalid.");
                    } else if ("P:R".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "Transaction timed out awaiting a virtual circuit. Merchant may not have enough virtual circuits for the volume of business.");
                    } else if ("P:#".equals(sCode)) {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterror"), "No MD5 hash / token key set up against account.");
                    } else {
                        payinfo.paymentError(AppLocal.getIntString("message.paymenterrorunknown"), "");
                    }
                }
            }
        }
        catch (UnknownHostException eUH) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), eUH.getMessage());
        }
        catch (UnsupportedEncodingException eUE) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), eUE.getMessage());
        }
        catch (ServiceException serviceException) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionservice"), serviceException.getMessage());
        }
        catch (RemoteException remoteException) {
            payinfo.paymentError(AppLocal.getIntString("message.paymentexceptionremote"), remoteException.getMessage());
        }
    }
}

