/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.format.Formats;
import com.posics.pos.payment.PaymentInfo;

public class PaymentInfoCash
extends PaymentInfo {
    private double m_dPaid;
    private double m_dTotal;
    private String m_sService;

    public PaymentInfoCash(double dTotal, double dPaid, String sService) {
        this.m_dTotal = dTotal;
        this.m_dPaid = dPaid;
        this.m_sService = sService;
    }

    @Override
    public PaymentInfo copyPayment() {
        return new PaymentInfoCash(this.m_dTotal, this.m_dPaid, this.m_sService);
    }

    @Override
    public String getName() {
        return "cash";
    }

    @Override
    public double getTotal() {
        return this.m_dTotal;
    }

    public double getPaid() {
        return this.m_dPaid;
    }

    @Override
    public String getTransactionID() {
        return this.m_sService;
    }

    public String printPaid() {
        return Formats.CURRENCY.formatValue(new Double(this.m_dPaid));
    }

    public String printChange() {
        return Formats.CURRENCY.formatValue(new Double(this.m_dPaid - this.m_dTotal));
    }
}

