/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.format.Formats;
import com.posics.pos.payment.PaymentInfo;

public class PaymentInfoCurrency
extends PaymentInfo {
    final double m_dPaid;
    final double m_dPaidCurrency;
    final double m_dTotal;
    final double m_dTotalCurrency;
    final double m_dRate;
    final String m_sCurrency;

    public PaymentInfoCurrency(double dTotal, double dPaid, double dPaidCurrency, double dRate, String sCurrency) {
        this.m_dTotal = dTotal;
        this.m_dTotalCurrency = dTotal * dRate;
        this.m_dPaid = dPaid;
        this.m_dPaidCurrency = dPaidCurrency;
        this.m_dRate = dRate;
        this.m_sCurrency = sCurrency;
    }

    @Override
    public PaymentInfo copyPayment() {
        return new PaymentInfoCurrency(this.m_dTotal, this.m_dPaid, this.m_dPaidCurrency, this.m_dRate, this.m_sCurrency);
    }

    @Override
    public String getName() {
        return "currency";
    }

    @Override
    public double getTotal() {
        return this.m_dTotal;
    }

    public double getPaid() {
        return this.m_dPaid;
    }

    public double getPaidCurrency() {
        return this.m_dPaidCurrency;
    }

    public double getRate() {
        return this.m_dRate;
    }

    public double getChange() {
        return this.m_dPaid - this.m_dTotal;
    }

    @Override
    public String getTransactionID() {
        return this.m_sCurrency + "," + Formats.CURRENCY.formatValue(this.m_dTotalCurrency) + "," + Formats.CURRENCY.formatValue(this.m_dRate) + "," + Formats.CURRENCY.formatValue(this.m_dPaidCurrency);
    }

    public String printPaid() {
        return Formats.CURRENCY.formatValue(this.m_dPaid);
    }

    public String printPaidCurrency() {
        return Formats.CURRENCY.formatValue(this.m_dPaidCurrency);
    }

    public String printRate() {
        return Formats.CURRENCY.formatValue(this.m_dRate);
    }

    public String printCurrency() {
        return this.m_sCurrency;
    }

    public String printChange() {
        return Formats.CURRENCY.formatValue(this.m_dPaid - this.m_dTotal);
    }

    public String printChangeCurrency() {
        return Formats.CURRENCY.formatValue(this.m_dPaidCurrency - this.m_dTotal * this.m_dRate);
    }
}

