/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializableRead;
import com.posics.format.Formats;
import com.posics.pos.payment.PaymentInfo;
import java.util.HashMap;

public class PaymentInfoTicket
extends PaymentInfo
implements SerializableRead {
    private static final long serialVersionUID = 8865238639097L;
    private double m_dTicket;
    private String m_sName;
    private String m_transactionID;
    private String m_dChequeNo;
    private Object m_dBankName;
    private String m_dChequeDate;
    private HashMap<Double, Integer> m_denomination;

    public PaymentInfoTicket(double dTicket, String sName) {
        this.m_sName = sName;
        this.m_dTicket = dTicket;
    }

    public PaymentInfoTicket(String dChequeDate, Object dBankName, String dChequeNo, double dTicket, String sName) {
        this.m_sName = sName;
        this.m_dTicket = dTicket;
        this.m_dChequeNo = dChequeNo;
        this.m_dBankName = dBankName;
        this.m_dChequeDate = dChequeDate;
        this.m_transactionID = this.m_dChequeNo + "##" + this.m_dBankName + "##" + this.m_dChequeDate;
    }

    public PaymentInfoTicket(double dTicket, String sName, HashMap hDenomination) {
        this.m_sName = sName;
        this.m_dTicket = dTicket;
        this.m_denomination = hDenomination;
        this.m_transactionID = this.m_denomination.toString();
    }

    public PaymentInfoTicket(double dTicket, String sName, String transactionID) {
        this.m_sName = sName;
        this.m_dTicket = dTicket;
        this.m_transactionID = transactionID;
    }

    public PaymentInfoTicket() {
        this.m_sName = null;
        this.m_dTicket = 0.0;
        this.m_transactionID = null;
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sName = dr.getString(1);
        this.m_dTicket = dr.getDouble(2);
        this.m_transactionID = dr.getString(3);
    }

    @Override
    public PaymentInfo copyPayment() {
        return new PaymentInfoTicket(this.m_dTicket, this.m_sName);
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public double getTotal() {
        return this.m_dTicket;
    }

    public double getPaid() {
        return this.m_dTicket;
    }

    @Override
    public String getTransactionID() {
        return this.m_transactionID;
    }

    public String printPaid() {
        return Formats.CURRENCY.formatValue(new Double(this.m_dTicket));
    }

    public String printDenomination() {
        return this.m_denomination.toString();
    }

    public String printPaperTotal() {
        return Formats.CURRENCY.formatValue(new Double(-this.m_dTicket));
    }
}

