/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.basic.BasicException;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.loader.SentenceList;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.payment.PaymentInfoMagcardRefund;
import com.posics.pos.payment.PaymentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class PaymentPanelBank
extends JPanel
implements PaymentPanel {
    private double m_dTotal;
    private String m_sTransactionID;
    private JPaymentNotifier m_notifier;
    private ComboBoxValModel m_BankModel;
    private SentenceList m_sentbank;
    private DataLogicSales m_dlSales;
    private JComboBox jBankNameCombo;
    private JLabel jLabel1;
    private JLabel jLabel8;
    private JPanel jPanel4;
    private JPanel jPanel5;

    public PaymentPanelBank(JPaymentNotifier notifier, AppView app) {
        this.m_notifier = notifier;
        this.initComponents();
        this.m_dlSales = (DataLogicSales)app.getBean("com.posics.pos.forms.DataLogicSales");
        this.m_sentbank = this.m_dlSales.getBanksList();
        this.m_BankModel = new ComboBoxValModel();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate(String sTransaction, double dTotal) {
        this.m_sTransactionID = sTransaction;
        this.m_dTotal = dTotal;
        this.resetState();
        try {
            this.m_BankModel = new ComboBoxValModel(this.m_sentbank.list());
            this.jBankNameCombo.setModel(this.m_BankModel);
        }
        catch (BasicException basicException) {
            // empty catch block
        }
    }

    private void resetState() {
        this.m_notifier.setStatus(true, true);
    }

    @Override
    public PaymentInfoMagcard getPaymentInfoMagcard() {
        String bankname = "";
        if (this.jBankNameCombo.getSelectedItem() != null) {
            bankname = this.jBankNameCombo.getSelectedItem().toString();
        }
        if (this.m_dTotal > 0.0) {
            return new PaymentInfoMagcard("", "", "", null, null, null, this.m_sTransactionID + "##" + bankname, this.m_dTotal);
        }
        return new PaymentInfoMagcardRefund("", "", "", null, null, null, this.m_sTransactionID + "##" + bankname, this.m_dTotal);
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jBankNameCombo = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jLabel8.setText(AppLocal.getIntString("label.bankname"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel8, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBankNameCombo, -2, 150, -2).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jBankNameCombo, -2, 25, -2)).addContainerGap(47, Short.MAX_VALUE)));
        this.add((Component)this.jPanel4, "Center");
        this.jLabel1.setText(AppLocal.getIntString("message.paymentgatewaybank"));
        this.jPanel5.add(this.jLabel1);
        this.add((Component)this.jPanel5, "North");
    }
}

