/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.pos.forms.AppLocal;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.MagCardReader;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.payment.PaymentInfoMagcardRefund;
import com.posics.pos.payment.PaymentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class PaymentPanelMagCard
extends JPanel
implements PaymentPanel {
    private JPaymentNotifier m_notifier;
    private MagCardReader m_cardreader;
    private String track1 = null;
    private String track2 = null;
    private String track3 = null;
    private String m_sTransactionID;
    private double m_dTotal;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton jReset;
    private JLabel m_jCardNumber;
    private JLabel m_jExpirationDate;
    private JLabel m_jHolderName;
    private JTextArea m_jKeyFactory;

    public PaymentPanelMagCard(MagCardReader cardreader, JPaymentNotifier notifier) {
        this.m_notifier = notifier;
        this.m_cardreader = cardreader;
        this.initComponents();
        if (this.m_cardreader != null) {
            this.m_jKeyFactory.addKeyListener(new KeyBarsListener());
            this.jReset.setEnabled(true);
        } else {
            this.jReset.setEnabled(false);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate(String sTransaction, double dTotal) {
        this.m_sTransactionID = sTransaction;
        this.m_dTotal = dTotal;
        this.resetState();
        this.m_jKeyFactory.setText(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaymentPanelMagCard.this.m_jKeyFactory.requestFocus();
            }
        });
    }

    private void resetState() {
        this.m_notifier.setStatus(false, false);
        this.m_jHolderName.setText(null);
        this.m_jCardNumber.setText(null);
        this.m_jExpirationDate.setText(null);
        this.track1 = null;
        this.track2 = null;
        this.track3 = null;
        if (this.m_cardreader != null) {
            this.m_cardreader.reset();
        }
    }

    @Override
    public PaymentInfoMagcard getPaymentInfoMagcard() {
        if (this.m_dTotal > 0.0) {
            return new PaymentInfoMagcard(this.m_jHolderName.getText(), this.m_jCardNumber.getText(), this.m_jExpirationDate.getText(), this.track1, this.track2, this.track3, this.m_sTransactionID, this.m_dTotal);
        }
        return new PaymentInfoMagcardRefund(this.m_jHolderName.getText(), this.m_jCardNumber.getText(), this.m_jExpirationDate.getText(), this.track1, this.track2, this.track3, this.m_sTransactionID, this.m_dTotal);
    }

    private void stateTransition(char cTrans) {
        this.m_cardreader.appendChar(cTrans);
        if (this.m_cardreader.isComplete()) {
            this.m_jHolderName.setText(this.m_cardreader.getHolderName());
            this.m_jCardNumber.setText(this.m_cardreader.getCardNumber());
            this.m_jExpirationDate.setText(this.m_cardreader.getExpirationDate());
            this.track1 = this.m_cardreader.getTrack1();
            this.track2 = this.m_cardreader.getTrack2();
            this.track3 = this.m_cardreader.getTrack3();
            this.m_notifier.setStatus(true, true);
        } else {
            this.m_jHolderName.setText(null);
            this.m_jCardNumber.setText(null);
            this.m_jExpirationDate.setText(null);
            this.track1 = null;
            this.track3 = null;
            this.track3 = null;
            this.m_notifier.setStatus(false, false);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jReset = new JButton();
        this.m_jKeyFactory = new JTextArea();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.m_jExpirationDate = new JLabel();
        this.m_jCardNumber = new JLabel();
        this.jLabel8 = new JLabel();
        this.m_jHolderName = new JLabel();
        this.setLayout(new BorderLayout());
        this.jLabel1.setText(AppLocal.getIntString("message.paymentgatewayswipe"));
        this.jPanel2.add(this.jLabel1);
        this.add((Component)this.jPanel2, "North");
        this.jPanel1.setLayout(null);
        this.jReset.setText(AppLocal.getIntString("button.reset"));
        this.jReset.setFocusPainted(false);
        this.jReset.setFocusable(false);
        this.jReset.setRequestFocusEnabled(false);
        this.jReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaymentPanelMagCard.this.jResetActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jReset);
        this.jReset.setBounds(310, 20, 90, 30);
        this.jPanel1.add(this.m_jKeyFactory);
        this.m_jKeyFactory.setBounds(0, 0, 0, 0);
        this.jLabel6.setText(AppLocal.getIntString("label.cardnumber"));
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(20, 50, 100, 15);
        this.jLabel7.setText(AppLocal.getIntString("label.cardexpdate"));
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(20, 80, 100, 15);
        this.m_jExpirationDate.setBackground(Color.white);
        this.m_jExpirationDate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jExpirationDate.setOpaque(true);
        this.m_jExpirationDate.setPreferredSize(new Dimension(150, 25));
        this.jPanel1.add(this.m_jExpirationDate);
        this.m_jExpirationDate.setBounds(120, 80, 70, 25);
        this.m_jCardNumber.setBackground(Color.white);
        this.m_jCardNumber.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jCardNumber.setOpaque(true);
        this.m_jCardNumber.setPreferredSize(new Dimension(150, 25));
        this.jPanel1.add(this.m_jCardNumber);
        this.m_jCardNumber.setBounds(120, 50, 180, 25);
        this.jLabel8.setText(AppLocal.getIntString("label.cardholder"));
        this.jPanel1.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 100, 15);
        this.m_jHolderName.setBackground(Color.white);
        this.m_jHolderName.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jHolderName.setOpaque(true);
        this.m_jHolderName.setPreferredSize(new Dimension(150, 25));
        this.jPanel1.add(this.m_jHolderName);
        this.m_jHolderName.setBounds(120, 20, 180, 25);
        this.add((Component)this.jPanel1, "Center");
    }

    private void jResetActionPerformed(ActionEvent evt) {
        this.resetState();
    }

    private class KeyBarsListener
    extends KeyAdapter {
        private KeyBarsListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            PaymentPanelMagCard.this.m_jKeyFactory.setText(null);
            PaymentPanelMagCard.this.stateTransition(e.getKeyChar());
        }
    }
}

