/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer;

import com.posics.pos.forms.AppProperties;
import com.posics.pos.printer.DeviceDisplay;
import com.posics.pos.printer.DeviceDisplayNull;
import com.posics.pos.printer.DeviceFiscalPrinter;
import com.posics.pos.printer.DeviceFiscalPrinterNull;
import com.posics.pos.printer.DevicePrinter;
import com.posics.pos.printer.DevicePrinterNull;
import com.posics.pos.printer.LabelPrinter;
import com.posics.pos.printer.LabelPrinterNull;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.printer.escpos.CodesBPL;
import com.posics.pos.printer.escpos.CodesEpson;
import com.posics.pos.printer.escpos.CodesIthaca;
import com.posics.pos.printer.escpos.CodesStar;
import com.posics.pos.printer.escpos.CodesSurePOS;
import com.posics.pos.printer.escpos.CodesTMU220;
import com.posics.pos.printer.escpos.CodesZPL;
import com.posics.pos.printer.escpos.DeviceDisplay8Digit;
import com.posics.pos.printer.escpos.DeviceDisplayESCPOS;
import com.posics.pos.printer.escpos.DeviceDisplaySurePOS;
import com.posics.pos.printer.escpos.DevicePrinterBPL;
import com.posics.pos.printer.escpos.DevicePrinterESCPOS;
import com.posics.pos.printer.escpos.DevicePrinterPlain;
import com.posics.pos.printer.escpos.DevicePrinterZPL;
import com.posics.pos.printer.escpos.PrinterWritter;
import com.posics.pos.printer.escpos.PrinterWritterFile;
import com.posics.pos.printer.escpos.PrinterWritterNetwork;
import com.posics.pos.printer.escpos.PrinterWritterRXTX;
import com.posics.pos.printer.escpos.UnicodeTranslatorArabic864;
import com.posics.pos.printer.escpos.UnicodeTranslatorEur;
import com.posics.pos.printer.escpos.UnicodeTranslatorInt;
import com.posics.pos.printer.escpos.UnicodeTranslatorStar;
import com.posics.pos.printer.escpos.UnicodeTranslatorSurePOS;
import com.posics.pos.printer.javapos.DeviceDisplayJavaPOS;
import com.posics.pos.printer.javapos.DeviceFiscalPrinterJavaPOS;
import com.posics.pos.printer.javapos.DevicePrinterJavaPOS;
import com.posics.pos.printer.printer.DeviceLabelPrinterPrinter;
import com.posics.pos.printer.printer.DevicePrinterPrinter;
import com.posics.pos.printer.screen.DeviceDisplayPanel;
import com.posics.pos.printer.screen.DeviceDisplayWindow;
import com.posics.pos.printer.screen.DeviceLabelPrinterPanel;
import com.posics.pos.printer.screen.DevicePrinterKDS;
import com.posics.pos.printer.screen.DevicePrinterPanel;
import com.posics.pos.util.StringParser;
import com.posics.pos.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceTicket {
    private static Logger logger = Logger.getLogger("com.posics.pos.printer.DeviceTicket");
    private DeviceFiscalPrinter m_deviceFiscal;
    private DeviceDisplay m_devicedisplay;
    private DevicePrinter m_nullprinter;
    private LabelPrinter m_nulllabelprinter;
    private LabelPrinter m_labelprinter;
    private Map<String, DevicePrinter> m_deviceprinters;
    private List<DevicePrinter> m_deviceprinterslist;

    public DeviceTicket() {
        this.m_deviceFiscal = new DeviceFiscalPrinterNull();
        this.m_devicedisplay = new DeviceDisplayNull();
        this.m_nullprinter = new DevicePrinterNull();
        this.m_nulllabelprinter = new LabelPrinterNull();
        this.m_deviceprinters = new HashMap<String, DevicePrinter>();
        this.m_deviceprinterslist = new ArrayList<DevicePrinter>();
        DevicePrinterPanel p = new DevicePrinterPanel();
        this.m_deviceprinters.put("1", p);
        this.m_deviceprinterslist.add(p);
    }

    public DeviceTicket(Component parent, AppProperties props) {
        String sPrinterParam2;
        String sPrinterParam1;
        String sPrinterType;
        StringParser sp;
        PrinterWritterPool pws = new PrinterWritterPool();
        StringParser sf = new StringParser(props.getProperty("machine.fiscalprinter"));
        String sFiscalType = sf.nextToken(':');
        String sFiscalParam1 = sf.nextToken(',');
        try {
            this.m_deviceFiscal = "javapos".equals(sFiscalType) ? new DeviceFiscalPrinterJavaPOS(sFiscalParam1) : new DeviceFiscalPrinterNull();
        }
        catch (TicketPrinterException e) {
            this.m_deviceFiscal = new DeviceFiscalPrinterNull(e.getMessage());
        }
        StringParser sd = new StringParser(props.getProperty("machine.display"));
        String sDisplayType = sd.nextToken(':');
        String sDisplayParam1 = sd.nextToken(',');
        String sDisplayParam2 = sd.nextToken(',');
        if ("serial".equals(sDisplayType) || "rxtx".equals(sDisplayType) || "file".equals(sDisplayType)) {
            sDisplayParam2 = sDisplayParam1;
            sDisplayParam1 = sDisplayType;
            sDisplayType = "epson";
        }
        try {
            this.m_devicedisplay = "screen".equals(sDisplayType) ? new DeviceDisplayPanel() : ("window".equals(sDisplayType) ? new DeviceDisplayWindow() : ("epson".equals(sDisplayType) ? new DeviceDisplayESCPOS(pws.getPrinterWritter(sDisplayParam1, sDisplayParam2), new UnicodeTranslatorInt()) : ("surepos".equals(sDisplayType) ? new DeviceDisplaySurePOS(pws.getPrinterWritter(sDisplayParam1, sDisplayParam2)) : ("8Digit".equals(sDisplayType) ? new DeviceDisplay8Digit(pws.getPrinterWritter(sDisplayParam1, sDisplayParam2)) : ("ld200".equals(sDisplayType) ? new DeviceDisplayESCPOS(pws.getPrinterWritter(sDisplayParam1, sDisplayParam2), new UnicodeTranslatorEur()) : ("javapos".equals(sDisplayType) ? new DeviceDisplayJavaPOS(sDisplayParam1) : new DeviceDisplayNull()))))));
        }
        catch (TicketPrinterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            this.m_devicedisplay = new DeviceDisplayNull(e.getMessage());
        }
        this.m_nullprinter = new DevicePrinterNull();
        this.m_nulllabelprinter = new LabelPrinterNull();
        this.m_deviceprinters = new HashMap<String, DevicePrinter>();
        this.m_deviceprinterslist = new ArrayList<DevicePrinter>();
        int iPrinterIndex = 1;
        String sPrinterIndex = Integer.toString(iPrinterIndex);
        String sprinter = props.getProperty("machine.printer");
        while (sprinter != null && !"".equals(sprinter)) {
            sp = new StringParser(sprinter);
            sPrinterType = sp.nextToken(':');
            sPrinterParam1 = sp.nextToken(',');
            sPrinterParam2 = sp.nextToken(',');
            if ("serial".equals(sPrinterType) || "rxtx".equals(sPrinterType) || "file".equals(sPrinterType) || "network".equals(sPrinterType)) {
                sPrinterParam2 = sPrinterParam1;
                sPrinterParam1 = sPrinterType;
                sPrinterType = "epson";
            }
            try {
                if ("screen".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterPanel());
                } else if ("printer".equals(sPrinterType)) {
                    if (sPrinterParam2 == null || sPrinterParam2.equals("") || sPrinterParam2.equals("true")) {
                        sPrinterParam2 = "receipt";
                    } else if (sPrinterParam2.equals("false")) {
                        sPrinterParam2 = "standard";
                    }
                    this.addPrinter(sPrinterIndex, new DevicePrinterPrinter(parent, sPrinterParam1, Integer.parseInt(props.getProperty("paper." + sPrinterParam2 + ".x")), Integer.parseInt(props.getProperty("paper." + sPrinterParam2 + ".y")), Integer.parseInt(props.getProperty("paper." + sPrinterParam2 + ".width")), Integer.parseInt(props.getProperty("paper." + sPrinterParam2 + ".height")), props.getProperty("paper." + sPrinterParam2 + ".mediasizename")));
                } else if ("epson".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterESCPOS(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesEpson(), new UnicodeTranslatorInt()));
                } else if ("arabicepson".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterESCPOS(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesEpson(), new UnicodeTranslatorArabic864()));
                } else if ("KDS".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterKDS(parent, sPrinterParam1));
                } else if ("tmu220".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterESCPOS(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesTMU220(), new UnicodeTranslatorInt()));
                } else if ("generic".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterPlain(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2)));
                } else if ("star".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterESCPOS(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesStar(), new UnicodeTranslatorStar()));
                } else if ("ithaca".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterESCPOS(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesIthaca(), new UnicodeTranslatorInt()));
                } else if ("surepos".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterESCPOS(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesSurePOS(), new UnicodeTranslatorSurePOS()));
                } else if ("plain".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterPlain(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2)));
                } else if ("javapos".equals(sPrinterType)) {
                    this.addPrinter(sPrinterIndex, new DevicePrinterJavaPOS(sPrinterParam1, sPrinterParam2));
                }
            }
            catch (TicketPrinterException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            sPrinterIndex = Integer.toString(++iPrinterIndex);
            sprinter = props.getProperty("machine.printer." + sPrinterIndex);
        }
        sprinter = props.getProperty("label.printer");
        while (sprinter != null && !"".equals(sprinter)) {
            sp = new StringParser(sprinter);
            sPrinterType = sp.nextToken(':');
            sPrinterParam1 = sp.nextToken(',');
            sPrinterParam2 = sp.nextToken(',');
            if ("serial".equals(sPrinterType) || "rxtx".equals(sPrinterType) || "file".equals(sPrinterType) || "network".equals(sPrinterType)) {
                sPrinterParam2 = sPrinterParam1;
                sPrinterParam1 = sPrinterType;
                sPrinterType = "screen";
            }
            try {
                if ("screen".equals(sPrinterType)) {
                    this.addLabelPrinter(sPrinterIndex, new DeviceLabelPrinterPanel());
                } else if ("printer".equals(sPrinterType)) {
                    if (sPrinterParam2 == null || sPrinterParam2.equals("") || sPrinterParam2.equals("true")) {
                        sPrinterParam2 = "receipt";
                    } else if (sPrinterParam2.equals("false")) {
                        sPrinterParam2 = "standard";
                    }
                    this.addLabelPrinter(sPrinterIndex, new DeviceLabelPrinterPrinter(parent, sPrinterParam1, new CodesBPL()));
                } else if ("ZPL".equals(sPrinterType)) {
                    this.addLabelPrinter(sPrinterIndex, new DevicePrinterZPL(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesZPL(), new UnicodeTranslatorInt()));
                } else if ("BPL".equals(sPrinterType)) {
                    this.addLabelPrinter(sPrinterIndex, new DevicePrinterBPL(pws.getPrinterWritter(sPrinterParam1, sPrinterParam2), new CodesBPL(), new UnicodeTranslatorInt()));
                }
            }
            catch (TicketPrinterException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            sPrinterIndex = Integer.toString(++iPrinterIndex);
            sprinter = props.getProperty("label.printer." + sPrinterIndex);
        }
    }

    private void addPrinter(String sPrinterIndex, DevicePrinter p) {
        this.m_deviceprinters.put(sPrinterIndex, p);
        this.m_deviceprinterslist.add(p);
    }

    private void addLabelPrinter(String sPrinterIndex, LabelPrinter p) {
        this.m_labelprinter = p;
    }

    public DeviceFiscalPrinter getFiscalPrinter() {
        return this.m_deviceFiscal;
    }

    public DeviceDisplay getDeviceDisplay() {
        return this.m_devicedisplay;
    }

    public DevicePrinter getDevicePrinter(String key) {
        DevicePrinter printer = this.m_deviceprinters.get(key);
        return printer == null ? this.m_nullprinter : printer;
    }

    public LabelPrinter getDeviceLabelPrinter(String key) {
        LabelPrinter printer = this.m_labelprinter;
        return printer == null ? this.m_nulllabelprinter : printer;
    }

    public List<DevicePrinter> getDevicePrinterAll() {
        return this.m_deviceprinterslist;
    }

    public static String getWhiteString(int iSize, char cWhiteChar) {
        char[] cFill = new char[iSize];
        for (int i = 0; i < iSize; ++i) {
            cFill[i] = cWhiteChar;
        }
        return new String(cFill);
    }

    public static String getWhiteString(int iSize) {
        return DeviceTicket.getWhiteString(iSize, ' ');
    }

    public static String alignBarCode(String sLine, int iSize) {
        if (sLine.length() > iSize) {
            return sLine.substring(sLine.length() - iSize);
        }
        return DeviceTicket.getWhiteString(iSize - sLine.length(), '0') + sLine;
    }

    public static String alignLeft(String sLine, int iSize) {
        if (sLine.length() > iSize) {
            return sLine.substring(0, iSize);
        }
        return sLine + DeviceTicket.getWhiteString(iSize - sLine.length());
    }

    public static String alignRight(String sLine, int iSize) {
        if (sLine.length() > iSize) {
            return sLine.substring(sLine.length() - iSize);
        }
        return DeviceTicket.getWhiteString(iSize - sLine.length()) + sLine;
    }

    public static String alignCenter(String sLine, int iSize) {
        if (sLine.length() > iSize) {
            return DeviceTicket.alignRight(sLine.substring(0, (sLine.length() + iSize) / 2), iSize);
        }
        return DeviceTicket.alignRight(sLine + DeviceTicket.getWhiteString((iSize - sLine.length()) / 2), iSize);
    }

    public static String alignCenter(String sLine) {
        return DeviceTicket.alignCenter(sLine, 48);
    }

    public static final byte[] transNumber(String sCad) {
        if (sCad == null) {
            return null;
        }
        byte[] bAux = new byte[sCad.length()];
        for (int i = 0; i < sCad.length(); ++i) {
            bAux[i] = DeviceTicket.transNumberChar(sCad.charAt(i));
        }
        return bAux;
    }

    public static byte transNumberChar(char sChar) {
        switch (sChar) {
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case 'A': {
                return 65;
            }
            case 'B': {
                return 66;
            }
            case 'C': {
                return 67;
            }
            case 'D': {
                return 68;
            }
            case 'E': {
                return 69;
            }
            case 'F': {
                return 70;
            }
            case 'G': {
                return 71;
            }
            case 'H': {
                return 72;
            }
            case 'I': {
                return 73;
            }
            case 'J': {
                return 74;
            }
            case 'K': {
                return 75;
            }
            case 'L': {
                return 76;
            }
            case 'M': {
                return 77;
            }
            case 'N': {
                return 78;
            }
            case 'O': {
                return 79;
            }
            case 'P': {
                return 80;
            }
            case 'Q': {
                return 81;
            }
            case 'R': {
                return 82;
            }
            case 'S': {
                return 83;
            }
            case 'T': {
                return 84;
            }
            case 'U': {
                return 85;
            }
            case 'V': {
                return 86;
            }
            case 'W': {
                return 87;
            }
            case 'X': {
                return 88;
            }
            case 'Y': {
                return 89;
            }
            case 'Z': {
                return 90;
            }
            case ' ': {
                return 32;
            }
            case '$': {
                return 36;
            }
            case '%': {
                return 37;
            }
            case '+': {
                return 43;
            }
            case '-': {
                return 45;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
            case '#': {
                return 35;
            }
        }
        return 48;
    }

    private static class PrinterWritterPool {
        private Map<String, PrinterWritter> m_apool = new HashMap<String, PrinterWritter>();

        private PrinterWritterPool() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PrinterWritter getPrinterWritter(String con, String port) throws TicketPrinterException {
            String skey = con + "-->" + port;
            PrinterWritter pw = this.m_apool.get(skey);
            if (pw != null) return pw;
            if ("serial".equals(con) || "rxtx".equals(con)) {
                pw = new PrinterWritterRXTX(port);
                this.m_apool.put(skey, pw);
                return pw;
            } else if ("file".equals(con)) {
                pw = new PrinterWritterFile(port);
                this.m_apool.put(skey, pw);
                return pw;
            } else {
                if (!"network".equals(con)) throw new TicketPrinterException();
                String[] tokens = port.split("\\:");
                int iPort = tokens.length == 2 ? Integer.parseInt(tokens[1]) : 9100;
                if (!StringUtils.isValidIPAddress(tokens[0])) throw new TicketPrinterException();
                pw = new PrinterWritterNetwork(tokens[0], iPort);
                this.m_apool.put(skey, pw);
                StringUtils.networkprinterpool.add(tokens[0]);
            }
            return pw;
        }
    }
}

