/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer;

import com.posics.data.loader.LocalRes;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.LabelPrinter;
import com.posics.pos.printer.TicketPrinterException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LabelParser
extends DefaultHandler {
    private static SAXParser m_sp = null;
    private DeviceTicket m_printer;
    private DataLogicSystem m_system;
    private StringBuffer text;
    private int m_iOutputType;
    private static final int OUTPUT_NONE = 0;
    private static final int OUTPUT_LABEL = 1;
    private LabelPrinter m_oOutputPrinter;
    private int labelCopies = 1;

    public LabelParser(DeviceTicket printer, DataLogicSystem system) {
        this.m_printer = printer;
        this.m_system = system;
    }

    public void printLabel(String sIn, int copies) throws TicketPrinterException {
        this.labelCopies = copies;
        this.printLabel(new StringReader(sIn));
    }

    public void printLabel(Reader in) throws TicketPrinterException {
        try {
            if (m_sp == null) {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                m_sp = spf.newSAXParser();
            }
            m_sp.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (ParserConfigurationException ePC) {
            throw new TicketPrinterException(LocalRes.getIntString("exception.parserconfig"), ePC);
        }
        catch (SAXException eSAX) {
            throw new TicketPrinterException(LocalRes.getIntString("exception.xmlfile"), eSAX);
        }
        catch (IOException eIO) {
            throw new TicketPrinterException(LocalRes.getIntString("exception.iofile"), eIO);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.text = null;
        this.m_iOutputType = 0;
        this.m_oOutputPrinter = null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.m_iOutputType) {
            case 0: {
                if (!"label".equals(qName)) break;
                this.m_iOutputType = 1;
                this.m_oOutputPrinter = this.m_printer.getDeviceLabelPrinter("label.printer");
                this.m_oOutputPrinter.beginLabel();
                this.m_oOutputPrinter.setLabel(attributes.getValue("width"), attributes.getValue("height"), attributes.getValue("gap"), attributes.getValue("cols"), attributes.getValue("direction"));
                break;
            }
            case 1: {
                if ("line".equals(qName)) break;
                if ("text".equals(qName)) {
                    this.text = new StringBuffer();
                    this.m_oOutputPrinter.setTextStyle(attributes.getValue("x"), attributes.getValue("y"), attributes.getValue("font"), attributes.getValue("rotation"), attributes.getValue("width"), attributes.getValue("height"));
                    break;
                }
                if (!"barcode".equals(qName)) break;
                this.text = new StringBuffer();
                this.m_oOutputPrinter.setBarcodeStyle(attributes.getValue("x"), attributes.getValue("y"), attributes.getValue("type"), attributes.getValue("height"), attributes.getValue("readable"), attributes.getValue("rotation"), attributes.getValue("narrow"), attributes.getValue("width"));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.m_iOutputType) {
            case 0: {
                break;
            }
            case 1: {
                if ("text".equals(qName)) {
                    this.m_oOutputPrinter.setText(this.text.toString().trim());
                    this.text = null;
                    break;
                }
                if ("barcode".equals(qName)) {
                    this.m_oOutputPrinter.setBarcode(this.text.toString().trim());
                    this.text = null;
                    break;
                }
                if ("line".equals(qName) || !"label".equals(qName)) break;
                this.m_oOutputPrinter.printLabel(this.labelCopies);
                this.m_oOutputPrinter.endLabel();
                this.m_iOutputType = 0;
                this.m_oOutputPrinter = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(ch, start, length);
        }
    }

    private int parseInt(String sValue, int iDefault) {
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException eNF) {
            return iDefault;
        }
    }

    private int parseInt(String sValue) {
        return this.parseInt(sValue, 0);
    }

    private double parseDouble(String sValue, double ddefault) {
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException eNF) {
            return ddefault;
        }
    }

    private double parseDouble(String sValue) {
        return this.parseDouble(sValue, 0.0);
    }

    private String readString(String sValue, String sDefault) {
        if (sValue == null || sValue.equals("")) {
            return sDefault;
        }
        return sValue;
    }
}

