/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import com.posics.pos.printer.escpos.CodesLabel;

public class CodesZPL
extends CodesLabel {
    private static final String LABEL_BEGIN = "^XA";
    private static final String LABEL_END = "^XZ";
    private static final String LABEL_HOME = "^LH";
    private static final String LABEL_ORIENTATION = "^PO";
    private static final String LABEL_COPIES = "^PQ";
    private static final String LABEL_MEDIA_CONTINUOUS = "^LL";
    private static final String FIELD_BLOCK = "^FB";
    private static final String FIELD_TYPE = "^FT";
    private static final String FIELD_FONT = "^A";
    private static final String FIELD_DATA = "^FD";
    private static final String FIELD_DATA_SEPERATOR = "^FS";
    private static final String FIELD_ORIGIN = "^FO";
    private static final String FIELD_FONT_NORMAL = "^ADN";
    private static final String FIELD_FONT_ROTATED = "^ADR";
    private static final String FIELD_FONT_INVERTED = "^ADI";
    private static final String FIELD_FONT_BOTTUMUP = "^ADB";
    private static final String BARCODE_CODE38 = "^B3";
    private static final String BARCODE_CODE128 = "^BC";
    private static final String BARCODE_EAN8 = "^B8";
    private static final String BARCODE_EAN13 = "^BE";
    private static final String BARCODE_WIDTH = "^BY";

    @Override
    public String beginLabel() {
        return LABEL_BEGIN;
    }

    @Override
    public String endLabel() {
        return LABEL_END;
    }

    @Override
    public String setLabel(String width, String height, String gap, String cols, String direction) {
        String code = "";
        code = direction == null || direction.equals("N") ? code + "^PON" : code + "^POI";
        if (gap != null && gap.equals("0")) {
            code = height == null ? code + "^LL100" : code + LABEL_MEDIA_CONTINUOUS + height;
        }
        return code;
    }

    @Override
    public String setTextStyle(String x, String y, String font, String rotation, String width, String height) {
        if (x == null) {
            x = "10";
        }
        if (y == null) {
            y = "10";
        }
        if (font == null) {
            font = "0";
        }
        rotation = rotation == null ? "N" : (rotation.equals("R") ? "R" : (rotation.equals("I") ? "I" : (rotation.equals("B") ? "B" : "N")));
        if (width == null) {
            width = "50";
        }
        if (height == null) {
            height = "50";
        }
        return FIELD_ORIGIN + x + "," + y + FIELD_FONT + font + rotation + "," + height + "," + width;
    }

    @Override
    public String setText(String text) {
        return FIELD_DATA + text + FIELD_DATA_SEPERATOR;
    }

    @Override
    public String printLabel(int copies) {
        return LABEL_COPIES + copies;
    }

    @Override
    public String setBarcodeStyle(String x, String y, String type, String height, String readable, String rotation, String narrow, String width) {
        if (x == null) {
            x = "50";
        }
        if (y == null) {
            y = "50";
        }
        if (width == null) {
            width = "3";
        }
        if (height == null) {
            height = "100";
        }
        rotation = rotation == null ? "N" : (rotation.equals("R") ? "R" : (rotation.equals("I") ? "I" : (rotation.equals("B") ? "B" : "N")));
        readable = readable == null || readable.equals("Y") ? "Y" : (readable.equals("N") ? "N" : "Y");
        String code = FIELD_ORIGIN + x + "," + y;
        code = code + BARCODE_WIDTH + width;
        code = "CODE128".equals(type) ? code + BARCODE_CODE128 + rotation + "," + height + "," + readable + ",N,N,N" : ("EAN8".equals(type) ? code + BARCODE_EAN8 + rotation + "," + height + "," + readable + ",Y" : ("EAN13".equals(type) ? code + BARCODE_EAN13 + rotation + "," + height + "," + readable + ",Y" : code + BARCODE_CODE38 + rotation + ",N," + height + "," + readable + ",N"));
        return code;
    }

    @Override
    public String setBarcode(String text) {
        return FIELD_DATA + text + FIELD_DATA_SEPERATOR;
    }
}

