/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import com.posics.pos.forms.AppLocal;
import com.posics.pos.printer.LabelPrinter;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.printer.escpos.CodesLabel;
import com.posics.pos.printer.escpos.PrinterWritter;
import com.posics.pos.printer.escpos.UnicodeTranslator;
import java.io.StringWriter;
import javax.swing.JComponent;

public class DevicePrinterBPL
implements LabelPrinter {
    private PrinterWritter m_CommOutputPrinter;
    private CodesLabel m_codes;
    private String m_sTextStyle;
    private String m_sBarcodeStyle;
    private String m_sName = AppLocal.getIntString("LabelPrinter.Serial");
    private StringWriter m_sLabelCodes;

    public DevicePrinterBPL(PrinterWritter CommOutputPrinter, CodesLabel codes, UnicodeTranslator trans) throws TicketPrinterException {
        this.m_CommOutputPrinter = CommOutputPrinter;
        this.m_codes = codes;
        this.m_CommOutputPrinter.flush();
    }

    @Override
    public String getPrinterName() {
        return this.m_sName;
    }

    @Override
    public String getPrinterDescription() {
        return null;
    }

    @Override
    public JComponent getPrinterComponent() {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void beginLabel() {
        this.m_sLabelCodes = new StringWriter();
        this.m_sLabelCodes.append(this.m_codes.beginLabel());
    }

    @Override
    public void endLabel() {
        this.m_sLabelCodes.append(this.m_codes.endLabel());
        this.m_CommOutputPrinter.write(this.m_sLabelCodes.toString().getBytes());
        this.m_CommOutputPrinter.flush();
    }

    @Override
    public void setLabel(String width, String height, String gap, String cols, String direction) {
        this.m_sLabelCodes.append(this.m_codes.setLabel(width, height, gap, cols, direction));
    }

    @Override
    public void setTextStyle(String x, String y, String font, String rotation, String width, String height) {
        this.m_sTextStyle = this.m_codes.setTextStyle(x, y, font, rotation, width, height);
    }

    @Override
    public void setText(String text) {
        this.m_sLabelCodes.append(this.m_sTextStyle + "," + this.m_codes.setText(text));
    }

    @Override
    public void printLabel(int copies) {
        this.m_sLabelCodes.append(this.m_codes.printLabel(copies));
    }

    @Override
    public void setBarcodeStyle(String x, String y, String type, String height, String readable, String rotation, String narrow, String wide) {
        this.m_sBarcodeStyle = this.m_codes.setBarcodeStyle(x, y, type, height, readable, rotation, narrow, wide);
    }

    @Override
    public void setBarcode(String barcode) {
        this.m_sLabelCodes.append(this.m_sBarcodeStyle + "," + this.m_codes.setBarcode(barcode));
    }
}

