/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import com.posics.pos.forms.AppLocal;
import com.posics.pos.printer.DevicePrinter;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.printer.escpos.Codes;
import com.posics.pos.printer.escpos.ESCPOS;
import com.posics.pos.printer.escpos.PrinterWritter;
import com.posics.pos.printer.escpos.UnicodeTranslator;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class DevicePrinterESCPOS
implements DevicePrinter {
    private PrinterWritter m_CommOutputPrinter;
    private Codes m_codes;
    private UnicodeTranslator m_trans;
    private String m_sName = AppLocal.getIntString("Printer.Serial");
    private boolean m_blSmallFont = false;

    public DevicePrinterESCPOS(PrinterWritter CommOutputPrinter, Codes codes, UnicodeTranslator trans) throws TicketPrinterException {
        this.m_CommOutputPrinter = CommOutputPrinter;
        this.m_codes = codes;
        this.m_trans = trans;
        this.m_CommOutputPrinter.init(ESCPOS.INIT);
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_CommOutputPrinter.init(this.m_codes.getInitSequence());
        this.m_CommOutputPrinter.write(this.m_trans.getCodeTable());
        this.m_CommOutputPrinter.flush();
    }

    @Override
    public String getPrinterName() {
        return this.m_sName;
    }

    @Override
    public String getPrinterDescription() {
        return null;
    }

    @Override
    public JComponent getPrinterComponent() {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void beginReceipt() {
    }

    @Override
    public void printImage(BufferedImage image) {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_CommOutputPrinter.write(this.m_codes.transImage(image));
    }

    @Override
    public void printBarCode(String type, String position, String code) {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_codes.printBarcode(this.m_CommOutputPrinter, type, position, code);
    }

    @Override
    public void beginLine(int iTextSize) {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        if (iTextSize == 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getSize0());
        } else if (iTextSize == 1) {
            this.m_CommOutputPrinter.write(this.m_codes.getSize1());
        } else if (iTextSize == 2) {
            this.m_CommOutputPrinter.write(this.m_codes.getSize2());
        } else if (iTextSize == 3) {
            this.m_CommOutputPrinter.write(this.m_codes.getSize3());
        } else if (iTextSize == -1) {
            this.m_CommOutputPrinter.write(this.m_codes.getSizeSmall1());
            this.m_blSmallFont = true;
        } else if (iTextSize == -2) {
            this.m_CommOutputPrinter.write(this.m_codes.getSizeSmall2());
            this.m_blSmallFont = true;
        } else {
            this.m_CommOutputPrinter.write(this.m_codes.getSize0());
        }
    }

    @Override
    public void printText(int iStyle, String sText) {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        if ((iStyle & 1) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getBoldSet());
        }
        if ((iStyle & 2) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getUnderlineSet());
        }
        if ((iStyle & 4) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getInvertedSet());
        }
        if ((iStyle & 8) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getRotateSet());
        }
        if ((iStyle & 0x10) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getRedColorSet());
        }
        this.m_CommOutputPrinter.write(this.m_trans.transString(sText));
        if ((iStyle & 2) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getUnderlineReset());
        }
        if ((iStyle & 1) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getBoldReset());
        }
        if ((iStyle & 4) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getInvertedReset());
        }
        if ((iStyle & 8) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getRotateReset());
        }
        if ((iStyle & 0x10) != 0) {
            this.m_CommOutputPrinter.write(this.m_codes.getRedColorReset());
        }
    }

    @Override
    public void endLine() {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_CommOutputPrinter.write(this.m_codes.getNewLine());
        if (this.m_blSmallFont) {
            this.m_CommOutputPrinter.write(this.m_codes.getSizeSmallReset());
            this.m_blSmallFont = false;
        }
    }

    @Override
    public void endReceipt() {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_CommOutputPrinter.write(this.m_codes.getNewLine());
        this.m_CommOutputPrinter.write(this.m_codes.getNewLine());
        this.m_CommOutputPrinter.write(this.m_codes.getNewLine());
        this.m_CommOutputPrinter.write(this.m_codes.getNewLine());
        this.m_CommOutputPrinter.write(this.m_codes.getNewLine());
        this.m_CommOutputPrinter.write(this.m_codes.getCutReceipt());
        this.m_CommOutputPrinter.flush();
    }

    @Override
    public void openDrawer() {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_CommOutputPrinter.write(this.m_codes.getOpenDrawer());
        this.m_CommOutputPrinter.flush();
    }

    @Override
    public void playBuzzer() {
        this.m_CommOutputPrinter.write(ESCPOS.SELECT_PRINTER);
        this.m_CommOutputPrinter.write(this.m_codes.getPlayBuzzer());
        this.m_CommOutputPrinter.flush();
    }
}

