/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import com.posics.pos.printer.escpos.ESCPOS;
import com.posics.pos.printer.escpos.UnicodeTranslator;
import java.util.ArrayList;

public class UnicodeTranslatorArabic864
extends UnicodeTranslator {
    public static int LETTER_ISOLATED = 0;
    public static int LETTER_INITIAL = 1;
    public static int LETTER_MEDIAL = 2;
    public static int LETTER_FINAL = 3;

    @Override
    public byte[] getCodeTable() {
        return ESCPOS.CODE_TABLE_ARABIC;
    }

    @Override
    public byte[] convertString(String sCad) {
        int i;
        String sConvert = sCad;
        byte[] bAux = new byte[sConvert.length()];
        boolean arabicStarted = false;
        ArrayList<Character> ara = new ArrayList<Character>();
        int LETTER_POSITION = 0;
        for (i = 0; i < sConvert.length(); ++i) {
            int c = sConvert.codePointAt(i);
            if (c >= 1536 && c <= 1760 || sConvert.charAt(i) == ' ' || sConvert.charAt(i) == ',' || sConvert.charAt(i) == '.') {
                arabicStarted = true;
                ara.add(Character.valueOf(sConvert.charAt(i)));
                continue;
            }
            if (arabicStarted) {
                for (int j = 0; j < ara.size(); ++j) {
                    LETTER_POSITION = ara.size() == 1 ? LETTER_ISOLATED : (ara.size() > 1 && j != ara.size() - 1 && (j == 0 || ((Character)ara.get(j - 1)).charValue() == ' ' || ((Character)ara.get(j - 1)).charValue() == '\u0648' || ((Character)ara.get(j - 1)).charValue() == '\u0632' || ((Character)ara.get(j - 1)).charValue() == '\u0631' || ((Character)ara.get(j - 1)).charValue() == '\u0630' || ((Character)ara.get(j - 1)).charValue() == '\u062f' || ((Character)ara.get(j - 1)).charValue() == '\u0627') ? LETTER_INITIAL : (j == ara.size() - 1 || ara.size() > j && ((Character)ara.get(j + 1)).charValue() == ' ' ? LETTER_FINAL : LETTER_MEDIAL));
                    bAux[i - j - 1] = this.transChar(((Character)ara.get(j)).charValue(), LETTER_POSITION);
                }
                arabicStarted = false;
                ara = new ArrayList();
            }
            bAux[i] = (byte)sConvert.charAt(i);
        }
        LETTER_POSITION = 0;
        if (--i > 0 && arabicStarted && ara.size() > 0) {
            for (int j = 0; j < ara.size(); ++j) {
                LETTER_POSITION = j == 0 && ara.size() == 1 ? LETTER_ISOLATED : (ara.size() > 1 && j != ara.size() - 1 && (j == 0 || ((Character)ara.get(j - 1)).charValue() == ' ' || ((Character)ara.get(j - 1)).charValue() == '\u0648' || ((Character)ara.get(j - 1)).charValue() == '\u0632' || ((Character)ara.get(j - 1)).charValue() == '\u0631' || ((Character)ara.get(j - 1)).charValue() == '\u0630' || ((Character)ara.get(j - 1)).charValue() == '\u062f' || ((Character)ara.get(j - 1)).charValue() == '\u0627') ? LETTER_INITIAL : (j == ara.size() - 1 || ara.size() > j && ((Character)ara.get(j + 1)).charValue() == ' ' ? LETTER_FINAL : LETTER_MEDIAL));
                bAux[i - j] = this.transChar(((Character)ara.get(j)).charValue(), LETTER_POSITION);
            }
        }
        return bAux;
    }

    public static boolean isProbablyArabic(String s) {
        for (int i = 0; i < Character.codePointCount(s, 0, s.length()); ++i) {
            int c = s.codePointAt(i);
            if (c < 1536 || c > 1760) continue;
            return true;
        }
        return false;
    }

    public byte transChar(char sChar, int position) {
        if (sChar >= '\u0000' && sChar < '\u0080') {
            return (byte)sChar;
        }
        switch (sChar) {
            case '\u0620': {
                return -64;
            }
            case '\u0621': {
                return -63;
            }
            case '\u0627': {
                if (position == LETTER_FINAL || position == LETTER_MEDIAL) {
                    return -88;
                }
                return -57;
            }
            case '\u0623': {
                if (position == LETTER_FINAL || position == LETTER_MEDIAL) {
                    return -91;
                }
                return -61;
            }
            case '\u0628': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -56;
                }
                return -87;
            }
            case '\u062a': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -54;
                }
                return -86;
            }
            case '\u062b': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -53;
                }
                return -85;
            }
            case '\u062c': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -52;
                }
                return -83;
            }
            case '\u062d': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -51;
                }
                return -82;
            }
            case '\u062e': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -50;
                }
                return -81;
            }
            case '\u062f': {
                return -49;
            }
            case '\u0630': {
                return -48;
            }
            case '\u0631': {
                return -47;
            }
            case '\u0632': {
                return -46;
            }
            case '\u0633': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -45;
                }
                return -68;
            }
            case '\u0634': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -44;
                }
                return -67;
            }
            case '\u0635': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -43;
                }
                return -66;
            }
            case '\u0636': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -42;
                }
                return -21;
            }
            case '\u0637': {
                return -41;
            }
            case '\u0638': {
                return -40;
            }
            case '\u0639': {
                if (position == LETTER_ISOLATED) {
                    return -33;
                }
                if (position == LETTER_MEDIAL) {
                    return -20;
                }
                if (position == LETTER_FINAL) {
                    return -59;
                }
                return -39;
            }
            case '\u063a': {
                if (position == LETTER_ISOLATED) {
                    return -18;
                }
                if (position == LETTER_INITIAL) {
                    return -38;
                }
                if (position == LETTER_FINAL) {
                    return -19;
                }
                return -9;
            }
            case '\u0641': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -31;
                }
                return -70;
            }
            case '\u0642': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -30;
                }
                return -8;
            }
            case '\u0643': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -29;
                }
                return -4;
            }
            case '\u0644': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -28;
                }
                return -5;
            }
            case '\u0645': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -27;
                }
                return -17;
            }
            case '\u0646': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -26;
                }
                return -14;
            }
            case '\u0647': {
                if (position == LETTER_INITIAL) {
                    return -25;
                }
                if (position == LETTER_MEDIAL) {
                    return -12;
                }
                return -13;
            }
            case '\u0648': {
                return -24;
            }
            case '\u064a': {
                if (position == LETTER_INITIAL || position == LETTER_MEDIAL) {
                    return -22;
                }
                if (position == LETTER_ISOLATED) {
                    return -3;
                }
                return -10;
            }
            case '\u0622': {
                if (position == LETTER_FINAL) {
                    return -94;
                }
                return -62;
            }
            case '\u0629': {
                return -55;
            }
            case '\u0649': {
                if (position == LETTER_FINAL || position == LETTER_MEDIAL) {
                    return -11;
                }
                return -23;
            }
            case '\u0624': {
                return -60;
            }
            case '\u0625': {
                return -59;
            }
            case '\u0626': {
                return -58;
            }
            case '\u063b': {
                return -37;
            }
            case '\u063c': {
                return -36;
            }
            case '\u063d': {
                return -35;
            }
            case '\u063e': {
                return -34;
            }
            case '\u063f': {
                return -33;
            }
            case '\u0640': {
                return -32;
            }
            case '\u0651': {
                if (position == LETTER_MEDIAL) {
                    return -16;
                }
                return -15;
            }
            case '\u06aa': {
                return -4;
            }
            case '\u066d': {
                return -2;
            }
            case '\u0660': {
                return -80;
            }
            case '\u0661': {
                return -79;
            }
            case '\u0662': {
                return -78;
            }
            case '\u0663': {
                return -77;
            }
            case '\u0664': {
                return -76;
            }
            case '\u0665': {
                return -75;
            }
            case '\u0666': {
                return -74;
            }
            case '\u0667': {
                return -73;
            }
            case '\u0668': {
                return -72;
            }
            case '\u0669': {
                return -71;
            }
            case '\u060c': {
                return -84;
            }
            case '\u061b': {
                return -69;
            }
            case '\u061f': {
                return -65;
            }
        }
        return 63;
    }
}

